/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduledTime;
import com.helpsystems.enterprise.core.scheduler.ScheduledTimeDM;
import com.helpsystems.enterprise.core.scheduler.SimpleList;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class NSTAuditor {
    private static final Logger logger = Logger.getLogger(NSTAuditor.class);
    private ScheduleInfoDM scheduleInfoDM = (ScheduleInfoDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleInfoDM");
    private ScheduledTimeDM scheduledTimeDM = (ScheduledTimeDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduledTimeDM");
    private ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
    private AgentDM agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
    private AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
    private static TimeZone serverTimeZone = TimeZone.getDefault();

    public NSTAuditor() {
        ScheduleInfo.setSuppressScheduleLogEntry((boolean)true);
    }

    public String audit() {
        MessageList messageList = new MessageList();
        try {
            this.verifyThatAllTimeBasedJobsHaveAnNstRecord(messageList);
            this.verifyThatThereAreNoDuplicateNSTPairs(messageList);
            this.verifyThatThereAreNoOrphanedNSTRecords(messageList);
            this.verifyAllOfTheNstValuesInTheDatabase(messageList);
            return this.resultsAsFormattedString(messageList);
        }
        catch (Error error) {
            try {
                String string = "Unable to complete the audit of the next scheduled time values in the database, due to a severe system error.";
                this.logFatal(string, error);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw error;
        }
    }

    private void compareNSTs(ScheduledTime scheduledTime, ScheduleInfo scheduleInfo, JobInfo jobInfo, MessageList messageList) throws ResourceUnavailableException, DataException {
        Calendar calendar;
        Object object;
        int n = scheduledTime.getSystem();
        Calendar calendar2 = scheduledTime.getConsideredScheduledTime();
        Calendar calendar3 = scheduledTime.getMaintainedAtDateTime();
        if (calendar3 == null) {
            String string = MessageUtil.formatMsg((String)"Unable to determine the next scheduled runtime for job {0} on agent {1}. The maintenance date/time field is missing from the next_scheduled_times table, in the database.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
            messageList.add(string);
            return;
        }
        Calendar calendar4 = this.isIntervalTypeJob(scheduleInfo.getScheduleType()) ? calendar2 : (calendar2 == null || calendar3.after(calendar2) ? Calendar.getInstance() : calendar2);
        if (calendar4 != null) {
            try {
                this.setTimeZoneForDateCalcs(calendar4, scheduleInfo, n);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                    string = string + " " + throwable.getMessage();
                }
                String string2 = MessageUtil.formatMsg((String)"Unable to determine the next scheduled runtime for job {0} on agent {1}. Cause: {2}", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string});
                messageList.add(string2);
                return;
            }
        }
        try {
            object = null;
            object = calendar4 != null ? calendar4.getTimeZone() : this.getTimeZone(scheduleInfo, n);
            calendar = scheduleInfo.calcNST(calendar4, jobInfo, (TimeZone)object);
        }
        catch (RuntimeException runtimeException) {
            String string = runtimeException.getMessage();
            for (Throwable throwable = runtimeException.getCause(); throwable != null; throwable = throwable.getCause()) {
                string = string + " " + throwable.getMessage();
            }
            String string3 = MessageUtil.formatMsg((String)"Unable to determine the next scheduled runtime for job {0} on agent {1}. Cause: {2}", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string});
            messageList.add(string3);
            return;
        }
        if (calendar == null) {
            object = MessageUtil.formatMsg((String)"Unable to determine the next scheduled runtime for job {0} on agent {1}. Cause: Unknown.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
            messageList.add((String)object);
            return;
        }
        object = scheduledTime.getNextScheduledTime();
        if (object == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            String string = MessageUtil.formatMsg((String)"Next scheduled time discrepancy for job {0}, on agent {1}. Current NST: NULL. Should be: {2}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(calendar.getTime())});
            messageList.add(string);
            return;
        }
        if (((Calendar)object).getTimeInMillis() != calendar.getTimeInMillis()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            String string = MessageUtil.formatMsg((String)"Next scheduled time discrepancy for job {0}, on agent {1}. Current NST: {2}. Should be: {3}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), simpleDateFormat.format(((Calendar)object).getTime()), simpleDateFormat.format(calendar.getTime())});
            messageList.add(string);
        }
    }

    private JobInfo constructJobInfo(int n, int n2) {
        return new JobInfo(n, this.retrieveJobName(n), n2, this.retrieveAgentName(n2));
    }

    private String formatNST(Calendar calendar) {
        if (calendar == null) {
            return "null";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        simpleDateFormat.setTimeZone(this.serverTimeZone());
        return simpleDateFormat.format(calendar.getTime());
    }

    private ScheduleInfo getScheduleInfo(int n, int n2, JobInfo jobInfo) throws ResourceUnavailableException {
        try {
            ScheduleInfo scheduleInfo = this.scheduleInfoDM.get(n);
            if (scheduleInfo == null && this.scheduledTimeDM.isInDatabase(n, n2)) {
                String string = MessageUtil.formatMsg((String)"A request was made to calculate the next scheduled time for job {0} on agent {1}, but it is not a scheduled type job. Technical note: There is a row in the next_scheduled_time table for this job and agent, but there should not be.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
                throw new IllegalStateException(string);
            }
            return scheduleInfo;
        }
        catch (NoDataException noDataException) {
            if (this.scheduledTimeDM.isInDatabase(n, n2)) {
                String string = MessageUtil.formatMsg((String)"A request was made to calculate the next scheduled time for job {0} on agent {1}, but the job was not found. Technical note: There is a row in the next_scheduled_time table for this job and agent, but there should not be.", (Object[])new Object[]{jobInfo.getJobIDAsString(), jobInfo.getAgentNameWithID()});
                throw new IllegalStateException(string);
            }
            return null;
        }
        catch (BadDataException badDataException) {
            String string = "";
            ErrorList errorList = badDataException.getErrorList();
            if (errorList != null) {
                string = string + " Details:";
                while (errorList.nextError()) {
                    string = string + " " + errorList.getErrorText();
                }
            }
            String string2 = MessageUtil.formatMsg((String)"Unable to determine the next scheduled runtime for job {0} on agent {1}, due to corrupted scheduling data.{2}", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string});
            throw new IllegalStateException(string2, badDataException);
        }
    }

    private boolean isAgentInGroup(long l, long l2) throws ResourceUnavailableException {
        long[] lArray;
        for (long l3 : lArray = this.agentGroupDM.getAgentsIDsInGroup(l2, null)) {
            if (l3 != l) continue;
            return true;
        }
        return false;
    }

    private boolean isIntervalTypeJob(ScheduleJobProxy.ScheduleType scheduleType) {
        return scheduleType == ScheduleJobProxy.ScheduleType.TIMED_INTERVAL || scheduleType == ScheduleJobProxy.ScheduleType.DAY_COUNT;
    }

    private boolean isValidAgentID(int n) throws ResourceUnavailableException {
        try {
            this.agentDM.get((long)n);
        }
        catch (DataException dataException) {
            if (dataException instanceof NoDataException) {
                return false;
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Data exception. Agent ID = {0}.", (Object[])new Object[]{n}), dataException);
        }
        return true;
    }

    private void logFatal(String string, Throwable throwable) {
        logger.error((Object)string, throwable);
    }

    private String resultsAsFormattedString(MessageList messageList) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        String string = "Audit of the Next Scheduled Time values - " + simpleDateFormat.format(new Date()) + "\n";
        String string2 = "-End of audit-\n";
        return string + messageList.getMessagesAsFormattedString() + string2;
    }

    private AgentGroupType retrieveAgentGroupType(long l) throws ResourceUnavailableException {
        try {
            AgentGroupProxy agentGroupProxy = this.agentGroupDM.getProxy(l);
            return agentGroupProxy.getAgentGroupType();
        }
        catch (DataException dataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve the agent group type because no agent group was found whose id is {0}.", (Object[])new Object[]{l}));
        }
    }

    private String retrieveAgentName(int n) {
        try {
            return this.agentDM.get((long)n).getName();
        }
        catch (Exception exception) {
            return String.valueOf(n);
        }
    }

    private String retrieveAgentNameWithIDForJob(int n) {
        try {
            ScheduleJobProxy scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy((long)n);
            if (scheduleJobProxy.getTargetType() != ScheduleInfo.TargetType.AGENT) {
                throw new IllegalStateException("Program error: Asking for the agent name associated with a job that does not run on just 1 agent.");
            }
            int n2 = (int)scheduleJobProxy.getTargetId();
            String string = this.retrieveAgentName(n2);
            String string2 = Integer.toString(n2);
            if (string == null || string.length() == 0) {
                return string2;
            }
            return MessageUtil.formatMsg((String)"{0} ({1})", (Object[])new Object[]{string, string2});
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    private String retrieveJobName(int n) {
        try {
            return this.scheduleJobDM.getScheduleJobProxy((long)n).getName();
        }
        catch (Exception exception) {
            return String.valueOf(n);
        }
    }

    private TimeZone serverTimeZone() {
        return serverTimeZone;
    }

    private void setTimeZoneForDateCalcs(Calendar calendar, ScheduleInfo scheduleInfo, int n) throws DataException, ResourceUnavailableException {
        TimeZone timeZone = this.getTimeZone(scheduleInfo, n);
        calendar.setTimeZone(timeZone);
    }

    private TimeZone getTimeZone(ScheduleInfo scheduleInfo, int n) throws DataException, ResourceUnavailableException {
        ScheduleInfo.TimeZoneType timeZoneType = scheduleInfo.getTimeZoneType();
        TimeZone timeZone = null;
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case AGENT: {
                timeZone = this.timeZoneOfSystem(n);
                break;
            }
            case JOB: {
                String string = scheduleInfo.getJobTimezone();
                timeZone = this.timezone(string);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Unrecognized Timezone Type - {0}", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private TimeZone timeZoneOfSystem(int n) throws DataException, ResourceUnavailableException {
        Agent agent = this.agentDM.get((long)n);
        return TimeZone.getTimeZone(agent.getTimeZone());
    }

    private TimeZone timezone(String string) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"The time zone ID {0} assigned to the job/suite) is unrecognized.", (Object[])new Object[]{string}));
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0} to a TimeZone object.", (Object[])new Object[]{string}), exception);
        }
        return timeZone;
    }

    private void verifyThatAllTimeBasedJobsHaveAnNstRecord(MessageList messageList) {
        try {
            ScheduleJobProxy[] scheduleJobProxyArray;
            try {
                scheduleJobProxyArray = this.scheduledTimeDM.getTimeBasedJobsWithNoNSTRecord();
            }
            catch (Exception exception) {
                String string = "An error occurred while trying to get a list of all time-based jobs that do not have a next scheduled time entry in the database.";
                throw new IllegalStateException(string, exception);
            }
            if (scheduleJobProxyArray.length == 0) {
                messageList.add("Verified that a next scheduled time entry exists in the database, for each time-based job or suite, for each agent that it runs on.");
                return;
            }
            for (int i = 0; i < scheduleJobProxyArray.length; ++i) {
                ScheduleJobProxy scheduleJobProxy = scheduleJobProxyArray[i];
                JobInfo jobInfo = this.constructJobInfo((int)scheduleJobProxy.getSkybotJobNumber(), scheduleJobProxy.getSystem());
                String string = MessageUtil.formatMsg((String)"A next scheduled time entry does not exist in the database for time-based job {0} on agent {1}.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID()});
                messageList.add(string);
            }
        }
        catch (Exception exception) {
            messageList.addError("Unable to verify that each time-based job or suite has a next scheduled time entry in the database, due to an error.", exception);
        }
    }

    private void verifyThatThereAreNoDuplicateNSTPairs(MessageList messageList) {
        try {
            ScheduledTime[] scheduledTimeArray = this.scheduledTimeDM.getDuplicateNSTPairs();
            if (scheduledTimeArray.length == 0) {
                messageList.add("Verified that no more than 1 next scheduled time entry exists in the database, for each time-based job or suite, for each agent that it runs on.\n That is, that there are no cases where there are multiple next scheduled time entries for the same job/agent.");
                return;
            }
            for (ScheduledTime scheduledTime : scheduledTimeArray) {
                JobInfo jobInfo = this.constructJobInfo(scheduledTime.getJobNumber(), scheduledTime.getSystem());
                String string = MessageUtil.formatMsg((String)"Job {0} on agent {1} has {2} next scheduled time entries in the database. There should only be one.", (Object[])new Object[]{jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), scheduledTime.getUpdateCounter()});
                messageList.add(string);
            }
        }
        catch (Exception exception) {
            messageList.addError("Unable to verify that there are no cases where there are multiple next scheduled time entries for the same job/agent, due to an error.", exception);
        }
    }

    private void verifyThatThereAreNoOrphanedNSTRecords(MessageList messageList) {
        try {
            ScheduledTime[] scheduledTimeArray = this.scheduledTimeDM.getOrphanedNSTRecords();
            if (scheduledTimeArray.length == 0) {
                messageList.add("Verified that there are no orphaned next scheduled time entries in the database.");
                return;
            }
            String string = "An invalid next scheduled time entry exists in the database: ";
            block12: for (ScheduledTime scheduledTime : scheduledTimeArray) {
                JobInfo jobInfo;
                ScheduleJobProxy scheduleJobProxy;
                int n = scheduledTime.getUpdateCounter();
                int n2 = scheduledTime.getJobNumber();
                String string2 = this.formatNST(scheduledTime.getNextScheduledTime());
                try {
                    scheduleJobProxy = this.scheduleJobDM.getScheduleJobProxy((long)n2);
                }
                catch (NoDataException noDataException) {
                    messageList.add(MessageUtil.formatMsg((String)(string + "row ID = {0}, job ID = {1}, next scheduled time = {2}. " + "The job ID is invalid. It is undefined."), (Object[])new Object[]{n, n2, string2}));
                    continue;
                }
                int n3 = scheduledTime.getSystem();
                if (!this.isValidAgentID(n3)) {
                    jobInfo = this.constructJobInfo(scheduledTime.getJobNumber(), scheduledTime.getSystem());
                    messageList.add(MessageUtil.formatMsg((String)(string + "row ID = {0}, job = {1}, agentID = {2}, next scheduled time = {3}. " + "The agent ID is invalid. It is undefined."), (Object[])new Object[]{n, jobInfo.getJobNameWithID(), n3, string2}));
                    continue;
                }
                block2 : switch (scheduleJobProxy.getTargetType()) {
                    case AGENT: {
                        if (scheduleJobProxy.getTargetId() == (long)n3) break;
                        jobInfo = this.constructJobInfo(scheduledTime.getJobNumber(), scheduledTime.getSystem());
                        String string3 = jobInfo.getAgentNameWithID();
                        String string4 = this.retrieveAgentNameWithIDForJob(n2);
                        messageList.add(MessageUtil.formatMsg((String)(string + "row ID = {0}, job = {1}, agent = {2}, next scheduled time = {3}. " + "Job {4} is currently defined to run on 1 agent and that agent is {5}."), (Object[])new Object[]{n, jobInfo.getJobNameWithID(), string3, string2, jobInfo.getJobName(), string4}));
                        continue block12;
                    }
                    case AGENT_GROUP: {
                        long l = scheduleJobProxy.getTargetId();
                        AgentGroupType agentGroupType = this.retrieveAgentGroupType(l);
                        switch (agentGroupType) {
                            case ALL_AGENTS: {
                                if (this.isAgentInGroup(n3, l)) break block2;
                                jobInfo = this.constructJobInfo(scheduledTime.getJobNumber(), scheduledTime.getSystem());
                                String string5 = this.agentGroupDM.getProxy(l).getName();
                                messageList.add(MessageUtil.formatMsg((String)(string + "row ID = {0}, job = {1}, agent = {2}, next scheduled time = {3}. " + "Job {4} is currently defined to run on agent group {5}. " + "Agent {6} is not defined as part of {5}."), (Object[])new Object[]{n, jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string2, jobInfo.getJobName(), string5, jobInfo.getAgentName()}));
                                continue block12;
                            }
                            case UTILIZATION_BALANCED: 
                            case PREFERRED_AGENT: {
                                if ((long)n3 == 0L) break block2;
                                jobInfo = this.constructJobInfo(scheduledTime.getJobNumber(), scheduledTime.getSystem());
                                String string5 = this.agentGroupDM.getProxy(l).getName();
                                messageList.add(MessageUtil.formatMsg((String)(string + "row ID = {0}, job = {1}, agent = {2}, next scheduled time = {3}. " + "Job {4} is currently defined to run on balanced agent group {5}. " + "The agent should not be assigned at this time."), (Object[])new Object[]{n, jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string2, jobInfo.getJobName(), string5}));
                                continue block12;
                            }
                            default: {
                                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{scheduleJobProxy.getTargetType()}));
                    }
                }
                jobInfo = this.constructJobInfo(scheduledTime.getJobNumber(), scheduledTime.getSystem());
                String string6 = MessageUtil.formatMsg((String)(string + "row ID = {0}, job = {1}, agent = {2}, next scheduled time = {3}. Unknown reason."), (Object[])new Object[]{n, jobInfo.getJobNameWithID(), jobInfo.getAgentNameWithID(), string2});
                messageList.add(string6);
            }
        }
        catch (Exception exception) {
            messageList.addError("Unable to verify that there are no orphaned next scheduled time entries in the database, due to an error.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAllOfTheNstValuesInTheDatabase(MessageList messageList) {
        int n = messageList.getMessageCount();
        try {
            SimpleList simpleList;
            try {
                simpleList = this.scheduledTimeDM.getNextScheduledTimeAuditList();
            }
            catch (Exception exception) {
                String string = "An error occurred while trying to get a list of all Scheduled Time objects.";
                throw new IllegalStateException(string, exception);
            }
            JobInfo jobInfo = new JobInfo();
            int n2 = -1;
            ScheduleInfo scheduleInfo = null;
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            try {
                while (simpleList.next()) {
                    ScheduleInfo scheduleInfo2;
                    ScheduledTime scheduledTime = (ScheduledTime)simpleList.get();
                    int n3 = scheduledTime.getJobNumber();
                    int n4 = scheduledTime.getSystem();
                    if (jobInfo.getJobID() != n3) {
                        jobInfo.setJobID(n3);
                        jobInfo.setJobName(this.retrieveJobName(n3));
                    }
                    if (jobInfo.getAgentID() != n4) {
                        String string = (String)hashMap.get(n4);
                        if (string == null && !hashMap.containsKey(n4)) {
                            string = this.retrieveAgentName(n4);
                            hashMap.put(n4, string);
                        }
                        jobInfo.setAgentName(string);
                        jobInfo.setAgentID(n4);
                    }
                    if (n3 != n2) {
                        try {
                            scheduleInfo = this.getScheduleInfo(n3, n4, jobInfo);
                            n2 = n3;
                        }
                        catch (IllegalStateException illegalStateException) {
                            messageList.add(illegalStateException.getMessage());
                            continue;
                        }
                    }
                    if ((scheduleInfo2 = scheduleInfo) == null) continue;
                    this.compareNSTs(scheduledTime, scheduleInfo2, jobInfo, messageList);
                }
            }
            finally {
                simpleList.close();
            }
            if (messageList.getMessageCount() == n) {
                messageList.add("Recalculated and verified all of the next scheduled time values in the database.");
            }
        }
        catch (Exception exception) {
            messageList.addError("Unable to recalculate and verify all of the next scheduled time values in the database, due to an error.", exception);
        }
    }

    private class MessageList {
        private List<String> msgList = new ArrayList<String>();

        private MessageList() {
        }

        public void add(String string) {
            this.msgList.add(string);
        }

        public void addError(String string, Throwable throwable) {
            this.add(string);
            this.add(this.stackTrace(throwable));
        }

        public String getMessagesAsFormattedString() {
            StringBuffer stringBuffer = new StringBuffer(this.msgList.size() * 80);
            for (String string : this.msgList) {
                stringBuffer.append(string + "\n");
            }
            return stringBuffer.toString();
        }

        public int getMessageCount() {
            return this.msgList.size();
        }

        private String stackTrace(Throwable throwable) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charArrayWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            return charArrayWriter.toString();
        }
    }
}

