/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobMissedCode;
import com.helpsystems.enterprise.core.busobj.JobReactCode;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.ForecastAM;
import com.helpsystems.enterprise.core.dm.JobMonitorManagerAM;
import com.helpsystems.enterprise.core.dm.JobSuiteAM;
import com.helpsystems.enterprise.core.dm.JobTrackerAM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.SpecialInstanceDM;
import com.helpsystems.enterprise.core.logger.CrossAppenderLogger;
import com.helpsystems.enterprise.core.logger.Log4jID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.core.scheduler.ActivityMatcherAM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.DependentMember;
import com.helpsystems.enterprise.core.scheduler.DependentMemberIDAndType;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteInstanceMember;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMember;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberJobSkipSpecialInstance;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberSkipFlag;
import com.helpsystems.enterprise.core.scheduler.JobSuiteStatus;
import com.helpsystems.enterprise.core.scheduler.MemberDependencyType;
import com.helpsystems.enterprise.core.scheduler.MemberRequiredPrereqs;
import com.helpsystems.enterprise.core.scheduler.MemberStatus;
import com.helpsystems.enterprise.core.scheduler.MissingJobDataException;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.PrereqMemberIDAndType;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobBigProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.SuiteInfo;
import com.helpsystems.enterprise.core.util.JobParameterUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class JobSuiteAMImpl
extends AbstractManager
implements JobSuiteAM {
    private static final Logger logger = Logger.getLogger(JobSuiteAMImpl.class);
    private JobSuiteDM jobSuiteDM;
    private JobTrackerAM jobTrackerAM;
    private PrereqDM prereqDM;
    private ReactivityAM reactivityAM;
    private JobMonitorManagerAM jobMonitorManagerAM;
    private ActivityMatcherAM activityMatcherAM;
    private ScheduleJobDM scheduleJobDM;
    private ForecastAM forecastAM;
    private Object statusChangeLock = new Object();

    public JobSuiteAMImpl(JobSuiteDM jobSuiteDM, JobTrackerAM jobTrackerAM, PrereqDM prereqDM, JobMonitorManagerAM jobMonitorManagerAM, ActivityMatcherAM activityMatcherAM, ScheduleJobDM scheduleJobDM) {
        ValidationHelper.checkForNull((String)"JobSuiteDM", (Object)jobSuiteDM);
        ValidationHelper.checkForNull((String)"JobTrackerAM", (Object)jobTrackerAM);
        ValidationHelper.checkForNull((String)"PrereqDM", (Object)prereqDM);
        ValidationHelper.checkForNull((String)"JobMonitorManagerAM", (Object)jobMonitorManagerAM);
        ValidationHelper.checkForNull((String)"ActivityMatcherAM", (Object)activityMatcherAM);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        this.setName("ENTERPRISE.JobSuiteAM");
        this.jobSuiteDM = jobSuiteDM;
        this.jobTrackerAM = jobTrackerAM;
        this.prereqDM = prereqDM;
        this.jobMonitorManagerAM = jobMonitorManagerAM;
        this.activityMatcherAM = activityMatcherAM;
        this.scheduleJobDM = scheduleJobDM;
    }

    public boolean startSuite(long l, String string, Date date, Calendar calendar, JobInitCode jobInitCode, String string2, boolean bl, String string3) {
        logger.debug((Object)MessageUtil.formatMsg((String)"Request received to start Job Suite {0}.", (Object[])new Object[]{string}));
        try {
            ScheduleJobProxy scheduleJobProxy = this.jobTrackerAM.getJobProxy(l);
            JobHistory jobHistory = this.createSuiteHistoryRecord(l, string, date, calendar, jobInitCode, string2, bl, string3, scheduleJobProxy.getTimezoneType(), scheduleJobProxy.getJobTimezone());
            boolean bl2 = this.checkTimeRange(jobHistory, scheduleJobProxy);
            if (!bl2) {
                return false;
            }
            long l2 = jobHistory.getId();
            int n = this.createInstanceTables(l, l2);
            RosettaMsg rosettaMsg = RosettaMsg.SUITE_STARTED;
            String[] stringArray = new String[]{string, ScheduleLogger.formatTimeStamp((Date)date), jobInitCode.toString(), Long.toString(l2), Integer.toString(n), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
            if (jobInitCode == JobInitCode.SCHEDULE || jobInitCode == JobInitCode.SCHEDULED_WITH_PREREQS) {
                rosettaMsg = RosettaMsg.SUITE_STARTED_SCHEDULED;
            }
            ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntryForSuite(stringArray, l, l2);
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            this.updateSuiteStatus(l2, null, null);
            this.activityMatcherAM.jobSubmitted(l, JobType.SUITE, 0L, l2, jobInitCode, jobHistory.getScheduledTime());
            this.prereqDM.createJobHistoryToEventXref(l, 0L, l2);
            this.prereqDM.resetPrereqStatus(PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS, l, 0L);
            boolean bl3 = jobHistory.getReactCode() == JobReactCode.PERFORM_REACTIVITY;
            SuiteInfo suiteInfo = new SuiteInfo(l, string, bl3, jobHistory.getBypassJobMonitors(), jobHistory.getScheduledTime(), jobHistory.getTimezoneType(), jobHistory.getJobTimezone());
            this.notifyJobSuiteMonitors(jobHistory, JobSuiteStatus.RUNNING);
            if (n == 0) {
                this.updateSuiteStatus(l2, null, null);
            } else {
                this.submitAllInitialMembers(l2, calendar, suiteInfo);
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"An error occurred while trying to start suite {0}.", (Object[])new Object[]{string}), (Throwable)exception);
            return false;
        }
        return true;
    }

    public List<JobHistory> startSuiteNow(long l, boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3) {
        ArrayList<JobHistory> arrayList = new ArrayList<JobHistory>();
        ScheduleJobProxy scheduleJobProxy = this.jobTrackerAM.getJobProxy(l);
        if (scheduleJobProxy != null) {
            Date date = new Date(System.currentTimeMillis());
            try {
                String string4 = JobHistory.buildOverridenJobName((String)scheduleJobProxy.getName(), (String)string3);
                JobHistory jobHistory = this.createJobHistory(l, string4, date, null, scheduleJobProxy.getTimezoneType(), scheduleJobProxy.getJobTimezone());
                jobHistory.setInitiationCode(JobInitCode.USER_DO);
                jobHistory.setInitiationData(string);
                jobHistory.setManuallyStarted(true);
                jobHistory.setClearPrereqStatus(bl2);
                jobHistory.setBypassJobMonitors(bl3);
                jobHistory.setJobParameters(string2);
                jobHistory.setDefaultSuiteParameters(scheduleJobProxy.getJobParameters());
                if (bl) {
                    jobHistory.setReactCode(JobReactCode.PERFORM_REACTIVITY);
                } else {
                    jobHistory.setReactCode(JobReactCode.SKIP_REACTIVITY);
                }
                jobHistory = this.jobSuiteDM.createSuiteHistoryRecord(jobHistory);
                jobHistory.setJobSuiteHistoryID(jobHistory.getId());
                try {
                    this.jobSuiteDM.populateSuiteHistoryID(jobHistory.getId());
                }
                catch (NotSavedException notSavedException) {
                    logger.error((Object)"", (Throwable)notSavedException);
                }
                String[] stringArray = new String[]{jobHistory.getJobName(), ScheduleLogger.formatTimeStamp((Date)date), string, Long.toString(jobHistory.getId())};
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.JOB_SUITE_SUBMITTED_BY_USER.newLogEntry(stringArray);
                scheduleLogEntry.setJobSuiteID(jobHistory.getJobID());
                scheduleLogEntry.setJobSuiteHistoryID(jobHistory.getId());
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                int n = this.createInstanceTables(l, jobHistory.getId());
                long l2 = jobHistory.getId();
                this.updateSuiteStatus(l2, null, null);
                SuiteInfo suiteInfo = new SuiteInfo(l, jobHistory.getJobName(), bl, bl3, jobHistory.getScheduledTime(), jobHistory.getTimezoneType(), jobHistory.getJobTimezone());
                suiteInfo.setMemberInitCode(JobInitCode.SUITE_MEMBER);
                suiteInfo.setJobParameters(jobHistory.getJobParameters());
                this.notifyJobSuiteMonitors(jobHistory, JobSuiteStatus.RUNNING);
                if (n == 0) {
                    this.updateSuiteStatus(l2, null, null);
                } else {
                    this.submitAllInitialMembers(l2, suiteInfo);
                }
                if (bl2) {
                    PrereqDM prereqDM = (PrereqDM)ManagerRegistry.getManager((String)"ENTERPRISE.PrereqDM");
                    prereqDM.resetPrereqStatus(jobHistory.getAgentID(), jobHistory.getJobID(), PrereqDM.ResetOption.CLEAR_ALL_PREREQ_STATUS, jobHistory.getId());
                }
                arrayList.add(jobHistory);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string5 = "Error starting JDBC connection pool.";
                logger.error((Object)string5, (Throwable)resourceUnavailableException);
                throw new RuntimeException(string5, resourceUnavailableException);
            }
        }
        return arrayList;
    }

    public void doManagedSuiteNow(long l, boolean bl, String string, String string2, boolean bl2, String string3) throws DataException, ActionFailedException {
        JobHistory jobHistory = null;
        try {
            jobHistory = this.jobSuiteDM.getSuiteHistory(l);
        }
        catch (Exception exception) {
            String string4 = "Cannot Start managed Suite.  Suite History could not be found.";
            logger.debug((Object)string4, (Throwable)exception);
            throw new ActionFailedException(string4, (Throwable)exception);
        }
        if (!jobHistory.getStatusCode().equals((Object)JobStatusCode.MANAGED)) {
            String string5 = "Cannot Start managed Suite.  Suite is no longer managed.";
            logger.debug((Object)string5);
            throw new ActionFailedException(string5);
        }
        jobHistory.setInitiationData(string2);
        jobHistory.setManuallyStarted(true);
        jobHistory.setBypassJobMonitors(bl2);
        if (bl) {
            jobHistory.setReactCode(JobReactCode.PERFORM_REACTIVITY);
        } else {
            jobHistory.setReactCode(JobReactCode.SKIP_REACTIVITY);
        }
        try {
            String string6 = JobParameterUtil.overrideJobParameters((String)jobHistory.getJobName(), (String)jobHistory.getJobParameters(), null, (String)string3);
            jobHistory.setJobParameters(string6);
        }
        catch (Exception exception) {
            String string7 = "Error processing job suite parameters.";
            logger.error((Object)string7, (Throwable)exception);
            throw new ActionFailedException(string7, (Throwable)exception);
        }
        long l2 = this.forecastAM.runDuration(jobHistory.getJobID(), 0L);
        jobHistory.setEstimatedRuntime(l2);
        try {
            jobHistory = this.jobTrackerAM.getJobHistoryDM().saveManaged(jobHistory, false);
        }
        catch (Exception exception) {
            String string8 = "Error starting job...unable to save new suite history info";
            logger.error((Object)string8, (Throwable)exception);
            throw new ActionFailedException(string8, (Throwable)exception);
        }
        try {
            long l3 = jobHistory.getJobID();
            int n = this.createInstanceTables(l3, jobHistory.getId());
            long l4 = jobHistory.getId();
            this.updateSuiteStatus(l4, null, null);
            SuiteInfo suiteInfo = new SuiteInfo(l3, jobHistory.getJobName(), bl, bl2, jobHistory.getScheduledTime(), jobHistory.getTimezoneType(), jobHistory.getJobTimezone());
            suiteInfo.setMemberInitCode(JobInitCode.SUITE_MEMBER);
            String string9 = JobParameterUtil.overrideJobParameters((String)suiteInfo.getSuiteName(), (String)jobHistory.getJobParameters(), null, (String)string3);
            suiteInfo.setJobParameters(string9);
            this.notifyJobSuiteMonitors(jobHistory, JobSuiteStatus.RUNNING);
            if (n == 0) {
                this.updateSuiteStatus(l4, null, null);
            } else {
                this.submitAllInitialMembers(l4, suiteInfo);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string10 = "Error starting JDBC connection pool.";
            logger.error((Object)string10, (Throwable)resourceUnavailableException);
            throw new RuntimeException(string10, resourceUnavailableException);
        }
        String[] stringArray = new String[]{jobHistory.getJobName(), ScheduleLogger.formatTimeStamp((Date)new Date(System.currentTimeMillis())), string2, Long.toString(jobHistory.getId())};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.MANAGED_SUITE_SUBMITTED_BY_USER.newLogEntry(stringArray);
        scheduleLogEntry.setJobSuiteID(jobHistory.getJobID());
        scheduleLogEntry.setJobSuiteHistoryID(jobHistory.getId());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    public void holdFailedSuite(JobHistory jobHistory) {
        ScheduleJobBigProxy scheduleJobBigProxy;
        ValidationHelper.checkForNull((String)"Suite history", (Object)jobHistory);
        if (!jobHistory.isJobSuite()) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: A request was made to hold a suite but the history record (run number {0}) does not represent a suite.", (Object[])new Object[]{jobHistory.getId()}));
        }
        long l = jobHistory.getJobID();
        String string = jobHistory.getJobName();
        try {
            scheduleJobBigProxy = this.scheduleJobDM.getScheduleJobBigProxy(jobHistory.getJobID());
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Suite {0} with run number {1} is in a Failed status, but unable to retrieve the Hold-on-failure setting.", (Object[])new Object[]{string, jobHistory.getId()}), (Throwable)exception);
            return;
        }
        if (scheduleJobBigProxy.isHoldOnFailure() && !scheduleJobBigProxy.isJobHeld()) {
            try {
                this.scheduleJobDM.hold(l);
                RosettaMsg rosettaMsg = RosettaMsg.JOB_SUITE_HELD_DUE_TO_FAILURE;
                String[] stringArray = new String[]{string};
                ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntryForSuite(stringArray, l, jobHistory.getId());
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                SystemMessage systemMessage = RosettaMsg.JOB_SUITE_HELD_DUE_TO_FAILURE.newSystemMessage(stringArray);
                SystemMessageQueue.write((SystemMessage)systemMessage);
                logger.warn((Object)scheduleLogEntry.getMessageText());
                CrossAppenderLogger.logMessage((Log4jID)Log4jID.SCHEDULER, (Level)Level.WARN, (String)scheduleLogEntry.getMessageText());
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error implementing Hold-on-failure for suite {0} with run number {1}.", (Object[])new Object[]{string, jobHistory.getId()}), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberStatusChange(JobHistory jobHistory) {
        JobStatusCode jobStatusCode = jobHistory.getStatusCode();
        if (jobStatusCode == JobStatusCode.INITIATED) {
            return;
        }
        if (jobStatusCode == JobStatusCode.SKIPPED) {
            return;
        }
        long l = jobHistory.getJobSuiteHistoryID();
        long l2 = jobHistory.getJobSuiteMemberInstanceID();
        JobSuiteStatus jobSuiteStatus = null;
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.statusChangeLock;
        synchronized (object) {
            MemberStatus memberStatus;
            try {
                long l3 = jobHistory.getId();
                long l4 = 0L;
                if (jobHistory.getAgentGroupID() == 0L) {
                    switch (jobStatusCode) {
                        case SUBMITTED: 
                        case RUNNING: 
                        case CONDITION_CHECK: 
                        case CONDITION_RETRY_WAIT: {
                            memberStatus = MemberStatus.RUNNING;
                            break;
                        }
                        case COMPLETED: {
                            memberStatus = MemberStatus.COMPLETED;
                            break;
                        }
                        case FAILED: {
                            memberStatus = MemberStatus.FAILED;
                            break;
                        }
                        case ERROR: {
                            memberStatus = MemberStatus.ERROR;
                            break;
                        }
                        case CANCELED: {
                            memberStatus = MemberStatus.CANCELED;
                            break;
                        }
                        default: {
                            MemberStatus memberStatus2 = MemberStatus.FAILED;
                            logger.error((Object)MessageUtil.formatMsg((String)"Program error: Job Suite processing has been notified of a change in the status of member job {0} on agent {1} with run number {2} to {3}. However, that status is unanticipated and has been changed to {4}.", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getJobSuiteHistoryID(), jobStatusCode, memberStatus2}));
                            memberStatus = memberStatus2;
                        }
                    }
                    switch (jobStatusCode) {
                        case SUBMITTED: {
                            l4 = jobHistory.getServerSubmittedTime();
                            break;
                        }
                        case CONDITION_CHECK: {
                            l4 = jobHistory.getQueueEndedTime();
                            break;
                        }
                        case RUNNING: {
                            l4 = jobHistory.getServerRunningTime();
                            break;
                        }
                        case COMPLETED: 
                        case FAILED: 
                        case ERROR: 
                        case CANCELED: {
                            l4 = jobHistory.getServerEndedTime();
                            break;
                        }
                        default: {
                            l4 = 0L;
                        }
                    }
                    this.updateMemberStatus(l2, memberStatus, l4, l3, l, jobHistory);
                    jobSuiteStatus = this.updateSuiteStatus(l, jobHistory, null);
                } else {
                    memberStatus = this.calculateMemberStatus(l2);
                    MemberStatus memberStatus3 = this.jobSuiteDM.getMemberStatus(l2);
                    if (memberStatus3 != memberStatus) {
                        l4 = 0L;
                        l3 = 0L;
                        this.updateMemberStatus(l2, memberStatus, l4, l3, l, jobHistory);
                        jobSuiteStatus = this.updateSuiteStatus(l, jobHistory, null);
                    }
                    if (memberStatus == MemberStatus.COMPLETED && memberStatus3 == MemberStatus.COMPLETED) {
                        bl = true;
                    }
                    if (memberStatus == MemberStatus.FAILED && memberStatus3 == MemberStatus.FAILED) {
                        bl2 = true;
                    }
                }
            }
            catch (Exception exception) {
                RosettaMsg rosettaMsg = RosettaMsg.SUITE_MEMBER_STATUS_CHANGE_ERROR;
                String[] stringArray = new String[]{jobHistory.getJobName(), jobHistory.getAgentName(), jobHistory.getStatusCode().toString(), this.getSuiteName(l), Long.toString(l)};
                this.writeToDiagnosticLog(rosettaMsg, stringArray, exception);
                this.writeToScheduleLog(rosettaMsg, stringArray, jobHistory);
                return;
            }
            catch (Error error) {
                try {
                    String string = MessageUtil.formatMsg((String)"Unable to process the member status change notification for job suite instance {0}, due to a severe system error.", (Object[])new Object[]{l});
                    logger.fatal((Object)string, (Throwable)error);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw error;
            }
            try {
                if (jobSuiteStatus == null) {
                    jobSuiteStatus = this.jobSuiteDM.getSuiteStatus(l);
                }
                if (!(memberStatus != MemberStatus.COMPLETED && memberStatus != MemberStatus.FAILED || jobSuiteStatus.isTerminalState() || bl || bl2)) {
                    this.memberReactivity(l2, l);
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("unhandled exception", exception);
            }
            catch (Error error) {
                try {
                    String string = MessageUtil.formatMsg((String)"Unable to perform internal member reactivity for job suite instance {0}, due to a severe system error.", (Object[])new Object[]{l});
                    logger.fatal((Object)string, (Throwable)error);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw error;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSuite(long l, JobSuiteStatus jobSuiteStatus, String string, boolean bl) throws ActionFailedException {
        String string2;
        JobHistory jobHistory = null;
        Object object = this.statusChangeLock;
        synchronized (object) {
            try {
                jobHistory = this.jobSuiteDM.getSuiteHistory(l);
            }
            catch (NoDataException noDataException) {
                String string3 = MessageUtil.formatMsg((String)"Can no longer find the history information for the suite with run number {0}.", (Object[])new Object[]{l});
                throw new ActionFailedException(string3);
            }
            catch (Exception exception) {
                String string4 = MessageUtil.formatMsg((String)"Error while trying to read the history information for the suite with run number {0}.", (Object[])new Object[]{l});
                logger.error((Object)string4, (Throwable)exception);
                throw new ActionFailedException(string4 + " " + this.nestedMsgText(exception));
            }
            string2 = jobHistory.getJobName();
            long l2 = jobHistory.getJobID();
            long l3 = System.currentTimeMillis();
            JobSuiteStatus jobSuiteStatus2 = this.getSuiteStatus(jobHistory);
            this.validateStatusTransition(jobSuiteStatus2, jobSuiteStatus, string2, l);
            try {
                String[] stringArray;
                JobEndedReasonCode jobEndedReasonCode = JobEndedReasonCode.ENDED_MANUALLY;
                RosettaMsg rosettaMsg = RosettaMsg.SUITE_ENDED_BY_USER;
                String[] stringArray2 = new String[]{string2, Long.toString(l), ScheduleLogger.formatTimeStamp((long)l3), string, jobSuiteStatus.toString()};
                if (bl) {
                    jobEndedReasonCode = JobEndedReasonCode.JOB_MONITOR_ACTION;
                    rosettaMsg = RosettaMsg.SUITE_ENDED_BY_JOB_MONITOR;
                    stringArray = new String[]{string2, Long.toString(l), ScheduleLogger.formatTimeStamp((long)l3)};
                    stringArray2 = stringArray;
                }
                this.jobSuiteDM.updateSuiteStatus(l, jobSuiteStatus, jobEndedReasonCode, l3);
                stringArray = rosettaMsg.newLogEntryForSuite(stringArray2, l2, l);
                ScheduleLogger.write((ScheduleLogEntry)stringArray);
                JobHistory jobHistory2 = this.jobSuiteDM.getSuiteHistory(l);
                if (jobHistory2.getReactCode() == JobReactCode.PERFORM_REACTIVITY && this.isTriggerReactivity(jobSuiteStatus2, jobSuiteStatus)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Triggering Suite reactivity (terminateSuite) - Suite Instance: " + l + " Job History ID: " + jobHistory2.getId() + " Current Status: " + jobSuiteStatus2 + " Status To Use: " + jobSuiteStatus));
                    }
                    this.reactivityAM.notifyJobStatusChange(jobHistory2);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not Triggering Suite reactivity (terminateSuite) - Suite Instance: " + l + " Current Status: " + jobSuiteStatus2 + " Status To Use: " + jobSuiteStatus));
                }
                this.jobTrackerAM.notifyOfJobSuiteStatus(jobHistory2, jobSuiteStatus, stringArray.getMessageText());
            }
            catch (Exception exception) {
                String string5 = MessageUtil.formatMsg((String)"Suite {0} with run number {1} was not ended, due to an error.", (Object[])new Object[]{string2, l});
                logger.error((Object)string5, (Throwable)exception);
                throw new ActionFailedException(string5 + " " + this.nestedMsgText(exception));
            }
            try {
                long l4 = jobHistory.getId();
                if (bl) {
                    this.jobMonitorManagerAM.jobWasTerminated(l4);
                } else {
                    this.jobMonitorManagerAM.jobHasCompleted(jobHistory, true);
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Error notifying job monitors of terminated job suite with run history ID " + jobHistory.getId()), (Throwable)exception);
            }
        }
        if (jobSuiteStatus == JobSuiteStatus.FAILED) {
            this.holdFailedSuite(jobHistory);
        }
        try {
            object = JobStatusCode.persistanceCodeToEnum((String)jobSuiteStatus.persistanceCode());
            this.terminateMembers(l, (JobStatusCode)object, string);
        }
        catch (Exception exception) {
            string2 = MessageUtil.formatMsg((String)"A error occurred while trying to end the active members that are part of Suite {0} with run number {1}.", (Object[])new Object[]{this.getSuiteName(l), l});
            logger.error((Object)string2, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateManagedSuite(long l, JobSuiteStatus jobSuiteStatus, String string) throws ActionFailedException {
        Object object = this.statusChangeLock;
        synchronized (object) {
            JobHistory jobHistory;
            try {
                jobHistory = this.jobSuiteDM.getSuiteHistory(l);
            }
            catch (NoDataException noDataException) {
                String string2 = MessageUtil.formatMsg((String)"Can no longer find the history information for the suite with run number {0}.", (Object[])new Object[]{l});
                throw new ActionFailedException(string2);
            }
            catch (Exception exception) {
                String string3 = MessageUtil.formatMsg((String)"Error while trying to read the history information for the suite with run number {0}.", (Object[])new Object[]{l});
                logger.error((Object)string3, (Throwable)exception);
                throw new ActionFailedException(string3 + " " + this.nestedMsgText(exception));
            }
            String string4 = jobHistory.getJobName();
            long l2 = jobHistory.getJobID();
            long l3 = System.currentTimeMillis();
            JobSuiteStatus jobSuiteStatus2 = this.getSuiteStatus(jobHistory);
            if (jobSuiteStatus2 != JobSuiteStatus.MANAGED) {
                String string5 = MessageUtil.formatMsg((String)"Suite {0} with run number {1} was not ended because the status is no longer MANAGED. It has changed to {2}.", (Object[])new Object[]{string4, l, jobSuiteStatus2});
                throw new ActionFailedException(string5);
            }
            try {
                this.jobSuiteDM.updateSuiteStatus(l, jobSuiteStatus, JobEndedReasonCode.MANAGED_JOB_ACTION, l3);
                RosettaMsg rosettaMsg = RosettaMsg.MANAGED_SUITE_ENDED_BY_USER;
                String[] stringArray = new String[]{string4, Long.toString(l), ScheduleLogger.formatTimeStamp((long)l3), string, jobSuiteStatus.toString()};
                ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntryForSuite(stringArray, l2, l);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                JobHistory jobHistory2 = this.jobSuiteDM.getSuiteHistory(l);
                if (jobHistory2.getReactCode() == JobReactCode.PERFORM_REACTIVITY && this.isTriggerReactivity(jobSuiteStatus2, jobSuiteStatus)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Triggering Suite reactivity (terminateManagedSuite) - Suite Instance: " + l + " Job History ID: " + jobHistory2.getId() + " Current Status: " + jobSuiteStatus2 + " Status To Use: " + jobSuiteStatus));
                    }
                    this.reactivityAM.notifyJobStatusChange(jobHistory2);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not Triggering Suite reactivity (terminateManagedSuite) - Suite Instance: " + l + " Current Status: " + jobSuiteStatus2 + " Status To Use: " + jobSuiteStatus));
                }
            }
            catch (Exception exception) {
                String string6 = MessageUtil.formatMsg((String)"Suite {0} with run number {1} was not ended, due to an error.", (Object[])new Object[]{string4, l});
                logger.error((Object)string6, (Throwable)exception);
                throw new ActionFailedException(string6 + " " + this.nestedMsgText(exception));
            }
            if (jobSuiteStatus == JobSuiteStatus.FAILED) {
                this.holdFailedSuite(jobHistory);
            }
            this.activityMatcherAM.suiteManaged_Ended(l);
        }
    }

    private MemberStatus calculateMemberStatus(long l) throws ResourceUnavailableException {
        Set set = this.jobSuiteDM.getMemberStatusesFromHistory(l);
        if (set.isEmpty()) {
            return MemberStatus.COMPLETED;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        block6: for (JobStatusCode jobStatusCode : set) {
            switch (jobStatusCode) {
                case CANCELED: {
                    bl = true;
                    continue block6;
                }
                case ERROR: {
                    bl2 = true;
                    continue block6;
                }
                case FAILED: {
                    bl3 = true;
                    continue block6;
                }
                case SUBMITTED: 
                case RUNNING: 
                case CONDITION_CHECK: 
                case CONDITION_RETRY_WAIT: 
                case INITIATED: {
                    bl4 = true;
                    continue block6;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Status {0} is not supported by this method.", (Object[])new Object[]{jobStatusCode}));
        }
        MemberStatus memberStatus = bl ? (bl4 ? MemberStatus.AGENT_CANCELED : MemberStatus.CANCELED) : (bl2 ? (bl4 ? MemberStatus.AGENT_ERROR : MemberStatus.ERROR) : (bl3 ? (bl4 ? MemberStatus.AGENT_FAILED : MemberStatus.FAILED) : MemberStatus.RUNNING));
        return memberStatus;
    }

    private JobSuiteStatus calculateSuiteStatus(long l) throws ResourceUnavailableException {
        Set set = this.jobSuiteDM.getMemberStatuses(l);
        if (set.isEmpty()) {
            JobSuiteStatus jobSuiteStatus = this.jobSuiteDM.getSuiteStatus(l);
            if (jobSuiteStatus == JobSuiteStatus.INITIATED) {
                return JobSuiteStatus.RUNNING;
            }
            return JobSuiteStatus.COMPLETED;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        block7: for (MemberStatus memberStatus : set) {
            switch (memberStatus) {
                case CANCELED: {
                    bl = true;
                    continue block7;
                }
                case FAILED: 
                case ERROR: {
                    bl2 = true;
                    continue block7;
                }
                case RUNNING: 
                case AGENT_CANCELED: 
                case AGENT_ERROR: 
                case AGENT_FAILED: 
                case INITIATED: {
                    bl3 = true;
                    continue block7;
                }
                case BLANK: {
                    bl4 = true;
                    continue block7;
                }
                case COMPLETED: 
                case SKIPPED: 
                case WILL_NOT_RUN: {
                    continue block7;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Member Status {0} is not supported by this method.", (Object[])new Object[]{memberStatus}));
        }
        JobSuiteStatus jobSuiteStatus = bl ? (bl3 || bl4 ? JobSuiteStatus.MEMBER_CANCELED : JobSuiteStatus.CANCELED) : (bl2 ? (bl3 || bl4 ? JobSuiteStatus.MEMBER_FAILED : JobSuiteStatus.FAILED) : (bl3 || bl4 ? JobSuiteStatus.RUNNING : JobSuiteStatus.COMPLETED));
        return jobSuiteStatus;
    }

    private boolean checkTimeRange(JobHistory jobHistory, ScheduleJobProxy scheduleJobProxy) {
        TimeZone timeZone = this.timezone(jobHistory);
        boolean bl = this.isAllowedTimeRange(scheduleJobProxy.getTimeRangeStart(), scheduleJobProxy.getTimeRangeEnd(), timeZone);
        if (!bl) {
            jobHistory.setStatusCode(JobStatusCode.CANCELED);
            jobHistory.setJobEndedReasonCode(JobEndedReasonCode.TIME_RANGE_VIOLATION);
            String string = String.valueOf(jobHistory.getId());
            String[] stringArray = new String[]{jobHistory.getJobName(), string};
            try {
                this.jobTrackerAM.getJobHistoryDM().save(jobHistory);
            }
            catch (Exception exception) {
                logger.error((Object)"Error updating job history for suite submitted during excluded run time range.", (Throwable)exception);
            }
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_CANCELED_DUE_TO_TIMERANGE.newLogEntry(stringArray);
            scheduleLogEntry.setAgentID(jobHistory.getAgentID());
            scheduleLogEntry.setJobID(jobHistory.getJobID());
            scheduleLogEntry.setJobHistoryID(jobHistory.getId());
            logger.info((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        }
        return bl;
    }

    private void clearAnyWillNotRunStatusesDownstreamFromThisMember(long l) {
        try {
            List list = this.jobSuiteDM.getDependentMemberIDsAndTypes(l);
            for (DependentMemberIDAndType dependentMemberIDAndType : list) {
                long l2 = dependentMemberIDAndType.getId();
                DependentMember dependentMember = this.jobSuiteDM.getDependentMember(l2);
                if (dependentMember.getMemberStatus() != MemberStatus.WILL_NOT_RUN) continue;
                this.clearTheWillNotRunStatus(l2);
                this.clearAnyWillNotRunStatusesDownstreamFromThisMember(l2);
            }
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"The suite member with instance ID {0} has been restarted (or manually changed to Completed status). However, an error occurred while trying to clear any 'will not run' statuses on the members dependent on that member. This may cause the restarted suite that contains that member to end prematurely.", (Object[])new Object[]{l});
            logger.error((Object)string, (Throwable)exception);
        }
    }

    private void clearTheWillNotRunStatus(long l) throws NotSavedException, ResourceUnavailableException {
        this.jobSuiteDM.updateMemberStatusToNull(l);
    }

    private String constructBadDataDetails(ErrorList errorList) {
        String string = "";
        if (errorList != null) {
            string = string + " Details:";
            while (errorList.nextError()) {
                string = string + " " + errorList.getErrorText();
            }
        }
        return string;
    }

    private int createInstanceTables(long l, long l2) throws ResourceUnavailableException {
        Map map = this.jobSuiteDM.createMemberStatusRecordsForSuiteInstance(l, l2);
        if (map.size() > 0) {
            this.jobSuiteDM.createDependencyRecordsForSuiteInstance(l, l2, map);
        }
        return map.size();
    }

    private JobHistory createJobHistory(long l, String string, Date date, Calendar calendar, ScheduleInfo.TimeZoneType timeZoneType, String string2) {
        JobHistory jobHistory = new JobHistory();
        jobHistory.setJobID(l);
        jobHistory.setJobName(string);
        jobHistory.setJobSuiteID(l);
        jobHistory.setServerInitiatedTime(date.getTime());
        jobHistory.setTimezoneType(timeZoneType.persistanceCode());
        jobHistory.setJobTimezone(string2);
        long l2 = this.forecastAM.runDuration(jobHistory.getJobID(), 0L);
        jobHistory.setEstimatedRuntime(l2);
        if (calendar != null) {
            jobHistory.setScheduledTime(calendar.getTimeInMillis());
            if (calendar instanceof MovedNST) {
                MovedNST movedNST = (MovedNST)calendar;
                jobHistory.setMovedFromScheduledDateTime(movedNST.getOriginalDateTimeYYYYMMDDHHMM());
            }
        } else {
            jobHistory.setScheduledTime(date.getTime());
        }
        return jobHistory;
    }

    private JobHistory createSuiteHistoryRecord(long l, String string, Date date, Calendar calendar, JobInitCode jobInitCode, String string2, boolean bl, String string3, ScheduleInfo.TimeZoneType timeZoneType, String string4) throws ResourceUnavailableException {
        JobHistory jobHistory = this.createJobHistory(l, string, date, calendar, timeZoneType, string4);
        jobHistory.setInitiationCode(jobInitCode);
        if (string2 != null) {
            jobHistory.setInitiationData(string2);
        }
        if (bl) {
            jobHistory.setMissedCode(JobMissedCode.MISSED);
        }
        jobHistory.setDefaultSuiteParameters(string3);
        jobHistory = this.jobSuiteDM.createSuiteHistoryRecord(jobHistory);
        jobHistory.setJobSuiteHistoryID(jobHistory.getId());
        try {
            this.jobSuiteDM.populateSuiteHistoryID(jobHistory.getId());
        }
        catch (NotSavedException notSavedException) {
            logger.error((Object)"", (Throwable)notSavedException);
        }
        return jobHistory;
    }

    private SuiteInfo createSuiteInfo(long l) throws ResourceUnavailableException {
        try {
            JobHistory jobHistory = this.jobSuiteDM.getSuiteHistory(l);
            boolean bl = jobHistory.getReactCode() == JobReactCode.PERFORM_REACTIVITY;
            return new SuiteInfo(jobHistory.getJobID(), jobHistory.getJobName(), bl, jobHistory.getBypassJobMonitors(), jobHistory.getScheduledTime(), jobHistory.getTimezoneType(), jobHistory.getJobTimezone(), jobHistory.getJobParameters());
        }
        catch (DataException dataException) {
            logger.error((Object)"Error creating suite info.", (Throwable)dataException);
            return new SuiteInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failTheMemberAsERROR(long l, long l2, long l3) {
        long l4 = 0L;
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.updateMemberStatus(l, MemberStatus.ERROR, l3, l4, l2, null);
            this.updateSuiteStatus(l2, null, l3);
        }
    }

    private void flagWillNotRunDependentMembers(long l, MemberStatus memberStatus) {
        try {
            if (memberStatus.isFinal()) {
                List list = this.jobSuiteDM.getDependentMemberIDsAndTypes(l);
                for (DependentMemberIDAndType dependentMemberIDAndType : list) {
                    MemberRequiredPrereqs memberRequiredPrereqs;
                    long l2;
                    DependentMember dependentMember;
                    MemberDependencyType memberDependencyType = dependentMemberIDAndType.getDependencyType();
                    if (!this.isLinkCannotBeSatisfied(memberDependencyType, memberStatus) || (dependentMember = this.jobSuiteDM.getDependentMember(l2 = dependentMemberIDAndType.getId())).getMemberStatus() != MemberStatus.BLANK || (memberRequiredPrereqs = dependentMember.getRequiredPrereqs()) != MemberRequiredPrereqs.ALL && !this.isMemberWillNotRun(l2)) continue;
                    this.flagMemberAsWillNotRun(l2);
                    this.flagWillNotRunDependentMembers(l2, MemberStatus.WILL_NOT_RUN);
                }
            }
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"An error occurred while trying to find and flag any member that we know will not run, as a result of the status change of the member with instance ID {0} to {1}. It is possible that there is nothing that has to be flagged. However, if there was something to be flagged, this error could interfere with the determination of what the suite status should be, after the member status change.", (Object[])new Object[]{l, memberStatus});
            logger.error((Object)string, (Throwable)exception);
        }
    }

    private boolean isLinkCannotBeSatisfied(MemberDependencyType memberDependencyType, MemberStatus memberStatus) {
        boolean bl = false;
        if (memberStatus.isFinal()) {
            switch (memberStatus) {
                case COMPLETED: 
                case SKIPPED: {
                    if (memberDependencyType != MemberDependencyType.FAILED) break;
                    bl = true;
                    break;
                }
                case FAILED: {
                    if (memberDependencyType != MemberDependencyType.COMPLETED) break;
                    bl = true;
                    break;
                }
                case CANCELED: 
                case ERROR: 
                case WILL_NOT_RUN: {
                    bl = true;
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Member Status {0} is not supported by this method.", (Object[])new Object[]{memberStatus}));
                }
            }
        }
        return bl;
    }

    private void flagMemberAsWillNotRun(long l) throws NotSavedException, ResourceUnavailableException {
        long l2 = System.currentTimeMillis();
        this.jobSuiteDM.updateMemberStatusToWillNotRun(l, l2);
    }

    private long getSuiteEndedTime(long l) {
        try {
            JobHistory jobHistory = this.jobSuiteDM.getSuiteHistory(l);
            return jobHistory.getServerEndedTime();
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve the server ended time for the suite with run number {0}.", (Object[])new Object[]{l}));
        }
    }

    private String getSuiteName(long l) {
        try {
            return this.jobSuiteDM.getSuiteNameFromHistory(l);
        }
        catch (Exception exception) {
            return "?";
        }
    }

    private JobSuiteStatus getSuiteStatus(JobHistory jobHistory) {
        JobStatusCode jobStatusCode = jobHistory.getStatusCode();
        return JobSuiteStatus.persistanceCodeToEnum((String)jobStatusCode.persistanceCode());
    }

    private Long[] identifyDependentMemberInstancesEligibleToSubmit(long l) throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        List list = this.jobSuiteDM.getDependentMemberIDsAndTypes(l);
        block5: for (DependentMemberIDAndType dependentMemberIDAndType : list) {
            if (!this.isDependencyPathSatisfied(l, dependentMemberIDAndType.getDependencyType())) continue;
            long l2 = dependentMemberIDAndType.getId();
            MemberRequiredPrereqs memberRequiredPrereqs = this.jobSuiteDM.getDependentMember(l2).getRequiredPrereqs();
            switch (memberRequiredPrereqs) {
                case ANY: {
                    arrayList.add(l2);
                    continue block5;
                }
                case FIRST: {
                    MemberStatus memberStatus = this.jobSuiteDM.getMemberStatus(l2);
                    if (memberStatus != MemberStatus.BLANK) continue block5;
                    arrayList.add(dependentMemberIDAndType.getId());
                    continue block5;
                }
                case ALL: {
                    MemberStatus memberStatus;
                    List list2 = this.jobSuiteDM.getPrerequisiteMemberIDsAndTypes(l2);
                    boolean bl = true;
                    for (PrereqMemberIDAndType prereqMemberIDAndType : list2) {
                        if (this.isDependencyPathSatisfied(prereqMemberIDAndType.getId(), prereqMemberIDAndType.getDependencyType())) continue;
                        bl = false;
                        break;
                    }
                    if (!bl || (memberStatus = this.jobSuiteDM.getMemberStatus(l2)) != MemberStatus.BLANK) continue block5;
                    arrayList.add(dependentMemberIDAndType.getId());
                    continue block5;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Member Required Prereqs {0} is not supported by this method.", (Object[])new Object[]{memberRequiredPrereqs}));
        }
        return arrayList.toArray(new Long[arrayList.size()]);
    }

    private boolean isAllowedTimeRange(int n, int n2, TimeZone timeZone) {
        logger.debug((Object)MessageUtil.formatMsg((String)"Selected time range = {0} to {1} using {2}.", (Object[])new Object[]{n, n2, timeZone.getID()}));
        if (n == n2) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTimeInMillis(System.currentTimeMillis());
        int n3 = n / 100;
        int n4 = n - n3 * 100;
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(11, n3);
        calendar2.set(12, n4);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        int n5 = n2 / 100;
        int n6 = n2 - n5 * 100;
        Calendar calendar3 = (Calendar)calendar.clone();
        calendar3.set(11, n5);
        calendar3.set(12, n6);
        calendar3.set(13, 59);
        calendar3.set(14, 999);
        String string = "Exception Schedule: " + ScheduleLogger.formatTimeStampTZ((Calendar)calendar) + " between " + ScheduleLogger.formatTimeStampTZ((Calendar)calendar2) + " and " + ScheduleLogger.formatTimeStampTZ((Calendar)calendar3) + "?";
        logger.debug((Object)string);
        if (!this.isValidTimeRange(n3, n4, n5, n6)) {
            logger.error((Object)("Invalid time range of " + n + " to " + n2 + ".  Time range will be ignored."));
            return false;
        }
        return n2 < n ? calendar.getTimeInMillis() == calendar2.getTimeInMillis() || calendar.after(calendar2) || calendar.before(calendar3) : (calendar.getTimeInMillis() == calendar2.getTimeInMillis() || calendar.after(calendar2)) && calendar.before(calendar3);
    }

    private boolean isDependencyPathSatisfied(long l, MemberDependencyType memberDependencyType) throws ResourceUnavailableException {
        MemberStatus[] memberStatusArray = new MemberStatus[]{MemberStatus.BLANK, MemberStatus.INITIATED, MemberStatus.RUNNING, MemberStatus.COMPLETED, MemberStatus.AGENT_FAILED, MemberStatus.FAILED, MemberStatus.AGENT_CANCELED, MemberStatus.CANCELED, MemberStatus.AGENT_ERROR, MemberStatus.ERROR, MemberStatus.SKIPPED, MemberStatus.WILL_NOT_RUN};
        MemberStatus.validateKnownValues((MemberStatus[])memberStatusArray);
        MemberStatus memberStatus = this.jobSuiteDM.getMemberStatus(l);
        switch (memberDependencyType) {
            case COMPLETED: {
                return memberStatus == MemberStatus.COMPLETED || memberStatus == MemberStatus.SKIPPED;
            }
            case FAILED: {
                return memberStatus == MemberStatus.FAILED;
            }
            case COMPLETED_OR_FAILED: {
                return memberStatus == MemberStatus.COMPLETED || memberStatus == MemberStatus.SKIPPED || memberStatus == MemberStatus.FAILED;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Member Dependency Type {0} is not supported by this method.", (Object[])new Object[]{memberDependencyType}));
    }

    private boolean isMemberStatusChangeAllowed(JobHistory jobHistory, long l) {
        if (this.isSuiteWasEndedManuallyOrByJobMonitor(l)) {
            if (jobHistory.getJobEndedReasonCode() == JobEndedReasonCode.PARENT_SUITE_ENDED) {
                return true;
            }
            if (jobHistory == null) {
                return false;
            }
            long l2 = this.getSuiteEndedTime(l);
            return this.isMemberWasRestartedAfterSuiteEnded(jobHistory, l2) || this.isMemberWasManuallyChangedToCompleted(jobHistory);
        }
        return true;
    }

    private boolean isMemberStatusChangeAllowedToAffectTheSuiteStatus(JobHistory jobHistory, JobHistory jobHistory2, Long l) {
        if (jobHistory2 == null && l == null) {
            throw new IllegalStateException("Program error: This method has been called when no member status change has occurred.");
        }
        if (jobHistory2 != null && l != null) {
            throw new IllegalStateException("Program error: It is invalid to pass in both a timestamp and a member job history.");
        }
        if (this.isSuiteWasEndedManuallyOrByJobMonitor(jobHistory)) {
            if (l != null) {
                return false;
            }
            long l2 = jobHistory.getServerEndedTime();
            return this.isMemberWasRestartedAfterSuiteEnded(jobHistory2, l2) || this.isMemberWasManuallyChangedToCompleted(jobHistory2);
        }
        return true;
    }

    private boolean isMemberWasManuallyChangedToCompleted(JobHistory jobHistory) {
        return jobHistory.getJobEndedReasonCode() == JobEndedReasonCode.ENDED_MANUALLY && jobHistory.getStatusCode() == JobStatusCode.COMPLETED;
    }

    private boolean isMemberWasRestartedAfterSuiteEnded(JobHistory jobHistory, long l) {
        boolean bl = jobHistory.getRestartParentHistoryID() > 0L;
        long l2 = jobHistory.getServerInitiatedTime();
        return bl && l2 > l;
    }

    private boolean isMemberWillNotRun(long l) throws ResourceUnavailableException {
        List list = this.jobSuiteDM.getPrerequisiteMemberIDsAndTypes(l);
        for (PrereqMemberIDAndType prereqMemberIDAndType : list) {
            MemberStatus memberStatus = this.jobSuiteDM.getMemberStatus(prereqMemberIDAndType.getId());
            if (this.isLinkCannotBeSatisfied(prereqMemberIDAndType.getDependencyType(), memberStatus)) continue;
            return false;
        }
        return true;
    }

    private boolean isRestart(JobSuiteStatus jobSuiteStatus, JobSuiteStatus jobSuiteStatus2) {
        boolean bl;
        boolean bl2 = jobSuiteStatus.isTerminalState() && !jobSuiteStatus2.isTerminalState();
        boolean bl3 = bl = jobSuiteStatus2 == JobSuiteStatus.RUNNING || jobSuiteStatus2 == JobSuiteStatus.MEMBER_CANCELED || jobSuiteStatus2 == JobSuiteStatus.MEMBER_FAILED;
        if (bl2 && !bl) {
            logger.info((Object)MessageUtil.formatMsg((String)"Unexpected suite restart status. Was {0}, now {1}.", (Object[])new Object[]{jobSuiteStatus, jobSuiteStatus2}));
        }
        return bl2;
    }

    private boolean isSuiteStillThinksThatThereAreRunningMembers(long l) throws ResourceUnavailableException {
        Set set = this.jobSuiteDM.getMemberStatuses(l);
        return set.contains(MemberStatus.RUNNING) || set.contains(MemberStatus.INITIATED) || set.contains(MemberStatus.AGENT_CANCELED) || set.contains(MemberStatus.AGENT_ERROR) || set.contains(MemberStatus.AGENT_FAILED);
    }

    private boolean isSuiteWasEndedManuallyOrByJobMonitor(JobHistory jobHistory) {
        return jobHistory.getJobEndedReasonCode() == JobEndedReasonCode.ENDED_MANUALLY || jobHistory.getJobEndedReasonCode() == JobEndedReasonCode.JOB_MONITOR_ACTION;
    }

    private boolean isSuiteWasEndedManuallyOrByJobMonitor(long l) {
        try {
            JobEndedReasonCode jobEndedReasonCode = this.jobSuiteDM.getSuiteEndedReasonCode(l);
            return jobEndedReasonCode != null && (jobEndedReasonCode == JobEndedReasonCode.ENDED_MANUALLY || jobEndedReasonCode == JobEndedReasonCode.JOB_MONITOR_ACTION);
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to determine if the suite with run number {0} was ended manaully.", (Object[])new Object[]{l}));
        }
    }

    private boolean isTriggerReactivity(JobSuiteStatus jobSuiteStatus, JobSuiteStatus jobSuiteStatus2) {
        switch (jobSuiteStatus2) {
            case RUNNING: {
                return jobSuiteStatus == JobSuiteStatus.INITIATED;
            }
            case COMPLETED: 
            case FAILED: 
            case CANCELED: {
                return true;
            }
            case MEMBER_FAILED: 
            case MEMBER_CANCELED: {
                return false;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Suite Status {0} is not supported by this method.", (Object[])new Object[]{jobSuiteStatus2}));
    }

    private boolean isUpdateSuiteStatusAllowed(JobSuiteStatus jobSuiteStatus, JobSuiteStatus jobSuiteStatus2, long l) {
        if (jobSuiteStatus == JobSuiteStatus.COMPLETED) {
            logger.error((Object)MessageUtil.formatMsg((String)"An attempt was made to change the suite with run number {0} from status {1} to {2}.", (Object[])new Object[]{l, jobSuiteStatus, jobSuiteStatus2}));
            return false;
        }
        return true;
    }

    private boolean isValidTimeRange(int n, int n2, int n3, int n4) {
        if (n < 0 || n3 < 0 || n2 < 0 || n4 < 0) {
            return false;
        }
        return n <= 23 && n3 <= 23 && n2 <= 59 && n4 <= 59;
    }

    private TimeZone jobSpecificTimeZone(SuiteInfo suiteInfo) {
        TimeZone timeZone;
        String string = suiteInfo.getJobTimezone();
        if (string != null && !string.isEmpty()) {
            timeZone = this.timezone(string, suiteInfo.getSuiteName());
        } else {
            timeZone = this.serverTimeZone();
            String string2 = timeZone.getID();
            logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{suiteInfo.getSuiteName(), string2}));
        }
        return timeZone;
    }

    private boolean memberIsBeingRestarted(JobHistory jobHistory) {
        if (jobHistory == null) {
            return false;
        }
        return jobHistory.getRestartParentHistoryID() > 0L || this.isMemberWasManuallyChangedToCompleted(jobHistory);
    }

    private void memberReactivity(long l, long l2) throws ResourceUnavailableException {
        Long[] longArray;
        Long[] longArray2 = longArray = this.identifyDependentMemberInstancesEligibleToSubmit(l);
        int n = longArray2.length;
        for (int i = 0; i < n; ++i) {
            long l3;
            long l4 = longArray2[i];
            JobSuiteInstanceMember jobSuiteInstanceMember = null;
            Throwable throwable = null;
            String string = "";
            try {
                jobSuiteInstanceMember = this.jobSuiteDM.getInstanceMember(l4);
            }
            catch (MissingJobDataException missingJobDataException) {
                throwable = missingJobDataException;
                string = MessageUtil.formatMsg((String)"the job data for the member (jobID {0}) is missing.", (Object[])new Object[]{missingJobDataException.getJobID()});
            }
            catch (BadDataException badDataException) {
                throwable = badDataException;
                String string2 = this.constructBadDataDetails(badDataException.getErrorList());
                string = MessageUtil.formatMsg((String)"there is corrupt data associated with this member.{3}", (Object[])new Object[]{string2});
            }
            catch (NoDataException noDataException) {
                throwable = noDataException;
                string = MessageUtil.formatMsg((String)"the member run data is missing.", (Object[])new Object[0]);
            }
            if (throwable != null) {
                logger.error((Object)MessageUtil.formatMsg((String)"Trying to submit member {0} as part of suite {1} with run number {2} but {3} The member will be placed in an ERROR state.", (Object[])new Object[]{l4, this.getSuiteName(l2), l2, string}), throwable);
                this.failTheMemberAsERROR(l4, l2, System.currentTimeMillis());
                return;
            }
            long l5 = l3 = System.currentTimeMillis();
            SuiteInfo suiteInfo = this.createSuiteInfo(l2);
            this.submitMember(jobSuiteInstanceMember, l3, l5, suiteInfo);
        }
    }

    private String nestedMsgText(Exception exception) {
        String string = exception.getMessage();
        for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
            string = string + " " + throwable.getMessage();
        }
        return string;
    }

    private void notifyJobSuiteMonitors(JobHistory jobHistory, JobSuiteStatus jobSuiteStatus) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notifying Job Monitor process of job suite status: " + jobSuiteStatus + " for " + jobHistory.getId() + ":" + jobHistory.getJobName() + " Scheduled at: " + ScheduleLogger.formatTimeStamp((long)jobHistory.getScheduledTime())));
        }
        switch (jobSuiteStatus) {
            case RUNNING: {
                if (jobHistory.isBypassJobMonitors()) break;
                this.jobMonitorManagerAM.jobHasStarted(jobHistory);
                break;
            }
            case COMPLETED: 
            case FAILED: {
                this.jobMonitorManagerAM.jobHasCompleted(jobHistory, true);
                break;
            }
            case SKIPPED: {
                this.jobMonitorManagerAM.jobHasCompleted(jobHistory, false);
                break;
            }
            case CANCELED: {
                if (jobHistory.getServerRunningTime() > 0L) {
                    this.jobMonitorManagerAM.jobHasCompleted(jobHistory, true);
                    break;
                }
                this.jobMonitorManagerAM.jobWasTerminated(jobHistory.getId());
                break;
            }
            case MEMBER_FAILED: 
            case MEMBER_CANCELED: {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Ignoring " + jobSuiteStatus + " status for job history ID: " + jobHistory.getId()));
                break;
            }
            default: {
                logger.warn((Object)("Undefined Job Suite status for monitor notification from job suite " + jobHistory.getJobName() + " with run ID " + jobHistory.getId() + ": " + jobSuiteStatus));
            }
        }
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private void submitAllInitialMembers(long l, SuiteInfo suiteInfo) throws ResourceUnavailableException {
        this.submitAllInitialMembers(l, null, suiteInfo);
    }

    private void submitAllInitialMembers(long l, Calendar calendar, SuiteInfo suiteInfo) throws ResourceUnavailableException {
        List list;
        try {
            list = this.jobSuiteDM.getInitialMembers(l);
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"An error occurred while trying to gather information on the initial members of suite {0}.", (Object[])new Object[]{suiteInfo.getSuiteName()}), exception);
        }
        if (list.isEmpty()) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"There are no initial members for suite {0}.", (Object[])new Object[]{suiteInfo.getSuiteName()}));
        }
        long l2 = System.currentTimeMillis();
        long l3 = calendar != null ? calendar.getTimeInMillis() : l2;
        block6: for (JobSuiteInstanceMember jobSuiteInstanceMember : list) {
            JobSuiteMember.MemberType memberType = jobSuiteInstanceMember.getMemberType();
            switch (memberType) {
                case JOB: {
                    this.submitMember(jobSuiteInstanceMember, l2, l3, suiteInfo);
                    continue block6;
                }
                case SUITE: {
                    throw new IllegalStateException("Program error: Nested Suites are not supported.");
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Suite Member Type {0} is not supported by this method.", (Object[])new Object[]{memberType}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitMember(JobSuiteInstanceMember jobSuiteInstanceMember, long l, long l2, SuiteInfo suiteInfo) throws ResourceUnavailableException {
        block15: {
            long l3 = jobSuiteInstanceMember.getMemberInstanceID();
            long l4 = jobSuiteInstanceMember.getSuiteInstanceID();
            try {
                SkippedMemberInfo skippedMemberInfo = this.isSuiteMemberSkipped(jobSuiteInstanceMember, suiteInfo, l2);
                if (skippedMemberInfo.skipped) {
                    JobHistory jobHistory = this.jobTrackerAM.skipJobSuiteMember(jobSuiteInstanceMember, l, l2, suiteInfo, skippedMemberInfo.message);
                    skippedMemberInfo.updateScheduleLogger(jobHistory);
                    long l5 = 0L;
                    Object object = this.statusChangeLock;
                    synchronized (object) {
                        this.updateMemberStatus(l3, MemberStatus.SKIPPED, l, l5, l4, null);
                        JobSuiteStatus jobSuiteStatus = this.updateSuiteStatus(l4, null, l);
                        if (!jobSuiteStatus.isTerminalState()) {
                            this.memberReactivity(l3, l4);
                        }
                        break block15;
                    }
                }
                this.jobSuiteDM.updateMemberStatusToInitiated(l3, l);
                int n = this.jobTrackerAM.submitJobSuiteMember(jobSuiteInstanceMember, l, l2, suiteInfo);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        long l6 = 0L;
                        Object object = this.statusChangeLock;
                        synchronized (object) {
                            this.updateMemberStatus(l3, MemberStatus.COMPLETED, l, l6, l4, null);
                            JobSuiteStatus jobSuiteStatus = this.updateSuiteStatus(l4, null, l);
                            if (!jobSuiteStatus.isTerminalState()) {
                                this.memberReactivity(l3, l4);
                            }
                        }
                        object = n == 1 ? RosettaMsg.SUITE_MEMBER_AGENT_GROUP_EMPTY : RosettaMsg.SUITE_MEMBER_ALL_AGENTS_IGNORED;
                        String[] stringArray = new String[]{jobSuiteInstanceMember.getName(), suiteInfo.getSuiteName(), Long.toString(l4), this.getAgentGroupName(jobSuiteInstanceMember.getTargetID())};
                        long l7 = 0L;
                        long l8 = 0L;
                        ScheduleLogEntry scheduleLogEntry = object.newLogEntry(stringArray, l8, jobSuiteInstanceMember.getJobID(), l7, suiteInfo.getSuiteID(), l4);
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Result code {0} is not supported by this method.", (Object[])new Object[]{n}));
                    }
                }
            }
            catch (Exception exception) {
                RosettaMsg rosettaMsg = RosettaMsg.SUITE_MEMBER_SUBMIT_ERROR;
                String[] stringArray = new String[]{jobSuiteInstanceMember.getName(), suiteInfo.getSuiteName(), Long.toString(l4)};
                long l9 = 0L;
                long l10 = 0L;
                ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, l10, jobSuiteInstanceMember.getJobID(), l9, suiteInfo.getSuiteID(), l4);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.error((Object)scheduleLogEntry.getMessageText(), (Throwable)exception);
                this.failTheMemberAsERROR(l3, l4, l);
            }
        }
    }

    private int terminateMembers(long l, JobStatusCode jobStatusCode, String string) throws ResourceUnavailableException {
        long l2;
        int n;
        Long[] longArray = this.jobSuiteDM.getActiveMembers(l);
        int n2 = 0;
        Long[] longArray2 = longArray;
        int n3 = longArray2.length;
        for (n = 0; n < n3; ++n) {
            l2 = longArray2[n];
            try {
                int n4 = this.jobTrackerAM.terminateMember(l2, jobStatusCode, string);
                switch (n4) {
                    case 0: 
                    case 1: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Result code {0} is not supported by this method.", (Object[])new Object[]{n4}));
                    }
                }
                continue;
            }
            catch (NoDataException noDataException) {
                logger.info((Object)"", (Throwable)noDataException);
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to terminate the suite member with run number {0}.", (Object[])new Object[]{l2}), (Throwable)exception);
                if (!(exception instanceof ResourceUnavailableException)) continue;
                throw (ResourceUnavailableException)((Object)exception);
            }
        }
        if (this.isSuiteStillThinksThatThereAreRunningMembers(l)) {
            longArray2 = longArray = this.jobSuiteDM.getActiveMembersPerMemberStatuses(l);
            n3 = longArray2.length;
            for (n = 0; n < n3; ++n) {
                l2 = longArray2[n];
                try {
                    int n5 = this.jobTrackerAM.terminateMember(l2, jobStatusCode, string);
                    switch (n5) {
                        case 0: 
                        case 1: {
                            logger.info((Object)MessageUtil.formatMsg((String)"Unexpected result code from terminateMember.", (Object[])new Object[]{n5}));
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Result code {0} is not supported by this method.", (Object[])new Object[]{n5}));
                        }
                    }
                    continue;
                }
                catch (NoDataException noDataException) {
                    logger.info((Object)"", (Throwable)noDataException);
                    continue;
                }
                catch (Exception exception) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to terminate the suite member with run number {0}.", (Object[])new Object[]{l2}), (Throwable)exception);
                    if (!(exception instanceof ResourceUnavailableException)) continue;
                    throw (ResourceUnavailableException)((Object)exception);
                }
            }
        }
        if (this.isSuiteStillThinksThatThereAreRunningMembers(l)) {
            logger.error((Object)MessageUtil.formatMsg((String)"Program error. Unable to properly terminate all of the active members of the suite with run number {0}.", (Object[])new Object[]{l}));
        }
        return n2;
    }

    private ScheduleInfo.TimeZoneType timezoneType(SuiteInfo suiteInfo) {
        String string = suiteInfo.getTimezoneType();
        String string2 = "";
        if (string != null && !string.isEmpty()) {
            try {
                return ScheduleInfo.TimeZoneType.persistanceCodeToEnum((String)string);
            }
            catch (Exception exception) {
                string2 = MessageUtil.formatMsg((String)"The time zone type code {0} for suite {1} is unrecognized. Code S (SERVER) will be used instead.", (Object[])new Object[]{string, suiteInfo.getSuiteName()});
            }
        } else {
            string2 = MessageUtil.formatMsg((String)"The time zone type code for suite {0} is missing. Code S (SERVER) will be used instead.", (Object[])new Object[]{suiteInfo.getSuiteName()});
        }
        logger.warn((Object)string2);
        return ScheduleInfo.TimeZoneType.SERVER;
    }

    private ScheduleInfo.TimeZoneType timezoneType(JobHistory jobHistory) {
        String string = jobHistory.getTimezoneType();
        String string2 = "";
        if (string != null && !string.isEmpty()) {
            try {
                return ScheduleInfo.TimeZoneType.persistanceCodeToEnum((String)string);
            }
            catch (Exception exception) {
                string2 = MessageUtil.formatMsg((String)"The time zone type code {0} for job {1} is unrecognized. Code S (SERVER) will be used instead.", (Object[])new Object[]{string, jobHistory.getJobName()});
            }
        } else {
            string2 = MessageUtil.formatMsg((String)"The time zone type code for job {0} is missing. Code S (SERVER) will be used instead.", (Object[])new Object[]{jobHistory.getJobName()});
        }
        logger.warn((Object)string2);
        return ScheduleInfo.TimeZoneType.SERVER;
    }

    private TimeZone timezone(String string, String string2) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                timeZone = this.serverTimeZone();
                String string3 = timeZone.getID();
                logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
            }
        }
        catch (Exception exception) {
            timeZone = this.serverTimeZone();
            String string4 = timeZone.getID();
            String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
            logger.error((Object)string5, (Throwable)exception);
        }
        return timeZone;
    }

    private TimeZone timezone(JobHistory jobHistory) {
        TimeZone timeZone;
        ScheduleInfo.TimeZoneType timeZoneType = this.timezoneType(jobHistory);
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case JOB: {
                String string = jobHistory.getJobTimezone();
                timeZone = this.timezone(string, jobHistory.getJobName());
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private SkippedMemberInfo isSuiteMemberSkipped(JobSuiteInstanceMember jobSuiteInstanceMember, SuiteInfo suiteInfo, long l) {
        block25: {
            String[] stringArray;
            String string;
            long l2;
            long l3 = jobSuiteInstanceMember.getMemberID();
            String string2 = jobSuiteInstanceMember.getName();
            JobSuiteMemberJobSkipSpecialInstance[] jobSuiteMemberJobSkipSpecialInstanceArray = null;
            try {
                jobSuiteMemberJobSkipSpecialInstanceArray = this.jobSuiteDM.getSuiteMemberSpecialInstancesToSkip(l3);
            }
            catch (Exception exception) {
                logger.error((Object)("Error retrieving Special Instances to Skip for Suite Member ID " + l3), (Throwable)exception);
            }
            JobSuiteMemberSkipFlag jobSuiteMemberSkipFlag = jobSuiteInstanceMember.getSkipFlag();
            if (jobSuiteMemberSkipFlag == JobSuiteMemberSkipFlag.NOT_SKIPPED && (jobSuiteMemberJobSkipSpecialInstanceArray == null || jobSuiteMemberJobSkipSpecialInstanceArray.length == 0)) {
                return this.getNotSkippedMemberInfo();
            }
            Calendar calendar = Calendar.getInstance();
            if (suiteInfo.getScheduledTime() != 0L) {
                calendar.setTimeInMillis(suiteInfo.getScheduledTime());
            } else {
                calendar.setTimeInMillis(l);
                logger.warn((Object)("Suite scheduled time is not available for skipped member processing. Using Member Scheduled Time for member " + jobSuiteInstanceMember.getName() + " in suite " + suiteInfo.getSuiteName()));
            }
            long l4 = jobSuiteInstanceMember.getJobID();
            long l5 = 0L;
            long l6 = suiteInfo.getSuiteID();
            long l7 = jobSuiteInstanceMember.getSuiteInstanceID();
            String string3 = suiteInfo.getSuiteName();
            ScheduleInfo.TargetType targetType = jobSuiteInstanceMember.getTargetType();
            String string4 = "";
            switch (targetType) {
                case AGENT: {
                    l2 = jobSuiteInstanceMember.getTargetID();
                    string4 = this.getAgentName(l2);
                    string = "agent";
                    break;
                }
                case AGENT_GROUP: {
                    long l8 = jobSuiteInstanceMember.getTargetID();
                    l2 = 0L;
                    string4 = this.getAgentGroupName(l8);
                    string = "agent group";
                    break;
                }
                default: {
                    throw new IllegalStateException("Undefined Target Type: " + targetType);
                }
            }
            if (jobSuiteMemberSkipFlag == JobSuiteMemberSkipFlag.SKIP) {
                String[] stringArray2 = new String[]{string2, string, string4, Long.toString(l7), string3};
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_MEMBER_WAS_SKIPPED_UNTIL_INCLUDED.newLogEntry(stringArray2, l2, l4, l5, l6, l7);
                return this.getSkippedMemberInfo(scheduleLogEntry.getMessageText(), scheduleLogEntry);
            }
            if (jobSuiteMemberSkipFlag == JobSuiteMemberSkipFlag.SKIP_X_TIMES) {
                int n;
                int n2 = jobSuiteInstanceMember.getSkipCount() + 1;
                if (n2 <= (n = jobSuiteInstanceMember.getSkipTimes())) {
                    String[] stringArray3 = new String[]{string2, string, string4, Long.toString(l7), string3, String.valueOf(n2), String.valueOf(n)};
                    ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_MEMBER_WAS_SKIPPED_NTH_TIME.newLogEntry(stringArray3, l2, l4, l5, l6, l7);
                    if (n2 < n) {
                        this.updateSkipCount(jobSuiteInstanceMember, n2);
                    } else {
                        this.releaseSkipSuiteMember(jobSuiteInstanceMember);
                    }
                    return this.getSkippedMemberInfo(scheduleLogEntry.getMessageText(), scheduleLogEntry);
                }
                stringArray = MessageUtil.formatMsg((String)"Releasing suite member {2} that was skipped {0} times and specified to be skipped {1} times.", (Object[])new Object[]{String.valueOf(jobSuiteInstanceMember.getSkipCount()), String.valueOf(n), string2});
                logger.debug((Object)stringArray);
                this.releaseSkipSuiteMember(jobSuiteInstanceMember);
            }
            if (jobSuiteMemberSkipFlag == JobSuiteMemberSkipFlag.SKIP_UNTIL) {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTimeInMillis(jobSuiteInstanceMember.getSkipUntil());
                ScheduleInfo.TimeZoneType timeZoneType = this.timezoneType(suiteInfo);
                if (timeZoneType == ScheduleInfo.TimeZoneType.JOB) {
                    calendar2.set(1, calendar2.get(1));
                    calendar2.setTimeZone(this.jobSpecificTimeZone(suiteInfo));
                    calendar2.getTimeInMillis();
                }
                if (calendar2.after(calendar)) {
                    stringArray = new String[]{string2, string, string4, Long.toString(l7), string3, ScheduleLogger.formatTimeStampTZ((Calendar)calendar2), ScheduleLogger.formatTimeStamp((Calendar)calendar)};
                    ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_MEMBER_WAS_SKIPPED_UNTIL_DATE.newLogEntry(stringArray, l2, l4, l5, l6, l7);
                    return this.getSkippedMemberInfo(scheduleLogEntry.getMessageText(), scheduleLogEntry);
                }
                logger.debug((Object)("Releasing skip until " + ScheduleLogger.formatTimeStamp((Calendar)calendar2) + " settings for suite member " + string2));
                this.releaseSkipSuiteMember(jobSuiteInstanceMember);
            }
            try {
                CalendarObject calendarObject;
                Object object;
                if (jobSuiteMemberJobSkipSpecialInstanceArray == null || jobSuiteMemberJobSkipSpecialInstanceArray.length <= 0) break block25;
                SpecialInstanceDM specialInstanceDM = (SpecialInstanceDM)ManagerRegistry.getManager((String)"ENTERPRISE.SpecialInstanceDM");
                long l9 = 0L;
                ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleJobDM");
                ScheduleJobProxy scheduleJobProxy = scheduleJobDM.getScheduleJobProxy(suiteInfo.getSuiteID());
                long l10 = scheduleJobProxy.getCalendarID();
                try {
                    object = (CalendarObjectDM)ManagerRegistry.getManager((String)"ENTERPRISE.CalendarObjectDM");
                    calendarObject = object.get(l10);
                }
                catch (Exception exception) {
                    String string5 = "Error loading Calendar Object with id " + l10;
                    throw new ResourceUnavailableException(string5, (Throwable)exception);
                }
                object = (Calendar)calendar.clone();
                ScheduleInfo.TimeZoneType timeZoneType = this.timezoneType(suiteInfo);
                if (timeZoneType == ScheduleInfo.TimeZoneType.JOB) {
                    ((Calendar)object).setTimeZone(this.jobSpecificTimeZone(suiteInfo));
                    ((Calendar)object).setTimeInMillis(calendar.getTimeInMillis());
                }
                for (int i = 0; i < jobSuiteMemberJobSkipSpecialInstanceArray.length; ++i) {
                    long l11 = jobSuiteMemberJobSkipSpecialInstanceArray[i].getSpecialInstanceID();
                    try {
                        SpecialInstance specialInstance = specialInstanceDM.get(l11);
                        logger.debug((Object)("Checking special instance against scheduled time (" + calendar.getTimeInMillis() + "): " + ScheduleLogger.formatTimeStamp((Calendar)calendar)));
                        boolean bl = specialInstance.isAcceptedTimestamp((Calendar)object, l9, calendarObject);
                        if ((!bl || !jobSuiteInstanceMember.isSkipMatched()) && (bl || jobSuiteInstanceMember.isSkipMatched())) continue;
                        String[] stringArray4 = new String[]{string2, string, string4, Long.toString(l7), string3, specialInstance.getName(), ScheduleLogger.formatTimeStamp((Calendar)object)};
                        ScheduleLogEntry scheduleLogEntry = RosettaMsg.SUITE_MEMBER_WAS_SKIPPED_BY_SPC_INST.newLogEntry(stringArray4, l2, l4, l5, l6, l7);
                        return this.getSkippedMemberInfo(scheduleLogEntry.getMessageText(), scheduleLogEntry);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error checking skipped special instance id " + l11 + " for suite member job id: " + l3), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Error checking skipped special instances for job member id: " + l3), (Throwable)exception);
            }
        }
        return this.getNotSkippedMemberInfo();
    }

    private String getAgentGroupName(long l) {
        try {
            AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentGroupDM");
            return agentGroupDM.getProxy(l).getName();
        }
        catch (DataException dataException) {
            return "";
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving agent group name for ID: " + l), (Throwable)exception);
            return "";
        }
    }

    private String getAgentName(long l) {
        try {
            AgentDM agentDM = (AgentDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentDM");
            return agentDM.get(l).getName();
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving agent name for ID: " + l), (Throwable)exception);
            return "";
        }
    }

    private void updateSkipCount(JobSuiteInstanceMember jobSuiteInstanceMember, int n) {
        String string = jobSuiteInstanceMember.getName();
        long l = jobSuiteInstanceMember.getMemberID();
        try {
            this.jobSuiteDM.updateSuiteMemberSkipCount(l, n);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = "Error updating skip count for suite member " + string;
            logger.error((Object)string2, (Throwable)resourceUnavailableException);
        }
    }

    private void releaseSkipSuiteMember(JobSuiteInstanceMember jobSuiteInstanceMember) {
        String string = jobSuiteInstanceMember.getName();
        long l = jobSuiteInstanceMember.getMemberID();
        try {
            this.jobSuiteDM.releaseSkippedSuiteMember(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            String string2 = "Error releasing skip settings for suite member " + string;
            logger.error((Object)string2, (Throwable)resourceUnavailableException);
        }
    }

    private void updateMemberStatus(long l, MemberStatus memberStatus, long l2, long l3, long l4, JobHistory jobHistory) {
        if (this.isMemberStatusChangeAllowed(jobHistory, l4)) {
            try {
                this.jobSuiteDM.updateMemberStatus(l, memberStatus, l2, l3);
            }
            catch (Exception exception) {
                String string = "An error occurred while updating the member status.";
                throw new IllegalStateException(string, exception);
            }
            if (this.memberIsBeingRestarted(jobHistory)) {
                this.clearAnyWillNotRunStatusesDownstreamFromThisMember(l);
            }
            this.flagWillNotRunDependentMembers(l, memberStatus);
        } else {
            String string = MessageUtil.formatMsg((String)"A member status change was disallowed - memberInstanceID={0} | status={1} | jhID={2}.", (Object[])new Object[]{l, memberStatus, l3});
            logger.info((Object)string);
        }
    }

    private JobSuiteStatus updateSuiteStatus(long l, JobHistory jobHistory, Long l2) {
        SuiteInfo suiteInfo = null;
        try {
            boolean bl;
            JobSuiteStatus jobSuiteStatus;
            JobHistory jobHistory2 = this.jobSuiteDM.getSuiteHistory(l);
            JobSuiteStatus jobSuiteStatus2 = jobSuiteStatus = this.jobSuiteDM.getSuiteStatus(l);
            boolean bl2 = bl = jobHistory != null || l2 != null;
            if (bl && !this.isMemberStatusChangeAllowedToAffectTheSuiteStatus(jobHistory2, jobHistory, l2)) {
                String string = MessageUtil.formatMsg((String)"A member status change was disallowed from affecting the status of suite {0} (run number {1}).", (Object[])new Object[]{jobHistory2.getJobName(), l});
                if (jobHistory != null) {
                    string = string + MessageUtil.formatMsg((String)" Member {0}, with run number {1}. Status = {2}).", (Object[])new Object[]{jobHistory.getJobName(), jobHistory.getId(), jobHistory.getStatusCode()});
                }
                logger.info((Object)string);
                return jobSuiteStatus;
            }
            JobSuiteStatus jobSuiteStatus3 = this.calculateSuiteStatus(l);
            if (jobSuiteStatus != jobSuiteStatus3 && this.isUpdateSuiteStatusAllowed(jobSuiteStatus, jobSuiteStatus3, l)) {
                boolean bl3;
                long l3 = this.jobSuiteDM.updateSuiteStatus(l, jobSuiteStatus3, this.isRestart(jobSuiteStatus, jobSuiteStatus3));
                if (this.isRestart(jobSuiteStatus, jobSuiteStatus3)) {
                    this.jobSuiteDM.removeEndedReasonCodeAndServerEndedTime(l);
                }
                jobHistory2 = this.jobSuiteDM.getSuiteHistory(l);
                jobSuiteStatus2 = jobSuiteStatus3;
                boolean bl4 = bl3 = jobHistory2.getReactCode() == JobReactCode.PERFORM_REACTIVITY;
                if (bl3 && this.isTriggerReactivity(jobSuiteStatus, jobSuiteStatus3)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Triggering Suite reactivity (updateSuiteStatus) - Suite Instance: " + l + " Job History ID: " + jobHistory2.getId() + " Current Status: " + jobSuiteStatus + " Proposed Status: " + jobSuiteStatus3));
                    }
                    this.reactivityAM.notifyJobStatusChange(jobHistory2);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not Triggering Suite reactivity (updateSuiteStatus) - Suite Instance: " + l + " Current Status: " + jobSuiteStatus + " Proposed Status: " + jobSuiteStatus3));
                }
                suiteInfo = new SuiteInfo(jobHistory2.getJobID(), jobHistory2.getJobName(), bl3, jobHistory2.getBypassJobMonitors(), jobHistory2.getScheduledTime(), jobHistory2.getTimezoneType(), jobHistory2.getJobTimezone());
                RosettaMsg rosettaMsg = jobSuiteStatus3 == JobSuiteStatus.COMPLETED ? RosettaMsg.SUITE_STATUS_CHANGE_COMPLETED : RosettaMsg.SUITE_STATUS_CHANGE_OTHER;
                if (l3 == 0L) {
                    l3 = System.currentTimeMillis();
                }
                String[] stringArray = new String[]{suiteInfo.getSuiteName(), Long.toString(l), ScheduleLogger.formatTimeStamp((long)l3), jobSuiteStatus3.toString()};
                ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntryForSuite(stringArray, suiteInfo.getSuiteID(), l);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                if (jobSuiteStatus3 != JobSuiteStatus.RUNNING) {
                    this.notifyJobSuiteMonitors(jobHistory2, jobSuiteStatus3);
                }
                this.jobTrackerAM.notifyOfJobSuiteStatus(jobHistory2, jobSuiteStatus3, scheduleLogEntry.getMessageText());
                if (jobSuiteStatus3 == JobSuiteStatus.FAILED) {
                    this.holdFailedSuite(jobHistory2);
                }
            }
            return jobSuiteStatus2;
        }
        catch (Exception exception) {
            String string = suiteInfo != null ? suiteInfo.getSuiteName() : this.getSuiteName(l);
            throw new IllegalStateException(MessageUtil.formatMsg((String)"An error occurred while updating the status of job suite {0} with run number {1}.", (Object[])new Object[]{string, Long.toString(l)}), exception);
        }
    }

    private void validateStatusTransition(JobSuiteStatus jobSuiteStatus, JobSuiteStatus jobSuiteStatus2, String string, long l) throws ActionFailedException {
        if (jobSuiteStatus == jobSuiteStatus2) {
            String string2 = MessageUtil.formatMsg((String)"Suite {0} with run number {1} was not ended using status {2} because it is already in that status.", (Object[])new Object[]{string, l, jobSuiteStatus2});
            throw new ActionFailedException(string2);
        }
        if (!jobSuiteStatus.isTerminatableState()) {
            String string3 = MessageUtil.formatMsg((String)"Suite {0} with run number {1} was not ended because changing the status from {2} to {3} is not allowed.", (Object[])new Object[]{string, l, jobSuiteStatus, jobSuiteStatus2});
            throw new ActionFailedException(string3);
        }
    }

    private String writeToDiagnosticLog(RosettaMsg rosettaMsg, String[] stringArray, Exception exception) {
        String string = RosettaMsg.getMsgText((RosettaMsg)rosettaMsg, (Object[])stringArray);
        logger.error((Object)string, (Throwable)exception);
        return string;
    }

    private void writeToScheduleLog(RosettaMsg rosettaMsg, String[] stringArray, JobHistory jobHistory, long l) {
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId(), l, jobHistory.getJobSuiteHistoryID());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    private void writeToScheduleLog(RosettaMsg rosettaMsg, String[] stringArray, JobHistory jobHistory) {
        long l;
        long l2 = jobHistory.getJobSuiteHistoryID();
        try {
            l = this.jobSuiteDM.getSuiteIDFromHistory(l2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            l = 0L;
        }
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray, jobHistory.getAgentID(), jobHistory.getJobID(), jobHistory.getId(), l, l2);
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
    }

    public void setReactivityAM(ReactivityAM reactivityAM) {
        ValidationHelper.checkForNull((String)"ReactivityAM", (Object)reactivityAM);
        this.reactivityAM = reactivityAM;
    }

    public void setForecastAM(ForecastAM forecastAM) {
        ValidationHelper.checkForNull((String)"ForecastAM", (Object)forecastAM);
        this.forecastAM = forecastAM;
    }

    public SkippedMemberInfo getNotSkippedMemberInfo() {
        SkippedMemberInfo skippedMemberInfo = new SkippedMemberInfo();
        skippedMemberInfo.skipped = false;
        skippedMemberInfo.message = null;
        return skippedMemberInfo;
    }

    public SkippedMemberInfo getSkippedMemberInfo(String string, ScheduleLogEntry scheduleLogEntry) {
        SkippedMemberInfo skippedMemberInfo = new SkippedMemberInfo();
        skippedMemberInfo.skipped = true;
        skippedMemberInfo.message = string;
        skippedMemberInfo.logEntry = scheduleLogEntry;
        return skippedMemberInfo;
    }

    class SkippedMemberInfo {
        boolean skipped = false;
        String message = null;
        ScheduleLogEntry logEntry = null;

        public void updateScheduleLogger(JobHistory jobHistory) {
            if (jobHistory != null) {
                this.logEntry.setJobHistoryID(jobHistory.getId());
            }
            ScheduleLogger.write((ScheduleLogEntry)this.logEntry);
            logger.error((Object)this.logEntry.getMessageText());
        }
    }
}

