/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.NanoTimer;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentEventHistory;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.DateObjectCache;
import com.helpsystems.enterprise.core.busobj.DateObjectCacheImpl;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.ReactivityDateObject;
import com.helpsystems.enterprise.core.busobj.ReactivityDayOfPeriod;
import com.helpsystems.enterprise.core.busobj.ReactivityDays;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEventHistoryAM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.CalendarObjectDM;
import com.helpsystems.enterprise.core.dm.ForecastAM;
import com.helpsystems.enterprise.core.dm.JobHistoryDM;
import com.helpsystems.enterprise.core.dm.ReactivityDateObjectDM;
import com.helpsystems.enterprise.core.dm.ReactivityDayOfPeriodDM;
import com.helpsystems.enterprise.core.dm.ReactivityDaysDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.forecast.ForecastDurations;
import com.helpsystems.enterprise.core.forecast.ForecastJobAgentPair;
import com.helpsystems.enterprise.core.forecast.ForecastPrereqEvent;
import com.helpsystems.enterprise.core.forecast.ForecastPrereqEvent_JobStatusChange;
import com.helpsystems.enterprise.core.forecast.ForecastPrereqEvent_MemberStatusChange;
import com.helpsystems.enterprise.core.forecast.ForecastPrereqEvent_SuiteStatusChange;
import com.helpsystems.enterprise.core.forecast.ForecastPrerequisiteStatus;
import com.helpsystems.enterprise.core.forecast.ForecastPrerequisitesDM;
import com.helpsystems.enterprise.core.forecast.ForecastProcessInfo;
import com.helpsystems.enterprise.core.forecast.ForecastReactivityCausePrereq;
import com.helpsystems.enterprise.core.forecast.ForecastSpecificInstance;
import com.helpsystems.enterprise.core.forecast.ForecastStatus;
import com.helpsystems.enterprise.core.forecast.ForecastSuiteEventInfo;
import com.helpsystems.enterprise.core.forecast.ForecastSuiteScheduleInfo;
import com.helpsystems.enterprise.core.forecast.ForecastTargetInfo;
import com.helpsystems.enterprise.core.forecast.ForecastedObjectRunID;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectChangeObserver;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.DateObjectDM;
import com.helpsystems.enterprise.core.scheduler.DependencyEntry;
import com.helpsystems.enterprise.core.scheduler.DependentObject;
import com.helpsystems.enterprise.core.scheduler.ForecastDM;
import com.helpsystems.enterprise.core.scheduler.ForecastDefinition;
import com.helpsystems.enterprise.core.scheduler.ForecastFilter;
import com.helpsystems.enterprise.core.scheduler.ForecastResults;
import com.helpsystems.enterprise.core.scheduler.ForecastRun;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent_SuiteMember;
import com.helpsystems.enterprise.core.scheduler.ForecastedEvent;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsDM;
import com.helpsystems.enterprise.core.scheduler.MovedNST;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.core.scheduler.PrerequisiteConditionsList;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfoDM;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.SharedResource;
import com.helpsystems.enterprise.core.scheduler.SimpleList;
import com.helpsystems.enterprise.core.scheduler.observers.AgentGroupChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.AgentGroupChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.AgentTimeZoneChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.AgentTimeZoneChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.DateListChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.DateListChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.JobChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.JobChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.MemberChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.MemberChangeObserver;
import com.helpsystems.enterprise.core.scheduler.observers.SuiteChangeNotifier;
import com.helpsystems.enterprise.core.scheduler.observers.SuiteChangeObserver;
import com.helpsystems.enterprise.scheduler.ForecastManager;
import com.helpsystems.enterprise.scheduler.NSTCalculator;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class ForecastAMImpl
extends AbstractManager
implements ForecastAM {
    private static final Logger logger = Logger.getLogger(ForecastAMImpl.class);
    private static final ThreadPoolExecutor forecastExecutor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10));
    private static final ThreadPoolExecutor maintenanceHandlerExecutor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10));
    private static long activeForecastProcessID;
    private static ReentrantLock forecastProcessLock;
    private Map<Long, ForecastProcess> activeForecastProcesses = new HashMap<Long, ForecastProcess>();
    private ForecastDM forecastDM;
    private ForecastPrerequisitesDM forecastPrerequisitesDM;
    private ScheduleInfoDM scheduleInfoDM;
    private NSTCalculator nstCalculator;
    private JobHistoryDM jobHistoryDM;
    private AgentGroupDM agentGroupDM;
    private ScheduleJobDM scheduleJobDM;
    private AgentDM agentDM;
    private JobSubmitter jobSubmitter = new JobSubmitter();
    private PrereqMarker prereqMarker = new PrereqMarker();
    private PrereqEvaluator prereqEvaluator = new PrereqEvaluator();
    private MaintenanceObserver maintenanceObserver = new MaintenanceObserver(this.activeForecastProcesses.values());

    public ForecastAMImpl(ForecastDM forecastDM, ForecastPrerequisitesDM forecastPrerequisitesDM, ScheduleInfoDM scheduleInfoDM, NSTCalculator nSTCalculator, JobHistoryDM jobHistoryDM, AgentGroupDM agentGroupDM, ScheduleJobDM scheduleJobDM, AgentDM agentDM) {
        ValidationHelper.checkForNull((String)"ForecastDM", (Object)forecastDM);
        ValidationHelper.checkForNull((String)"ForecastPrerequisitesDM", (Object)forecastPrerequisitesDM);
        ValidationHelper.checkForNull((String)"ScheduleInfoDM", (Object)scheduleInfoDM);
        ValidationHelper.checkForNull((String)"NSTCalculator", (Object)nSTCalculator);
        ValidationHelper.checkForNull((String)"JobHistoryDM", (Object)jobHistoryDM);
        ValidationHelper.checkForNull((String)"AgentGroupDM", (Object)agentGroupDM);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        this.setName("ENTERPRISE.ForecastAM");
        this.forecastDM = forecastDM;
        this.forecastPrerequisitesDM = forecastPrerequisitesDM;
        this.scheduleInfoDM = scheduleInfoDM;
        this.nstCalculator = nSTCalculator;
        this.jobHistoryDM = jobHistoryDM;
        this.agentGroupDM = agentGroupDM;
        this.scheduleJobDM = scheduleJobDM;
        this.agentDM = agentDM;
    }

    public void runForecast(long l, ForecastFilter forecastFilter) {
        ForecastRunner forecastRunner = new ForecastRunner(l, forecastFilter);
        ForecastManager.getInstance().runUserForecast(forecastRunner, forecastExecutor);
    }

    public ForecastResults forecast(ForecastableEvent[] forecastableEventArray, Calendar calendar, Calendar calendar2) {
        ValidationHelper.checkForNull((String)"Forecastable Events", (Object)forecastableEventArray);
        ValidationHelper.checkForNull((String)"Range Begin", (Object)calendar);
        ValidationHelper.checkForNull((String)"Range End", (Object)calendar2);
        if (forecastableEventArray.length > 0) {
            ForecastGenerator forecastGenerator = new ForecastGenerator();
            ForecastFilter forecastFilter = null;
            return forecastGenerator.forecast(forecastableEventArray, forecastFilter, calendar, calendar2);
        }
        throw new IllegalArgumentException("There are no forecastable events to process.");
    }

    public ForecastResults forecast(ForecastableEvent[] forecastableEventArray, ForecastFilter forecastFilter, Calendar calendar, Calendar calendar2) {
        ValidationHelper.checkForNull((String)"Forecastable Events", (Object)forecastableEventArray);
        ValidationHelper.checkForNull((String)"Forecast Filter", (Object)forecastFilter);
        ValidationHelper.checkForNull((String)"Range Begin", (Object)calendar);
        ValidationHelper.checkForNull((String)"Range End", (Object)calendar2);
        if (forecastableEventArray.length > 0) {
            ForecastGenerator forecastGenerator = new ForecastGenerator();
            return forecastGenerator.forecast(forecastableEventArray, forecastFilter, calendar, calendar2);
        }
        throw new IllegalArgumentException("There are no forecastable events to process.");
    }

    public void regenerateForecast(long l) {
        ForecastProcess forecastProcess = this.activeForecastProcesses.get(l);
        if (forecastProcess == null) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Forecast process {0} not found.", (Object[])new Object[]{l}));
        }
        String string = MessageUtil.formatMsg((String)"ForecastProcess {0} regen", (Object[])new Object[]{l});
        RegenRunner regenRunner = new RegenRunner(forecastProcess);
        Thread thread = new Thread((Runnable)regenRunner, string);
        thread.setDaemon(false);
        thread.start();
    }

    public void regenerateSAMForecast() {
        try {
            long l = this.forecastDM.getInternalForecastProcessID();
            this.regenerateForecast(l);
        }
        catch (Exception exception) {
            String string = "An error occurred while trying to regenerate the SAM forecast data.";
            logger.error((Object)string, (Throwable)exception);
        }
    }

    public void restartForecastProcess(long l, long l2, long l3, ForecastFilter forecastFilter) {
        boolean bl = true;
        ForecastProcess forecastProcess = new ForecastProcess(l, l2, l3, forecastFilter, bl);
        String string = MessageUtil.formatMsg((String)"ForecastProcess {0} (restart)", (Object[])new Object[]{l});
        new Thread((Runnable)forecastProcess, string).start();
        this.activeForecastProcesses.put(l, forecastProcess);
    }

    public long runDuration(long l, long l2) {
        ForecastProcess forecastProcess = null;
        try {
            switch (this.activeForecastProcesses.size()) {
                case 1: {
                    forecastProcess = this.activeForecastProcesses.values().iterator().next();
                    break;
                }
                case 0: {
                    throw new IllegalStateException("There is no Forecast Process available.");
                }
                default: {
                    long l3;
                    try {
                        l3 = this.forecastDM.getInternalForecastProcessID();
                    }
                    catch (NoDataException noDataException) {
                        throw new IllegalStateException("There is no internal forecast process running.");
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        throw new IllegalStateException(resourceUnavailableException.getMessage());
                    }
                    forecastProcess = this.activeForecastProcesses.get(l3);
                }
            }
            if (forecastProcess == null) {
                throw new IllegalStateException("There is no Forecast Process available.");
            }
            return forecastProcess.runDuration(l, l2);
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Unable to retrieve the run duration for jobID {0}, agentID {1}. Details: [{2}]. This is not technically a forecast error. The forecast engine is being asked for data from an external source.", (Object[])new Object[]{l, l2, exception.getMessage()});
            logger.debug((Object)string);
            return 0L;
        }
    }

    public long startSAMForecastProcess() {
        long l;
        long l2 = 60000L;
        long l3 = 60L * l2;
        long l4 = 24L * l3;
        long l5 = 6L * l3;
        ForecastProcessInfo forecastProcessInfo = null;
        try {
            boolean bl;
            SimpleDateFormat simpleDateFormat;
            try {
                forecastProcessInfo = this.forecastDM.getInternalForecastProcessInfo();
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                long l6 = System.currentTimeMillis();
                if (l6 >= forecastProcessInfo.getWindowBegin() && l6 <= forecastProcessInfo.getWindowEnd()) {
                    bl = true;
                    logger.info((Object)MessageUtil.formatMsg((String)"The server is being started within the time period covered by the existing SAM forecast data {0} - {1}. As much as possible of the existing forecast data and matching data in the database will be retained.", (Object[])new Object[]{simpleDateFormat.format(new Date(forecastProcessInfo.getWindowBegin())), simpleDateFormat.format(new Date(forecastProcessInfo.getWindowEnd()))}));
                } else {
                    bl = false;
                    logger.info((Object)MessageUtil.formatMsg((String)"The server is being started outside of the time period covered by the existing SAM forecast data {0} - {1}. Any existing data will be considered outdated and will be deleted.", (Object[])new Object[]{simpleDateFormat.format(new Date(forecastProcessInfo.getWindowBegin())), simpleDateFormat.format(new Date(forecastProcessInfo.getWindowEnd()))}));
                    try {
                        this.forecastDM.deleteAllForecastProcessData();
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Unable to clear forecast process data.", (Throwable)exception);
                    }
                }
            }
            catch (NoDataException noDataException) {
                logger.debug((Object)"No existing SAM forecast process data has been found.");
                bl = false;
            }
            simpleDateFormat = null;
            if (bl) {
                l = forecastProcessInfo.getForecastProcessID();
                this.restartForecastProcess(l, l4, l5, (ForecastFilter)simpleDateFormat);
            } else {
                l = this.startForecastProcess(l4, l5, (ForecastFilter)simpleDateFormat);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("An error occurred while trying start the SAM forecast process.", exception);
        }
        return l;
    }

    public long startForecastProcess(long l, long l2, ForecastFilter forecastFilter) {
        long l3;
        try {
            l3 = this.forecastDM.createForecastProcessRecord();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to create a forecast process record.", exception);
        }
        boolean bl = false;
        ForecastProcess forecastProcess = new ForecastProcess(l3, l, l2, forecastFilter, bl);
        new Thread((Runnable)forecastProcess, "ForecastProcess " + l3).start();
        this.activeForecastProcesses.put(l3, forecastProcess);
        return l3;
    }

    public void stopForecastProcess(long l) {
        ForecastProcess forecastProcess = this.activeForecastProcesses.get(l);
        if (forecastProcess == null) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Forecast process {0} not found.", (Object[])new Object[]{l}));
        }
        forecastProcess.shutdown();
    }

    public void setAgentGroupChangeNotifier(AgentGroupChangeNotifier agentGroupChangeNotifier) {
        ValidationHelper.checkForNull((String)"Agent Group Change Notifier", (Object)agentGroupChangeNotifier);
        agentGroupChangeNotifier.addAgentGroupChangeObserver((AgentGroupChangeObserver)this.maintenanceObserver);
    }

    public void setAgentTimeZoneChangeNotifier(AgentTimeZoneChangeNotifier agentTimeZoneChangeNotifier) {
        ValidationHelper.checkForNull((String)"Agent Timezone Change Notifier", (Object)agentTimeZoneChangeNotifier);
        agentTimeZoneChangeNotifier.addAgentTimeZoneChangeObserver((AgentTimeZoneChangeObserver)this.maintenanceObserver);
    }

    public void setCalendarObjectChangeNotifier(CalendarObjectChangeNotifier calendarObjectChangeNotifier) {
        ValidationHelper.checkForNull((String)"Calendar Object Change Notifier", (Object)calendarObjectChangeNotifier);
        calendarObjectChangeNotifier.addCalendarObjectChangeObserver((CalendarObjectChangeObserver)this.maintenanceObserver);
    }

    public void setDateListChangeNotifier(DateListChangeNotifier dateListChangeNotifier) {
        ValidationHelper.checkForNull((String)"Date List Change Notifier", (Object)dateListChangeNotifier);
        dateListChangeNotifier.addDateListChangeObserver((DateListChangeObserver)this.maintenanceObserver);
    }

    public void setJobChangeNotifier(JobChangeNotifier jobChangeNotifier) {
        ValidationHelper.checkForNull((String)"Job Change Notifier", (Object)jobChangeNotifier);
        jobChangeNotifier.addJobChangeObserver((JobChangeObserver)this.maintenanceObserver);
    }

    public void setMemberChangeNotifier(MemberChangeNotifier memberChangeNotifier) {
        ValidationHelper.checkForNull((String)"Member Change Notifier", (Object)memberChangeNotifier);
        memberChangeNotifier.addMemberChangeObserver((MemberChangeObserver)this.maintenanceObserver);
    }

    public void setSuiteChangeNotifier(SuiteChangeNotifier suiteChangeNotifier) {
        ValidationHelper.checkForNull((String)"Suite Change Notifier", (Object)suiteChangeNotifier);
        suiteChangeNotifier.addSuiteChangeObserver((SuiteChangeObserver)this.maintenanceObserver);
    }

    static {
        forecastExecutor.allowCoreThreadTimeOut(true);
        maintenanceHandlerExecutor.allowCoreThreadTimeOut(true);
        forecastProcessLock = new ReentrantLock();
    }

    private class SkipInstanceCache {
        private long[] membersWithExclusionPerSpecialInstanceInfo;
        private Map<Long, SpecialInstance[]> memberSkipInstances;
        private Map<Long, Boolean> skipMatchedSettings;
        private Map<Long, CalendarObject> calendarObjects_bySuiteID;
        private Map<Long, CalendarObject> calendarObjects_byCalendarObjectID;

        private SkipInstanceCache() {
            try {
                this.membersWithExclusionPerSpecialInstanceInfo = ForecastAMImpl.this.forecastDM.getAllMembersWithExclusionPerSpecialInstanceInfo();
                Arrays.sort(this.membersWithExclusionPerSpecialInstanceInfo);
            }
            catch (Exception exception) {
                logger.info((Object)"Could not batch load the Members With Exclusion Per Special Instance information.", (Throwable)exception);
            }
        }

        private boolean isSkipped(ForecastedEvent forecastedEvent) {
            if (forecastedEvent.getForecastableEvent().getType() != ForecastableEvent.ForecastableEventType.MEMBER_JOB) {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Forecastable Event Type {0} is not supported by this method.", (Object[])new Object[]{forecastedEvent.getForecastableEvent().getType()}));
            }
            long l = forecastedEvent.getForecastableEvent().getID();
            try {
                SpecialInstance[] specialInstanceArray = this.retrieveSkipInstances(l);
                if (specialInstanceArray == null) {
                    return false;
                }
                long l2 = forecastedEvent.getSuiteEventInfo().getSuiteID();
                long l3 = forecastedEvent.getSuiteEventInfo().getRunningDateTime();
                boolean bl = this.getSkipMatchedSetting(l);
                return this.isSkipped(specialInstanceArray, l2, l3, bl);
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to determine if member {0} is skipped per special instance.", (Object[])new Object[]{l}), (Throwable)exception);
                return false;
            }
        }

        private boolean isSkipped(SpecialInstance[] specialInstanceArray, long l, long l2, boolean bl) throws ResourceUnavailableException {
            ScheduleJobProxy scheduleJobProxy = this.jobProxy(l);
            TimeZone timeZone = this.timezone(scheduleJobProxy);
            Calendar calendar = Calendar.getInstance(timeZone);
            calendar.setTimeInMillis(l2);
            long l3 = 0L;
            CalendarObject calendarObject = this.getCalendarObject(l);
            for (SpecialInstance specialInstance : specialInstanceArray) {
                boolean bl2 = specialInstance.isAcceptedTimestamp(calendar, l3, calendarObject);
                if ((!bl2 || !bl) && (bl2 || bl)) continue;
                return true;
            }
            return false;
        }

        private CalendarObject getCalendarObject(long l) throws ResourceUnavailableException {
            if (this.calendarObjects_bySuiteID == null) {
                this.calendarObjects_bySuiteID = new HashMap<Long, CalendarObject>();
                this.calendarObjects_byCalendarObjectID = new HashMap<Long, CalendarObject>();
            }
            if (!this.calendarObjects_bySuiteID.containsKey(l)) {
                long l2 = this.getCalendarObjectID(l);
                CalendarObject calendarObject = this.getCalendarObjectUsingID(l2);
                this.calendarObjects_bySuiteID.put(l, calendarObject);
            }
            return this.calendarObjects_bySuiteID.get(l);
        }

        private long getCalendarObjectID(long l) throws ResourceUnavailableException {
            try {
                ScheduleJobProxy scheduleJobProxy = ForecastAMImpl.this.scheduleJobDM.getScheduleJobProxy(l);
                return scheduleJobProxy.getCalendarID();
            }
            catch (NoDataException noDataException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to determine the Calendar that suite {0} uses.", (Object[])new Object[]{l}), noDataException);
            }
        }

        private CalendarObject getCalendarObjectUsingID(long l) {
            if (!this.calendarObjects_byCalendarObjectID.containsKey(l)) {
                try {
                    CalendarObjectDM calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
                    this.calendarObjects_byCalendarObjectID.put(l, calendarObjectDM.get(l));
                }
                catch (Exception exception) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Error retrieving the Calendar Object with ID {0}.", (Object[])new Object[]{l}), exception);
                }
            }
            return this.calendarObjects_byCalendarObjectID.get(l);
        }

        private Boolean getSkipMatchedSetting(long l) {
            if (this.skipMatchedSettings == null) {
                this.skipMatchedSettings = new HashMap<Long, Boolean>();
            }
            if (!this.skipMatchedSettings.containsKey(l)) {
                try {
                    this.skipMatchedSettings.put(l, ForecastAMImpl.this.forecastDM.getMemberSkipMatchedSetting(l));
                }
                catch (Exception exception) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Error retrieving the Skip Matched Setting for the suite member with ID {0}.", (Object[])new Object[]{l}), exception);
                }
            }
            return this.skipMatchedSettings.get(l);
        }

        private ScheduleJobProxy jobProxy(long l) {
            try {
                return ForecastAMImpl.this.scheduleJobDM.getScheduleJobProxy(l);
            }
            catch (Exception exception) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to load the ScheduleJobProxy for the suite with ID {0}.", (Object[])new Object[]{l}), exception);
            }
        }

        private SpecialInstance[] retrieveSkipInstances(long l) {
            if (this.memberSkipInstances == null) {
                this.memberSkipInstances = new HashMap<Long, SpecialInstance[]>();
            }
            try {
                if (this.membersWithExclusionPerSpecialInstanceInfo != null) {
                    if (!this.isInArray(this.membersWithExclusionPerSpecialInstanceInfo, l)) {
                        return null;
                    }
                    if (!this.memberSkipInstances.containsKey(l)) {
                        this.memberSkipInstances.put(l, ForecastAMImpl.this.forecastDM.getMemberSkipInstances(l));
                    }
                    return this.memberSkipInstances.get(l);
                }
                return ForecastAMImpl.this.forecastDM.getMemberSkipInstances(l);
            }
            catch (Exception exception) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve member skip per special instance data for member {0}.", (Object[])new Object[]{l}), exception);
            }
        }

        private TimeZone serverTimeZone() {
            return TimeZone.getDefault();
        }

        private TimeZone timezone(ScheduleJobProxy scheduleJobProxy) {
            TimeZone timeZone;
            String string = scheduleJobProxy.getName();
            ScheduleInfo.TimeZoneType timeZoneType = scheduleJobProxy.getTimezoneType();
            switch (timeZoneType) {
                case SERVER: {
                    timeZone = this.serverTimeZone();
                    break;
                }
                case JOB: {
                    String string2 = scheduleJobProxy.getJobTimezone();
                    if (string2 != null && !string2.isEmpty()) {
                        timeZone = this.timezone(string2, string);
                        break;
                    }
                    timeZone = this.serverTimeZone();
                    String string3 = timeZone.getID();
                    logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{string, string3}));
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
                }
            }
            return timeZone;
        }

        private TimeZone timezone(String string, String string2) {
            TimeZone timeZone = null;
            try {
                timeZone = ZoneInfo.getTimeZone(string);
                if (timeZone == null) {
                    timeZone = this.serverTimeZone();
                    String string3 = timeZone.getID();
                    logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
                }
            }
            catch (Exception exception) {
                timeZone = this.serverTimeZone();
                String string4 = timeZone.getID();
                String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
                logger.error((Object)string5, (Throwable)exception);
            }
            return timeZone;
        }

        private boolean isInArray(long[] lArray, long l) {
            return Arrays.binarySearch(lArray, l) > -1;
        }
    }

    private class SequenceNumberComparator
    implements Comparator<DependencyEntry> {
        private SequenceNumberComparator() {
        }

        @Override
        public int compare(DependencyEntry dependencyEntry, DependencyEntry dependencyEntry2) {
            return dependencyEntry.getSequenceNumber() - dependencyEntry2.getSequenceNumber();
        }
    }

    private class ResidualData {
        private Map<PrereqConditionKey, PrereqCondition> prereqConditions;
        private ForecastableEvent forecastableEvent;
        private List<QueueEntry> queueEntries;

        private ResidualData(Map<PrereqConditionKey, PrereqCondition> map, ForecastableEvent forecastableEvent, List<QueueEntry> list) {
            this.prereqConditions = map;
            this.forecastableEvent = forecastableEvent;
            this.queueEntries = list;
        }

        private Map<PrereqConditionKey, PrereqCondition> getPrereqConditions() {
            return this.prereqConditions;
        }

        private ForecastableEvent getForecastableEvent() {
            return this.forecastableEvent;
        }

        private List<QueueEntry> getQueueEntries() {
            return this.queueEntries;
        }
    }

    private class OmitDates {
        private Map<Long, long[]> objectsWithOmitDates;
        private DateObjectCache dateObjectCache;
        private CalendarObjectManager calendarObjectManager;

        private OmitDates(DateObjectCache dateObjectCache, CalendarObjectManager calendarObjectManager) {
            this.dateObjectCache = dateObjectCache;
            this.calendarObjectManager = calendarObjectManager;
            this.objectsWithOmitDates = this.identifyAllTheObjectsWithOmitDates();
        }

        private boolean hasOmitDates(DependentObject dependentObject) {
            switch (dependentObject.getType()) {
                case MEMBER_JOB: {
                    return false;
                }
                case JOB: 
                case JOB_SUITE: {
                    long l = dependentObject.getID();
                    return this.objectsWithOmitDates.containsKey(l);
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
        }

        private boolean isOmitDate(DependentObject dependentObject, Calendar calendar) {
            try {
                switch (dependentObject.getType()) {
                    case MEMBER_JOB: {
                        return false;
                    }
                    case JOB: 
                    case JOB_SUITE: {
                        long l = dependentObject.getID();
                        return this.hasOmitDates(dependentObject) && this.omitDates(l).contains(this.yyyymmdd(calendar, l));
                    }
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
            }
            catch (Exception exception) {
                String string = MessageUtil.formatMsg((String)"Unable to check for an omit date for {0} {1}. Will assume it is not an omit date. Details: {2}", (Object[])new Object[]{dependentObject.getType(), dependentObject.getID(), this.nestedMsgText(exception)});
                logger.error((Object)string);
                return false;
            }
        }

        private Map<Long, long[]> identifyAllTheObjectsWithOmitDates() {
            try {
                JobDateObjectsDM jobDateObjectsDM = (JobDateObjectsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobDateObjectsDM");
                List list = jobDateObjectsDM.getAllOmitTypeDateObjectEntries();
                HashMap<Long, long[]> hashMap = new HashMap<Long, long[]>(list.size());
                for (AbstractMap.SimpleEntry simpleEntry : list) {
                    long l = (Long)simpleEntry.getKey();
                    long l2 = (Long)simpleEntry.getValue();
                    long[] lArray = (long[])hashMap.get(l);
                    if (lArray == null) {
                        long[] lArray2 = new long[]{l2};
                        hashMap.put(l, lArray2);
                        continue;
                    }
                    int n = lArray.length + 1;
                    lArray = Arrays.copyOf(lArray, n);
                    lArray[n] = l2;
                    hashMap.put(l, lArray);
                }
                return hashMap;
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error identifying all of the jobs/suites with omit-type Date Lists. Processing will continue as if there were none. Details: {0}", (Object[])new Object[]{exception.getMessage()}));
                return new HashMap<Long, long[]>();
            }
        }

        private DateObject omitDates(long l) {
            long[] lArray;
            DateObject dateObject = null;
            for (long l2 : lArray = this.objectsWithOmitDates.get(l)) {
                DateObject dateObject2;
                try {
                    dateObject2 = this.dateObjectCache.getDateObject(l2);
                }
                catch (NoDataException noDataException) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Date List not found for ID: {0}. An empty DateList will be returned.", (Object[])new Object[]{l2}));
                    return new DateObject();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Error loading Date List for ID: {0}. An empty DateList will be returned. Details: {1}", (Object[])new Object[]{l2, resourceUnavailableException.getMessage()}));
                    return new DateObject();
                }
                if (dateObject == null) {
                    dateObject = dateObject2;
                    continue;
                }
                dateObject.addDates(dateObject2.getDates());
                dateObject.setName("*MERGED");
                dateObject.setDescription("Composite Date List");
            }
            return dateObject;
        }

        private int yyyymmdd(Calendar calendar, long l) {
            try {
                CalendarObject calendarObject = this.calendarObjectManager.getCalendarObjectForJob(l);
                return calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar);
            }
            catch (Exception exception) {
                logger.debug((Object)MessageUtil.formatMsg((String)"Unable to retrieve the CalendarObject associated with jobID {0}. No virtual day adjustment will be able to be performed. Details: {1}", (Object[])new Object[]{l, exception.getMessage()}));
                int n = calendar.get(1);
                int n2 = calendar.get(2) + 1;
                int n3 = calendar.get(5);
                return n * 10000 + n2 * 100 + n3;
            }
        }

        private String nestedMsgText(Exception exception) {
            String string = exception.getMessage();
            for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                string = string + " " + throwable.getMessage();
            }
            return string;
        }
    }

    private class DateListChangeRunner
    implements Runnable {
        private long dateListID;
        Collection<ForecastProcess> forecastProcesses;

        public DateListChangeRunner(long l, Collection<ForecastProcess> collection) {
            this.dateListID = l;
            this.forecastProcesses = collection;
        }

        @Override
        public void run() {
            this.changedDateList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changedDateList() {
            String string;
            Object object;
            Object object2;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            Exception exception = null;
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            try (SimpleList simpleList = null;){
                simpleList = ForecastAMImpl.this.scheduleJobDM.getList_JobsThatReferToDateObject(this.dateListID);
                while (simpleList.next()) {
                    long l;
                    block22: {
                        try {
                            object2 = (ScheduleJobProxy)simpleList.get();
                            l = object2.getSkybotJobNumber();
                            object = object2.getJobType();
                        }
                        catch (BadDataException badDataException) {
                            object2 = (ScheduleJobProxy)badDataException.getLoadedObject();
                            l = object2.getSkybotJobNumber();
                            object = object2.getJobType();
                            if (object != null) break block22;
                            throw badDataException;
                        }
                    }
                    if (l == 0L) continue;
                    arrayList.add(l);
                    switch (object) {
                        case JOB: {
                            string = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION);
                            break;
                        }
                        case SUITE: {
                            string = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUITE);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{object}));
                        }
                    }
                    hashSet.add(string);
                }
            }
            object2 = null;
            try {
                object2 = ForecastAMImpl.this.forecastDM.getAllEventsThatHaveAForecastScheduleThatUsesThisDateList(this.dateListID);
                hashSet.addAll((Collection<String>)object2);
            }
            catch (Exception exception2) {
                string3 = " However, an error occurred while trying to identify the jobs/events that refer to the Date List via a Forecast Schedule (see below).";
                exception = exception2;
            }
            Set set = null;
            try {
                set = ForecastAMImpl.this.forecastDM.getAllEventsThatHaveASpecialInstanceThatUsesThisDateList(this.dateListID);
                hashSet.addAll(set);
            }
            catch (Exception exception3) {
                string4 = " However, an error occurred while trying to identify the jobs/events that refer to the Date List via a Special Instance (see below).";
                exception = exception3;
            }
            String string5 = "s were";
            if (arrayList.size() == 1) {
                string5 = " was";
            }
            object = "were";
            if (object2 != null && object2.size() == 1) {
                object = "was";
            }
            string = "were";
            if (set != null && set.size() == 1) {
                string = "was";
            }
            for (ForecastProcess forecastProcess : this.forecastProcesses) {
                forecastProcess.recordChangedEvents(hashSet);
                String string6 = MessageUtil.formatMsg((String)"Forecast process {0} was notified of a change to Date List {1}. {2} job{3} identified as referring to the Date List directly.{4} {5} job(s)/event(s) {6} identified as referring to the Date List via a Forecast Schedule. {7}{8} job(s)/event(s) {9} identified as referring to the Date List via a Special Instance.{10}", (Object[])new Object[]{forecastProcess.forecastProcessID, this.getDateListName(this.dateListID), arrayList.size(), string5, string2, object2 != null ? object2.size() : 0, object, string3, set != null ? set.size() : 0, string, string4});
                if (exception == null) {
                    logger.info((Object)string6);
                    continue;
                }
                logger.info((Object)string6, (Throwable)exception);
            }
        }

        private String getDateListName(long l) {
            try {
                DateObjectDM dateObjectDM = (DateObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.DateObjectDM");
                return dateObjectDM.get(l).getName();
            }
            catch (Exception exception) {
                return String.valueOf(l);
            }
        }
    }

    private class CalendarChangeRunner
    implements Runnable {
        private long calendarID;
        Collection<ForecastProcess> forecastProcesses;

        public CalendarChangeRunner(long l, Collection<ForecastProcess> collection) {
            this.calendarID = l;
            this.forecastProcesses = collection;
        }

        @Override
        public void run() {
            this.changedCalendar();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changedCalendar() {
            Object object;
            String string = "";
            String string2 = "";
            Exception exception = null;
            HashSet<ForecastProcess> hashSet = new HashSet<ForecastProcess>();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            try (SimpleList simpleList = null;){
                simpleList = ForecastAMImpl.this.scheduleJobDM.getList_JobsThatReferToCalendar(this.calendarID);
                while (simpleList.next()) {
                    ForecastProcess forecastProcess;
                    Object object2;
                    long l;
                    block19: {
                        try {
                            object = (ScheduleJobProxy)simpleList.get();
                            l = object.getSkybotJobNumber();
                            object2 = object.getJobType();
                        }
                        catch (BadDataException badDataException) {
                            object = (ScheduleJobProxy)badDataException.getLoadedObject();
                            l = object.getSkybotJobNumber();
                            object2 = object.getJobType();
                            if (object2 != null) break block19;
                            throw badDataException;
                        }
                    }
                    if (l == 0L) continue;
                    arrayList.add(l);
                    switch (1.$SwitchMap$com$helpsystems$enterprise$core$busobj$JobType[object2.ordinal()]) {
                        case 1: {
                            forecastProcess = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION);
                            break;
                        }
                        case 2: {
                            forecastProcess = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUITE);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{object2}));
                        }
                    }
                    hashSet.add(forecastProcess);
                }
            }
            object = null;
            try {
                object = ForecastAMImpl.this.forecastDM.getAllEventsThatHaveAForecastScheduleThatUsesThisCalendar(this.calendarID);
                hashSet.addAll((Collection<ForecastProcess>)object);
            }
            catch (Exception exception2) {
                string2 = " However, an error occurred while trying to identify the jobs/events that refer to the Calendar Object via a Forecast Schedule (see below).";
                exception = exception2;
            }
            String string3 = "s were";
            if (arrayList.size() == 1) {
                string3 = " was";
            }
            String string4 = "were";
            if (object != null && object.size() == 1) {
                string4 = "was";
            }
            for (ForecastProcess forecastProcess : this.forecastProcesses) {
                forecastProcess.recordChangedEvents(hashSet);
                String string5 = MessageUtil.formatMsg((String)"Forecast process {0} was notified of a change to Calendar Object {1}. {2} job{3} identified as referring to the Calendar Object directly.{4} {5} job(s)/event(s) {6} identified as referring to the Calendar Object via a Forecast Schedule.{7}", (Object[])new Object[]{forecastProcess.forecastProcessID, this.getCalendarName(this.calendarID), arrayList.size(), string3, string, object != null ? object.size() : 0, string4, string2});
                if (exception == null) {
                    logger.info((Object)string5);
                    continue;
                }
                logger.info((Object)string5, (Throwable)exception);
            }
        }

        private String getCalendarName(long l) {
            try {
                CalendarObjectDM calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
                return calendarObjectDM.get(l).getName();
            }
            catch (Exception exception) {
                return String.valueOf(l);
            }
        }
    }

    private class AgentTimeZoneChangeRunner
    implements Runnable {
        private long agentID;
        private String oldTimeZone;
        private String newTimeZone;
        private Collection<ForecastProcess> forecastProcesses;

        private AgentTimeZoneChangeRunner(long l, String string, String string2, Collection<ForecastProcess> collection) {
            this.agentID = l;
            this.oldTimeZone = string;
            this.newTimeZone = string2;
            this.forecastProcesses = collection;
        }

        @Override
        public void run() {
            this.changedAgentTimeZone();
        }

        private void changedAgentTimeZone() {
            HashSet hashSet;
            String string = "";
            ResourceUnavailableException resourceUnavailableException = null;
            try {
                hashSet = ForecastAMImpl.this.forecastDM.getAllAgentTimezoneTypeJobsThatRunOnAgent(this.agentID);
            }
            catch (ResourceUnavailableException resourceUnavailableException2) {
                string = " Please note that an error occurred while trying to identify the jobs affected by the time zone change (see below). ";
                resourceUnavailableException = resourceUnavailableException2;
                hashSet = new HashSet();
            }
            String string2 = "s were";
            if (hashSet.size() == 1) {
                string2 = " was";
            }
            for (ForecastProcess forecastProcess : this.forecastProcesses) {
                forecastProcess.recordChangedEvents(hashSet);
                String string3 = MessageUtil.formatMsg((String)"Forecast process {0} was notified of the time zone change of Agent {1} from {2} to {3}. {4} job{5} affected.{6} ", (Object[])new Object[]{forecastProcess.forecastProcessID, this.getAgentName(this.agentID), this.oldTimeZone, this.newTimeZone, hashSet.size(), string2, string});
                if (resourceUnavailableException == null) {
                    logger.info((Object)string3);
                    continue;
                }
                logger.info((Object)string3, (Throwable)resourceUnavailableException);
            }
        }

        private String getAgentName(long l) {
            if (l == 0L) {
                return "";
            }
            try {
                return ForecastAMImpl.this.agentDM.get(l).getName();
            }
            catch (Exception exception) {
                return "with ID " + l;
            }
        }
    }

    private class AgentGroupChangeRunner
    implements Runnable {
        private long agentGroupID;
        Collection<ForecastProcess> forecastProcesses;

        public AgentGroupChangeRunner(long l, Collection<ForecastProcess> collection) {
            this.agentGroupID = l;
            this.forecastProcesses = collection;
        }

        @Override
        public void run() {
            this.changedAgentGroup();
        }

        private void changedAgentGroup() {
            String string = "";
            Exception exception = null;
            Set set = new HashSet();
            try {
                set = ForecastAMImpl.this.forecastDM.getAllEventsThatReferToAgentGroup(this.agentGroupID);
            }
            catch (Exception exception2) {
                string = " Please note that an error occurred while trying to identify the jobs associated with the Agent Group (see below). ";
                exception = exception2;
            }
            String string2 = "s. These";
            if (set.size() == 1) {
                string2 = ". This";
            }
            for (ForecastProcess forecastProcess : this.forecastProcesses) {
                forecastProcess.recordChangedEvents(set);
                String string3 = MessageUtil.formatMsg((String)"Forecast process {0} was notified of a change to Agent Group {1}. The Agent Group contains {2} job{3} will be considered changed when the next regeneration of the forecast data occurs for this process.{4}", (Object[])new Object[]{forecastProcess.forecastProcessID, this.getAgentGroupName(this.agentGroupID), set.size(), string2, string});
                if (exception == null) {
                    logger.info((Object)string3);
                    continue;
                }
                logger.info((Object)string3, (Throwable)exception);
            }
        }

        private String getAgentGroupName(long l) {
            try {
                AgentGroupDM agentGroupDM = (AgentGroupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentGroupDM");
                return agentGroupDM.get(l).getName();
            }
            catch (Exception exception) {
                return String.valueOf(l);
            }
        }
    }

    private class MaintenanceObserver
    implements JobChangeObserver,
    CalendarObjectChangeObserver,
    DateListChangeObserver,
    AgentGroupChangeObserver,
    SuiteChangeObserver,
    MemberChangeObserver,
    AgentTimeZoneChangeObserver {
        Collection<ForecastProcess> forecastProcesses;

        private MaintenanceObserver(Collection<ForecastProcess> collection) {
            this.forecastProcesses = collection;
        }

        public void agentGroupChanged(long l) {
            maintenanceHandlerExecutor.execute(new AgentGroupChangeRunner(l, this.forecastProcesses));
        }

        public void agentTimeZoneChanged(long l, String string, String string2) {
            maintenanceHandlerExecutor.execute(new AgentTimeZoneChangeRunner(l, string, string2, this.forecastProcesses));
        }

        public void calendarObjectChanged(long l) {
            maintenanceHandlerExecutor.execute(new CalendarChangeRunner(l, this.forecastProcesses));
        }

        public void dateListChanged(long l) {
            maintenanceHandlerExecutor.execute(new DateListChangeRunner(l, this.forecastProcesses));
        }

        public void jobChanged(long l) {
            ForecastableEvent forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUBMISSION);
            for (ForecastProcess forecastProcess : this.forecastProcesses) {
                forecastProcess.recordChangedEvent(forecastableEvent);
            }
        }

        public void memberChanged(long l) {
            Set set;
            try {
                set = ForecastAMImpl.this.forecastDM.membersAssociatedWithJob(l);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"Forecasting has been notified of a change to a suite member (job ID = {0}). However, an error occurred while trying to determine which members are associated, with this job ID.", (Object[])new Object[]{l});
                logger.error((Object)string, (Throwable)resourceUnavailableException);
                return;
            }
            for (ForecastProcess forecastProcess : this.forecastProcesses) {
                forecastProcess.recordChangedEvents(set);
            }
        }

        public void suiteChanged(long l) {
            ForecastableEvent forecastableEvent = new ForecastableEvent(l, ForecastableEvent.ForecastableEventType.JOB_SUITE);
            for (ForecastProcess forecastProcess : this.forecastProcesses) {
                forecastProcess.recordChangedEvent(forecastableEvent);
            }
        }
    }

    private class CalendarObjectManager {
        HashMap<Long, CalendarObject> calendarObjectMap = new HashMap();
        CalendarObjectDM calendarObjectDM = (CalendarObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.CalendarObjectDM");
        private long standardCalendarID;
        private Map<Long, Long> objectsWithNonStdCalendars;

        public CalendarObject getCalendarObject(long l) throws ResourceUnavailableException, BadDataException, NoDataException {
            if (this.calendarObjectMap.containsKey(l)) {
                return this.calendarObjectMap.get(l);
            }
            CalendarObject calendarObject = this.calendarObjectDM.get(l);
            this.calendarObjectMap.put(l, calendarObject);
            return calendarObject;
        }

        private CalendarObject getCalendarObjectForJob(long l) throws BadDataException, NoDataException, ResourceUnavailableException {
            if (this.objectsWithNonStdCalendars == null) {
                throw new IllegalStateException("The objectsWithNonStdCalendars map is NULL.");
            }
            Long l2 = this.objectsWithNonStdCalendars.get(l);
            if (l2 == null) {
                l2 = this.standardCalendarID;
            }
            return this.getCalendarObject(l2);
        }

        private void clearCalendarObjects() {
            this.calendarObjectMap.clear();
        }

        private void identifyAllReferencesToOtherThanTheStandardCalendar() {
            this.standardCalendarID = this.standardCalendarID();
            try {
                this.objectsWithNonStdCalendars = ForecastAMImpl.this.forecastDM.getJobsThatDoNotUseTheStandardCalendar(this.standardCalendarID);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Unable to identify the jobs and suites that do not reference the Standard calendar.", (Throwable)resourceUnavailableException);
            }
        }

        private long standardCalendarID() {
            try {
                return ForecastAMImpl.this.forecastDM.getTheIdOfTheMostCommonlyUsedCalendar();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.warn((Object)MessageUtil.formatMsg((String)"Unable to determine the ID of the most commonly used Calendar Object. Defaulting to 1. {0}", (Object[])new Object[]{resourceUnavailableException.getMessage()}));
                return 1L;
            }
        }
    }

    private class ReactivityTimeRangeFilter {
        private ScheduleJobProxy.ScheduleType scheduleType = null;
        ReactivityDays[] rds = null;
        ReactivityDayOfPeriod[] rdp = null;
        CalendarObject.DayType dayType = null;
        ReactivityDateObject[] rdo = null;
        CalendarObject calObj;

        protected ReactivityTimeRangeFilter(ReactivityDays[] reactivityDaysArray, CalendarObject calendarObject) {
            this.rds = reactivityDaysArray;
            this.calObj = calendarObject;
            this.scheduleType = ScheduleJobProxy.ScheduleType.REACTIVITY_DAY_OF_WEEK;
        }

        protected ReactivityTimeRangeFilter(ReactivityDayOfPeriod[] reactivityDayOfPeriodArray, CalendarObject calendarObject, CalendarObject.DayType dayType) {
            this.rdp = reactivityDayOfPeriodArray;
            this.calObj = calendarObject;
            this.dayType = dayType;
            this.scheduleType = ScheduleJobProxy.ScheduleType.REACTIVITY_DAY_OF_PERIOD;
        }

        protected ReactivityTimeRangeFilter(ReactivityDateObject[] reactivityDateObjectArray, CalendarObject calendarObject) {
            this.rdo = reactivityDateObjectArray;
            this.calObj = calendarObject;
            this.scheduleType = ScheduleJobProxy.ScheduleType.REACTIVITY_DATE_LIST;
        }

        public boolean isReactiveTime(Calendar calendar) {
            switch (this.scheduleType) {
                case REACTIVITY_DAY_OF_WEEK: {
                    return this.isReactiveTime_DOW(calendar);
                }
                case REACTIVITY_DAY_OF_PERIOD: {
                    return this.isReactiveTime_DOP(calendar);
                }
                case REACTIVITY_DATE_LIST: {
                    return this.isReactiveTime_DateList(calendar);
                }
            }
            return true;
        }

        private boolean isReactiveTime_DOW(Calendar calendar) {
            if (this.rds == null || this.rds.length == 0) {
                return true;
            }
            long l = 0L;
            for (int i = 0; i < this.rds.length; ++i) {
                if (!this.rds[i].isTimeAccepted(calendar, l, this.calObj)) continue;
                return true;
            }
            return false;
        }

        private boolean isReactiveTime_DOP(Calendar calendar) {
            if (this.rdp == null || this.rdp.length == 0) {
                return true;
            }
            for (int i = 0; i < this.rdp.length; ++i) {
                if (!this.rdp[i].isTimeAccepted(calendar, this.calObj, this.dayType)) continue;
                return true;
            }
            return false;
        }

        private boolean isReactiveTime_DateList(Calendar calendar) {
            if (this.rdo == null || this.rdo.length == 0) {
                return true;
            }
            for (ReactivityDateObject reactivityDateObject : this.rdo) {
                if (!reactivityDateObject.isTimeAccepted(calendar, this.calObj)) continue;
                return true;
            }
            return false;
        }
    }

    private class ReactivityTimeRangeManager {
        private HashMap<Long, ReactivityTimeRangeFilter> rtrfMap = new HashMap();
        private ScheduleJobDM scheduledJobDM = null;
        private CalendarObjectManager coManager = null;
        private ReactivityDaysDM reactivityDaysDM = null;
        private ReactivityDayOfPeriodDM reactivityDayOfPeriodDM = null;
        private ReactivityDateObjectDM reactivityDateObjectDM = null;

        protected ReactivityTimeRangeManager(CalendarObjectManager calendarObjectManager) {
            this.coManager = calendarObjectManager;
            this.scheduledJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
            this.reactivityDaysDM = (ReactivityDaysDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReactivityDaysDM");
            this.reactivityDayOfPeriodDM = (ReactivityDayOfPeriodDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReactivityDayOfPeriodDM");
            this.reactivityDateObjectDM = (ReactivityDateObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReactivityDateObjectDM");
        }

        public boolean isReactiveTime(long l, Calendar calendar) {
            ReactivityTimeRangeFilter reactivityTimeRangeFilter = null;
            if (this.rtrfMap.containsKey(l)) {
                reactivityTimeRangeFilter = this.rtrfMap.get(l);
                if (reactivityTimeRangeFilter == null) {
                    return true;
                }
                return reactivityTimeRangeFilter.isReactiveTime(calendar);
            }
            ScheduleJobProxy scheduleJobProxy = null;
            try {
                scheduleJobProxy = this.scheduledJobDM.getScheduleJobProxy(l);
                if (scheduleJobProxy == null) {
                    logger.error((Object)("A job proxy was not loaded for job id: " + l));
                    this.rtrfMap.put(l, null);
                    return true;
                }
                CalendarObject calendarObject = this.coManager.getCalendarObject(scheduleJobProxy.getCalendarID());
                switch (scheduleJobProxy.getScheduleType()) {
                    case REACTIVITY_DAY_OF_WEEK: {
                        ReactivityDays[] reactivityDaysArray = this.reactivityDaysDM.get(l);
                        reactivityTimeRangeFilter = new ReactivityTimeRangeFilter(reactivityDaysArray, calendarObject);
                        break;
                    }
                    case REACTIVITY_DAY_OF_PERIOD: {
                        ReactivityDayOfPeriod[] reactivityDayOfPeriodArray = this.reactivityDayOfPeriodDM.get(l);
                        reactivityTimeRangeFilter = new ReactivityTimeRangeFilter(reactivityDayOfPeriodArray, calendarObject, scheduleJobProxy.getDayType());
                        break;
                    }
                    case REACTIVITY_DATE_LIST: {
                        ReactivityDateObject[] reactivityDateObjectArray = this.reactivityDateObjectDM.get(l);
                        reactivityTimeRangeFilter = new ReactivityTimeRangeFilter(reactivityDateObjectArray, calendarObject);
                        break;
                    }
                    default: {
                        this.rtrfMap.put(l, null);
                        return true;
                    }
                }
                this.rtrfMap.put(l, reactivityTimeRangeFilter);
                return reactivityTimeRangeFilter.isReactiveTime(calendar);
            }
            catch (Exception exception) {
                logger.error((Object)("Error loading reactivity time range for: " + l), (Throwable)exception);
                return true;
            }
        }
    }

    private static enum NodeType {
        JOB,
        JOB_SUITE,
        MEMBER_JOB,
        AGENT_EVENT,
        JOB_MONITOR_EVENT,
        SNMP_TRAP_EVENT,
        REACTIVE_EVENT,
        SUITE_MONITOR_EVENT,
        MEMBER_MONITOR_EVENT,
        REMOTE_EVENT;


        public static NodeType forecastableEventTypeToEnum(ForecastableEvent.ForecastableEventType forecastableEventType) {
            switch (forecastableEventType) {
                case JOB_SUBMISSION: {
                    return JOB;
                }
                case JOB_SUITE: {
                    return JOB_SUITE;
                }
                case MEMBER_JOB: {
                    return MEMBER_JOB;
                }
                case AGENT_EVENT_OCCURS: {
                    return AGENT_EVENT;
                }
                case REACTIVE_EVENT_OCCURS: {
                    return REACTIVE_EVENT;
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no NodeType associated with ForecastableEvent type: {0}.", (Object[])new Object[]{forecastableEventType}));
        }

        public static NodeType dependentObjectTypeToEnum(DependentObject.DependentObjectType dependentObjectType) {
            switch (dependentObjectType) {
                case JOB: {
                    return JOB;
                }
                case JOB_SUITE: {
                    return JOB_SUITE;
                }
                case MEMBER_JOB: {
                    return MEMBER_JOB;
                }
                case REACTIVE_EVENT: {
                    return REACTIVE_EVENT;
                }
            }
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no NodeType associated with DependentObject type: {0}.", (Object[])new Object[]{dependentObjectType}));
        }
    }

    private class Node
    implements Comparable<Node> {
        private long id;
        private NodeType type;

        private Node(long l, NodeType nodeType) {
            this.id = l;
            this.type = nodeType;
        }

        private Node(ForecastableEvent forecastableEvent) {
            this.id = forecastableEvent.getID();
            this.type = NodeType.forecastableEventTypeToEnum(forecastableEvent.getType());
        }

        private Node(DependentObject dependentObject) {
            this.id = dependentObject.getID();
            this.type = NodeType.dependentObjectTypeToEnum(dependentObject.getType());
        }

        private boolean isCanHavePrereqs() {
            switch (this.type) {
                case JOB: 
                case JOB_SUITE: 
                case MEMBER_JOB: 
                case REACTIVE_EVENT: {
                    return true;
                }
                case AGENT_EVENT: 
                case JOB_MONITOR_EVENT: 
                case SNMP_TRAP_EVENT: 
                case SUITE_MONITOR_EVENT: 
                case MEMBER_MONITOR_EVENT: 
                case REMOTE_EVENT: {
                    return false;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Node Type {0} is not supported by this method.", (Object[])new Object[]{this.type}));
        }

        public boolean isJob() {
            switch (this.type) {
                case JOB: 
                case JOB_SUITE: 
                case MEMBER_JOB: {
                    return true;
                }
                case AGENT_EVENT: 
                case REACTIVE_EVENT: 
                case JOB_MONITOR_EVENT: 
                case SNMP_TRAP_EVENT: 
                case SUITE_MONITOR_EVENT: 
                case MEMBER_MONITOR_EVENT: 
                case REMOTE_EVENT: {
                    return false;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Node Type {0} is not supported by this method.", (Object[])new Object[]{this.type}));
        }

        @Override
        public int compareTo(Node node) {
            if (node != null) {
                if (this.type.ordinal() < node.type.ordinal()) {
                    return -1;
                }
                if (this.type.ordinal() > node.type.ordinal()) {
                    return 1;
                }
                if (this.id < node.id) {
                    return -1;
                }
                if (this.id > node.id) {
                    return 1;
                }
                return 0;
            }
            throw new NullPointerException("Trying to compare to null.");
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            Node node = (Node)object;
            return node.id == this.id && node.type == this.type;
        }

        public int hashCode() {
            return (int)this.id + this.type.hashCode();
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + Long.toString(this.id);
        }
    }

    private class PrereqObj {
        private long id;
        private PrereqEventType prereqObjType;

        private PrereqObj(long l, PrereqEventType prereqEventType) {
            this.id = l;
            this.prereqObjType = prereqEventType;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            PrereqObj prereqObj = (PrereqObj)object;
            return prereqObj.id == this.id && prereqObj.prereqObjType == this.prereqObjType;
        }

        public String toString() {
            return this.prereqObjType + ":" + this.id;
        }
    }

    private class PrereqCondition_OR
    implements PrereqCondition {
        List<PrereqCondition> prereqConditions = new ArrayList<PrereqCondition>();

        private PrereqCondition_OR() {
        }

        @Override
        public boolean hasBeenMet() {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                if (!prereqCondition.hasBeenMet()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAtLeastOneNonBlankStatus() {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                if (!prereqCondition.hasAtLeastOneNonBlankStatus()) continue;
                return true;
            }
            return false;
        }

        @Override
        public PrereqCondition_Simple[] getCauseData() {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                if (!prereqCondition.hasBeenMet()) continue;
                return prereqCondition.getCauseData();
            }
            throw new IllegalStateException("Program error: Asking for cause data when conditions have not been met.");
        }

        @Override
        public void updateStatus(PrereqObj prereqObj, long l, PrereqStatusType prereqStatusType, Calendar calendar, DependencyEntry dependencyEntry, ForecastSuiteEventInfo forecastSuiteEventInfo, ForecastSuiteScheduleInfo forecastSuiteScheduleInfo) {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                prereqCondition.updateStatus(prereqObj, l, prereqStatusType, calendar, dependencyEntry, forecastSuiteEventInfo, forecastSuiteScheduleInfo);
            }
        }

        @Override
        public void updateStatus(PrereqObj prereqObj, long l, PrereqStatusType prereqStatusType, long l2, int n) {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                prereqCondition.updateStatus(prereqObj, l, prereqStatusType, l2, n);
            }
        }

        @Override
        public void clearStatuses() {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                prereqCondition.clearStatuses();
            }
        }

        private boolean add(PrereqCondition prereqCondition) {
            return this.prereqConditions.add(prereqCondition);
        }

        @Override
        public PrereqCondition_OR copyOf() {
            ArrayList<PrereqCondition> arrayList = new ArrayList<PrereqCondition>(this.prereqConditions.size());
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                arrayList.add(prereqCondition.copyOf());
            }
            PrereqCondition_OR prereqCondition_OR = new PrereqCondition_OR();
            prereqCondition_OR.prereqConditions = arrayList;
            return prereqCondition_OR;
        }

        public String toString() {
            return this.prereqConditions.toString();
        }
    }

    private class PrereqCondition_AND
    implements PrereqCondition {
        List<PrereqCondition> prereqConditions = new ArrayList<PrereqCondition>();

        private PrereqCondition_AND() {
        }

        @Override
        public boolean hasBeenMet() {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                if (prereqCondition.hasBeenMet()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean hasAtLeastOneNonBlankStatus() {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                if (!prereqCondition.hasAtLeastOneNonBlankStatus()) continue;
                return true;
            }
            return false;
        }

        @Override
        public PrereqCondition_Simple[] getCauseData() {
            if (this.hasBeenMet()) {
                if (this.prereqConditions.size() == 1) {
                    return this.prereqConditions.get(0).getCauseData();
                }
                ArrayList<PrereqCondition_Simple> arrayList = new ArrayList<PrereqCondition_Simple>();
                for (PrereqCondition prereqCondition : this.prereqConditions) {
                    PrereqCondition_Simple[] prereqCondition_SimpleArray = prereqCondition.getCauseData();
                    for (int i = 0; i < prereqCondition_SimpleArray.length; ++i) {
                        arrayList.add(prereqCondition_SimpleArray[i]);
                    }
                }
                return arrayList.toArray(new PrereqCondition_Simple[arrayList.size()]);
            }
            throw new IllegalStateException("Program error: Asking for cause data when conditions have not been met.");
        }

        @Override
        public void updateStatus(PrereqObj prereqObj, long l, PrereqStatusType prereqStatusType, Calendar calendar, DependencyEntry dependencyEntry, ForecastSuiteEventInfo forecastSuiteEventInfo, ForecastSuiteScheduleInfo forecastSuiteScheduleInfo) {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                prereqCondition.updateStatus(prereqObj, l, prereqStatusType, calendar, dependencyEntry, forecastSuiteEventInfo, forecastSuiteScheduleInfo);
            }
        }

        @Override
        public void updateStatus(PrereqObj prereqObj, long l, PrereqStatusType prereqStatusType, long l2, int n) {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                prereqCondition.updateStatus(prereqObj, l, prereqStatusType, l2, n);
            }
        }

        @Override
        public void clearStatuses() {
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                prereqCondition.clearStatuses();
            }
        }

        private boolean add(PrereqCondition prereqCondition) {
            return this.prereqConditions.add(prereqCondition);
        }

        @Override
        public PrereqCondition_AND copyOf() {
            ArrayList<PrereqCondition> arrayList = new ArrayList<PrereqCondition>(this.prereqConditions.size());
            for (PrereqCondition prereqCondition : this.prereqConditions) {
                arrayList.add(prereqCondition.copyOf());
            }
            PrereqCondition_AND prereqCondition_AND = new PrereqCondition_AND();
            prereqCondition_AND.prereqConditions = arrayList;
            return prereqCondition_AND;
        }

        public String toString() {
            return this.prereqConditions.toString();
        }
    }

    private class PrereqCondition_Simple
    implements PrereqCondition {
        private PrereqObj conditionPrereqObject;
        private long prereqAgentID;
        private PrereqStatusType reactToStatus;
        private PrereqStatusType lastStatus;
        private long timestamp;
        private DependencyEntry dependencyEntry;
        private ForecastSuiteEventInfo suiteEventInfo;
        private ForecastSuiteScheduleInfo suiteScheduleInfo;

        public PrereqCondition_Simple() {
        }

        public PrereqCondition_Simple(PrereqObj prereqObj, PrereqStatusType prereqStatusType, DependencyEntry dependencyEntry) {
            this.conditionPrereqObject = prereqObj;
            this.reactToStatus = prereqStatusType;
            this.dependencyEntry = dependencyEntry;
        }

        @Override
        public boolean hasBeenMet() {
            if (this.reactToStatus == PrereqStatusType.ENDED) {
                return this.lastStatus == PrereqStatusType.CANCELED || this.lastStatus == PrereqStatusType.COMPLETED || this.lastStatus == PrereqStatusType.FAILED;
            }
            return this.lastStatus == this.reactToStatus;
        }

        @Override
        public boolean hasAtLeastOneNonBlankStatus() {
            return this.lastStatus != null && this.lastStatus != PrereqStatusType.BLANK;
        }

        @Override
        public PrereqCondition_Simple[] getCauseData() {
            if (this.hasBeenMet()) {
                return new PrereqCondition_Simple[]{this};
            }
            throw new IllegalStateException("Program error: Asking for cause data when conditions have not been met.");
        }

        @Override
        public void updateStatus(PrereqObj prereqObj, long l, PrereqStatusType prereqStatusType, Calendar calendar, DependencyEntry dependencyEntry, ForecastSuiteEventInfo forecastSuiteEventInfo, ForecastSuiteScheduleInfo forecastSuiteScheduleInfo) {
            if (prereqObj.equals(this.conditionPrereqObject) && l == this.prereqAgentID && dependencyEntry == this.dependencyEntry) {
                this.lastStatus = prereqStatusType;
                this.timestamp = calendar.getTimeInMillis();
                this.suiteEventInfo = forecastSuiteEventInfo;
                this.suiteScheduleInfo = forecastSuiteScheduleInfo;
            }
        }

        @Override
        public void updateStatus(PrereqObj prereqObj, long l, PrereqStatusType prereqStatusType, long l2, int n) {
            if (prereqObj.equals(this.conditionPrereqObject) && l == this.prereqAgentID && n == this.dependencyEntry.getSequenceNumber()) {
                this.lastStatus = prereqStatusType;
                this.timestamp = l2;
            }
        }

        @Override
        public void clearStatuses() {
            this.lastStatus = PrereqStatusType.BLANK;
        }

        @Override
        public PrereqCondition_Simple copyOf() {
            PrereqCondition_Simple prereqCondition_Simple = new PrereqCondition_Simple(this.conditionPrereqObject, this.reactToStatus, this.dependencyEntry);
            prereqCondition_Simple.prereqAgentID = this.prereqAgentID;
            prereqCondition_Simple.lastStatus = this.lastStatus;
            prereqCondition_Simple.timestamp = this.timestamp;
            prereqCondition_Simple.suiteEventInfo = this.suiteEventInfo;
            prereqCondition_Simple.suiteScheduleInfo = this.suiteScheduleInfo;
            return prereqCondition_Simple;
        }

        public String toString() {
            return this.conditionPrereqObject + " reactTo=" + this.reactToStatus.persistanceCode() + " last=" + this.lastStatus.persistanceCode();
        }
    }

    private static interface PrereqCondition {
        public boolean hasBeenMet();

        public boolean hasAtLeastOneNonBlankStatus();

        public PrereqCondition_Simple[] getCauseData();

        public void updateStatus(PrereqObj var1, long var2, PrereqStatusType var4, Calendar var5, DependencyEntry var6, ForecastSuiteEventInfo var7, ForecastSuiteScheduleInfo var8);

        public void updateStatus(PrereqObj var1, long var2, PrereqStatusType var4, long var5, int var7);

        public void clearStatuses();

        public PrereqCondition copyOf();
    }

    private class PrereqConditionKey {
        private DependentObject dependentObject;
        private long dependentAgent;

        private PrereqConditionKey() {
        }

        private PrereqConditionKey(DependentObject dependentObject, long l) {
            this.dependentObject = dependentObject;
            this.dependentAgent = l;
        }

        private PrereqConditionKey copyOf() {
            DependentObject dependentObject = (DependentObject)this.dependentObject.clone();
            return new PrereqConditionKey(dependentObject, this.dependentAgent);
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            PrereqConditionKey prereqConditionKey = (PrereqConditionKey)object;
            return prereqConditionKey.dependentObject.equals((Object)this.dependentObject) && prereqConditionKey.dependentAgent == this.dependentAgent;
        }

        public int hashCode() {
            return this.dependentObject.hashCode() + (int)this.dependentAgent;
        }

        public String toString() {
            return this.dependentObject + " depAgent=" + this.dependentAgent;
        }
    }

    private class PrereqGroup_OR
    implements Prerequisite {
        private Collection<Prerequisite> and_groups = new ArrayList<Prerequisite>();
        private Node node;
        private Boolean isFlowRecursive;
        private Boolean isHappyPath;
        private Boolean isScheduledDateTimeCanBeDetermined;
        private Set<Node> nodes;
        private boolean isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue;

        public PrereqGroup_OR(Node node) {
            this.node = node;
        }

        @Override
        public boolean isScheduledDateTimeCanBeDetermined() {
            if (this.isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue) {
                return true;
            }
            if (this.isScheduledDateTimeCanBeDetermined == null) {
                this.isScheduledDateTimeCanBeDetermined = false;
                for (Prerequisite prerequisite : this.and_groups) {
                    if (!prerequisite.isScheduledDateTimeCanBeDetermined()) continue;
                    this.isScheduledDateTimeCanBeDetermined = true;
                    break;
                }
            }
            return this.isScheduledDateTimeCanBeDetermined;
        }

        @Override
        public boolean isHappyPath() {
            if (this.isHappyPath == null) {
                this.isHappyPath = false;
                for (Prerequisite prerequisite : this.and_groups) {
                    if (!prerequisite.isHappyPath()) continue;
                    this.isHappyPath = true;
                    break;
                }
            }
            return this.isHappyPath;
        }

        @Override
        public boolean isFlowRecursive() {
            if (this.isFlowRecursive == null) {
                this.isFlowRecursive = false;
                for (Prerequisite prerequisite : this.and_groups) {
                    if (!prerequisite.isFlowRecursive()) continue;
                    this.isFlowRecursive = true;
                    break;
                }
            }
            return this.isFlowRecursive;
        }

        @Override
        public Set<Node> nodes() {
            if (this.nodes == null) {
                this.nodes = new HashSet<Node>();
                this.nodes.add(this.node);
                for (Prerequisite prerequisite : this.and_groups) {
                    this.nodes.addAll(prerequisite.nodes());
                }
            }
            return this.nodes;
        }

        @Override
        public void overrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue() {
            this.isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue = true;
        }

        public String toString() {
            return "OR group for " + this.node;
        }

        private boolean add(PrereqGroup_AND prereqGroup_AND) {
            return this.and_groups.add(prereqGroup_AND);
        }
    }

    private class PrereqGroup_AND
    implements Prerequisite {
        private Collection<Prerequisite> prereqs = new ArrayList<Prerequisite>();
        private boolean isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue;

        private PrereqGroup_AND() {
        }

        @Override
        public boolean isScheduledDateTimeCanBeDetermined() {
            if (this.isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue) {
                return true;
            }
            for (Prerequisite prerequisite : this.prereqs) {
                if (prerequisite.isScheduledDateTimeCanBeDetermined()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isHappyPath() {
            for (Prerequisite prerequisite : this.prereqs) {
                if (prerequisite.isHappyPath()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isFlowRecursive() {
            for (Prerequisite prerequisite : this.prereqs) {
                if (!prerequisite.isFlowRecursive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Node> nodes() {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Prerequisite prerequisite : this.prereqs) {
                hashSet.addAll(prerequisite.nodes());
            }
            return hashSet;
        }

        @Override
        public void overrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue() {
            this.isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue = true;
        }

        private boolean add(Prerequisite prerequisite) {
            return this.prereqs.add(prerequisite);
        }
    }

    private class Prerequisite_Recursive
    implements Prerequisite {
        private Node mainNode;
        private Set<Node> nodes;

        public Prerequisite_Recursive(Node node, Set<Node> set) {
            this.mainNode = node;
            this.nodes = set;
        }

        @Override
        public boolean isScheduledDateTimeCanBeDetermined() {
            return true;
        }

        @Override
        public boolean isHappyPath() {
            return true;
        }

        @Override
        public boolean isFlowRecursive() {
            return true;
        }

        public Node getMainNode() {
            return this.mainNode;
        }

        @Override
        public Set<Node> nodes() {
            return this.nodes;
        }

        @Override
        public void overrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue() {
        }

        public String toString() {
            return MessageUtil.formatMsg((String)"Recursive. mainNode:{0} nodes:{1} ", (Object[])new Object[]{this.mainNode, this.nodes});
        }
    }

    private class Prerequisite_Simple
    implements Prerequisite {
        private Node node;
        private boolean isTimeBased;
        private boolean isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue;

        public Prerequisite_Simple(Node node, boolean bl) {
            this.node = node;
            this.isTimeBased = bl;
        }

        @Override
        public Set<Node> nodes() {
            HashSet<Node> hashSet = new HashSet<Node>(2);
            hashSet.add(this.node);
            return hashSet;
        }

        @Override
        public boolean isScheduledDateTimeCanBeDetermined() {
            if (this.isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue) {
                return true;
            }
            return this.isTimeBased;
        }

        @Override
        public boolean isHappyPath() {
            return true;
        }

        @Override
        public boolean isFlowRecursive() {
            return false;
        }

        @Override
        public void overrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue() {
            this.isOverrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue = true;
        }

        public String toString() {
            return this.node + " time based=" + this.isTimeBased;
        }
    }

    private static interface Prerequisite {
        public boolean isScheduledDateTimeCanBeDetermined();

        public boolean isHappyPath();

        public boolean isFlowRecursive();

        public Set<Node> nodes();

        public void overrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue();
    }

    private class ForecastInfo {
        private ForecastableEvent forecastableEvent;
        private Collection<ForecastedEvent> forecastedEvents;
        private ForecastGenerator forecastGenerator;

        private ForecastInfo() {
        }
    }

    private class JobSubmitter {
        private JobSubmitter() {
        }

        private void submit(DependentObject dependentObject, long l, Calendar calendar, PrereqCondition_Simple[] prereqCondition_SimpleArray, ForecastedEvent.ForecastInitiationCode forecastInitiationCode, ForecastInfo forecastInfo) {
            ForecastableEvent forecastableEvent = forecastInfo.forecastableEvent;
            ForecastGenerator forecastGenerator = forecastInfo.forecastGenerator;
            Collection<ForecastReactivityCausePrereq> collection = forecastGenerator.prereqsThatNeedRunID;
            Calendar calendar2 = calendar;
            DependentObject.DependentObjectType dependentObjectType = DependentObject.DependentObjectType.forecastableEventTypeToEnum((ForecastableEvent.ForecastableEventType)forecastableEvent.getType());
            if (dependentObject.getType() == dependentObjectType && dependentObject.getID() == forecastableEvent.getID() && !calendar.before(forecastGenerator.rangeBegin)) {
                SkipInstanceCache skipInstanceCache;
                AgentJobDuration agentJobDuration = forecastInfo.forecastGenerator.getAgentJobDurationCache().getAgentJobDuration(l, this.getJobID(forecastableEvent));
                long l2 = agentJobDuration.getQueueDuration();
                if (forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.JOB_SUITE) {
                    l2 = 0L;
                }
                ForecastedEvent forecastedEvent = new ForecastedEvent(forecastableEvent, l, calendar2.getTimeInMillis(), forecastInitiationCode, l2, agentJobDuration.getRunDuration());
                forecastInfo.forecastedEvents.add(forecastedEvent);
                forecastedEvent.setForecastReactivityCause(this.constructForecastReactivityCause(prereqCondition_SimpleArray, forecastInfo));
                forecastedEvent.setForecastedObjectRunID(new ForecastedObjectRunID());
                if (this.isSatisfiesARunIDNeed(forecastedEvent, collection)) {
                    this.updatePrereqsInNeedOfARunID(forecastedEvent, collection);
                }
                if (dependentObject.getType() == DependentObject.DependentObjectType.MEMBER_JOB) {
                    forecastedEvent.setSuiteEventInfo(this.retrieveSuiteEventInfo(prereqCondition_SimpleArray));
                }
                if (dependentObject.getType() == DependentObject.DependentObjectType.JOB_SUITE) {
                    skipInstanceCache = new ForecastSuiteEventInfo(dependentObject.getID(), calendar2.getTimeInMillis());
                    forecastedEvent.setSuiteEventInfo((ForecastSuiteEventInfo)skipInstanceCache);
                    forecastGenerator.suiteEventInfoCache.add(skipInstanceCache);
                }
                if (dependentObject.getType() == DependentObject.DependentObjectType.MEMBER_JOB) {
                    skipInstanceCache = forecastGenerator.skipInstanceCache;
                    forecastedEvent.setMemberSkippedPerSpecialInstance(skipInstanceCache.isSkipped(forecastedEvent));
                }
            }
            switch (dependentObject.getType()) {
                case JOB: {
                    long l3 = dependentObject.getID();
                    forecastGenerator.createQueueEntries_JobStatusChange(l3, l, calendar2);
                    break;
                }
                case JOB_SUITE: {
                    long l4 = dependentObject.getID();
                    forecastGenerator.createQueueEntries_SuiteStatusChange(l4, l, calendar2);
                    break;
                }
                case MEMBER_JOB: {
                    long l5 = dependentObject.getID();
                    forecastGenerator.createQueueEntries_MemberStatusChange(l5, l, calendar2, this.retrieveSuiteEventInfo(prereqCondition_SimpleArray), this.retrieveSuiteScheduleInfo(prereqCondition_SimpleArray));
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
                }
            }
        }

        private ForecastReactivityCausePrereq[] constructForecastReactivityCause(PrereqCondition_Simple[] prereqCondition_SimpleArray, ForecastInfo forecastInfo) {
            ForecastReactivityCausePrereq[] forecastReactivityCausePrereqArray = new ForecastReactivityCausePrereq[prereqCondition_SimpleArray.length];
            for (int i = 0; i < prereqCondition_SimpleArray.length; ++i) {
                ForecastReactivityCausePrereq forecastReactivityCausePrereq;
                forecastReactivityCausePrereqArray[i] = forecastReactivityCausePrereq = this.toForecastReactivityCausePrereq(prereqCondition_SimpleArray[i], forecastInfo);
            }
            return forecastReactivityCausePrereqArray;
        }

        private ForecastReactivityCausePrereq toForecastReactivityCausePrereq(PrereqCondition_Simple prereqCondition_Simple, ForecastInfo forecastInfo) {
            Collection<ForecastReactivityCausePrereq> collection = ((ForecastInfo)forecastInfo).forecastGenerator.prereqsThatNeedRunID;
            ForecastReactivityCausePrereq forecastReactivityCausePrereq = new ForecastReactivityCausePrereq();
            forecastReactivityCausePrereq.setPrereqObjectId(prereqCondition_Simple.conditionPrereqObject.id);
            forecastReactivityCausePrereq.setPrereqObjectType(prereqCondition_Simple.conditionPrereqObject.prereqObjType);
            forecastReactivityCausePrereq.setPrereqAgentID(prereqCondition_Simple.prereqAgentID);
            forecastReactivityCausePrereq.setStatus(prereqCondition_Simple.lastStatus);
            forecastReactivityCausePrereq.setTimestamp(prereqCondition_Simple.timestamp);
            if (collection.contains(forecastReactivityCausePrereq)) {
                forecastReactivityCausePrereq = this.getFromSet(forecastReactivityCausePrereq, collection);
            } else {
                ForecastedObjectRunID forecastedObjectRunID = this.getRunIDFromMatchingForecastedEvent(forecastReactivityCausePrereq, ((ForecastInfo)forecastInfo).forecastGenerator.forecastedEvents_ForRun);
                if (forecastedObjectRunID != null) {
                    forecastReactivityCausePrereq.setForecastedObjectRunID(forecastedObjectRunID);
                } else {
                    collection.add(forecastReactivityCausePrereq);
                }
            }
            return forecastReactivityCausePrereq;
        }

        private ForecastReactivityCausePrereq getFromSet(ForecastReactivityCausePrereq forecastReactivityCausePrereq, Collection<ForecastReactivityCausePrereq> collection) {
            for (ForecastReactivityCausePrereq forecastReactivityCausePrereq2 : collection) {
                if (!forecastReactivityCausePrereq2.equals((Object)forecastReactivityCausePrereq)) continue;
                if (forecastReactivityCausePrereq2 == forecastReactivityCausePrereq) {
                    throw new IllegalStateException("Program error.");
                }
                return forecastReactivityCausePrereq2;
            }
            throw new IllegalStateException("Program error. Usage error calling getFromSet method.");
        }

        private long getJobID(ForecastableEvent forecastableEvent) {
            if (forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.MEMBER_JOB) {
                return ((ForecastableEvent_SuiteMember)forecastableEvent).getJobID();
            }
            return forecastableEvent.getID();
        }

        private ForecastedObjectRunID getRunIDFromMatchingForecastedEvent(ForecastReactivityCausePrereq forecastReactivityCausePrereq, Collection<ForecastedEvent> collection) {
            for (ForecastedEvent forecastedEvent : collection) {
                if (!forecastReactivityCausePrereq.isMatchesForecastedEvent(forecastedEvent)) continue;
                if (forecastedEvent.getForecastedObjectRunID() == null) {
                    forecastedEvent.setForecastedObjectRunID(new ForecastedObjectRunID());
                }
                return forecastedEvent.getForecastedObjectRunID();
            }
            return null;
        }

        private boolean isSatisfiesARunIDNeed(ForecastedEvent forecastedEvent, Collection<ForecastReactivityCausePrereq> collection) {
            for (ForecastReactivityCausePrereq forecastReactivityCausePrereq : collection) {
                if (!forecastReactivityCausePrereq.isMatchesForecastedEvent(forecastedEvent)) continue;
                return true;
            }
            return false;
        }

        private ForecastSuiteEventInfo retrieveSuiteEventInfo(PrereqCondition_Simple[] prereqCondition_SimpleArray) {
            ValidationHelper.checkForNull((String)"Prereqs", (Object)prereqCondition_SimpleArray);
            if (prereqCondition_SimpleArray.length > 0) {
                return prereqCondition_SimpleArray[0].suiteEventInfo;
            }
            throw new IllegalArgumentException("Prereqs must not be empty.");
        }

        private ForecastSuiteScheduleInfo retrieveSuiteScheduleInfo(PrereqCondition_Simple[] prereqCondition_SimpleArray) {
            ValidationHelper.checkForNull((String)"Prereqs", (Object)prereqCondition_SimpleArray);
            if (prereqCondition_SimpleArray.length > 0) {
                return prereqCondition_SimpleArray[0].suiteScheduleInfo;
            }
            throw new IllegalArgumentException("Prereqs must not be empty.");
        }

        private void updatePrereqsInNeedOfARunID(ForecastedEvent forecastedEvent, Collection<ForecastReactivityCausePrereq> collection) {
            Iterator<ForecastReactivityCausePrereq> iterator = collection.iterator();
            while (iterator.hasNext()) {
                ForecastReactivityCausePrereq forecastReactivityCausePrereq = iterator.next();
                if (!forecastReactivityCausePrereq.isMatchesForecastedEvent(forecastedEvent)) continue;
                forecastReactivityCausePrereq.setForecastedObjectRunID(forecastedEvent.getForecastedObjectRunID());
                iterator.remove();
            }
        }
    }

    private class PrereqEvaluator {
        private PrereqEvaluator() {
        }

        private void prereqEvent(DependentObject dependentObject, Map<PrereqConditionKey, PrereqCondition> map, Calendar calendar, ForecastInfo forecastInfo, ReactivityTimeRangeManager reactivityTimeRangeManager, Map<Long, Set<DependentObject>> map2, OmitDates omitDates, CalendarObjectManager calendarObjectManager) throws ResourceUnavailableException {
            ForecastGenerator forecastGenerator = forecastInfo.forecastGenerator;
            if (forecastGenerator.hasRegularSchedule(dependentObject)) {
                return;
            }
            for (Map.Entry<PrereqConditionKey, PrereqCondition> entry : map.entrySet()) {
                long l;
                PrereqCondition prereqCondition;
                PrereqConditionKey prereqConditionKey = entry.getKey();
                if (!prereqConditionKey.dependentObject.equals((Object)dependentObject) || !(prereqCondition = entry.getValue()).hasBeenMet() || !this.isWithinReactiveRange(dependentObject, l = prereqConditionKey.dependentAgent, calendar, forecastGenerator, reactivityTimeRangeManager) || omitDates.isOmitDate(dependentObject, calendar) || this.isBypassDueToNonWorkday(dependentObject, calendar, forecastGenerator, calendarObjectManager) || this.isMemberThatIsBeingRestrictedFromRunningAgain(dependentObject, forecastGenerator, map2, prereqCondition.getCauseData())) continue;
                ForecastAMImpl.this.jobSubmitter.submit(dependentObject, l, calendar, prereqCondition.getCauseData(), this.initiationCode(dependentObject), forecastInfo);
                if (dependentObject.getType() == DependentObject.DependentObjectType.MEMBER_JOB) {
                    this.recordThatMemberRan(dependentObject, map2, prereqCondition.getCauseData());
                }
                prereqCondition.clearStatuses();
            }
        }

        private ForecastedEvent.ForecastInitiationCode initiationCode(DependentObject dependentObject) {
            if (dependentObject.getType() == DependentObject.DependentObjectType.MEMBER_JOB) {
                return ForecastedEvent.ForecastInitiationCode.SUITE_MEMBER;
            }
            return ForecastedEvent.ForecastInitiationCode.REACTIVE_ONLY;
        }

        private boolean isBypassDueToNonWorkday(DependentObject dependentObject, Calendar calendar, ForecastGenerator forecastGenerator, CalendarObjectManager calendarObjectManager) {
            switch (dependentObject.getType()) {
                case JOB: 
                case JOB_SUITE: {
                    long l = dependentObject.getID();
                    boolean bl = forecastGenerator.isReactiveJobThatDoesNotRunOnNonWorkDays(l);
                    if (bl) {
                        CalendarObject calendarObject;
                        try {
                            calendarObject = calendarObjectManager.getCalendarObjectForJob(l);
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to load a CalendarObject for {0} with ID {1}.", (Object[])new Object[]{dependentObject.getType(), l}), exception);
                        }
                        return calendarObject.isNonWorkday(calendar);
                    }
                    return false;
                }
                case MEMBER_JOB: {
                    return false;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
        }

        private boolean isMemberThatIsBeingRestrictedFromRunningAgain(DependentObject dependentObject, ForecastGenerator forecastGenerator, Map<Long, Set<DependentObject>> map, PrereqCondition_Simple[] prereqCondition_SimpleArray) {
            ForecastSuiteScheduleInfo forecastSuiteScheduleInfo;
            long l;
            Set<DependentObject> set;
            boolean bl;
            boolean bl2 = bl = dependentObject.getType() == DependentObject.DependentObjectType.MEMBER_JOB && !forecastGenerator.membersWithTheANYOption.contains(dependentObject.getID());
            return bl && (set = map.get(l = (forecastSuiteScheduleInfo = this.retrieveSuiteScheduleInfo(prereqCondition_SimpleArray)).getSuiteRunID())) != null && set.contains(dependentObject);
        }

        private boolean isWithinReactiveRange(DependentObject dependentObject, long l, Calendar calendar, ForecastGenerator forecastGenerator, ReactivityTimeRangeManager reactivityTimeRangeManager) throws ResourceUnavailableException {
            if (forecastGenerator.hasReactiveRange(dependentObject)) {
                switch (dependentObject.getType()) {
                    case JOB: 
                    case JOB_SUITE: {
                        ScheduleJobProxy scheduleJobProxy = this.jobProxy(dependentObject);
                        Calendar calendar2 = (Calendar)calendar.clone();
                        TimeZone timeZone = this.timezone(scheduleJobProxy, l);
                        calendar2.setTimeZone(timeZone);
                        long l2 = scheduleJobProxy.getSkybotJobNumber();
                        return reactivityTimeRangeManager.isReactiveTime(l2, calendar2);
                    }
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
            }
            return true;
        }

        private String agentTimezoneID(long l) {
            String string;
            try {
                Agent agent = ForecastAMImpl.this.agentDM.get(l);
                string = agent.getTimeZone();
            }
            catch (Exception exception) {
                TimeZone timeZone = this.serverTimeZone();
                string = timeZone.getID();
                String string2 = MessageUtil.formatMsg((String)"Unable to retrieve the time zone ID for the agent with ID {0}. The ID of the server time zone ({1}) will be used instead.", (Object[])new Object[]{l, string});
                logger.error((Object)string2, (Throwable)exception);
            }
            return string;
        }

        private ScheduleJobProxy jobProxy(DependentObject dependentObject) {
            switch (dependentObject.getType()) {
                case JOB: 
                case JOB_SUITE: {
                    long l = dependentObject.getID();
                    try {
                        return ForecastAMImpl.this.scheduleJobDM.getScheduleJobProxy(l);
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to load the ScheduleJobProxy for the job with ID {0}.", (Object[])new Object[]{l}), exception);
                    }
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
        }

        private void recordThatMemberRan(DependentObject dependentObject, Map<Long, Set<DependentObject>> map, PrereqCondition_Simple[] prereqCondition_SimpleArray) {
            ForecastSuiteScheduleInfo forecastSuiteScheduleInfo = this.retrieveSuiteScheduleInfo(prereqCondition_SimpleArray);
            long l = forecastSuiteScheduleInfo.getSuiteRunID();
            Set<DependentObject> set = map.get(l);
            if (set == null) {
                set = new HashSet<DependentObject>();
                map.put(l, set);
            }
            set.add(dependentObject);
        }

        private ForecastSuiteScheduleInfo retrieveSuiteScheduleInfo(PrereqCondition_Simple[] prereqCondition_SimpleArray) {
            ValidationHelper.checkForNull((String)"Prereqs", (Object)prereqCondition_SimpleArray);
            if (prereqCondition_SimpleArray.length > 0) {
                return prereqCondition_SimpleArray[0].suiteScheduleInfo;
            }
            throw new IllegalArgumentException("Prereqs must not be empty.");
        }

        private TimeZone serverTimeZone() {
            return TimeZone.getDefault();
        }

        private TimeZone timezone(ScheduleJobProxy scheduleJobProxy, long l) {
            TimeZone timeZone;
            String string = scheduleJobProxy.getName();
            ScheduleInfo.TimeZoneType timeZoneType = scheduleJobProxy.getTimezoneType();
            switch (timeZoneType) {
                case SERVER: {
                    timeZone = this.serverTimeZone();
                    break;
                }
                case AGENT: {
                    String string2 = this.agentTimezoneID(l);
                    timeZone = this.timezone(string2, string);
                    break;
                }
                case JOB: {
                    String string3 = scheduleJobProxy.getJobTimezone();
                    if (string3 != null && !string3.isEmpty()) {
                        timeZone = this.timezone(string3, string);
                        break;
                    }
                    timeZone = this.serverTimeZone();
                    String string4 = timeZone.getID();
                    logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for job/suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{string, string4}));
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
                }
            }
            return timeZone;
        }

        private TimeZone timezone(String string, String string2) {
            TimeZone timeZone = null;
            try {
                timeZone = ZoneInfo.getTimeZone(string);
                if (timeZone == null) {
                    timeZone = this.serverTimeZone();
                    String string3 = timeZone.getID();
                    logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
                }
            }
            catch (Exception exception) {
                timeZone = this.serverTimeZone();
                String string4 = timeZone.getID();
                String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
                logger.error((Object)string5, (Throwable)exception);
            }
            return timeZone;
        }
    }

    private class PrereqMarker {
        private PrereqMarker() {
        }

        private Set<DependentObject> processEvent(ForecastPrereqEvent forecastPrereqEvent, DependencyEntry[] dependencyEntryArray, Map<PrereqConditionKey, PrereqCondition> map, CalendarObjectManager calendarObjectManager, ForecastInfo forecastInfo, DateObjectCache dateObjectCache) throws ResourceUnavailableException {
            HashSet<DependentObject> hashSet = new HashSet<DependentObject>();
            for (int i = 0; i < dependencyEntryArray.length; ++i) {
                boolean bl;
                boolean bl2;
                DependencyEntry dependencyEntry = dependencyEntryArray[i];
                if (dependencyEntry.getPrerequisiteID() != forecastPrereqEvent.getEventID() || dependencyEntry.getPrerequisiteType() != forecastPrereqEvent.getEventType() || dependencyEntry.isReactToSpecificInstanceOnly() && !this.prereqEventMatchesTheSpecificInstanceCriteria(forecastPrereqEvent, dependencyEntry.getSpecificInstance(), calendarObjectManager, dateObjectCache)) continue;
                if (this.statusMatchesReactToStatus(forecastPrereqEvent.getStatus(), dependencyEntry.getReactToStatus())) {
                    bl2 = true;
                    bl = true;
                } else if (!dependencyEntry.isLatchStatus()) {
                    bl2 = true;
                    bl = false;
                } else {
                    bl2 = false;
                    bl = false;
                }
                if (bl2) {
                    for (PrereqCondition prereqCondition : map.values()) {
                        PrereqObj prereqObj = new PrereqObj(forecastPrereqEvent.getEventID(), forecastPrereqEvent.getEventType());
                        prereqCondition.updateStatus(prereqObj, forecastPrereqEvent.getAgentID(), forecastPrereqEvent.getStatus(), forecastPrereqEvent.getTimestamp(), dependencyEntry, this.suiteEventInfo(forecastPrereqEvent), this.suiteScheduleInfo(forecastPrereqEvent, forecastInfo));
                    }
                }
                if (!bl) continue;
                hashSet.add(dependencyEntry.getDependentObject());
            }
            return hashSet;
        }

        private boolean prereqEventMatchesTheSpecificInstanceCriteria(ForecastPrereqEvent forecastPrereqEvent, ForecastSpecificInstance forecastSpecificInstance, CalendarObjectManager calendarObjectManager, DateObjectCache dateObjectCache) throws ResourceUnavailableException {
            Object object;
            ForecastSuiteScheduleInfo forecastSuiteScheduleInfo;
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            ValidationHelper.checkForNull((String)"Specific Instance", (Object)forecastSpecificInstance);
            try {
                l5 = ForecastAMImpl.this.forecastDM.getCalendarObjectID(forecastPrereqEvent);
            }
            catch (NoDataException noDataException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not determine the Calendar Object id for {0} {1}.", (Object[])new Object[]{forecastPrereqEvent.getEventType(), forecastPrereqEvent.getEventID()}), noDataException);
            }
            CalendarObject calendarObject = null;
            try {
                calendarObject = calendarObjectManager.getCalendarObject(l5);
            }
            catch (NoDataException noDataException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Calendar Object (id {0}) not found.", (Object[])new Object[]{l5}), noDataException);
            }
            catch (BadDataException badDataException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to construct Calendar Object (id {0}), due to corrupt data.", (Object[])new Object[]{l5}), badDataException);
            }
            switch (forecastPrereqEvent.getEventType()) {
                case AGENT_EVENT: {
                    return forecastSpecificInstance.matchesSpecificInstanceCriteria(forecastPrereqEvent.getTimestamp(), 0L, calendarObject, dateObjectCache);
                }
                case JOB_STATUS_CHANGE: {
                    l4 = ((ForecastPrereqEvent_JobStatusChange)forecastPrereqEvent).getScheduledDateTime();
                    l3 = ((ForecastPrereqEvent_JobStatusChange)forecastPrereqEvent).getMovedFromScheduledDateTime();
                    l2 = forecastPrereqEvent.getEventID();
                    l = forecastPrereqEvent.getAgentID();
                    break;
                }
                case JOB_SUITE_STATUS_CHANGE: {
                    l4 = ((ForecastPrereqEvent_SuiteStatusChange)forecastPrereqEvent).getScheduledDateTime();
                    l3 = ((ForecastPrereqEvent_SuiteStatusChange)forecastPrereqEvent).getMovedFromScheduledDateTime();
                    l2 = forecastPrereqEvent.getEventID();
                    l = 0L;
                    break;
                }
                case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                    forecastSuiteScheduleInfo = ((ForecastPrereqEvent_MemberStatusChange)forecastPrereqEvent).getSuiteScheduleInfo();
                    l4 = forecastSuiteScheduleInfo.getScheduledDateTime();
                    l3 = forecastSuiteScheduleInfo.getMovedFromScheduledDateTime();
                    object = ((ForecastPrereqEvent_MemberStatusChange)forecastPrereqEvent).getSuiteEventInfo();
                    l2 = object.getSuiteID();
                    l = 0L;
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prerequisite Event Type {0} is not supported by this method.", (Object[])new Object[]{forecastPrereqEvent.getEventType()}));
                }
            }
            forecastSuiteScheduleInfo = this.jobProxy(l2);
            object = this.timezone((ScheduleJobProxy)forecastSuiteScheduleInfo, l);
            Calendar calendar = Calendar.getInstance((TimeZone)object);
            calendar.setTimeInMillis(l4);
            return forecastSpecificInstance.matchesSpecificInstanceCriteria(calendar, l3, calendarObject, dateObjectCache);
        }

        private String agentTimezoneID(long l) {
            String string;
            try {
                Agent agent = ForecastAMImpl.this.agentDM.get(l);
                string = agent.getTimeZone();
            }
            catch (Exception exception) {
                TimeZone timeZone = this.serverTimeZone();
                string = timeZone.getID();
                String string2 = MessageUtil.formatMsg((String)"Unable to retrieve the time zone ID for the agent with ID {0}. The ID of the server time zone ({1}) will be used instead.", (Object[])new Object[]{l, string});
                logger.error((Object)string2, (Throwable)exception);
            }
            return string;
        }

        private ScheduleJobProxy jobProxy(long l) {
            try {
                return ForecastAMImpl.this.scheduleJobDM.getScheduleJobProxy(l);
            }
            catch (Exception exception) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to load the ScheduleJobProxy for the job/suite with ID {0}.", (Object[])new Object[]{l}), exception);
            }
        }

        private TimeZone serverTimeZone() {
            return TimeZone.getDefault();
        }

        private boolean statusMatchesReactToStatus(PrereqStatusType prereqStatusType, PrereqStatusType prereqStatusType2) {
            if (prereqStatusType2 == PrereqStatusType.ENDED) {
                return prereqStatusType == PrereqStatusType.CANCELED || prereqStatusType == PrereqStatusType.COMPLETED || prereqStatusType == PrereqStatusType.FAILED;
            }
            return prereqStatusType == prereqStatusType2;
        }

        private ForecastSuiteEventInfo suiteEventInfo(ForecastPrereqEvent forecastPrereqEvent) {
            switch (forecastPrereqEvent.getEventType()) {
                case JOB_SUITE_STATUS_CHANGE: {
                    return ((ForecastPrereqEvent_SuiteStatusChange)forecastPrereqEvent).getSuiteEventInfo();
                }
                case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                    return ((ForecastPrereqEvent_MemberStatusChange)forecastPrereqEvent).getSuiteEventInfo();
                }
            }
            return null;
        }

        private ForecastSuiteScheduleInfo suiteScheduleInfo(ForecastPrereqEvent forecastPrereqEvent, ForecastInfo forecastInfo) {
            switch (forecastPrereqEvent.getEventType()) {
                case JOB_SUITE_STATUS_CHANGE: {
                    long l = forecastInfo.forecastGenerator.suiteRunIDGenerator++;
                    long l2 = ((ForecastPrereqEvent_SuiteStatusChange)forecastPrereqEvent).getScheduledDateTime();
                    long l3 = ((ForecastPrereqEvent_SuiteStatusChange)forecastPrereqEvent).getMovedFromScheduledDateTime();
                    return new ForecastSuiteScheduleInfo(l, l2, l3);
                }
                case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                    return ((ForecastPrereqEvent_MemberStatusChange)forecastPrereqEvent).getSuiteScheduleInfo();
                }
            }
            return null;
        }

        private TimeZone timezone(ScheduleJobProxy scheduleJobProxy, long l) {
            TimeZone timeZone;
            String string = scheduleJobProxy.getName();
            ScheduleInfo.TimeZoneType timeZoneType = scheduleJobProxy.getTimezoneType();
            switch (timeZoneType) {
                case SERVER: {
                    timeZone = this.serverTimeZone();
                    break;
                }
                case AGENT: {
                    String string2 = this.agentTimezoneID(l);
                    timeZone = this.timezone(string2, string);
                    break;
                }
                case JOB: {
                    String string3 = scheduleJobProxy.getJobTimezone();
                    if (string3 != null && !string3.isEmpty()) {
                        timeZone = this.timezone(string3, string);
                        break;
                    }
                    timeZone = this.serverTimeZone();
                    String string4 = timeZone.getID();
                    logger.error((Object)MessageUtil.formatMsg((String)"The job-specific time zone ID for job/suite {0} is missing. The server time zone ID {1} will be used instead.", (Object[])new Object[]{string, string4}));
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
                }
            }
            return timeZone;
        }

        private TimeZone timezone(String string, String string2) {
            TimeZone timeZone = null;
            try {
                timeZone = ZoneInfo.getTimeZone(string);
                if (timeZone == null) {
                    timeZone = this.serverTimeZone();
                    String string3 = timeZone.getID();
                    logger.error((Object)MessageUtil.formatMsg((String)"The time zone ID {0}, for job/suite {1} is unrecognized. The server time zone {2} will be used instead.", (Object[])new Object[]{string, string2, string3}));
                }
            }
            catch (Exception exception) {
                timeZone = this.serverTimeZone();
                String string4 = timeZone.getID();
                String string5 = MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0}, for job/suite {1}, to a TimeZone object. The server time zone ({2}) will be used instead.", (Object[])new Object[]{string, string2, string4});
                logger.error((Object)string5, (Throwable)exception);
            }
            return timeZone;
        }
    }

    private class ReactivitySimulator {
        private ReactivitySimulator() {
        }

        private ResidualData simulate(Queue<QueueEntry> queue, Map<Node, Prerequisite> map, Map<DependentObject, List<DependencyEntry>> map2, Calendar calendar, ForecastInfo forecastInfo, Map<PrereqConditionKey, PrereqCondition> map3, CalendarObjectManager calendarObjectManager, DateObjectCache dateObjectCache, OmitDates omitDates) throws ResourceUnavailableException {
            QueueEntry queueEntry;
            ReactivityTimeRangeManager reactivityTimeRangeManager = new ReactivityTimeRangeManager(calendarObjectManager);
            ArrayList<QueueEntry> arrayList = null;
            HashMap hashMap = new HashMap();
            Map<DependentObject, List<DependencyEntry>> map4 = this.subsetDepEntries(map2, map);
            DependencyEntry[] dependencyEntryArray = this.createArrayFromMapValues(map4);
            Map<PrereqConditionKey, PrereqCondition> map5 = this.createPrereqConditionsMap(map4, map3);
            block4: while ((queueEntry = queue.poll()) != null) {
                if (!queueEntry.timestamp.after(calendar)) {
                    switch (queueEntry.getQueueEntryType()) {
                        case CHECK_DEPENDENCIES_EVENT: {
                            ForecastPrereqEvent forecastPrereqEvent = this.toForecastPrereqEvent(queueEntry);
                            Set set = ForecastAMImpl.this.prereqMarker.processEvent(forecastPrereqEvent, dependencyEntryArray, map5, calendarObjectManager, forecastInfo, dateObjectCache);
                            for (DependentObject dependentObject : set) {
                                ForecastAMImpl.this.prereqEvaluator.prereqEvent(dependentObject, map5, forecastPrereqEvent.getTimestamp(), forecastInfo, reactivityTimeRangeManager, hashMap, omitDates, calendarObjectManager);
                            }
                            continue block4;
                        }
                        case CHECK_PREREQS_EVENT: {
                            DependentObject dependentObject = this.toDependentObject((QueueEntry_CheckPrereqsEvent)queueEntry);
                            long l = queueEntry.getAgentID();
                            Calendar calendar2 = queueEntry.getTimestamp();
                            PrereqConditionKey prereqConditionKey = new PrereqConditionKey(dependentObject, l);
                            boolean bl = false;
                            PrereqCondition prereqCondition = map5.get(prereqConditionKey);
                            if (prereqCondition != null && prereqCondition.hasBeenMet()) {
                                bl = true;
                            }
                            if (bl) {
                                ForecastAMImpl.this.jobSubmitter.submit(dependentObject, l, calendar2, prereqCondition.getCauseData(), ForecastedEvent.ForecastInitiationCode.REACTIVE_AND_REGULAR_SCHEDULE, forecastInfo);
                                prereqCondition.clearStatuses();
                                continue block4;
                            }
                            if (prereqCondition == null) continue block4;
                            prereqCondition.clearStatuses();
                            continue block4;
                        }
                    }
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Queue Entry Type {0} is not supported by this method.", (Object[])new Object[]{queueEntry.getQueueEntryType()}));
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<QueueEntry>();
                }
                arrayList.add(queueEntry);
            }
            return new ResidualData(map5, forecastInfo.forecastableEvent, arrayList);
        }

        private long[] agentsInGroup(long l) {
            try {
                return ForecastAMImpl.this.agentGroupDM.getAgentsIDsInGroup(l, null);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new RuntimeException("Error retrieving agents in group: " + l, resourceUnavailableException);
            }
        }

        private long[] agentsThatTheDependentObjectRunsOn(List<DependencyEntry> list) throws ResourceUnavailableException {
            Iterator<DependencyEntry> iterator = list.iterator();
            if (iterator.hasNext()) {
                DependencyEntry dependencyEntry = iterator.next();
                return this.agentsOnTarget(dependencyEntry.getDependentTargetInfo());
            }
            return null;
        }

        private long[] agentsOnTarget(ForecastTargetInfo forecastTargetInfo) throws ResourceUnavailableException {
            long l = forecastTargetInfo.getId();
            ScheduleInfo.TargetType targetType = forecastTargetInfo.getType();
            if (targetType != null) {
                switch (targetType) {
                    case AGENT: {
                        return new long[]{l};
                    }
                    case AGENT_GROUP: {
                        switch (forecastTargetInfo.getAgentGroupType()) {
                            case ALL_AGENTS: {
                                return ForecastAMImpl.this.agentGroupDM.getAgentsIDsInGroup(l, null);
                            }
                            case UTILIZATION_BALANCED: 
                            case PREFERRED_AGENT: {
                                return new long[]{0L};
                            }
                        }
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group Type {0} is not supported by this method.", (Object[])new Object[]{forecastTargetInfo.getAgentGroupType()}));
                    }
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{targetType}));
            }
            return new long[]{0L};
        }

        private long agentThatThePrereqObjectRunsOn(DependencyEntry dependencyEntry) {
            ForecastTargetInfo forecastTargetInfo = dependencyEntry.getPrereqTargetInfo();
            if (!this.targetRepresentsOneAgent(forecastTargetInfo)) {
                throw new IllegalStateException("Program error: Being asked to return just one agent ID, when multiple are possible.");
            }
            ScheduleInfo.TargetType targetType = forecastTargetInfo.getType();
            if (targetType == null) {
                return 0L;
            }
            switch (targetType) {
                case AGENT: {
                    return forecastTargetInfo.getId();
                }
                case AGENT_GROUP: {
                    AgentGroupType agentGroupType = forecastTargetInfo.getAgentGroupType();
                    switch (agentGroupType) {
                        case UTILIZATION_BALANCED: 
                        case PREFERRED_AGENT: {
                            return 0L;
                        }
                    }
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group Type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{targetType}));
        }

        private PrereqCondition constructPrereqCondition(List<DependencyEntry> list, long l) throws ResourceUnavailableException {
            Collections.sort(list, new SequenceNumberComparator());
            PrereqCondition_OR prereqCondition_OR = null;
            PrereqCondition_AND prereqCondition_AND = null;
            for (DependencyEntry dependencyEntry : list) {
                if (prereqCondition_OR == null) {
                    prereqCondition_OR = new PrereqCondition_OR();
                    prereqCondition_AND = new PrereqCondition_AND();
                    prereqCondition_OR.add(prereqCondition_AND);
                } else if (dependencyEntry.getConjunction() == PrerequisiteConditionsList.PrereqConjunction.OR) {
                    prereqCondition_AND = new PrereqCondition_AND();
                    prereqCondition_OR.add(prereqCondition_AND);
                }
                PrereqObj prereqObj = new PrereqObj(dependencyEntry.getPrerequisiteID(), dependencyEntry.getPrerequisiteType());
                PrereqCondition_Simple prereqCondition_Simple = new PrereqCondition_Simple(prereqObj, dependencyEntry.getReactToStatus(), dependencyEntry);
                boolean bl = this.targetRepresentsOneAgent(dependencyEntry.getPrereqTargetInfo());
                if (bl) {
                    prereqCondition_Simple.prereqAgentID = this.agentThatThePrereqObjectRunsOn(dependencyEntry);
                    prereqCondition_AND.add(prereqCondition_Simple);
                    continue;
                }
                boolean bl2 = this.targetIsAnAllAgentsTypeAgentGroup(dependencyEntry.getDependentTargetInfo());
                if (bl2) {
                    prereqCondition_Simple.prereqAgentID = l;
                    prereqCondition_AND.add(prereqCondition_Simple);
                    continue;
                }
                for (long l2 : this.agentsInGroup(dependencyEntry.getPrereqTargetID())) {
                    PrereqCondition_Simple prereqCondition_Simple2 = prereqCondition_Simple.copyOf();
                    prereqCondition_Simple2.prereqAgentID = l2;
                    prereqCondition_AND.add(prereqCondition_Simple2);
                }
            }
            if (prereqCondition_OR.prereqConditions.size() == 1 && prereqCondition_AND.prereqConditions.size() == 1) {
                return prereqCondition_AND.prereqConditions.get(0);
            }
            return prereqCondition_OR;
        }

        private DependencyEntry[] createArrayFromMapValues(Map<DependentObject, List<DependencyEntry>> map) {
            ArrayList arrayList = new ArrayList();
            for (Map.Entry<DependentObject, List<DependencyEntry>> entry : map.entrySet()) {
                arrayList.addAll(entry.getValue());
            }
            return arrayList.toArray(new DependencyEntry[arrayList.size()]);
        }

        private DependentObject convertToDependentObject(Node node) {
            DependentObject.DependentObjectType dependentObjectType;
            switch (node.type) {
                case JOB: {
                    dependentObjectType = DependentObject.DependentObjectType.JOB;
                    break;
                }
                case JOB_SUITE: {
                    dependentObjectType = DependentObject.DependentObjectType.JOB_SUITE;
                    break;
                }
                case MEMBER_JOB: {
                    dependentObjectType = DependentObject.DependentObjectType.MEMBER_JOB;
                    break;
                }
                case REACTIVE_EVENT: {
                    dependentObjectType = DependentObject.DependentObjectType.REACTIVE_EVENT;
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Node Type {0} is not expected in the convertToDependentObject method.", (Object[])new Object[]{node.type}));
                }
            }
            return new DependentObject(node.id, dependentObjectType);
        }

        private Map<PrereqConditionKey, PrereqCondition> createPrereqConditionsMap(Map<DependentObject, List<DependencyEntry>> map, Map<PrereqConditionKey, PrereqCondition> map2) throws ResourceUnavailableException {
            for (List<DependencyEntry> object : map.values()) {
                for (DependencyEntry dependencyEntry : object) {
                    this.retrieveDependentObjectTargetInfo(dependencyEntry);
                    this.retrievePrereqObjectTargetInfo(dependencyEntry);
                }
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry<DependentObject, List<DependencyEntry>> entry : map.entrySet()) {
                DependencyEntry dependencyEntry;
                dependencyEntry = entry.getKey();
                List<DependencyEntry> list = entry.getValue();
                for (long l : this.agentsThatTheDependentObjectRunsOn(list)) {
                    PrereqConditionKey prereqConditionKey = new PrereqConditionKey((DependentObject)dependencyEntry, l);
                    hashMap.put(prereqConditionKey, this.constructPrereqCondition(list, l));
                }
            }
            this.loadAnyCachedPrereqConditions(hashMap, map2, map);
            return hashMap;
        }

        private Set<DependentObject> extractDependentObjectsFromFlowMap(Map<Node, Prerequisite> map) {
            HashSet<DependentObject> hashSet = new HashSet<DependentObject>();
            for (Map.Entry<Node, Prerequisite> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                Node node = entry.getKey();
                hashSet.add(this.convertToDependentObject(node));
            }
            return hashSet;
        }

        private void loadAnyCachedPrereqConditions(Map<PrereqConditionKey, PrereqCondition> map, Map<PrereqConditionKey, PrereqCondition> map2, Map<DependentObject, List<DependencyEntry>> map3) {
            if (map2 != null) {
                Set<DependentObject> set = map3.keySet();
                for (Map.Entry<PrereqConditionKey, PrereqCondition> entry : map2.entrySet()) {
                    DependentObject dependentObject = entry.getKey().dependentObject;
                    if (!set.contains(dependentObject)) continue;
                    map.put(entry.getKey().copyOf(), entry.getValue().copyOf());
                }
            }
        }

        private void retrieveDependentObjectTargetInfo(DependencyEntry dependencyEntry) throws ResourceUnavailableException {
            if (!dependencyEntry.isDependentTargetInfoSet()) {
                try {
                    ForecastTargetInfo forecastTargetInfo = ForecastAMImpl.this.forecastDM.getTargetInfo(dependencyEntry.getDependentObject());
                    dependencyEntry.setDependentTargetInfo(forecastTargetInfo);
                }
                catch (NoDataException noDataException) {
                    throw new IllegalStateException(noDataException);
                }
            }
        }

        private void retrievePrereqObjectTargetInfo(DependencyEntry dependencyEntry) throws ResourceUnavailableException {
            if (!dependencyEntry.isPrereqTargetInfoSet()) {
                try {
                    ForecastTargetInfo forecastTargetInfo = ForecastAMImpl.this.forecastDM.getTargetInfo(dependencyEntry.getPrerequisiteID(), dependencyEntry.getPrerequisiteType());
                    dependencyEntry.setPrereqTargetInfo(forecastTargetInfo);
                }
                catch (NoDataException noDataException) {
                    throw new IllegalStateException(noDataException);
                }
            }
        }

        private Map<DependentObject, List<DependencyEntry>> subsetDepEntries(Map<DependentObject, List<DependencyEntry>> map, Map<Node, Prerequisite> map2) {
            Set<DependentObject> set = this.extractDependentObjectsFromFlowMap(map2);
            HashMap<DependentObject, List<DependencyEntry>> hashMap = new HashMap<DependentObject, List<DependencyEntry>>();
            for (DependentObject dependentObject : set) {
                hashMap.put(dependentObject, map.get(dependentObject));
            }
            return hashMap;
        }

        private boolean targetRepresentsOneAgent(ForecastTargetInfo forecastTargetInfo) {
            ValidationHelper.checkForNull((String)"Forecast Target Info", (Object)forecastTargetInfo);
            ScheduleInfo.TargetType targetType = forecastTargetInfo.getType();
            if (targetType == null) {
                return true;
            }
            switch (targetType) {
                case AGENT: {
                    return true;
                }
                case AGENT_GROUP: {
                    AgentGroupType agentGroupType = forecastTargetInfo.getAgentGroupType();
                    switch (agentGroupType) {
                        case ALL_AGENTS: {
                            return false;
                        }
                        case UTILIZATION_BALANCED: 
                        case PREFERRED_AGENT: {
                            return true;
                        }
                    }
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group Type {0} is not supported by this method.", (Object[])new Object[]{agentGroupType}));
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{targetType}));
        }

        private boolean targetIsAnAllAgentsTypeAgentGroup(ForecastTargetInfo forecastTargetInfo) {
            ValidationHelper.checkForNull((String)"Forecast Target Info", (Object)forecastTargetInfo);
            ScheduleInfo.TargetType targetType = forecastTargetInfo.getType();
            return targetType != null && targetType == ScheduleInfo.TargetType.AGENT_GROUP && forecastTargetInfo.getAgentGroupType() == AgentGroupType.ALL_AGENTS;
        }

        private DependentObject toDependentObject(QueueEntry_CheckPrereqsEvent queueEntry_CheckPrereqsEvent) {
            long l = queueEntry_CheckPrereqsEvent.eventID;
            switch (queueEntry_CheckPrereqsEvent.getCheckPrereqsEventType()) {
                case JOB: {
                    return new DependentObject(l, DependentObject.DependentObjectType.JOB);
                }
                case SUITE: {
                    return new DependentObject(l, DependentObject.DependentObjectType.JOB_SUITE);
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Check Prereq Event Type {0} is not supported by this method.", (Object[])new Object[]{queueEntry_CheckPrereqsEvent.getCheckPrereqsEventType()}));
        }

        private ForecastPrereqEvent toForecastPrereqEvent(QueueEntry queueEntry) {
            if (queueEntry.getQueueEntryType() == QueueEntryType.CHECK_DEPENDENCIES_EVENT) {
                QueueEntry_CheckDependenciesEvent queueEntry_CheckDependenciesEvent = (QueueEntry_CheckDependenciesEvent)queueEntry;
                long l = queueEntry_CheckDependenciesEvent.agentID;
                Calendar calendar = queueEntry_CheckDependenciesEvent.timestamp;
                CheckDependenciesEventType checkDependenciesEventType = queueEntry_CheckDependenciesEvent.getCheckDependenciesEventType();
                switch (checkDependenciesEventType) {
                    case JOB_STATUS_CHANGE: 
                    case SUITE_STATUS_CHANGE: {
                        long l2 = queueEntry_CheckDependenciesEvent.eventID;
                        PrereqStatusType prereqStatusType = ((QueueEntry_JobStatusChange)queueEntry_CheckDependenciesEvent).getStatus();
                        long l3 = ((QueueEntry_JobStatusChange)queueEntry_CheckDependenciesEvent).scheduledDateTime;
                        long l4 = ((QueueEntry_JobStatusChange)queueEntry_CheckDependenciesEvent).movedFromScheduledDateTime;
                        if (checkDependenciesEventType == CheckDependenciesEventType.JOB_STATUS_CHANGE) {
                            return new ForecastPrereqEvent_JobStatusChange(l2, l, prereqStatusType, calendar, l3, l4);
                        }
                        ForecastSuiteEventInfo forecastSuiteEventInfo = ((QueueEntry_JobStatusChange)queueEntry_CheckDependenciesEvent).getSuiteEventInfo();
                        return new ForecastPrereqEvent_SuiteStatusChange(l2, prereqStatusType, calendar, l3, l4, forecastSuiteEventInfo);
                    }
                    case MEMBER_STATUS_CHANGE: {
                        long l5 = queueEntry_CheckDependenciesEvent.eventID;
                        PrereqStatusType prereqStatusType = ((QueueEntry_MemberStatusChange)queueEntry_CheckDependenciesEvent).getStatus();
                        ForecastSuiteEventInfo forecastSuiteEventInfo = ((QueueEntry_MemberStatusChange)queueEntry_CheckDependenciesEvent).getSuiteEventInfo();
                        ForecastSuiteScheduleInfo forecastSuiteScheduleInfo = ((QueueEntry_MemberStatusChange)queueEntry_CheckDependenciesEvent).getSuiteScheduleInf0();
                        return new ForecastPrereqEvent_MemberStatusChange(l5, l, prereqStatusType, calendar, forecastSuiteEventInfo, forecastSuiteScheduleInfo);
                    }
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Check Dependencies Event Type {0} is not supported by this method.", (Object[])new Object[]{checkDependenciesEventType}));
            }
            throw new IllegalStateException("Program error: Invalid QueueEntryType.");
        }
    }

    private static enum EventType {
        AGENT_EVENT,
        JOB_MONITOR_EVENT,
        SNMP_TRAP_EVENT,
        REACTIVE_EVENT;

    }

    private static enum EventIDType {
        JOB,
        MEMBER,
        AGENT_EVENT;

    }

    private static enum CheckDependenciesEventType {
        JOB_STATUS_CHANGE,
        SUITE_STATUS_CHANGE,
        EVENT_OCCURRED,
        MEMBER_STATUS_CHANGE;

    }

    private static enum CheckPrereqsEventType {
        JOB,
        SUITE,
        REACTIVE_EVENT;

    }

    private static enum QueueEntryType {
        CHECK_PREREQS_EVENT,
        CHECK_DEPENDENCIES_EVENT;

    }

    private class QueueEntry_EventOccurred
    extends QueueEntry_CheckDependenciesEvent {
        EventType eventType;

        private QueueEntry_EventOccurred(long l, long l2, Calendar calendar, EventType eventType) {
            super(l, l2, calendar, EventIDType.AGENT_EVENT);
            this.eventType = eventType;
        }

        private EventType getEventType() {
            return this.eventType;
        }

        @Override
        protected CheckDependenciesEventType getCheckDependenciesEventType() {
            return CheckDependenciesEventType.EVENT_OCCURRED;
        }
    }

    private class QueueEntry_MemberStatusChange
    extends QueueEntry_CheckDependenciesEvent {
        PrereqStatusType status;
        ForecastSuiteEventInfo suiteEventInfo;
        ForecastSuiteScheduleInfo suiteScheduleInfo;

        private QueueEntry_MemberStatusChange(long l, long l2, Calendar calendar, ForecastSuiteEventInfo forecastSuiteEventInfo, ForecastSuiteScheduleInfo forecastSuiteScheduleInfo, PrereqStatusType prereqStatusType) {
            super(l, l2, calendar, EventIDType.MEMBER);
            this.suiteEventInfo = forecastSuiteEventInfo;
            this.suiteScheduleInfo = forecastSuiteScheduleInfo;
            this.status = prereqStatusType;
        }

        private PrereqStatusType getStatus() {
            return this.status;
        }

        private ForecastSuiteEventInfo getSuiteEventInfo() {
            return this.suiteEventInfo;
        }

        private ForecastSuiteScheduleInfo getSuiteScheduleInf0() {
            return this.suiteScheduleInfo;
        }

        @Override
        protected CheckDependenciesEventType getCheckDependenciesEventType() {
            return CheckDependenciesEventType.MEMBER_STATUS_CHANGE;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.getStatus();
        }
    }

    private class QueueEntry_JobStatusChange
    extends QueueEntry_CheckDependenciesEvent {
        boolean isSuite;
        PrereqStatusType status;
        long scheduledDateTime;
        long movedFromScheduledDateTime;
        ForecastSuiteEventInfo suiteEventInfo;

        private QueueEntry_JobStatusChange(long l, long l2, Calendar calendar, long l3, long l4, PrereqStatusType prereqStatusType, boolean bl) {
            super(l, l2, calendar, EventIDType.JOB);
            this.scheduledDateTime = l3;
            this.movedFromScheduledDateTime = l4;
            this.status = prereqStatusType;
            this.isSuite = bl;
        }

        private PrereqStatusType getStatus() {
            return this.status;
        }

        private ForecastSuiteEventInfo getSuiteEventInfo() {
            return this.suiteEventInfo;
        }

        private void setSuiteEventInfo(ForecastSuiteEventInfo forecastSuiteEventInfo) {
            if (!this.isSuite) {
                throw new IllegalStateException("Program error: Trying to set suite event info for a non-suite.");
            }
            this.suiteEventInfo = forecastSuiteEventInfo;
        }

        @Override
        protected CheckDependenciesEventType getCheckDependenciesEventType() {
            if (this.isSuite) {
                return CheckDependenciesEventType.SUITE_STATUS_CHANGE;
            }
            return CheckDependenciesEventType.JOB_STATUS_CHANGE;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.getStatus();
        }
    }

    private abstract class QueueEntry_CheckDependenciesEvent
    extends QueueEntry {
        private QueueEntry_CheckDependenciesEvent(long l, long l2, Calendar calendar, EventIDType eventIDType) {
            super(l, l2, calendar, eventIDType);
        }

        @Override
        protected QueueEntryType getQueueEntryType() {
            return QueueEntryType.CHECK_DEPENDENCIES_EVENT;
        }

        protected abstract CheckDependenciesEventType getCheckDependenciesEventType();

        @Override
        public String toString() {
            return super.toString() + " " + (Object)((Object)this.getCheckDependenciesEventType()) + " " + this.eventID;
        }
    }

    private class QueueEntry_ScheduledSuite
    extends QueueEntry_CheckPrereqsEvent {
        private QueueEntry_ScheduledSuite(long l, long l2, Calendar calendar) {
            super(l, l2, calendar, EventIDType.JOB);
        }

        @Override
        protected CheckPrereqsEventType getCheckPrereqsEventType() {
            return CheckPrereqsEventType.SUITE;
        }
    }

    private class QueueEntry_ScheduledJob
    extends QueueEntry_CheckPrereqsEvent {
        private QueueEntry_ScheduledJob(long l, long l2, Calendar calendar) {
            super(l, l2, calendar, EventIDType.JOB);
        }

        @Override
        protected CheckPrereqsEventType getCheckPrereqsEventType() {
            return CheckPrereqsEventType.JOB;
        }
    }

    private abstract class QueueEntry_CheckPrereqsEvent
    extends QueueEntry {
        private QueueEntry_CheckPrereqsEvent(long l, long l2, Calendar calendar, EventIDType eventIDType) {
            super(l, l2, calendar, eventIDType);
        }

        @Override
        protected QueueEntryType getQueueEntryType() {
            return QueueEntryType.CHECK_PREREQS_EVENT;
        }

        protected abstract CheckPrereqsEventType getCheckPrereqsEventType();

        @Override
        public String toString() {
            return super.toString() + " " + (Object)((Object)this.getCheckPrereqsEventType()) + " " + this.eventID;
        }
    }

    private abstract class QueueEntry
    implements Comparable<QueueEntry> {
        long eventID;
        long agentID;
        Calendar timestamp;
        EventIDType eventIDType;

        protected QueueEntry(long l, long l2, Calendar calendar, EventIDType eventIDType) {
            this.eventID = l;
            this.agentID = l2;
            this.timestamp = calendar;
            this.eventIDType = eventIDType;
        }

        private long getAgentID() {
            return this.agentID;
        }

        private long getEventID() {
            return this.eventID;
        }

        private Calendar getTimestamp() {
            return this.timestamp;
        }

        private EventIDType getEventIDType() {
            return this.eventIDType;
        }

        protected abstract QueueEntryType getQueueEntryType();

        public boolean equals(Object object) {
            if (object instanceof QueueEntry) {
                QueueEntry queueEntry = (QueueEntry)object;
                return queueEntry.eventID == this.eventID && queueEntry.getEventIDType() == this.getEventIDType() && queueEntry.getQueueEntryType() == this.getQueueEntryType() && queueEntry.agentID == this.agentID && queueEntry.timestamp.getTimeInMillis() == this.timestamp.getTimeInMillis();
            }
            return false;
        }

        @Override
        public int compareTo(QueueEntry queueEntry) {
            if (queueEntry != null) {
                if (this.timestamp.getTimeInMillis() < queueEntry.timestamp.getTimeInMillis()) {
                    return -1;
                }
                if (this.timestamp.getTimeInMillis() > queueEntry.timestamp.getTimeInMillis()) {
                    return 1;
                }
                if (this.eventID < queueEntry.eventID) {
                    return -1;
                }
                if (this.eventID > queueEntry.eventID) {
                    return 1;
                }
                if (this.agentID < queueEntry.agentID) {
                    return -1;
                }
                if (this.agentID > queueEntry.agentID) {
                    return 1;
                }
                return 0;
            }
            throw new NullPointerException("Trying to compare to null.");
        }

        public String toString() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
            simpleDateFormat.setTimeZone(this.getTimestamp().getTimeZone());
            return simpleDateFormat.format(this.getTimestamp().getTime()) + " " + (Object)((Object)this.getQueueEntryType());
        }
    }

    private class AgentMemberDuration {
        private long queueDuration = 1L;
        private long runDuration = 1L;

        private AgentMemberDuration() {
        }

        private AgentMemberDuration(long l, long l2) {
            if (l > 0L) {
                this.queueDuration = l;
            }
            if (l2 > 0L) {
                this.runDuration = l2;
            }
        }

        private long getQueueDuration() {
            return this.queueDuration;
        }

        private long getRunDuration() {
            return this.runDuration;
        }

        public String toString() {
            return MessageUtil.formatMsg((String)"q= {0} r= {1}", (Object[])new Object[]{this.queueDuration, this.runDuration});
        }
    }

    private class AgentMemberDurationCache {
        AgentJobDurationCache agentJobDurationCache;
        private Map<Long, Long> jobIDs = new HashMap<Long, Long>();

        private AgentMemberDurationCache(AgentJobDurationCache agentJobDurationCache) {
            this.agentJobDurationCache = agentJobDurationCache;
        }

        private AgentMemberDuration getAgentMemberDuration(long l, long l2) {
            if (!this.jobIDs.containsKey(l2)) {
                try {
                    this.jobIDs.put(l2, ForecastAMImpl.this.forecastDM.getJobIDForMember(l2));
                }
                catch (NoDataException noDataException) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Error retrieving duration data for member {0}, on agent {1}.", (Object[])new Object[]{l2, l}), noDataException);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to retrieve duration data, while forecasting member {0}, on agent {1}.", (Object[])new Object[]{l2, l}), (Throwable)resourceUnavailableException);
                    return new AgentMemberDuration();
                }
            }
            long l3 = this.jobIDs.get(l2);
            AgentJobDuration agentJobDuration = this.agentJobDurationCache.getAgentJobDuration(l, l3);
            return new AgentMemberDuration(agentJobDuration.queueDuration, agentJobDuration.runDuration);
        }
    }

    class AgentJobDurationCache {
        private HashMap<AgentJobID, AgentJobDuration> agentJobDurations = new HashMap();

        AgentJobDurationCache() {
        }

        private AgentJobDuration getAgentJobDuration(long l, long l2) {
            AgentJobID agentJobID = new AgentJobID(l, l2);
            AgentJobDuration agentJobDuration = null;
            if (this.agentJobDurations.containsKey(agentJobID)) {
                agentJobDuration = this.agentJobDurations.get(agentJobID);
                if (agentJobDuration != null) {
                    return agentJobDuration;
                }
                throw new NullPointerException("Null agent job duration cache entry for: " + l + ":" + l2);
            }
            try {
                ForecastDurations forecastDurations = ForecastAMImpl.this.jobHistoryDM.calculateDurations(l2, l);
                long l3 = forecastDurations.getQueueDuration();
                long l4 = forecastDurations.getRunDuration();
                agentJobDuration = new AgentJobDuration(l3, l4);
                this.agentJobDurations.put(agentJobID, agentJobDuration);
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Error calculating the run and queue durations for jobID {0}, agentID {1}. Default values will be used.", (Object[])new Object[]{l2, l}), (Throwable)exception);
            }
            if (agentJobDuration == null) {
                if (logger.isTraceEnabled()) {
                    logger.error((Object)("Durations are not available. Using default durations for " + l + ":" + l2));
                }
                agentJobDuration = new AgentJobDuration();
            }
            return agentJobDuration;
        }

        private long runDuration(long l, long l2) {
            try {
                long l3;
                AgentJobID agentJobID = new AgentJobID(l2, l);
                AgentJobDuration agentJobDuration = this.agentJobDurations.get(agentJobID);
                if (agentJobDuration != null && (l3 = agentJobDuration.getRunDuration()) > 1L) {
                    return l3;
                }
                ForecastDurations forecastDurations = ForecastAMImpl.this.jobHistoryDM.calculateDurations(l, l2);
                return forecastDurations.getRunDuration();
            }
            catch (Exception exception) {
                String string = MessageUtil.formatMsg((String)"Unable to calculate the run duration for jobID {0}, agentID {1}. Details: [{2}]", (Object[])new Object[]{l, l2, exception.getMessage()});
                throw new IllegalStateException(string);
            }
        }

        private long[] getZeroAgentJobs() {
            HashSet<Long> hashSet = new HashSet<Long>();
            for (AgentJobID agentJobID : this.agentJobDurations.keySet()) {
                if (agentJobID.agentID != 0L) continue;
                hashSet.add(agentJobID.jobID);
            }
            Object object = new long[hashSet.size()];
            int n = 0;
            for (Long l : hashSet) {
                object[n++] = l;
            }
            Arrays.sort((long[])object);
            return object;
        }

        private void removeAgentJobDuration(long l, long l2) {
            this.agentJobDurations.remove(new AgentJobID(l, l2));
        }

        class AgentJobID {
            long agentID;
            long jobID;

            public AgentJobID(long l, long l2) {
                this.jobID = l2;
                this.agentID = l;
            }

            public boolean equals(Object object) {
                if (object == null || !(object instanceof AgentJobID)) {
                    return false;
                }
                AgentJobID agentJobID = (AgentJobID)object;
                return this.jobID == agentJobID.jobID && this.agentID == agentJobID.agentID;
            }

            public int hashCode() {
                return (this.agentID + ":" + this.jobID).hashCode();
            }

            public String toString() {
                return MessageUtil.formatMsg((String)"j= {0} a= {1}", (Object[])new Object[]{this.jobID, this.agentID});
            }
        }
    }

    class AgentJobDuration {
        private long queueDuration = 1L;
        private long runDuration = 1L;

        protected AgentJobDuration() {
        }

        protected AgentJobDuration(long l, long l2) {
            if (l > 0L) {
                this.queueDuration = l;
            }
            if (l2 > 0L) {
                this.runDuration = l2;
            }
        }

        public long getQueueDuration() {
            return this.queueDuration;
        }

        public long getRunDuration() {
            return this.runDuration;
        }

        public String toString() {
            return MessageUtil.formatMsg((String)"q= {0} r= {1}", (Object[])new Object[]{this.queueDuration, this.runDuration});
        }
    }

    private class ActivityConstrainedPriorityQueue<E>
    extends PriorityQueue<E> {
        private static final long serialVersionUID = 8502565311540556836L;
        int maximumAdds;
        int addCount;
        String addCountExceededMessage = "Add count exceeded.";

        private ActivityConstrainedPriorityQueue() {
        }

        @Override
        public boolean offer(E e) {
            if (this.addCount++ > this.maximumAdds) {
                throw new IllegalStateException(this.addCountExceededMessage);
            }
            return super.offer(e);
        }

        @Override
        public void clear() {
            this.addCount = 0;
            super.clear();
        }

        public int getMaximumAdds() {
            return this.maximumAdds;
        }

        public String getAddCountExceededMessage() {
            return this.addCountExceededMessage;
        }

        public void setMaximumAdds(int n) {
            this.maximumAdds = n;
        }

        public void setAddCountExceededMessage(String string) {
            this.addCountExceededMessage = string;
        }
    }

    private class ForecastGenerator {
        private ForecastFilter forecastFilter;
        private Calendar rangeBegin;
        private Calendar rangeEnd;
        private Calendar simulationBegin;
        Collection<ForecastedEvent> forecastedEvents_ForRun = new ArrayList<ForecastedEvent>();
        private Map<Node, Prerequisite> prereqsMap = new HashMap<Node, Prerequisite>();
        private Node[] nodesWithForecastSchedule;
        private List<DependentObject> dependentObjectsWithReactiveRange = new ArrayList<DependentObject>();
        private Collection<Long> membersWithTheANYOption;
        private SkipInstanceCache skipInstanceCache;
        private Map<DependentObject, List<DependencyEntry>> depMap2 = new HashMap<DependentObject, List<DependencyEntry>>();
        private Map<Node, ScheduleInfo> scheduleInfoMap_RegularSchedule = new HashMap<Node, ScheduleInfo>();
        private Map<Node, ScheduleInfo> scheduleInfoMap_ForecastSchedule = new HashMap<Node, ScheduleInfo>();
        private Calendar cloneOnly_Calendar = Calendar.getInstance();
        private ReactivitySimulator reactivitySimulator = new ReactivitySimulator();
        private ActivityConstrainedPriorityQueue<QueueEntry> queue = new ActivityConstrainedPriorityQueue();
        private AgentJobDurationCache durationCache = new AgentJobDurationCache();
        private AgentMemberDurationCache memberDurationCache = new AgentMemberDurationCache(this.durationCache);
        Collection<ForecastReactivityCausePrereq> prereqsThatNeedRunID = new ArrayList<ForecastReactivityCausePrereq>();
        private Map<PrereqConditionKey, PrereqCondition> prereqConditionsCache = new HashMap<PrereqConditionKey, PrereqCondition>();
        private Map<ForecastableEvent, List<QueueEntry>> queueEntriesCache = new HashMap<ForecastableEvent, List<QueueEntry>>();
        private Set<ForecastSuiteEventInfo> suiteEventInfoCache = new HashSet<ForecastSuiteEventInfo>();
        private CalendarObjectManager calendarObjectManager = new CalendarObjectManager();
        private DateObjectCache dateObjectCache = this.dateObjectCache();
        private OmitDates omitDates;
        private long[] reactiveJobsThatDoNotRunOnNonWorkDays;
        private long suiteRunIDGenerator = 1L;
        ResidualData residualData;
        private int limit_10000;
        private int limitFor_forecastEvents_for_timebasedEvents = this.limit_10000 = 10000;

        private ForecastGenerator() {
            this.queue.setMaximumAdds(10080);
            this.queue.setAddCountExceededMessage(MessageUtil.formatMsg((String)"While simulating reactivity, the limit for job submissions for a single job flow was exceeded. This limit is set at {0}. A recursive job flow, with unrealistically small run durations, is the likely cause. In System Settings, set the Diagnostic - Logging Level to 'Debug' and rerun the forecast to identify recursive job flows.", (Object[])new Object[]{this.queue.getMaximumAdds()}));
        }

        private ForecastResults forecast(ForecastableEvent[] forecastableEventArray, ForecastFilter forecastFilter, Calendar calendar, Calendar calendar2) {
            this.forecastFilter = forecastFilter;
            this.rangeBegin = calendar;
            this.rangeEnd = calendar2;
            ForecastResults forecastResults = new ForecastResults(forecastableEventArray, calendar, calendar2);
            forecastResults.setForecastFilter(forecastFilter);
            if (forecastableEventArray.length > 10) {
                this.batchLoadForecastScheduleInfo();
            }
            this.batchLoadReactiveRangeInfo();
            this.batchLoadMemberExclusionPerSpecialInstanceInfo();
            this.batchLoadMembersWithTheANYOption();
            this.batchLoadOmitDates();
            this.batchLoadReactiveJobsThatDoNotRunOnNonWorkDays();
            this.batchLoadReferencesToNonStandardCalendars();
            if (calendar.getTimeInMillis() < System.currentTimeMillis()) {
                this.simulationBegin = calendar;
            } else {
                this.capturePrereqStatusInfo();
                this.simulationBegin = Calendar.getInstance();
            }
            HashMap<ForecastableEvent, Exception> hashMap = null;
            for (ForecastableEvent forecastableEvent : forecastableEventArray) {
                String string;
                String string2;
                try {
                    this.forecastedEvents_ForRun.addAll(this.forecast(forecastableEvent));
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    string2 = this.toEventType_forMessageString(forecastableEvent.getType());
                    string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). The forecast will be ended and any results that may have been generated so far will be discarded.", (Object[])new Object[]{string2, forecastableEvent.getName(), forecastableEvent.getID()});
                    logger.error((Object)string, (Throwable)resourceUnavailableException);
                    throw new IllegalStateException(string, resourceUnavailableException);
                }
                catch (Exception exception) {
                    string2 = this.toEventType_forMessageString(forecastableEvent.getType());
                    string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). It will not be included in the forecast output.", (Object[])new Object[]{string2, forecastableEvent.getName(), forecastableEvent.getID()});
                    if (hashMap == null) {
                        hashMap = new HashMap<ForecastableEvent, Exception>();
                    }
                    hashMap.put(forecastableEvent, new Exception(string, exception));
                }
            }
            Object[] objectArray = new ForecastedEvent[this.forecastedEvents_ForRun.size()];
            this.forecastedEvents_ForRun.toArray(objectArray);
            Arrays.sort(objectArray);
            forecastResults.setForecastedEvents((ForecastedEvent[])objectArray);
            forecastResults.setErrorMap(hashMap);
            return forecastResults;
        }

        private ResidualData forecast(ForecastableEvent forecastableEvent, Calendar calendar, Calendar calendar2, Calendar calendar3, Collection<ForecastedEvent> collection) throws ResourceUnavailableException {
            this.rangeBegin = calendar;
            this.rangeEnd = calendar2;
            this.simulationBegin = calendar3;
            collection.addAll(this.forecast(forecastableEvent));
            return this.residualData;
        }

        private Collection<ForecastedEvent> forecast(ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            ScheduleInfo scheduleInfo;
            ArrayList<ForecastedEvent> arrayList = new ArrayList<ForecastedEvent>();
            logger.trace((Object)("Forecasting " + this.toEventType_forMessageString(forecastableEvent.getType()) + " " + forecastableEvent.getName() + " (id " + forecastableEvent.getID() + ")."));
            if (this.hasForecastSchedule(forecastableEvent)) {
                scheduleInfo = this.retrieveForecastScheduleInfo(forecastableEvent);
                arrayList.addAll(this.createForecastedEventForEachNSTWithinForecastRange(forecastableEvent, scheduleInfo, ForecastedEvent.ForecastInitiationCode.FORECAST_SCHEDULE));
            }
            arrayList.addAll(this.simulateReactivity(forecastableEvent));
            if (this.hasRegularSchedule(forecastableEvent) && !this.hasPrereqs(forecastableEvent)) {
                scheduleInfo = this.retrieveRegularScheduleInfo(forecastableEvent);
                arrayList.addAll(this.createForecastedEventForEachNSTWithinForecastRange(forecastableEvent, scheduleInfo, ForecastedEvent.ForecastInitiationCode.REGULAR_SCHEDULE));
            }
            return arrayList;
        }

        private void addToMap(DependencyEntry dependencyEntry, Map<Node, List<DependencyEntry>> map) {
            Node node = this.createNodeFromDependencyEntryDependentObject(dependencyEntry);
            List<DependencyEntry> list = map.get(node);
            if (list == null) {
                list = new ArrayList<DependencyEntry>();
                map.put(node, list);
            }
            list.add(dependencyEntry);
        }

        private void adjustCachedDataFor(Collection<ForecastableEvent> collection, Collection<ForecastableEvent> collection2) {
            this.adjustCachedData_ReactiveJobsThatDoNotRunOnNonWorkDays(collection, collection2);
        }

        private void adjustCachedData_ReactiveJobsThatDoNotRunOnNonWorkDays(Collection<ForecastableEvent> collection, Collection<ForecastableEvent> collection2) {
            ForecastableEvent.ForecastableEventType forecastableEventType;
            boolean bl = false;
            for (ForecastableEvent forecastableEvent : collection) {
                forecastableEventType = forecastableEvent.getType();
                if (forecastableEventType != ForecastableEvent.ForecastableEventType.JOB_SUBMISSION && forecastableEventType != ForecastableEvent.ForecastableEventType.JOB_SUITE) continue;
                bl = true;
                break;
            }
            for (ForecastableEvent forecastableEvent : collection2) {
                forecastableEventType = forecastableEvent.getType();
                if (forecastableEventType != ForecastableEvent.ForecastableEventType.JOB_SUBMISSION && forecastableEventType != ForecastableEvent.ForecastableEventType.JOB_SUITE) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.batchLoadReactiveJobsThatDoNotRunOnNonWorkDays();
            }
        }

        private long[] agentsThatTheForecastableEventRunsOn(ScheduleInfo scheduleInfo) throws ResourceUnavailableException {
            ScheduleInfo.TargetType targetType = scheduleInfo.getTargetType();
            if (targetType != null) {
                switch (targetType) {
                    case AGENT: {
                        return new long[]{scheduleInfo.getTargetID()};
                    }
                    case AGENT_GROUP: {
                        switch (scheduleInfo.getAgentGroupType()) {
                            case ALL_AGENTS: {
                                return ForecastAMImpl.this.agentGroupDM.getAgentsIDsInGroup((long)scheduleInfo.getTargetID(), null);
                            }
                            case UTILIZATION_BALANCED: 
                            case PREFERRED_AGENT: {
                                return new long[]{0L};
                            }
                        }
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Agent Group Type {0} is not supported by this method.", (Object[])new Object[]{scheduleInfo.getAgentGroupType()}));
                    }
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Target Type {0} is not supported by this method.", (Object[])new Object[]{targetType}));
            }
            return new long[]{0L};
        }

        private void batchLoadForecastScheduleInfo() {
            try {
                ForecastableEvent[] forecastableEventArray = ForecastAMImpl.this.forecastDM.getAllEventsThatHaveAForecastSchedule();
                this.nodesWithForecastSchedule = new Node[forecastableEventArray.length];
                for (int i = 0; i < forecastableEventArray.length; ++i) {
                    ForecastableEvent forecastableEvent = forecastableEventArray[i];
                    this.nodesWithForecastSchedule[i] = new Node(forecastableEvent);
                }
                Arrays.sort(this.nodesWithForecastSchedule);
            }
            catch (Exception exception) {
                logger.info((Object)"Could not batch load Forecast Schedule information.", (Throwable)exception);
            }
        }

        private void batchLoadMemberExclusionPerSpecialInstanceInfo() {
            this.skipInstanceCache = new SkipInstanceCache();
        }

        private void batchLoadMembersWithTheANYOption() {
            try {
                this.membersWithTheANYOption = ForecastAMImpl.this.forecastDM.getAllMembersWithTheANYOption();
            }
            catch (Exception exception) {
                logger.error((Object)"Could not batch load the list of suite members that have the ANY option.", (Throwable)exception);
                this.membersWithTheANYOption = new ArrayList<Long>();
            }
        }

        private void batchLoadOmitDates() {
            this.omitDates = new OmitDates(this.dateObjectCache, this.calendarObjectManager);
        }

        private void batchLoadReactiveJobsThatDoNotRunOnNonWorkDays() {
            try {
                this.reactiveJobsThatDoNotRunOnNonWorkDays = ForecastAMImpl.this.forecastDM.getAllReactiveJobsThatDoNotRunOnNonWorkDays();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)"Could not batch load the reactive jobs that do not run on non-work days.", (Throwable)resourceUnavailableException);
            }
            Arrays.sort(this.reactiveJobsThatDoNotRunOnNonWorkDays);
        }

        private void batchLoadReactiveRangeInfo() {
            try {
                this.dependentObjectsWithReactiveRange = ForecastAMImpl.this.forecastDM.getAllDependentObjectsThatHaveAReactiveRange();
            }
            catch (Exception exception) {
                logger.info((Object)"Could not batch load Reactive Range information.", (Throwable)exception);
            }
        }

        private void batchLoadReferencesToNonStandardCalendars() {
            this.calendarObjectManager.identifyAllReferencesToOtherThanTheStandardCalendar();
        }

        private Calendar[] calcNSTs_ForJob(long l, long l2, ScheduleInfo scheduleInfo, Calendar calendar, Calendar calendar2) throws ResourceUnavailableException {
            int n = (int)l;
            int n2 = (int)l2;
            try {
                return ForecastAMImpl.this.nstCalculator.calcNST(n, n2, scheduleInfo, calendar, calendar2);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw resourceUnavailableException;
            }
            catch (Exception exception) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                simpleDateFormat.setTimeZone(calendar.getTimeZone());
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to determine a next scheduled runtime for job {0} on agent {1}, that occurs after {2}.", (Object[])new Object[]{this.getJobName(l), this.getAgentName(l2), simpleDateFormat.format(calendar.getTime())}), exception);
            }
        }

        private Calendar[] calcNSTs_ForEvent(long l, long l2, ScheduleInfo scheduleInfo, Calendar calendar, Calendar calendar2) throws ResourceUnavailableException {
            int n = (int)l2;
            try {
                return ForecastAMImpl.this.nstCalculator.calcNST(scheduleInfo, calendar, calendar2, n);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw resourceUnavailableException;
            }
            catch (Exception exception) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                simpleDateFormat.setTimeZone(calendar.getTimeZone());
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to determine a next scheduled runtime for the event with ID {0}, on agent {1}, that occurs after {2}.", (Object[])new Object[]{l, this.getAgentName(l2), simpleDateFormat.format(calendar.getTime())}), exception);
            }
        }

        private void capturePrereqStatusInfo() {
            try {
                ForecastPrerequisiteStatus[] forecastPrerequisiteStatusArray = ForecastAMImpl.this.forecastPrerequisitesDM.retrieveAllNonBlankPrerequisiteStatuses();
                HashSet<DependentObject> hashSet = new HashSet<DependentObject>();
                for (ForecastPrerequisiteStatus forecastPrerequisiteStatus : forecastPrerequisiteStatusArray) {
                    hashSet.add(forecastPrerequisiteStatus.getDependentObject());
                }
                ArrayList arrayList = new ArrayList(hashSet);
                DependencyEntry[] dependencyEntryArray = ForecastAMImpl.this.forecastPrerequisitesDM.retrieveDependencyEntriesForDependentObjects(arrayList);
                if (dependencyEntryArray != null) {
                    for (DependencyEntry dependencyEntry : dependencyEntryArray) {
                        DependentObject dependentObject = dependencyEntry.getDependentObject();
                        Object object = this.depMap2.get(dependentObject);
                        if (object == null) {
                            object = new ArrayList();
                            this.depMap2.put(dependentObject, (List<DependencyEntry>)object);
                        }
                        object.add((DependencyEntry)dependencyEntry);
                    }
                }
                Map map = this.reactivitySimulator.createPrereqConditionsMap(this.depMap2, null);
                PrereqConditionKey prereqConditionKey = new PrereqConditionKey();
                for (Object object : forecastPrerequisiteStatusArray) {
                    prereqConditionKey.dependentObject = object.getDependentObject();
                    prereqConditionKey.dependentAgent = object.getDependentAgentID();
                    PrereqCondition prereqCondition = (PrereqCondition)map.get(prereqConditionKey);
                    PrereqObj prereqObj = new PrereqObj(object.getPrereqObjectID(), object.getPrereqObjectType());
                    prereqCondition.updateStatus(prereqObj, object.getPrereqAgentID(), object.getLastStatus(), object.getStatusTime(), object.getSequenceNumber());
                }
                this.setPrereqConditionsCache(map);
            }
            catch (Exception exception) {
                logger.info((Object)"Could not capture non-blank prerequisite status information.", (Throwable)exception);
                return;
            }
        }

        private Map<PrereqConditionKey, PrereqCondition> capturePrereqStatusInfo(Set<ForecastableEvent> set) {
            Map<PrereqConditionKey, PrereqCondition> map = new HashMap<PrereqConditionKey, PrereqCondition>();
            try {
                ForecastPrerequisiteStatus[] forecastPrerequisiteStatusArray = ForecastAMImpl.this.forecastPrerequisitesDM.retrieveAllNonBlankPrerequisiteStatuses();
                Set<DependentObject> set2 = this.toDependentObjectSet(set);
                ArrayList<ForecastPrerequisiteStatus> arrayList = new ArrayList<ForecastPrerequisiteStatus>();
                for (ForecastPrerequisiteStatus object2 : forecastPrerequisiteStatusArray) {
                    if (!set2.contains(object2.getDependentObject())) continue;
                    arrayList.add(object2);
                }
                HashSet hashSet = new HashSet();
                for (ForecastPrerequisiteStatus forecastPrerequisiteStatus : arrayList) {
                    hashSet.add(forecastPrerequisiteStatus.getDependentObject());
                }
                ArrayList arrayList2 = new ArrayList(hashSet);
                DependencyEntry[] dependencyEntryArray = ForecastAMImpl.this.forecastPrerequisitesDM.retrieveDependencyEntriesForDependentObjects((List)arrayList2);
                if (dependencyEntryArray != null) {
                    Object object;
                    HashMap<DependentObject, ArrayList<DependencyEntry>> hashMap = new HashMap<DependentObject, ArrayList<DependencyEntry>>();
                    for (DependencyEntry dependencyEntry : dependencyEntryArray) {
                        object = dependencyEntry.getDependentObject();
                        ArrayList<DependencyEntry> arrayList3 = (ArrayList<DependencyEntry>)hashMap.get(object);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList<DependencyEntry>();
                            hashMap.put((DependentObject)object, arrayList3);
                        }
                        arrayList3.add(dependencyEntry);
                    }
                    this.depMap2.putAll(hashMap);
                    map = this.reactivitySimulator.createPrereqConditionsMap(hashMap, null);
                    PrereqConditionKey prereqConditionKey = new PrereqConditionKey();
                    for (ForecastPrerequisiteStatus forecastPrerequisiteStatus : arrayList) {
                        prereqConditionKey.dependentObject = forecastPrerequisiteStatus.getDependentObject();
                        prereqConditionKey.dependentAgent = forecastPrerequisiteStatus.getDependentAgentID();
                        PrereqCondition prereqCondition = map.get(prereqConditionKey);
                        object = new PrereqObj(forecastPrerequisiteStatus.getPrereqObjectID(), forecastPrerequisiteStatus.getPrereqObjectType());
                        prereqCondition.updateStatus((PrereqObj)object, forecastPrerequisiteStatus.getPrereqAgentID(), forecastPrerequisiteStatus.getLastStatus(), forecastPrerequisiteStatus.getStatusTime(), forecastPrerequisiteStatus.getSequenceNumber());
                    }
                }
            }
            catch (Exception exception) {
                logger.info((Object)"Could not capture non-blank prerequisite status information.", (Throwable)exception);
            }
            return map;
        }

        private void clearCalendarObjectCache() {
            this.calendarObjectManager.clearCalendarObjects();
        }

        private void clearDateObjectCache() {
            this.dateObjectCache.clear();
        }

        private void clearSuiteEventInfoCache() {
            this.suiteEventInfoCache.clear();
        }

        private String constructBadDataDetails(ErrorList errorList) {
            String string = "";
            if (errorList != null) {
                string = string + " Details:";
                while (errorList.nextError()) {
                    string = string + " " + errorList.getErrorText();
                }
            }
            return string;
        }

        private Map<Node, Prerequisite> constructFlow(Node node) throws ResourceUnavailableException {
            logger.debug((Object)MessageUtil.formatMsg((String)"Forecasting >> {0} <<", (Object[])new Object[]{node}));
            if (this.isFlowCached(node)) {
                return this.constructFlowFromCachedData(node);
            }
            HashSet<Node> hashSet = new HashSet<Node>();
            HashSet<Node> hashSet2 = new HashSet<Node>();
            HashMap<Node, List<DependencyEntry>> hashMap = new HashMap<Node, List<DependencyEntry>>();
            HashMap<Node, Prerequisite> hashMap2 = new HashMap<Node, Prerequisite>();
            hashSet.add(node);
            hashSet2.add(node);
            while (hashSet2.size() > 0) {
                List<DependentObject> list = this.toDependentObjectList(hashSet2);
                DependencyEntry[] object3 = ForecastAMImpl.this.forecastPrerequisitesDM.retrieveDependencyEntriesForDependentObjects((List)list);
                hashSet2.clear();
                if (object3 == null) continue;
                for (Object object : object3) {
                    this.addToMap((DependencyEntry)object, hashMap);
                    Node node2 = this.createNodeFromDependencyEntryPrerequisiteObject((DependencyEntry)object);
                    if (hashMap.containsKey(node2)) continue;
                    hashSet.add(node2);
                    if (this.isFlowCached(node2)) {
                        Prerequisite prerequisite = this.prereqsMap.get(node2);
                        hashMap2.put(node2, prerequisite);
                        if (prerequisite == null) continue;
                        Set<Node> set = prerequisite.nodes();
                        for (Node node3 : set) {
                            hashSet.add(node3);
                            hashMap2.put(node3, this.prereqsMap.get(node3));
                        }
                        continue;
                    }
                    if (!node2.isCanHavePrereqs()) continue;
                    hashSet2.add(node2);
                }
            }
            for (Node node4 : hashSet) {
                if (hashMap2.containsKey(node4) || hashMap.containsKey(node4)) continue;
                hashMap2.put(node4, null);
            }
            while (hashMap2.size() < hashSet.size()) {
                int n = hashMap2.size();
                for (Map.Entry entry : hashMap.entrySet()) {
                    Object object;
                    Node node5 = (Node)entry.getKey();
                    List list = (List)entry.getValue();
                    if (hashMap2.containsKey(node5) || !this.weHaveDataForAllOfThePrereqs(list, hashMap2)) continue;
                    object = this.constructPrerequisite(list, hashMap2);
                    if (this.hasForecastSchedule(node5)) {
                        object.overrideScheduledDateTimeCanBeDeterminedMethod_ToReturnTrue();
                    }
                    hashMap2.put(node5, (Prerequisite)object);
                }
                if (hashMap2.size() != n) continue;
                Prerequisite_Recursive prerequisite_Recursive = this.findANodeThatIsInARecursiveFlow(hashMap2, hashMap);
                if (prerequisite_Recursive != null) {
                    hashMap2.put(prerequisite_Recursive.getMainNode(), prerequisite_Recursive);
                    continue;
                }
                throw new IllegalStateException("Unable to convert the dependency flow data into a Prerequisite object.");
            }
            this.prereqsMap.putAll(hashMap2);
            this.putAll(hashMap, this.depMap2);
            return hashMap2;
        }

        private Map<Node, Prerequisite> constructFlowFromCachedData(Node node) {
            HashMap<Node, Prerequisite> hashMap = new HashMap<Node, Prerequisite>();
            if (this.prereqsMap.containsKey(node)) {
                Prerequisite prerequisite = this.prereqsMap.get(node);
                hashMap.put(node, prerequisite);
                if (prerequisite != null) {
                    Set<Node> set = prerequisite.nodes();
                    for (Node node2 : set) {
                        hashMap.put(node2, this.prereqsMap.get(node2));
                    }
                }
                return hashMap;
            }
            throw new IllegalStateException("Cached data does not contain " + node);
        }

        private Prerequisite constructPrerequisite(List<DependencyEntry> list, Map<Node, Prerequisite> map) throws ResourceUnavailableException {
            Collections.sort(list, new SequenceNumberComparator());
            PrereqGroup_OR prereqGroup_OR = null;
            PrereqGroup_AND prereqGroup_AND = null;
            for (DependencyEntry dependencyEntry : list) {
                Object object;
                if (prereqGroup_OR == null) {
                    object = this.createNodeFromDependencyEntryDependentObject(dependencyEntry);
                    prereqGroup_OR = new PrereqGroup_OR((Node)object);
                    prereqGroup_AND = new PrereqGroup_AND();
                    prereqGroup_OR.add(prereqGroup_AND);
                } else if (dependencyEntry.getConjunction() == PrerequisiteConditionsList.PrereqConjunction.OR) {
                    prereqGroup_AND = new PrereqGroup_AND();
                    prereqGroup_OR.add(prereqGroup_AND);
                }
                Node node = this.createNodeFromDependencyEntryPrerequisiteObject(dependencyEntry);
                object = map.get(node);
                if (object == null) {
                    object = new Prerequisite_Simple(node, this.isTimeBased(node));
                }
                prereqGroup_AND.add((Prerequisite)object);
            }
            return prereqGroup_OR;
        }

        private Node[] convertDepEntryListToNodeArray(List<DependencyEntry> list) {
            if (list == null) {
                return new Node[0];
            }
            DependencyEntry[] dependencyEntryArray = new DependencyEntry[list.size()];
            list.toArray(dependencyEntryArray);
            Node[] nodeArray = new Node[dependencyEntryArray.length];
            for (int i = 0; i < dependencyEntryArray.length; ++i) {
                nodeArray[i] = this.createNodeFromDependencyEntryPrerequisiteObject(dependencyEntryArray[i]);
            }
            return nodeArray;
        }

        private Collection<ForecastedEvent> createForecastedEventForEachNSTWithinForecastRange(ForecastableEvent forecastableEvent, ScheduleInfo scheduleInfo, ForecastedEvent.ForecastInitiationCode forecastInitiationCode) throws ResourceUnavailableException {
            long[] lArray;
            ArrayList<ForecastedEvent> arrayList = new ArrayList<ForecastedEvent>();
            for (long l : lArray = this.agentsThatTheForecastableEventRunsOn(scheduleInfo)) {
                Calendar[] calendarArray;
                long l2 = 1L;
                long l3 = 1L;
                switch (forecastableEvent.getType()) {
                    case JOB_SUBMISSION: 
                    case JOB_SUITE: {
                        long l4 = forecastableEvent.getID();
                        calendarArray = this.calcNSTs_ForJob(l4, l, scheduleInfo, this.rangeBegin, this.rangeEnd);
                        AgentJobDuration agentJobDuration = this.durationCache.getAgentJobDuration(l, forecastableEvent.getID());
                        l2 = agentJobDuration.getQueueDuration();
                        if (forecastableEvent.getType() == ForecastableEvent.ForecastableEventType.JOB_SUITE) {
                            l2 = 0L;
                        }
                        l3 = agentJobDuration.getRunDuration();
                        break;
                    }
                    case AGENT_EVENT_OCCURS: {
                        long l5 = forecastableEvent.getID();
                        calendarArray = this.calcNSTs_ForEvent(l5, l, scheduleInfo, this.rangeBegin, this.rangeEnd);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Forecastable Event Type {0} is not supported by this method.", (Object[])new Object[]{forecastableEvent.getType()}));
                    }
                }
                if (calendarArray.length > this.limitFor_forecastEvents_for_timebasedEvents) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Time-based job/event has been forecast to run {0} times within the forecast period. This exceeds the limit of {1}, which was put in place to prevent excessive data generation.", (Object[])new Object[]{calendarArray.length, this.limitFor_forecastEvents_for_timebasedEvents}));
                }
                for (Calendar calendar : calendarArray) {
                    ForecastedObjectRunID forecastedObjectRunID;
                    ForecastedEvent forecastedEvent = new ForecastedEvent(forecastableEvent, l, calendar.getTimeInMillis(), forecastInitiationCode, l2, l3);
                    arrayList.add(forecastedEvent);
                    if (this.isSatisfiesARunIDNeed(forecastedEvent)) {
                        forecastedObjectRunID = new ForecastedObjectRunID();
                        forecastedEvent.setForecastedObjectRunID(forecastedObjectRunID);
                        this.updatePrereqsInNeedOfARunID(forecastedEvent);
                    }
                    if (!forecastedEvent.isSuite()) continue;
                    forecastedObjectRunID = new ForecastSuiteEventInfo(forecastableEvent.getID(), calendar.getTimeInMillis());
                    forecastedEvent.setSuiteEventInfo((ForecastSuiteEventInfo)forecastedObjectRunID);
                    this.suiteEventInfoCache.add((ForecastSuiteEventInfo)forecastedObjectRunID);
                }
            }
            return arrayList;
        }

        private Node createNodeFromDependencyEntryDependentObject(DependencyEntry dependencyEntry) {
            return new Node(dependencyEntry.getDependentObject());
        }

        private Node createNodeFromDependencyEntryPrerequisiteObject(DependencyEntry dependencyEntry) {
            long l = dependencyEntry.getPrerequisiteID();
            PrereqEventType prereqEventType = dependencyEntry.getPrerequisiteType();
            switch (prereqEventType) {
                case JOB_STATUS_CHANGE: {
                    return new Node(l, NodeType.JOB);
                }
                case JOB_SUITE_STATUS_CHANGE: {
                    return new Node(l, NodeType.JOB_SUITE);
                }
                case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                    return new Node(l, NodeType.MEMBER_JOB);
                }
                case AGENT_EVENT: {
                    return new Node(l, NodeType.AGENT_EVENT);
                }
                case JOB_MONITOR_EVENT: {
                    return new Node(l, NodeType.JOB_MONITOR_EVENT);
                }
                case SNMP_TRAP_EVENT: {
                    return new Node(l, NodeType.SNMP_TRAP_EVENT);
                }
                case JOB_SUITE_MONITOR_EVENT: {
                    return new Node(l, NodeType.SUITE_MONITOR_EVENT);
                }
                case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                    return new Node(l, NodeType.MEMBER_MONITOR_EVENT);
                }
                case REMOTE_EVENT: {
                    return new Node(l, NodeType.REMOTE_EVENT);
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prerequisite Type {0} is not supported by this method.", (Object[])new Object[]{prereqEventType}));
        }

        private void createQueueEntries_ForRunningJobs(ForecastableEvent forecastableEvent) {
            List<QueueEntry> list = this.queueEntriesCache.get(forecastableEvent);
            if (list != null) {
                for (QueueEntry queueEntry : list) {
                    this.queue.add(queueEntry);
                }
            }
        }

        private void createQueueEntries_ForLeafNode(Node node, Calendar calendar) throws ResourceUnavailableException {
            ScheduleInfo scheduleInfo;
            if (this.hasForecastSchedule(node)) {
                scheduleInfo = this.retrieveForecastScheduleInfo(node);
                if (node.isJob()) {
                    this.createQueueEntries_JobStatusChange_ForEachNSTWithinSimulationRange(node.id, node.type, scheduleInfo, calendar);
                } else {
                    this.createQueueEntries_EventOccurred_ForEachNSTWithinSimulationRange(node.id, scheduleInfo, calendar);
                }
            }
            if (this.hasRegularSchedule(node)) {
                scheduleInfo = this.retrieveRegularScheduleInfo(node);
                this.createQueueEntries_JobStatusChange_ForEachNSTWithinSimulationRange(node.id, node.type, scheduleInfo, calendar);
            }
        }

        private void createQueueEntries_ForInternalNodeJob(Node node, Calendar calendar) throws ResourceUnavailableException {
            ScheduleInfo scheduleInfo;
            long l = node.id;
            if (this.hasForecastSchedule(node)) {
                scheduleInfo = this.retrieveForecastScheduleInfo(node);
                this.createQueueEntries_JobStatusChange_ForEachNSTWithinSimulationRange(l, node.type, scheduleInfo, calendar);
            }
            if (this.hasRegularSchedule(node)) {
                scheduleInfo = this.retrieveRegularScheduleInfo(node);
                this.createQueueEntries_ScheduledJob_ForEachNSTWithinSimulationRange(l, node.type, scheduleInfo, calendar);
            }
        }

        private void createQueueEntries_EventOccurred_ForEachNSTWithinSimulationRange(long l, ScheduleInfo scheduleInfo, Calendar calendar) throws ResourceUnavailableException {
            long[] lArray;
            for (long l2 : lArray = this.agentsThatTheForecastableEventRunsOn(scheduleInfo)) {
                Calendar[] calendarArray;
                EventType eventType = null;
                for (Calendar calendar2 : calendarArray = this.calcNSTs_ForEvent(l, l2, scheduleInfo, calendar, this.rangeEnd)) {
                    QueueEntry_EventOccurred queueEntry_EventOccurred = new QueueEntry_EventOccurred(l, l2, calendar2, eventType);
                    this.queue.add(queueEntry_EventOccurred);
                }
            }
        }

        private void createQueueEntries_JobStatusChange(long l, long l2, Calendar calendar) {
            long l3 = calendar.getTimeInMillis();
            long l4 = 0L;
            if (calendar instanceof MovedNST) {
                MovedNST movedNST = (MovedNST)calendar;
                l4 = movedNST.getOriginalDateTimeYYYYMMDDHHMM();
            }
            boolean bl = false;
            this.queue.add(new QueueEntry_JobStatusChange(l, l2, calendar, l3, l4, PrereqStatusType.SUBMITTED, bl));
            AgentJobDuration agentJobDuration = this.durationCache.getAgentJobDuration(l2, l);
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeInMillis(calendar.getTimeInMillis() + agentJobDuration.getQueueDuration());
            this.queue.add(new QueueEntry_JobStatusChange(l, l2, calendar2, l3, l4, PrereqStatusType.RUNNING, bl));
            Calendar calendar3 = (Calendar)calendar2.clone();
            calendar3.setTimeInMillis(calendar2.getTimeInMillis() + agentJobDuration.getRunDuration());
            this.queue.add(new QueueEntry_JobStatusChange(l, l2, calendar3, l3, l4, PrereqStatusType.COMPLETED, bl));
        }

        private void createQueueEntries_MemberStatusChange(long l, long l2, Calendar calendar, ForecastSuiteEventInfo forecastSuiteEventInfo, ForecastSuiteScheduleInfo forecastSuiteScheduleInfo) {
            this.queue.add(new QueueEntry_MemberStatusChange(l, l2, calendar, forecastSuiteEventInfo, forecastSuiteScheduleInfo, PrereqStatusType.SUBMITTED));
            AgentMemberDuration agentMemberDuration = this.memberDurationCache.getAgentMemberDuration(l2, l);
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeInMillis(calendar.getTimeInMillis() + agentMemberDuration.getQueueDuration());
            this.queue.add(new QueueEntry_MemberStatusChange(l, l2, calendar2, forecastSuiteEventInfo, forecastSuiteScheduleInfo, PrereqStatusType.RUNNING));
            Calendar calendar3 = (Calendar)calendar2.clone();
            calendar3.setTimeInMillis(calendar2.getTimeInMillis() + agentMemberDuration.getRunDuration());
            this.queue.add(new QueueEntry_MemberStatusChange(l, l2, calendar3, forecastSuiteEventInfo, forecastSuiteScheduleInfo, PrereqStatusType.COMPLETED));
        }

        private void createQueueEntries_JobStatusChange_ForEachNSTWithinSimulationRange(long l, NodeType nodeType, ScheduleInfo scheduleInfo, Calendar calendar) throws ResourceUnavailableException {
            long[] lArray;
            for (long l2 : lArray = this.agentsThatTheForecastableEventRunsOn(scheduleInfo)) {
                Calendar[] calendarArray;
                for (Calendar calendar2 : calendarArray = this.calcNSTs_ForJob(l, l2, scheduleInfo, calendar, this.rangeEnd)) {
                    if (nodeType == NodeType.JOB_SUITE) {
                        this.createQueueEntries_SuiteStatusChange(l, l2, calendar2);
                        continue;
                    }
                    this.createQueueEntries_JobStatusChange(l, l2, calendar2);
                }
            }
        }

        private void createQueueEntries_ScheduledJob_ForEachNSTWithinSimulationRange(long l, NodeType nodeType, ScheduleInfo scheduleInfo, Calendar calendar) throws ResourceUnavailableException {
            long[] lArray;
            for (long l2 : lArray = this.agentsThatTheForecastableEventRunsOn(scheduleInfo)) {
                Calendar[] calendarArray;
                for (Calendar calendar2 : calendarArray = this.calcNSTs_ForJob(l, l2, scheduleInfo, calendar, this.rangeEnd)) {
                    QueueEntry_CheckPrereqsEvent queueEntry_CheckPrereqsEvent = nodeType == NodeType.JOB_SUITE ? new QueueEntry_ScheduledSuite(l, l2, calendar2) : new QueueEntry_ScheduledJob(l, l2, calendar2);
                    this.queue.add(queueEntry_CheckPrereqsEvent);
                }
            }
        }

        private void createQueueEntries_SuiteStatusChange(long l, long l2, Calendar calendar) {
            long l3 = calendar.getTimeInMillis();
            long l4 = 0L;
            if (calendar instanceof MovedNST) {
                MovedNST movedNST = (MovedNST)calendar;
                l4 = movedNST.getOriginalDateTimeYYYYMMDDHHMM();
            }
            boolean bl = true;
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            QueueEntry_JobStatusChange queueEntry_JobStatusChange = new QueueEntry_JobStatusChange(l, l2, calendar2, l3, l4, PrereqStatusType.RUNNING, bl);
            long l5 = l;
            queueEntry_JobStatusChange.setSuiteEventInfo(this.getSuiteEventInfoThatMatches(l5, calendar2.getTimeInMillis()));
            this.queue.add(queueEntry_JobStatusChange);
            AgentJobDuration agentJobDuration = this.durationCache.getAgentJobDuration(l2, l);
            Calendar calendar3 = (Calendar)calendar2.clone();
            calendar3.setTimeInMillis(calendar2.getTimeInMillis() + agentJobDuration.getRunDuration());
            this.queue.add(new QueueEntry_JobStatusChange(l, l2, calendar3, l3, l4, PrereqStatusType.COMPLETED, bl));
        }

        private DateObjectCache dateObjectCache() {
            DateObjectDM dateObjectDM = (DateObjectDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.DateObjectDM");
            return new DateObjectCacheImpl(dateObjectDM);
        }

        private Prerequisite_Recursive findANodeThatIsInARecursiveFlow(Map<Node, Prerequisite> map, Map<Node, List<DependencyEntry>> map2) {
            logger.debug((Object)MessageUtil.formatMsg((String)"Looking for a recursive flow. (Technical details - flowMap count: {0}, depMap count: {1}", (Object[])new Object[]{map.size(), map2.size()}));
            Prerequisite_Recursive prerequisite_Recursive = null;
            int n = 0;
            int n2 = 0;
            for (Node node : map2.keySet()) {
                if (map.containsKey(node)) {
                    ++n;
                    continue;
                }
                Set<Node> set = this.recursiveFlow(node, map2);
                if (set != null) {
                    prerequisite_Recursive = new Prerequisite_Recursive(node, set);
                    break;
                }
                ++n2;
            }
            if (prerequisite_Recursive != null) {
                logger.debug((Object)MessageUtil.formatMsg((String)"The flow that contains {0} is recursive. (Search details - failCount: {1}, alreadyKnowAboutCount: {2})", (Object[])new Object[]{prerequisite_Recursive.getMainNode(), n2, n}));
            } else {
                logger.debug((Object)"No recursive flows found.");
            }
            return prerequisite_Recursive;
        }

        private void gatherInfo() {
        }

        private String getAgentName(long l) {
            if (l == 0L) {
                return "";
            }
            try {
                return ForecastAMImpl.this.agentDM.get(l).getName();
            }
            catch (Exception exception) {
                return "with ID " + l;
            }
        }

        private Node[] getImmediatePrereqs(Node node) throws ResourceUnavailableException {
            if (!node.isCanHavePrereqs()) {
                return new Node[0];
            }
            List<DependentObject> list = this.toDependentObjectList(node);
            DependencyEntry[] dependencyEntryArray = ForecastAMImpl.this.forecastPrerequisitesDM.retrieveDependencyEntriesForDependentObjects(list);
            if (dependencyEntryArray != null) {
                Node[] nodeArray = new Node[dependencyEntryArray.length];
                for (int i = 0; i < dependencyEntryArray.length; ++i) {
                    nodeArray[i] = this.createNodeFromDependencyEntryPrerequisiteObject(dependencyEntryArray[i]);
                }
                return nodeArray;
            }
            return new Node[0];
        }

        private String getJobName(long l) {
            try {
                return ForecastAMImpl.this.scheduleJobDM.getScheduleJobProxy(l).getName();
            }
            catch (Exception exception) {
                return "with ID " + l;
            }
        }

        private Collection<Node> getImmediatePrereqs(Node node, Map<Node, List<DependencyEntry>> map) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (!node.isCanHavePrereqs()) {
                return arrayList;
            }
            List<DependencyEntry> list = null;
            if (map.containsKey(node)) {
                list = map.get(node);
            } else if (this.depMap2.containsKey(this.toDependentObject(node))) {
                list = this.depMap2.get(this.toDependentObject(node));
            }
            if (list != null) {
                for (DependencyEntry dependencyEntry : list) {
                    arrayList.add(this.createNodeFromDependencyEntryPrerequisiteObject(dependencyEntry));
                }
            }
            return arrayList;
        }

        private ForecastSuiteEventInfo getSuiteEventInfoThatMatches(long l, long l2) {
            for (ForecastSuiteEventInfo forecastSuiteEventInfo : this.suiteEventInfoCache) {
                if (forecastSuiteEventInfo.getSuiteID() != l || forecastSuiteEventInfo.getRunningDateTime() != l2) continue;
                return forecastSuiteEventInfo;
            }
            return new ForecastSuiteEventInfo(l, 0L);
        }

        private boolean hasForecastSchedule(ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            if (this.nodesWithForecastSchedule != null) {
                return this.isInArray(this.nodesWithForecastSchedule, new Node(forecastableEvent));
            }
            switch (forecastableEvent.getType()) {
                case JOB_SUBMISSION: 
                case JOB_SUITE: 
                case AGENT_EVENT_OCCURS: {
                    return ForecastAMImpl.this.forecastDM.hasForecastSchedule(forecastableEvent);
                }
                case MEMBER_JOB: 
                case REACTIVE_EVENT_OCCURS: {
                    return false;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Forecastable Event Type {0} is not supported by this method.", (Object[])new Object[]{forecastableEvent.getType()}));
        }

        private boolean hasForecastSchedule(Node node) throws ResourceUnavailableException {
            ForecastableEvent.ForecastableEventType forecastableEventType;
            if (this.nodesWithForecastSchedule != null) {
                return this.isInArray(this.nodesWithForecastSchedule, node);
            }
            long l = node.id;
            switch (node.type) {
                case JOB: {
                    forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
                    break;
                }
                case JOB_SUITE: {
                    forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUITE;
                    break;
                }
                case AGENT_EVENT: {
                    forecastableEventType = ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS;
                    break;
                }
                case MEMBER_JOB: 
                case REACTIVE_EVENT: 
                case JOB_MONITOR_EVENT: 
                case SNMP_TRAP_EVENT: 
                case SUITE_MONITOR_EVENT: 
                case MEMBER_MONITOR_EVENT: 
                case REMOTE_EVENT: {
                    return false;
                }
                default: {
                    throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Node Type {0} is not supported by this method.", (Object[])new Object[]{node.type}));
                }
            }
            return ForecastAMImpl.this.forecastDM.hasForecastSchedule(new ForecastableEvent(l, forecastableEventType));
        }

        private boolean hasPrereqs(ForecastableEvent forecastableEvent) {
            return this.hasPrereqs(new Node(forecastableEvent));
        }

        private boolean hasPrereqs(Node node) {
            if (this.prereqsMap.containsKey(node)) {
                return this.prereqsMap.get(node) != null;
            }
            throw new IllegalStateException("prereqsMap does not contain x");
        }

        private boolean hasReactiveRange(DependentObject dependentObject) {
            return this.dependentObjectsWithReactiveRange.contains(dependentObject);
        }

        private boolean hasRegularSchedule(ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            return this.hasRegularSchedule(new Node(forecastableEvent));
        }

        private boolean hasRegularSchedule(DependentObject dependentObject) throws ResourceUnavailableException {
            return this.hasRegularSchedule(new Node(dependentObject));
        }

        private boolean hasRegularSchedule(Node node) throws ResourceUnavailableException {
            switch (node.type) {
                case JOB: 
                case JOB_SUITE: {
                    return this.retrieveRegularScheduleInfo(node) != null;
                }
            }
            return false;
        }

        private boolean isFlowCached(Node node) {
            return this.prereqsMap.containsKey(node);
        }

        private boolean isInArray(Node[] nodeArray, Node node) {
            return Arrays.binarySearch(nodeArray, node) > -1;
        }

        private boolean isInArray(long[] lArray, long l) {
            return Arrays.binarySearch(lArray, l) > -1;
        }

        private boolean isLeafNode(Node node) {
            if (this.prereqsMap.containsKey(node)) {
                return this.prereqsMap.get(node) == null;
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error. prereqMap does not contain an entry for {0}.", (Object[])new Object[]{node}));
        }

        private boolean isReactiveJobThatDoesNotRunOnNonWorkDays(long l) {
            return this.isInArray(this.reactiveJobsThatDoNotRunOnNonWorkDays, l);
        }

        private boolean isSatisfiesARunIDNeed(ForecastedEvent forecastedEvent) {
            for (ForecastReactivityCausePrereq forecastReactivityCausePrereq : this.prereqsThatNeedRunID) {
                if (!forecastReactivityCausePrereq.isMatchesForecastedEvent(forecastedEvent)) continue;
                return true;
            }
            return false;
        }

        private boolean isTimeBased(Node node) throws ResourceUnavailableException {
            return this.hasRegularSchedule(node) || this.hasForecastSchedule(node);
        }

        private Set<Node> prereqNodes(Node node, Set<Node> set, Map<Node, Set<Node>> map, Map<Node, List<DependencyEntry>> map2) {
            if (!map.containsKey(node)) {
                if (set.contains(node)) {
                    HashSet<Node> hashSet = new HashSet<Node>();
                    hashSet.add(node);
                    return hashSet;
                }
                set.add(node);
                HashSet<Node> hashSet = new HashSet<Node>();
                Collection<Node> collection = this.getImmediatePrereqs(node, map2);
                for (Node node2 : collection) {
                    hashSet.add(node2);
                    Set<Node> set2 = this.prereqNodes(node2, set, map, map2);
                    hashSet.addAll(set2);
                }
                map.put(node, hashSet);
            }
            return map.get(node);
        }

        private void primeTheQueue(Map<Node, Prerequisite> map, boolean bl, ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            this.queue.clear();
            this.createQueueEntries_ForRunningJobs(forecastableEvent);
            if (bl) {
                for (Node node : map.keySet()) {
                    if (!this.isTimeBased(node)) continue;
                    if (this.isLeafNode(node)) {
                        this.createQueueEntries_ForLeafNode(node, this.simulationBegin);
                        continue;
                    }
                    this.createQueueEntries_ForInternalNodeJob(node, this.simulationBegin);
                }
            } else {
                for (Map.Entry<Node, Prerequisite> entry : map.entrySet()) {
                    Node node = entry.getKey();
                    Prerequisite prerequisite = entry.getValue();
                    if (!this.isTimeBased(node)) continue;
                    if (this.isLeafNode(node)) {
                        this.createQueueEntries_ForLeafNode(node, this.simulationBegin);
                        continue;
                    }
                    if (!prerequisite.isScheduledDateTimeCanBeDetermined() || !prerequisite.isHappyPath()) continue;
                    this.createQueueEntries_ForInternalNodeJob(node, this.simulationBegin);
                }
            }
        }

        private Collection<ForecastedEvent> processTheQueue(Map<Node, Prerequisite> map, ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            ArrayList<ForecastedEvent> arrayList = new ArrayList<ForecastedEvent>();
            ForecastInfo forecastInfo = new ForecastInfo();
            forecastInfo.forecastableEvent = forecastableEvent;
            forecastInfo.forecastedEvents = arrayList;
            forecastInfo.forecastGenerator = this;
            this.residualData = this.reactivitySimulator.simulate(this.queue, map, this.depMap2, this.rangeEnd, forecastInfo, this.prereqConditionsCache, this.calendarObjectManager, this.dateObjectCache, this.omitDates);
            return arrayList;
        }

        private void putAll(Map<Node, List<DependencyEntry>> map, Map<DependentObject, List<DependencyEntry>> map2) {
            for (Map.Entry<Node, List<DependencyEntry>> entry : map.entrySet()) {
                DependentObject dependentObject = this.toDependentObject(entry.getKey());
                if (map2.containsKey(dependentObject)) continue;
                map2.put(dependentObject, entry.getValue());
            }
        }

        private Set<Node> recursiveFlow(Node node, Map<Node, List<DependencyEntry>> map) {
            HashSet<Node> hashSet = new HashSet<Node>();
            HashMap<Node, Set<Node>> hashMap = new HashMap<Node, Set<Node>>();
            Set<Node> set = this.prereqNodes(node, hashSet, hashMap, map);
            if (set.contains(node)) {
                return set;
            }
            return null;
        }

        private void removeCachedDataFor(Collection<ForecastableEvent> collection) {
            for (ForecastableEvent forecastableEvent : collection) {
                Node node = new Node(forecastableEvent);
                DependentObject dependentObject = this.toDependentObject(forecastableEvent);
                this.scheduleInfoMap_RegularSchedule.remove(node);
                this.scheduleInfoMap_ForecastSchedule.remove(node);
                this.depMap2.remove(dependentObject);
                this.prereqsMap.remove(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOutdatedCachedDurationData(long l) throws ResourceUnavailableException {
            long[] lArray = this.durationCache.getZeroAgentJobs();
            try (SimpleList simpleList = null;){
                simpleList = ForecastAMImpl.this.jobHistoryDM.getCompletionActivitySince(l);
                while (simpleList.next()) {
                    ForecastJobAgentPair forecastJobAgentPair;
                    try {
                        forecastJobAgentPair = (ForecastJobAgentPair)simpleList.get();
                    }
                    catch (BadDataException badDataException) {
                        logger.error((Object)MessageUtil.formatMsg((String)"Unable to use the list of job/agents with job history records that are completed and whose server_ended_time_utc is > {0}.", (Object[])new Object[]{l}), (Throwable)badDataException);
                        break;
                    }
                    long l2 = forecastJobAgentPair.getAgentID();
                    long l3 = forecastJobAgentPair.getJobID();
                    this.durationCache.removeAgentJobDuration(l2, l3);
                    if (!this.isInArray(lArray, l3)) continue;
                    this.durationCache.removeAgentJobDuration(0L, l3);
                }
            }
        }

        private ScheduleInfo retrieveForecastScheduleInfo(ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            return this.retrieveForecastScheduleInfo(new Node(forecastableEvent));
        }

        private ScheduleInfo retrieveForecastScheduleInfo(Node node) throws ResourceUnavailableException {
            if (!this.scheduleInfoMap_ForecastSchedule.containsKey(node)) {
                ScheduleInfo scheduleInfo;
                long l;
                ForecastableEvent.ForecastableEventType forecastableEventType;
                long l2 = node.id;
                switch (node.type) {
                    case JOB: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
                        break;
                    }
                    case JOB_SUITE: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUITE;
                        break;
                    }
                    case AGENT_EVENT: {
                        forecastableEventType = ForecastableEvent.ForecastableEventType.AGENT_EVENT_OCCURS;
                        break;
                    }
                    case MEMBER_JOB: 
                    case REACTIVE_EVENT: 
                    case JOB_MONITOR_EVENT: 
                    case SNMP_TRAP_EVENT: 
                    case SUITE_MONITOR_EVENT: 
                    case MEMBER_MONITOR_EVENT: 
                    case REMOTE_EVENT: {
                        this.scheduleInfoMap_ForecastSchedule.put(node, null);
                        return null;
                    }
                    default: {
                        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Node Type {0} is not supported by this method.", (Object[])new Object[]{node.type}));
                    }
                }
                try {
                    l = ForecastAMImpl.this.forecastDM.getForecastScheduleID(new ForecastableEvent(l2, forecastableEventType));
                }
                catch (NoDataException noDataException) {
                    throw new IllegalStateException(noDataException);
                }
                try {
                    scheduleInfo = ForecastAMImpl.this.scheduleInfoDM.getScheduleInfoForForecastSchedule(l);
                }
                catch (NoDataException noDataException) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Forecast Schedule for {0} not found.", (Object[])new Object[]{node}), noDataException);
                }
                catch (BadDataException badDataException) {
                    String string = this.constructBadDataDetails(badDataException.getErrorList());
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to construct a forecast schedule for {0}, due to corrupt data.{1}", (Object[])new Object[]{node, string}), badDataException);
                }
                this.scheduleInfoMap_ForecastSchedule.put(node, scheduleInfo);
            }
            return this.scheduleInfoMap_ForecastSchedule.get(node);
        }

        private ScheduleInfo retrieveRegularScheduleInfo(ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            return this.retrieveRegularScheduleInfo(new Node(forecastableEvent));
        }

        private ScheduleInfo retrieveRegularScheduleInfo(Node node) throws ResourceUnavailableException {
            if (!this.scheduleInfoMap_RegularSchedule.containsKey(node)) {
                switch (node.type) {
                    case JOB: 
                    case JOB_SUITE: {
                        int n = (int)node.id;
                        try {
                            this.scheduleInfoMap_RegularSchedule.put(node, ForecastAMImpl.this.scheduleInfoDM.get(n));
                            break;
                        }
                        catch (NoDataException noDataException) {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Regular Schedule for {0} not found.", (Object[])new Object[]{node}), noDataException);
                        }
                        catch (BadDataException badDataException) {
                            String string = this.constructBadDataDetails(badDataException.getErrorList());
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to construct a regular schedule for {0}, due to corrupt data.{1}", (Object[])new Object[]{node, string}), badDataException);
                        }
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Node Type {0} is not expected in the retrieveRegularScheduleInfo method.", (Object[])new Object[]{node.type}));
                    }
                }
            }
            return this.scheduleInfoMap_RegularSchedule.get(node);
        }

        private long runDuration(long l, long l2) {
            return this.durationCache.runDuration(l, l2);
        }

        private void setPrereqConditionsCache(Map<PrereqConditionKey, PrereqCondition> map) {
            this.prereqConditionsCache = map;
        }

        private void setQueueEntriesCache(Map<ForecastableEvent, List<QueueEntry>> map) {
            this.queueEntriesCache = map;
        }

        private Map<Node, List<DependencyEntry>> shallowCopy(Map<Node, List<DependencyEntry>> map) {
            return new HashMap<Node, List<DependencyEntry>>(map);
        }

        private Collection<ForecastedEvent> simulateReactivity(ForecastableEvent forecastableEvent) throws ResourceUnavailableException {
            boolean bl;
            Node node = new Node(forecastableEvent);
            Collection<ForecastedEvent> collection = new ArrayList<ForecastedEvent>();
            if (!node.isCanHavePrereqs()) {
                this.prereqsMap.put(node, null);
                return collection;
            }
            Map<Node, Prerequisite> map = this.constructFlow(node);
            Prerequisite prerequisite = map.get(node);
            boolean bl2 = bl = prerequisite != null && prerequisite.isFlowRecursive();
            if (bl) {
                logger.debug((Object)MessageUtil.formatMsg((String)"Forecasting has detected a recursive job flow while simulating reactivity for job {0}.", (Object[])new Object[]{node.id}));
            }
            if (prerequisite != null && prerequisite.isScheduledDateTimeCanBeDetermined() && prerequisite.isHappyPath()) {
                this.gatherInfo();
                this.primeTheQueue(map, bl, forecastableEvent);
                collection = this.processTheQueue(map, forecastableEvent);
            }
            return collection;
        }

        private void submitTimeBasedJob(long l) {
        }

        private DependentObject toDependentObject(ForecastableEvent forecastableEvent) {
            DependentObject.DependentObjectType dependentObjectType = DependentObject.DependentObjectType.forecastableEventTypeToEnum((ForecastableEvent.ForecastableEventType)forecastableEvent.getType());
            return new DependentObject(forecastableEvent.getID(), dependentObjectType);
        }

        private DependentObject toDependentObject(Node node) {
            DependentObject.DependentObjectType dependentObjectType;
            switch (node.type) {
                case JOB: {
                    dependentObjectType = DependentObject.DependentObjectType.JOB;
                    break;
                }
                case JOB_SUITE: {
                    dependentObjectType = DependentObject.DependentObjectType.JOB_SUITE;
                    break;
                }
                case MEMBER_JOB: {
                    dependentObjectType = DependentObject.DependentObjectType.MEMBER_JOB;
                    break;
                }
                case REACTIVE_EVENT: {
                    dependentObjectType = DependentObject.DependentObjectType.REACTIVE_EVENT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no DependentObject type associated with Node type: {0}.", (Object[])new Object[]{node.type}));
                }
            }
            return new DependentObject(node.id, dependentObjectType);
        }

        private List<DependentObject> toDependentObjectList(Set<Node> set) {
            ArrayList<DependentObject> arrayList = new ArrayList<DependentObject>(set.size());
            for (Node node : set) {
                arrayList.add(this.toDependentObject(node));
            }
            return arrayList;
        }

        private List<DependentObject> toDependentObjectList(Node node) {
            ArrayList<DependentObject> arrayList = new ArrayList<DependentObject>(1);
            arrayList.add(this.toDependentObject(node));
            return arrayList;
        }

        private Set<DependentObject> toDependentObjectSet(Set<ForecastableEvent> set) {
            HashSet<DependentObject> hashSet = new HashSet<DependentObject>();
            for (ForecastableEvent forecastableEvent : set) {
                hashSet.add(this.toDependentObject(forecastableEvent));
            }
            return hashSet;
        }

        private String toEventType_forMessageString(ForecastableEvent.ForecastableEventType forecastableEventType) {
            switch (forecastableEventType) {
                case JOB_SUBMISSION: {
                    return "Job";
                }
                case JOB_SUITE: {
                    return "Job suite";
                }
                case MEMBER_JOB: {
                    return "Member job";
                }
                case AGENT_EVENT_OCCURS: {
                    return "Agent event";
                }
                case REACTIVE_EVENT_OCCURS: {
                    return "Reactive event";
                }
            }
            return forecastableEventType.toString();
        }

        private void updatePrereqsInNeedOfARunID(ForecastedEvent forecastedEvent) {
            Iterator<ForecastReactivityCausePrereq> iterator = this.prereqsThatNeedRunID.iterator();
            while (iterator.hasNext()) {
                ForecastReactivityCausePrereq forecastReactivityCausePrereq = iterator.next();
                if (!forecastReactivityCausePrereq.isMatchesForecastedEvent(forecastedEvent)) continue;
                forecastReactivityCausePrereq.setForecastedObjectRunID(forecastedEvent.getForecastedObjectRunID());
                iterator.remove();
            }
        }

        private boolean weHaveDataForAllOfThePrereqs(List<DependencyEntry> list, Map<Node, Prerequisite> map) {
            for (DependencyEntry dependencyEntry : list) {
                Node node = this.createNodeFromDependencyEntryPrerequisiteObject(dependencyEntry);
                if (map.containsKey(node)) continue;
                return false;
            }
            return true;
        }

        private AgentJobDurationCache getAgentJobDurationCache() {
            return this.durationCache;
        }
    }

    private class RegenRunner
    implements Runnable {
        private ForecastProcess forecastProcess;

        public RegenRunner(ForecastProcess forecastProcess) {
            this.forecastProcess = forecastProcess;
        }

        @Override
        public void run() {
            try {
                long l = TimeUnit.SECONDS.toNanos(2L);
                this.forecastProcess.manualRegen(l);
            }
            catch (Exception exception) {
                String string = "An error occurred while trying to regenerate the forecast data.";
                logger.error((Object)string, (Throwable)exception);
            }
        }
    }

    public class ForecastRunner
    implements Runnable {
        private long forecastDefinitionID;
        private ForecastFilter forecastFilter;
        private ForecastRun forecastRun = null;

        public ForecastRunner(long l, ForecastFilter forecastFilter) {
            this.forecastDefinitionID = l;
            this.forecastFilter = forecastFilter;
        }

        @Override
        public void run() {
            try {
                NSTCalculator.setSuppressScheduleLogEntry(true);
                ScheduleInfo.setSuppressScheduleLogEntry((boolean)true);
                Runtimes_Basic.setSuppressScheduleLogEntry((boolean)true);
                this.runForecast();
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Forecast processing ended in error, for forecast definition {0}.", (Object[])new Object[]{this.forecastDefinitionID}), (Throwable)exception);
                this.failTheForecast();
            }
            catch (Error error) {
                this.failTheForecast();
                try {
                    String string = MessageUtil.formatMsg((String)"Unable to run the forecast for forecast definition {0}, due to a severe system error.", (Object[])new Object[]{this.forecastDefinitionID});
                    logger.fatal((Object)string, (Throwable)error);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw error;
            }
            finally {
                ForecastManager.getInstance().clearActiveForecast();
            }
        }

        private void failTheForecast() {
            if (this.forecastRun != null) {
                try {
                    this.forecastRun.setGenerationEnd(Calendar.getInstance());
                    this.forecastRun.setForecastStatus(ForecastStatus.FAILED);
                    ForecastAMImpl.this.forecastDM.updateForecastRunData(this.forecastRun);
                    String[] stringArray = new String[]{this.forecastRun.getForecastName(), ScheduleLogger.formatTimeStampSecs((Date)this.forecastRun.getGenerationBegin().getTime())};
                    this.writeToScheduleLog(RosettaMsg.FORECAST_GENERATION_FAILED, stringArray);
                    this.forecastRun = null;
                }
                catch (Exception exception) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Error recording forecast failure, for forecast definition {0}.", (Object[])new Object[]{this.forecastDefinitionID}), (Throwable)exception);
                }
            }
        }

        public long getForecastDefinitionID() {
            return this.forecastDefinitionID;
        }

        private void runForecast() throws NoDataException, NotSavedException {
            ForecastDefinition forecastDefinition;
            try {
                forecastDefinition = ForecastAMImpl.this.forecastDM.getForecastDefinition(this.forecastDefinitionID);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to retrieve forecast definition {0}.", (Object[])new Object[]{this.forecastDefinitionID}), resourceUnavailableException);
            }
            catch (BadDataException badDataException) {
                String string = this.constructBadDataDetails(badDataException.getErrorList());
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Corrupt data for forecast definition {0}.{1}", (Object[])new Object[]{this.forecastDefinitionID, string}), badDataException);
            }
            Calendar calendar = Calendar.getInstance();
            this.forecastRun = new ForecastRun(forecastDefinition);
            this.forecastRun.setGenerationBegin(calendar);
            try {
                long l = ForecastAMImpl.this.forecastDM.recordForecastRunStarted(this.forecastRun);
                this.forecastRun.setForecastRunID(l);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to record that the forecast run for forecast definition {0} has started.", (Object[])new Object[]{this.forecastDefinitionID}), resourceUnavailableException);
            }
            String[] stringArray = new String[]{forecastDefinition.getName()};
            this.writeToScheduleLog(RosettaMsg.FORECAST_GENERATION_STARTED, stringArray);
            ForecastableEvent[] forecastableEventArray = this.constructForecastableEvents(forecastDefinition, this.forecastFilter);
            ForecastResults forecastResults = this.forecastFilter != null ? ForecastAMImpl.this.forecast(forecastableEventArray, this.forecastFilter, this.forecastRun.getForecastWindowBegin(), this.forecastRun.getForecastWindowEnd()) : ForecastAMImpl.this.forecast(forecastableEventArray, this.forecastRun.getForecastWindowBegin(), this.forecastRun.getForecastWindowEnd());
            this.forecastRun.setGenerationEnd(Calendar.getInstance());
            try {
                ForecastAMImpl.this.forecastDM.recordForecastResults(this.forecastRun, forecastResults);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to record the forecast results for forecast definition {0}.", (Object[])new Object[]{this.forecastDefinitionID}), resourceUnavailableException);
            }
            try {
                ForecastAMImpl.this.forecastDM.recordExcludedJobs(forecastDefinition.getID(), this.forecastRun.getForecastRunID());
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                String string = MessageUtil.formatMsg((String)"Unable to record explicitly excluded jobs for forecast {0}. **", (Object[])new Object[]{forecastDefinition.getName()});
                logger.error((Object)string, (Throwable)resourceUnavailableException);
            }
            String[] stringArray2 = new String[]{forecastDefinition.getName(), ScheduleLogger.formatTimeStampSecs((Date)this.forecastRun.getGenerationBegin().getTime())};
            this.writeToScheduleLog(RosettaMsg.FORECAST_GENERATION_COMPLETED, stringArray2);
            this.sendAgentEventNotification(forecastDefinition);
        }

        private void sendAgentEventNotification(ForecastDefinition forecastDefinition) {
            AgentEventMonitor agentEventMonitor = null;
            String string = null;
            int n = 20;
            try {
                string = "SKYFMGEN_" + forecastDefinition.getName();
                if (string.length() > n) {
                    string = string.substring(0, n);
                }
                logger.debug((Object)("Attempting to send forecast generated notification manual event: " + string));
                AgentEventMonitorDM agentEventMonitorDM = (AgentEventMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEventMonitorDM");
                agentEventMonitor = agentEventMonitorDM.get(string, null);
                if (agentEventMonitor != null) {
                    AgentEventHistory[] agentEventHistoryArray = new AgentEventHistory[1];
                    if (agentEventMonitor.getTargetType() != ScheduleInfo.TargetType.AGENT) {
                        if (agentEventMonitor.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                            String string2 = "Agent Event Monitor '" + agentEventMonitor.getName() + "' is assigned to an Agent Group and cannot be used for forecast completed notification.";
                            throw new RuntimeException(string2);
                        }
                        String string3 = "Invalid agent event monitor specification.";
                        throw new RuntimeException(string3);
                    }
                    AgentEventHistory agentEventHistory = new AgentEventHistory(agentEventMonitor.getOID(), agentEventMonitor.getTargetID(), System.currentTimeMillis(), '*', forecastDefinition.getName());
                    agentEventHistory.setFromSendStatus(false);
                    agentEventHistoryArray[0] = agentEventHistory;
                    agentEventHistory = (AgentEventHistoryAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentEventHistoryAM");
                    agentEventHistory.sendEvents(agentEventHistoryArray);
                } else {
                    logger.debug((Object)("An Agent Event Monitor was not found: " + string));
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)("Error sending forecast generated event notification: " + string), throwable);
            }
        }

        private ForecastableEvent[] constructForecastableEvents(ForecastDefinition forecastDefinition, ForecastFilter forecastFilter) {
            ForecastableEvent[] forecastableEventArray;
            ForecastableEvent[] forecastableEventArray2;
            ForecastableEvent[] forecastableEventArray3;
            try {
                forecastableEventArray3 = ForecastAMImpl.this.forecastDM.getJobsToForecast(forecastDefinition, forecastFilter);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException("Unable to retrieve the jobs to forecast.", resourceUnavailableException);
            }
            try {
                forecastableEventArray2 = ForecastAMImpl.this.forecastDM.getMembersToForecast(forecastDefinition);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException("Unable to retrieve the suite members to forecast.", resourceUnavailableException);
            }
            try {
                forecastableEventArray = ForecastAMImpl.this.forecastDM.getEventsToForecast(forecastFilter);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException("Unable to retrieve the events to forecast.", resourceUnavailableException);
            }
            ForecastableEvent[] forecastableEventArray4 = new ForecastableEvent[forecastableEventArray3.length + forecastableEventArray2.length + forecastableEventArray.length];
            System.arraycopy(forecastableEventArray3, 0, forecastableEventArray4, 0, forecastableEventArray3.length);
            System.arraycopy(forecastableEventArray2, 0, forecastableEventArray4, forecastableEventArray3.length, forecastableEventArray2.length);
            System.arraycopy(forecastableEventArray, 0, forecastableEventArray4, forecastableEventArray3.length + forecastableEventArray2.length, forecastableEventArray.length);
            return forecastableEventArray4;
        }

        private String constructBadDataDetails(ErrorList errorList) {
            String string = "";
            if (errorList != null) {
                string = string + " Details:";
                while (errorList.nextError()) {
                    string = string + " " + errorList.getErrorText();
                }
            }
            return string;
        }

        private void writeToScheduleLog(RosettaMsg rosettaMsg, String[] stringArray) {
            ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray);
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        }
    }

    private static enum ClearanceRequestResult {
        GRANTED,
        SAME_PROCESS_ALREADY_ACTIVE,
        TIMEOUT,
        INTERRUPTED_WHILE_WAITING;

    }

    private class ForecastProcess
    implements Runnable {
        private long forecastProcessID;
        private long horizon;
        private long regenInterval;
        private ForecastFilter forecastFilter;
        private ForecastableEvent[] forecastableEvents;
        private Object waitLock = new Object();
        private long waitTime;
        private long wakeupTime;
        private boolean sleeping;
        private volatile boolean shutdown;
        private ForecastGenerator forecastGenerator = new ForecastGenerator();
        private boolean isExcludeTimedIntervalJobs = false;
        private boolean isExcludeDailyIntervalJobs = false;
        private Calendar windowBegin;
        private Calendar windowEnd;
        private boolean isRestart;
        private Collection<ForecastedEvent> forecastedEvents = new ArrayList<ForecastedEvent>();
        private Map<ForecastableEvent, Exception> errorMap = new HashMap<ForecastableEvent, Exception>();
        private Map<PrereqConditionKey, PrereqCondition> prereqConditionsCache = new HashMap<PrereqConditionKey, PrereqCondition>();
        private Map<ForecastableEvent, List<QueueEntry>> queueEntriesCache = new HashMap<ForecastableEvent, List<QueueEntry>>();
        private Set<ForecastableEvent> changedEvents = new HashSet<ForecastableEvent>();
        private Object changeLock = new Object();

        private ForecastProcess(long l, long l2, long l3, ForecastFilter forecastFilter, boolean bl) {
            this.forecastProcessID = l;
            this.horizon = l2;
            this.regenInterval = l3;
            this.forecastFilter = forecastFilter;
            this.isRestart = bl;
        }

        @Override
        public void run() {
            try {
                NSTCalculator.setSuppressScheduleLogEntry(true);
                ScheduleInfo.setSuppressScheduleLogEntry((boolean)true);
                Runtimes_Basic.setSuppressScheduleLogEntry((boolean)true);
                this.initialForecast();
            }
            catch (Exception exception) {
                logger.error((Object)"initForecast error", (Throwable)exception);
            }
            catch (Error error) {
                try {
                    String string = MessageUtil.formatMsg((String)"Unable to initiate forecast process, due to a severe system error.", (Object[])new Object[0]);
                    logger.fatal((Object)string, (Throwable)error);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw error;
            }
            try {
                this.mainLoop();
            }
            catch (Exception exception) {
                String string = "Forecast process error.";
                logger.error((Object)string, (Throwable)exception);
                throw new IllegalStateException(string, exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialForecast() throws ResourceUnavailableException {
            long l = TimeUnit.SECONDS.toNanos(30L);
            ClearanceRequestResult clearanceRequestResult = this.getClearanceForForecastAction(this.forecastProcessID, l);
            switch (clearanceRequestResult) {
                case GRANTED: {
                    try {
                        if (this.isRestart) {
                            this.restartForecast_ActualWork();
                            break;
                        }
                        this.initialForecast_ActualWork();
                        break;
                    }
                    finally {
                        this.releaseForecastProcessLock();
                    }
                }
                case TIMEOUT: {
                    logger.info((Object)MessageUtil.formatMsg((String)"A request was made to generate the initial forecast data for forecast process {0}. However, the (re)generation of the data associated with another forecast process was running and the maximum time to wait was exceeded. This request will be skipped.", (Object[])new Object[]{this.forecastProcessID}));
                    break;
                }
                case INTERRUPTED_WHILE_WAITING: {
                    logger.info((Object)MessageUtil.formatMsg((String)"A request was made to generate the initial forecast data for forecast process {0}. However, the (re)generation of the data associated with another forecast process was running and while waiting for it to complete, this forecast process was interrupted. This request will be skipped.", (Object[])new Object[]{this.forecastProcessID}));
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Clearance Request Result {0} is not supported by this method.", (Object[])new Object[]{clearanceRequestResult}));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mainLoop() throws ResourceUnavailableException {
            while (!this.shutdown) {
                Object object = this.waitLock;
                synchronized (object) {
                    while (!this.arrivedAtWakeupTime() && !this.shutdown) {
                        this.setWaitTime();
                        this.sleeping = true;
                        try {
                            this.waitLock.wait(this.waitTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.sleeping = false;
                    }
                }
                if (this.shutdown) continue;
                this.autoRegen();
                this.setWakeupTime();
            }
            this.cleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void regenerateForecast(long l) throws ResourceUnavailableException {
            ClearanceRequestResult clearanceRequestResult = this.getClearanceForForecastAction(this.forecastProcessID, l);
            switch (clearanceRequestResult) {
                case GRANTED: {
                    try {
                        this.regenerateForecast_ActualWork();
                        break;
                    }
                    finally {
                        this.releaseForecastProcessLock();
                    }
                }
                case SAME_PROCESS_ALREADY_ACTIVE: {
                    logger.info((Object)MessageUtil.formatMsg((String)"A request was made to regenerate the forecast data associated with forecast process {0}. However, a regeneration of the data (either automatically or manually requested) was still running. This request will be ignored.", (Object[])new Object[]{this.forecastProcessID}));
                    break;
                }
                case TIMEOUT: {
                    logger.info((Object)MessageUtil.formatMsg((String)"A request was made to regenerate the forecast data associated with forecast process {0}. However, the (re)generation of the data associated with another forecast process was running and the maximum time to wait was exceeded. This request will be skipped.", (Object[])new Object[]{this.forecastProcessID}));
                    break;
                }
                case INTERRUPTED_WHILE_WAITING: {
                    logger.info((Object)MessageUtil.formatMsg((String)"A request was made to regenerate the forecast data associated with forecast process {0}. However, the (re)generation of the data associated with another forecast process was running and while waiting for it to complete, this forecast process was interrupted. This request will be skipped.", (Object[])new Object[]{this.forecastProcessID}));
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Clearance Request Result {0} is not supported by this method.", (Object[])new Object[]{clearanceRequestResult}));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restartForecast_ActualWork() throws ResourceUnavailableException {
            Object object2;
            ForecastProcessInfo forecastProcessInfo;
            long l = NanoTimer.start();
            this.forecastGenerator.capturePrereqStatusInfo();
            this.windowBegin = Calendar.getInstance();
            try {
                forecastProcessInfo = ForecastAMImpl.this.forecastDM.getInternalForecastProcessInfo();
            }
            catch (NoDataException noDataException) {
                throw new IllegalStateException("ForecastProcessInfo not found", noDataException);
            }
            Calendar calendar = (Calendar)this.windowBegin.clone();
            calendar.setTimeInMillis(forecastProcessInfo.getWindowEnd() + 1L);
            long l2 = this.horizon + this.regenInterval;
            this.windowEnd = (Calendar)this.windowBegin.clone();
            this.windowEnd.setTimeInMillis(this.windowBegin.getTimeInMillis() + l2);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            logger.info((Object)MessageUtil.formatMsg((String)"Retaining the forecast and matching data from the previous SAM forecast process, which covered the period {0} - {1}, with the last data regeneration occurring {2}.", (Object[])new Object[]{simpleDateFormat.format(new Date(forecastProcessInfo.getProcessBegin())), simpleDateFormat.format(new Date(forecastProcessInfo.getWindowEnd())), simpleDateFormat.format(new Date(forecastProcessInfo.getWindowBegin()))}));
            this.forecastableEvents = this.constructForecastableEvents(this.forecastFilter, this.isExcludeTimedIntervalJobs, this.isExcludeDailyIntervalJobs);
            this.forecastGenerator.batchLoadForecastScheduleInfo();
            this.forecastGenerator.batchLoadReactiveRangeInfo();
            this.forecastGenerator.batchLoadMemberExclusionPerSpecialInstanceInfo();
            this.forecastGenerator.batchLoadMembersWithTheANYOption();
            this.forecastGenerator.batchLoadOmitDates();
            this.forecastGenerator.batchLoadReferencesToNonStandardCalendars();
            this.forecastGenerator.batchLoadReactiveJobsThatDoNotRunOnNonWorkDays();
            Map<ForecastableEvent, AgentGroupProxy> map = this.batchLoadAgentGroupInfo();
            long l3 = forecastProcessInfo.getWindowBegin();
            Set<ForecastableEvent> set = this.identifyEventsThatHaveBeenAddedSinceLastRegen(l3);
            Set<ForecastableEvent> set2 = this.identifyEventsThatHaveChangedSinceLastRegen_onRestart(l3, set);
            Set<ForecastableEvent> set3 = this.identifyEventsDependentOnChangedEvents(set2);
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            boolean bl = set2.size() == 0 && set.size() == 0;
            ResidualData residualData = null;
            logger.info((Object)MessageUtil.formatMsg((String)"Forecastable events: {0}", (Object[])new Object[]{this.forecastableEvents.length}));
            try (SharedResource sharedResource = null;){
                for (Object object2 : this.forecastableEvents) {
                    String string;
                    String string2;
                    this.forecastedEvents.clear();
                    try {
                        residualData = bl || !set2.contains(object2) && !set.contains(object2) ? this.forecastGenerator.forecast(object2, calendar, this.windowEnd, this.windowBegin, this.forecastedEvents) : this.forecastGenerator.forecast(object2, this.windowBegin, this.windowEnd, this.windowBegin, this.forecastedEvents);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        string2 = this.toEventType_forMessageString(object2.getType());
                        string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). The forecast process will be ended and any results that may have been generated so far will be discarded.", (Object[])new Object[]{string2, object2.getName(), object2.getID()});
                        logger.error((Object)string, (Throwable)resourceUnavailableException);
                        throw new IllegalStateException(string, resourceUnavailableException);
                    }
                    catch (Exception exception) {
                        string2 = this.toEventType_forMessageString(object2.getType());
                        string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). It will not be included in the forecast output.", (Object[])new Object[]{string2, object2.getName(), object2.getID()});
                        this.errorMap.put((ForecastableEvent)object2, new Exception(string, exception));
                        this.forecastedEvents.clear();
                    }
                    sharedResource = this.insertEventRecords(this.windowBegin.getTimeInMillis(), sharedResource, map);
                    this.cacheAnyResidualData(residualData);
                }
            }
            if (this.errorMap.size() > 0) {
                this.logErrors(this.errorMap, this.forecastProcessID);
                this.errorMap.clear();
            }
            ForecastAMImpl.this.forecastDM.setForecastProcessDataLockoutFlag(this.forecastProcessID, true);
            if (set2.size() > 0) {
                long l4 = this.windowBegin.getTimeInMillis();
                ForecastAMImpl.this.forecastDM.deleteObsoleteForecastProcessEvents(set2, this.forecastProcessID, l4);
            }
            if (hashSet.size() > 0 || hashSet2.size() > 0) {
                HashSet hashSet3 = new HashSet(hashSet);
                hashSet3.addAll(hashSet2);
                ForecastAMImpl.this.forecastDM.deleteForecastProcessEvents((Set)hashSet3, this.forecastProcessID);
            }
            this.purgeDataFromTailEnd(this.windowBegin.getTimeInMillis());
            try {
                ForecastAMImpl.this.forecastDM.recordForecastProcessRegenerated(this.forecastProcessID, this.windowBegin.getTimeInMillis(), this.windowEnd.getTimeInMillis());
            }
            catch (NotSavedException notSavedException) {
                throw new IllegalStateException(notSavedException);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException(resourceUnavailableException);
            }
            long l5 = NanoTimer.elapsed((long)l);
            object2 = MessageUtil.formatMsg((String)"Elapsed time: {0} ms.", (Object[])new Object[]{l5});
            String string = bl ? MessageUtil.formatMsg((String)"SAM forecast restarted by extending the data from {0} - {1}, since no changes were detected to the underlying jobs and events.", (Object[])new Object[]{simpleDateFormat.format(calendar.getTime()), simpleDateFormat.format(this.windowEnd.getTime())}) : MessageUtil.formatMsg((String)"SAM forecast restart detected {0} changed, {1} added, {2} removed, {3} deleted jobs/events since the previous regeneration.", (Object[])new Object[]{set2.size(), set.size(), hashSet.size(), hashSet2.size()});
            logger.info((Object)(string + " " + (String)object2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialForecast_ActualWork() throws ResourceUnavailableException {
            long l = NanoTimer.start();
            this.forecastGenerator.capturePrereqStatusInfo();
            this.windowBegin = Calendar.getInstance();
            long l2 = this.horizon + this.regenInterval;
            this.windowEnd = (Calendar)this.windowBegin.clone();
            this.windowEnd.setTimeInMillis(this.windowBegin.getTimeInMillis() + l2);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            logger.info((Object)MessageUtil.formatMsg((String)"Beginning the creation of SAM forecast data for the period {0} - {1}.", (Object[])new Object[]{simpleDateFormat.format(this.windowBegin.getTime()), simpleDateFormat.format(this.windowEnd.getTime())}));
            this.forecastableEvents = this.constructForecastableEvents(this.forecastFilter, this.isExcludeTimedIntervalJobs, this.isExcludeDailyIntervalJobs);
            this.forecastGenerator.batchLoadForecastScheduleInfo();
            this.forecastGenerator.batchLoadReactiveRangeInfo();
            this.forecastGenerator.batchLoadMemberExclusionPerSpecialInstanceInfo();
            this.forecastGenerator.batchLoadMembersWithTheANYOption();
            this.forecastGenerator.batchLoadOmitDates();
            this.forecastGenerator.batchLoadReferencesToNonStandardCalendars();
            this.forecastGenerator.batchLoadReactiveJobsThatDoNotRunOnNonWorkDays();
            Map<ForecastableEvent, AgentGroupProxy> map = this.batchLoadAgentGroupInfo();
            ResidualData residualData = null;
            logger.info((Object)MessageUtil.formatMsg((String)"Forecastable events: {0}", (Object[])new Object[]{this.forecastableEvents.length}));
            try (SharedResource sharedResource = null;){
                for (ForecastableEvent forecastableEvent : this.forecastableEvents) {
                    String string;
                    String string2;
                    this.forecastedEvents.clear();
                    try {
                        residualData = this.forecastGenerator.forecast(forecastableEvent, this.windowBegin, this.windowEnd, this.windowBegin, this.forecastedEvents);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        string2 = this.toEventType_forMessageString(forecastableEvent.getType());
                        string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). The forecast process will be ended and any results that may have been generated so far will be discarded.", (Object[])new Object[]{string2, forecastableEvent.getName(), forecastableEvent.getID()});
                        logger.error((Object)string, (Throwable)resourceUnavailableException);
                        throw new IllegalStateException(string, resourceUnavailableException);
                    }
                    catch (Exception exception) {
                        string2 = this.toEventType_forMessageString(forecastableEvent.getType());
                        string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). It will not be included in the forecast output.", (Object[])new Object[]{string2, forecastableEvent.getName(), forecastableEvent.getID()});
                        this.errorMap.put(forecastableEvent, new Exception(string, exception));
                        this.forecastedEvents.clear();
                    }
                    sharedResource = this.insertEventRecords(this.windowBegin.getTimeInMillis(), sharedResource, map);
                    this.cacheAnyResidualData(residualData);
                }
            }
            if (this.errorMap.size() > 0) {
                this.logErrors(this.errorMap, this.forecastProcessID);
                this.errorMap.clear();
            }
            try {
                ForecastAMImpl.this.forecastDM.recordForecastProcessStarted(this.forecastProcessID, this.windowBegin.getTimeInMillis(), this.windowEnd.getTimeInMillis());
            }
            catch (NotSavedException notSavedException) {
                throw new IllegalStateException(notSavedException);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException(resourceUnavailableException);
            }
            long l3 = NanoTimer.elapsed((long)l);
            logger.info((Object)MessageUtil.formatMsg((String)"SAM forecast data creation has completed. Elapsed time: {0} ms.", (Object[])new Object[]{l3}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void regenerateForecast_ActualWork() throws ResourceUnavailableException {
            Object object2;
            Cloneable cloneable;
            boolean bl;
            Set<ForecastableEvent> set;
            ForecastProcessInfo forecastProcessInfo;
            long l = NanoTimer.start();
            try {
                forecastProcessInfo = ForecastAMImpl.this.forecastDM.getInternalForecastProcessInfo();
            }
            catch (NoDataException noDataException) {
                throw new IllegalStateException("ForecastProcessInfo not found", noDataException);
            }
            long l2 = forecastProcessInfo.getWindowBegin();
            Set<ForecastableEvent>[] setArray = this.identifyEventsThatHaveBeenAddedRemovedOrDeletedSinceLastRegen(l2);
            Set<ForecastableEvent> set2 = setArray[0];
            Set<ForecastableEvent> set3 = setArray[1];
            Set<ForecastableEvent> set4 = setArray[2];
            setArray = this.identifyEventsThatHaveBeenChangedOrImpactedSinceLastRegen(l2, set2);
            Set<ForecastableEvent> set5 = setArray[0];
            Set<ForecastableEvent> set6 = setArray[1];
            if (set6.isEmpty()) {
                set = set5;
            } else {
                set = new HashSet<ForecastableEvent>(set5);
                set.addAll(set6);
            }
            this.forecastGenerator.removeCachedDataFor(set);
            this.forecastGenerator.removeCachedDataFor(set4);
            this.forecastGenerator.adjustCachedDataFor(set, set4);
            this.removeCachedDataFor(set);
            this.removeCachedDataFor(set4);
            this.forecastGenerator.removeOutdatedCachedDurationData(l2);
            boolean bl2 = bl = set.size() == 0 && set2.size() == 0;
            if (bl) {
                this.windowBegin = Calendar.getInstance();
            } else {
                cloneable = new HashSet<ForecastableEvent>(set);
                cloneable.addAll(set2);
                Map map = this.forecastGenerator.capturePrereqStatusInfo(cloneable);
                this.windowBegin = Calendar.getInstance();
                this.prereqConditionsCache.putAll(map);
            }
            cloneable = (Calendar)this.windowBegin.clone();
            ((Calendar)cloneable).setTimeInMillis(forecastProcessInfo.getWindowEnd() + 1L);
            long l3 = this.horizon + this.regenInterval;
            this.windowEnd.setTimeInMillis(this.windowBegin.getTimeInMillis() + l3);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            logger.info((Object)MessageUtil.formatMsg((String)"Regenerating the SAM forecast data for {0} - {1}.", (Object[])new Object[]{simpleDateFormat.format(this.windowBegin.getTime()), simpleDateFormat.format(this.windowEnd.getTime())}));
            this.forecastGenerator.batchLoadForecastScheduleInfo();
            this.forecastGenerator.batchLoadReactiveRangeInfo();
            this.forecastGenerator.batchLoadMemberExclusionPerSpecialInstanceInfo();
            this.forecastGenerator.batchLoadMembersWithTheANYOption();
            this.forecastGenerator.batchLoadOmitDates();
            this.forecastGenerator.batchLoadReferencesToNonStandardCalendars();
            Map<ForecastableEvent, AgentGroupProxy> map = this.batchLoadAgentGroupInfo();
            this.forecastGenerator.setPrereqConditionsCache(this.prereqConditionsCache);
            this.prereqConditionsCache = new HashMap<PrereqConditionKey, PrereqCondition>();
            this.forecastGenerator.setQueueEntriesCache(this.queueEntriesCache);
            this.queueEntriesCache = new HashMap<ForecastableEvent, List<QueueEntry>>();
            this.forecastGenerator.clearCalendarObjectCache();
            this.forecastGenerator.clearDateObjectCache();
            this.forecastGenerator.clearSuiteEventInfoCache();
            ResidualData residualData = null;
            logger.debug((Object)MessageUtil.formatMsg((String)"Forecastable events: {0}", (Object[])new Object[]{this.forecastableEvents.length}));
            try (SharedResource sharedResource = null;){
                for (Object object2 : this.forecastableEvents) {
                    String string;
                    String string2;
                    this.forecastedEvents.clear();
                    try {
                        residualData = bl || !set.contains(object2) && !set2.contains(object2) ? this.forecastGenerator.forecast(object2, (Calendar)cloneable, this.windowEnd, (Calendar)cloneable, this.forecastedEvents) : this.forecastGenerator.forecast(object2, this.windowBegin, this.windowEnd, this.windowBegin, this.forecastedEvents);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        string2 = this.toEventType_forMessageString(object2.getType());
                        string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). The forecast process will be ended and any results that may have been generated so far will be discarded.", (Object[])new Object[]{string2, object2.getName(), object2.getID()});
                        logger.error((Object)string, (Throwable)resourceUnavailableException);
                        throw new IllegalStateException(string, resourceUnavailableException);
                    }
                    catch (Exception exception) {
                        string2 = this.toEventType_forMessageString(object2.getType());
                        string = MessageUtil.formatMsg((String)"An error occurred while forecasting {0} {1} (id {2}). It will not be included in the forecast output.", (Object[])new Object[]{string2, object2.getName(), object2.getID()});
                        this.errorMap.put((ForecastableEvent)object2, new Exception(string, exception));
                        this.forecastedEvents.clear();
                    }
                    sharedResource = this.insertEventRecords(this.windowBegin.getTimeInMillis(), sharedResource, map);
                    this.cacheAnyResidualData(residualData);
                }
            }
            if (this.errorMap.size() > 0) {
                this.logErrors(this.errorMap, this.forecastProcessID);
                this.errorMap.clear();
            }
            ForecastAMImpl.this.forecastDM.setForecastProcessDataLockoutFlag(this.forecastProcessID, true);
            if (set.size() > 0) {
                long l4 = this.windowBegin.getTimeInMillis();
                ForecastAMImpl.this.forecastDM.deleteObsoleteForecastProcessEvents(set, this.forecastProcessID, l4);
            }
            if (set3.size() > 0 || set4.size() > 0) {
                HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>(set3);
                hashSet.addAll(set4);
                ForecastAMImpl.this.forecastDM.deleteForecastProcessEvents((Set)hashSet, this.forecastProcessID);
            }
            this.purgeDataFromTailEnd(this.windowBegin.getTimeInMillis());
            try {
                ForecastAMImpl.this.forecastDM.recordForecastProcessRegenerated(this.forecastProcessID, this.windowBegin.getTimeInMillis(), this.windowEnd.getTimeInMillis());
            }
            catch (NotSavedException notSavedException) {
                throw new IllegalStateException(notSavedException);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException(resourceUnavailableException);
            }
            long l5 = NanoTimer.elapsed((long)l);
            object2 = MessageUtil.formatMsg((String)"Elapsed time: {0} ms.", (Object[])new Object[]{l5});
            String string = bl ? MessageUtil.formatMsg((String)"SAM forecast data regenerated by extending the data from {0} - {1}, since no changes were detected to the underlying jobs and events.", (Object[])new Object[]{simpleDateFormat.format(((Calendar)cloneable).getTime()), simpleDateFormat.format(this.windowEnd.getTime())}) : MessageUtil.formatMsg((String)"SAM forecast data regeneration detected {0} changed, {1} impacted, {2} added, {3} removed, {4} deleted jobs/events since the previous regeneration.", (Object[])new Object[]{set5.size(), set6.size(), set2.size(), set3.size(), set4.size()});
            logger.info((Object)(string + " " + (String)object2));
        }

        private boolean arrivedAtWakeupTime() {
            if (this.wakeupTime == 0L) {
                this.setWakeupTime();
            }
            return this.currentTime() >= this.wakeupTime;
        }

        private void autoRegen() throws ResourceUnavailableException {
            long l = TimeUnit.SECONDS.toNanos(30L);
            this.regenerateForecast(l);
        }

        private Map<ForecastableEvent, AgentGroupProxy> batchLoadAgentGroupInfo() {
            try {
                return ForecastAMImpl.this.forecastDM.getAllEventsThatRunOnAnAgentGroup();
            }
            catch (Exception exception) {
                logger.info((Object)"Could not batch load Agent Group information.", (Throwable)exception);
                return new HashMap<ForecastableEvent, AgentGroupProxy>();
            }
        }

        private void cacheAnyResidualData(ResidualData residualData) {
            if (residualData != null) {
                Object object;
                Map map = residualData.getPrereqConditions();
                if (map != null) {
                    object = map.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry entry = (Map.Entry)object.next();
                        if (!((PrereqCondition)entry.getValue()).hasAtLeastOneNonBlankStatus()) continue;
                        this.prereqConditionsCache.put((PrereqConditionKey)entry.getKey(), (PrereqCondition)entry.getValue());
                    }
                }
                if ((object = residualData.getQueueEntries()) != null) {
                    this.queueEntriesCache.put(residualData.forecastableEvent, (List<QueueEntry>)object);
                }
            }
        }

        private void cleanup() {
            logger.info((Object)MessageUtil.formatMsg((String)"Forecast process {0} ending.", (Object[])new Object[]{this.forecastProcessID}));
        }

        private ForecastableEvent[] constructForecastableEvents(ForecastFilter forecastFilter, boolean bl, boolean bl2) {
            ForecastableEvent[] forecastableEventArray;
            ForecastableEvent[] forecastableEventArray2;
            ForecastableEvent[] forecastableEventArray3;
            try {
                forecastableEventArray3 = ForecastAMImpl.this.forecastDM.getJobsToForecast(forecastFilter, bl, bl2);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException("Unable to retrieve the jobs to forecast.", resourceUnavailableException);
            }
            try {
                forecastableEventArray2 = ForecastAMImpl.this.forecastDM.getMembersToForecast();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException("Unable to retrieve the suite members to forecast.", resourceUnavailableException);
            }
            try {
                forecastableEventArray = ForecastAMImpl.this.forecastDM.getEventsToForecast(forecastFilter);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw new IllegalStateException("Unable to retrieve the events to forecast.", resourceUnavailableException);
            }
            ForecastableEvent[] forecastableEventArray4 = new ForecastableEvent[forecastableEventArray3.length + forecastableEventArray2.length + forecastableEventArray.length];
            System.arraycopy(forecastableEventArray3, 0, forecastableEventArray4, 0, forecastableEventArray3.length);
            System.arraycopy(forecastableEventArray2, 0, forecastableEventArray4, forecastableEventArray3.length, forecastableEventArray2.length);
            System.arraycopy(forecastableEventArray, 0, forecastableEventArray4, forecastableEventArray3.length + forecastableEventArray2.length, forecastableEventArray.length);
            return forecastableEventArray4;
        }

        private long currentTime() {
            return System.currentTimeMillis();
        }

        private int findInArray(ForecastableEvent[] forecastableEventArray, ForecastableEvent forecastableEvent) {
            return Arrays.binarySearch(forecastableEventArray, forecastableEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<ForecastableEvent> getAndClearChangedEvents() {
            Set<ForecastableEvent> set;
            Object object = this.changeLock;
            synchronized (object) {
                set = this.changedEvents;
                this.changedEvents = new HashSet<ForecastableEvent>();
            }
            return set;
        }

        private ClearanceRequestResult getClearanceForForecastAction(long l, long l2) {
            if (activeForecastProcessID == l) {
                return ClearanceRequestResult.SAME_PROCESS_ALREADY_ACTIVE;
            }
            try {
                if (!forecastProcessLock.tryLock(l2, TimeUnit.NANOSECONDS)) {
                    return ClearanceRequestResult.TIMEOUT;
                }
            }
            catch (InterruptedException interruptedException) {
                return ClearanceRequestResult.INTERRUPTED_WHILE_WAITING;
            }
            activeForecastProcessID = l;
            return ClearanceRequestResult.GRANTED;
        }

        private Set<ForecastableEvent>[] identifyEventsThatHaveBeenAddedRemovedOrDeletedSinceLastRegen(long l) throws ResourceUnavailableException {
            boolean bl;
            HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
            HashSet<ForecastableEvent> hashSet2 = new HashSet<ForecastableEvent>();
            HashSet<ForecastableEvent> hashSet3 = new HashSet<ForecastableEvent>();
            Set[] setArray = new Set[]{hashSet, hashSet2, hashSet3};
            ForecastableEvent[] forecastableEventArray = this.forecastableEvents;
            ForecastableEvent[] forecastableEventArray2 = this.forecastableEvents = this.constructForecastableEvents(this.forecastFilter, this.isExcludeTimedIntervalJobs, this.isExcludeDailyIntervalJobs);
            for (ForecastableEvent forecastableEvent : forecastableEventArray2) {
                bl = false;
                for (ForecastableEvent forecastableEvent2 : forecastableEventArray) {
                    if (!forecastableEvent2.equals((Object)forecastableEvent)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                hashSet.add(forecastableEvent);
            }
            for (ForecastableEvent forecastableEvent : forecastableEventArray) {
                bl = false;
                for (ForecastableEvent forecastableEvent2 : forecastableEventArray2) {
                    if (!forecastableEvent2.equals((Object)forecastableEvent)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                hashSet2.add(forecastableEvent);
            }
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                ForecastableEvent forecastableEvent = (ForecastableEvent)iterator.next();
                int n = 0;
                switch (forecastableEvent.getType()) {
                    case JOB_SUBMISSION: 
                    case JOB_SUITE: {
                        if (ForecastAMImpl.this.forecastDM.isJobInDatabase(forecastableEvent.getID())) break;
                        n = 1;
                        break;
                    }
                    case MEMBER_JOB: {
                        if (ForecastAMImpl.this.forecastDM.isMemberInDatabase(forecastableEvent.getID())) break;
                        n = 1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Forecastable Event Type {0} is not supported by this method.", (Object[])new Object[]{forecastableEvent.getType()}));
                    }
                }
                if (n == 0) continue;
                hashSet3.add(forecastableEvent);
                iterator.remove();
            }
            return setArray;
        }

        private Set<ForecastableEvent>[] identifyEventsThatHaveBeenChangedOrImpactedSinceLastRegen(long l, Set<ForecastableEvent> set) throws ResourceUnavailableException {
            HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
            HashSet<ForecastableEvent> hashSet2 = new HashSet<ForecastableEvent>();
            Set[] setArray = new Set[]{hashSet, hashSet2};
            Set<ForecastableEvent> set2 = this.identifyEventsThatHaveChangedSinceLastRegen(l, set);
            if (!set2.isEmpty()) {
                int n;
                Set<ForecastableEvent> set3 = this.identifyEventsDependentOnChangedEvents(set2);
                Arrays.sort(this.forecastableEvents);
                for (ForecastableEvent forecastableEvent : set2) {
                    n = this.findInArray(this.forecastableEvents, forecastableEvent);
                    if (n < 0) continue;
                    hashSet.add(this.forecastableEvents[n]);
                }
                for (ForecastableEvent forecastableEvent : set3) {
                    n = this.findInArray(this.forecastableEvents, forecastableEvent);
                    if (n < 0) continue;
                    hashSet2.add(this.forecastableEvents[n]);
                }
            }
            return setArray;
        }

        private Set<ForecastableEvent> identifyEventsThatHaveBeenAddedSinceLastRegen(long l) throws ResourceUnavailableException {
            HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
            List list = ForecastAMImpl.this.forecastDM.getJobsCreatedAfter(l - 1L);
            int n = list.size();
            if (n > 0) {
                for (ForecastableEvent forecastableEvent : this.forecastableEvents) {
                    if (forecastableEvent.getType() != ForecastableEvent.ForecastableEventType.JOB_SUBMISSION || !list.contains(forecastableEvent.getID())) continue;
                    hashSet.add(forecastableEvent);
                }
            }
            return hashSet;
        }

        private Set<ForecastableEvent> identifyEventsThatHaveChangedSinceLastRegen_onRestart(long l, Set<ForecastableEvent> set) throws ResourceUnavailableException {
            HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
            List list = ForecastAMImpl.this.forecastDM.getJobsUpdatedAfter(l - 1L);
            for (Long l2 : list) {
                hashSet.add(new ForecastableEvent(l2.longValue(), ForecastableEvent.ForecastableEventType.JOB_SUBMISSION));
            }
            this.removeDoubleCountedEvents(hashSet, set);
            return hashSet;
        }

        private Set<ForecastableEvent> identifyEventsThatHaveChangedSinceLastRegen(long l, Set<ForecastableEvent> set) {
            Set<ForecastableEvent> set2 = this.getAndClearChangedEvents();
            this.removeDoubleCountedEvents(set2, set);
            return set2;
        }

        private Set<ForecastableEvent> identifyEventsDependentOnChangedEvents(Set<ForecastableEvent> set) {
            HashSet<ForecastableEvent> hashSet = new HashSet<ForecastableEvent>();
            if (!set.isEmpty()) {
                ArrayList<ForecastableEvent> arrayList = new ArrayList<ForecastableEvent>(set);
                ArrayList<ForecastableEvent> arrayList2 = new ArrayList<ForecastableEvent>();
                DependencyEntry[] dependencyEntryArray = this.toDependencyEntryArray(this.forecastGenerator.depMap2);
                while (arrayList.size() > 0) {
                    arrayList2.clear();
                    arrayList2.addAll(arrayList);
                    arrayList.clear();
                    for (ForecastableEvent forecastableEvent : arrayList2) {
                        PrereqEventType prereqEventType = this.toPrereqEventType(forecastableEvent.getType());
                        for (int i = 0; i < dependencyEntryArray.length; ++i) {
                            ForecastableEvent forecastableEvent2;
                            DependencyEntry dependencyEntry = dependencyEntryArray[i];
                            if (dependencyEntry.getPrerequisiteID() != forecastableEvent.getID() || dependencyEntry.getPrerequisiteType() != prereqEventType || set.contains(forecastableEvent2 = this.toForecastableEvent(dependencyEntry.getDependentObject())) || !hashSet.add(forecastableEvent2)) continue;
                            arrayList.add(forecastableEvent2);
                        }
                    }
                }
            }
            return hashSet;
        }

        private SharedResource insertEventRecords(long l, SharedResource sharedResource, Map<ForecastableEvent, AgentGroupProxy> map) throws ResourceUnavailableException {
            try {
                for (ForecastedEvent forecastedEvent : this.forecastedEvents) {
                    if (sharedResource == null) {
                        sharedResource = ForecastAMImpl.this.forecastDM.insertForecastProcessEvent(this.forecastProcessID, forecastedEvent, l, map);
                        continue;
                    }
                    ForecastAMImpl.this.forecastDM.insertForecastProcessEvent(this.forecastProcessID, forecastedEvent, l, map, sharedResource);
                }
            }
            catch (NotSavedException notSavedException) {
                throw new IllegalStateException(notSavedException);
            }
            return sharedResource;
        }

        private void logErrors(Map<ForecastableEvent, Exception> map, long l) {
            if (map.size() > 0) {
                logger.info((Object)MessageUtil.formatMsg((String)"Error(s) detected in SAM forecast process {0}.", (Object[])new Object[]{l}));
                for (Map.Entry<ForecastableEvent, Exception> entry : map.entrySet()) {
                    logger.info((Object)this.nestedMsgText(entry.getValue()));
                }
            }
        }

        private void manualRegen(long l) throws ResourceUnavailableException {
            NSTCalculator.setSuppressScheduleLogEntry(true);
            ScheduleInfo.setSuppressScheduleLogEntry((boolean)true);
            Runtimes_Basic.setSuppressScheduleLogEntry((boolean)true);
            this.regenerateForecast(l);
        }

        private String nestedMsgText(Exception exception) {
            String string = exception.getMessage();
            for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                string = string + " " + throwable.getMessage();
            }
            return string;
        }

        private void purgeDataFromTailEnd(long l) {
            long l2 = 3600000L;
            long l3 = 48L * l2;
            long l4 = l - (l3 - 1L);
            try {
                int n = ForecastAMImpl.this.forecastDM.purgeForecastProcessData(l4);
                if (n > 0) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    logger.info((Object)MessageUtil.formatMsg((String)"Deleted {0} {1} older than {2} from the SAM forecast data.", (Object[])new Object[]{n, n > 1 ? "rows" : "row", simpleDateFormat.format(new Date(l4))}));
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Unable to purge forecast process data.", (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordChangedEvent(ForecastableEvent forecastableEvent) {
            Object object = this.changeLock;
            synchronized (object) {
                this.changedEvents.add(forecastableEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordChangedEvents(Set<ForecastableEvent> set) {
            Object object = this.changeLock;
            synchronized (object) {
                this.changedEvents.addAll(set);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void releaseForecastProcessLock() {
            if (!forecastProcessLock.isLocked()) throw new IllegalStateException("Program error: A request was made to unlock the forecastProcessLock, but it was not locked.");
            if (!forecastProcessLock.isHeldByCurrentThread()) throw new IllegalStateException("Program error: A request was made to unlock the forecastProcessLock, but another thread holds the lock.");
            if (forecastProcessLock.getHoldCount() != 1) {
                throw new IllegalStateException("Program error: A request was made to unlock the forecastProcessLock, but more than 1 lock was held by this thread.");
            }
            activeForecastProcessID = 0L;
            forecastProcessLock.unlock();
        }

        private void removeCachedDataFor(Collection<ForecastableEvent> collection) {
            Set<Map.Entry<PrereqConditionKey, PrereqCondition>> set = this.prereqConditionsCache.entrySet();
            Iterator<Map.Entry<PrereqConditionKey, PrereqCondition>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<PrereqConditionKey, PrereqCondition> entry = iterator.next();
                DependentObject dependentObject = ((PrereqConditionKey)entry.getKey()).dependentObject;
                ForecastableEvent forecastableEvent = this.toForecastableEvent(dependentObject);
                if (!collection.contains(forecastableEvent)) continue;
                iterator.remove();
            }
            for (ForecastableEvent forecastableEvent : collection) {
                this.queueEntriesCache.remove(forecastableEvent);
            }
        }

        private void removeDoubleCountedEvents(Set<ForecastableEvent> set, Set<ForecastableEvent> set2) {
            Iterator<ForecastableEvent> iterator = set.iterator();
            while (iterator.hasNext()) {
                ForecastableEvent forecastableEvent = iterator.next();
                if (!set2.contains(forecastableEvent)) continue;
                iterator.remove();
            }
        }

        private long runDuration(long l, long l2) {
            return this.forecastGenerator.runDuration(l, l2);
        }

        private void setWaitTime() {
            this.waitTime = this.wakeupTime - this.currentTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setWakeupTime() {
            Object object = this.waitLock;
            synchronized (object) {
                this.wakeupTime = this.windowBegin.getTimeInMillis() + this.regenInterval;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            if (!this.shutdown) {
                this.shutdown = true;
                Object object = this.waitLock;
                synchronized (object) {
                    if (this.sleeping) {
                        this.waitLock.notify();
                    }
                }
            }
        }

        private DependencyEntry[] toDependencyEntryArray(Map<DependentObject, List<DependencyEntry>> map) {
            ArrayList arrayList = new ArrayList();
            for (Map.Entry<DependentObject, List<DependencyEntry>> entry : map.entrySet()) {
                arrayList.addAll(entry.getValue());
            }
            return arrayList.toArray(new DependencyEntry[arrayList.size()]);
        }

        private String toEventType_forMessageString(ForecastableEvent.ForecastableEventType forecastableEventType) {
            switch (forecastableEventType) {
                case JOB_SUBMISSION: {
                    return "Job";
                }
                case JOB_SUITE: {
                    return "Job suite";
                }
                case MEMBER_JOB: {
                    return "Member job";
                }
                case AGENT_EVENT_OCCURS: {
                    return "Agent event";
                }
                case REACTIVE_EVENT_OCCURS: {
                    return "Reactive event";
                }
            }
            return forecastableEventType.toString();
        }

        private ForecastableEvent toForecastableEvent(DependentObject dependentObject) {
            ForecastableEvent.ForecastableEventType forecastableEventType;
            long l = dependentObject.getID();
            switch (dependentObject.getType()) {
                case JOB: {
                    forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUBMISSION;
                    break;
                }
                case JOB_SUITE: {
                    forecastableEventType = ForecastableEvent.ForecastableEventType.JOB_SUITE;
                    break;
                }
                case MEMBER_JOB: {
                    forecastableEventType = ForecastableEvent.ForecastableEventType.MEMBER_JOB;
                    break;
                }
                case REACTIVE_EVENT: {
                    forecastableEventType = ForecastableEvent.ForecastableEventType.REACTIVE_EVENT_OCCURS;
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Dependent Object Type {0} is not supported by this method.", (Object[])new Object[]{dependentObject.getType()}));
                }
            }
            return new ForecastableEvent(l, forecastableEventType);
        }

        private PrereqEventType toPrereqEventType(ForecastableEvent.ForecastableEventType forecastableEventType) {
            switch (forecastableEventType) {
                case JOB_SUBMISSION: {
                    return PrereqEventType.JOB_STATUS_CHANGE;
                }
                case JOB_SUITE: {
                    return PrereqEventType.JOB_SUITE_STATUS_CHANGE;
                }
                case MEMBER_JOB: {
                    return PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE;
                }
                case AGENT_EVENT_OCCURS: {
                    return PrereqEventType.AGENT_EVENT;
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Forecastable Event Type {0} is not supported by this method.", (Object[])new Object[]{forecastableEventType}));
        }
    }
}

