/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.scheduler;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.forecast.ForecastedObjectType;
import com.helpsystems.enterprise.core.scheduler.ActivityMatcherAM;
import com.helpsystems.enterprise.core.scheduler.ForecastDM;
import org.apache.log4j.Logger;

public class ActivityMatcherAMImpl
extends AbstractManager
implements ActivityMatcherAM {
    private static final Logger logger = Logger.getLogger(ActivityMatcherAMImpl.class);
    private ForecastDM forecastDM;

    public ActivityMatcherAMImpl(ForecastDM forecastDM) {
        ValidationHelper.checkForNull((String)"ForecastDM", (Object)forecastDM);
        this.forecastDM = forecastDM;
        this.setName("ENTERPRISE.ActivityMatcherAM");
    }

    public void eventOccurred(long l, long l2, long l3, long l4) {
    }

    public void jobMissedIgnored(long l, JobType jobType, long l2, JobInitCode jobInitCode, long l3) {
        try {
            ForecastedObjectType forecastedObjectType = this.toForecastedObjectType(jobType);
            switch (jobInitCode) {
                case SCHEDULE: 
                case SCHEDULED_WITH_PREREQS: {
                    this.forecastDM.updateIfExactMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.MISSED_IGNORED);
                    break;
                }
                case REACTIVE: {
                    this.forecastDM.updateIfProbableMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.MISSED_IGNORED);
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Init Code {0} is not supported by this method.", (Object[])new Object[]{jobInitCode}));
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast job as missed-ignored.", (Throwable)exception);
        }
    }

    public void jobSkipped_IntervalJobAlreadyActive(long l, JobType jobType, long l2, long l3) {
        try {
            ForecastedObjectType forecastedObjectType = this.toForecastedObjectType(jobType);
            this.forecastDM.updateIfExactMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.SKIPPED_INTERVAL_JOB_ALREADY_ACTIVE);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast job as skipped.", (Throwable)exception);
        }
    }

    public void jobSkipped_IntervalJobAlreadyActive(long l, JobType jobType, long l2, long l3, long l4) {
        try {
            ForecastedObjectType forecastedObjectType = this.toForecastedObjectType(jobType);
            this.forecastDM.updateIfExactMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.SKIPPED_INTERVAL_JOB_ALREADY_ACTIVE, l4);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast job as skipped.", (Throwable)exception);
        }
    }

    public void jobSkipped_IsHeld(long l, JobType jobType, long l2, JobInitCode jobInitCode, long l3) {
        try {
            ForecastedObjectType forecastedObjectType = this.toForecastedObjectType(jobType);
            switch (jobInitCode) {
                case SCHEDULE: 
                case SCHEDULED_WITH_PREREQS: {
                    this.forecastDM.updateIfExactMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.SKIPPED_HELD);
                    break;
                }
                case REACTIVE: {
                    this.forecastDM.updateIfProbableMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.SKIPPED_HELD);
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Init Code {0} is not supported by this method.", (Object[])new Object[]{jobInitCode}));
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast job as skipped.", (Throwable)exception);
        }
    }

    public void jobSkipped_PrereqsNotMet(long l, JobType jobType, long l2, long l3) {
        try {
            ForecastedObjectType forecastedObjectType = this.toForecastedObjectType(jobType);
            this.forecastDM.updateIfExactMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.SKIPPED_PREREQS_NOT_MET);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast job as skipped.", (Throwable)exception);
        }
    }

    public void jobSkipped_PrereqsNotMet(long l, JobType jobType, long l2, long l3, long l4) {
        try {
            ForecastedObjectType forecastedObjectType = this.toForecastedObjectType(jobType);
            this.forecastDM.updateIfExactMatch(l3, l, forecastedObjectType, l2, ForecastDM.ActivityMatchCode.SKIPPED_PREREQS_NOT_MET, l4);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast job as skipped.", (Throwable)exception);
        }
    }

    public void jobSubmitted(long l, JobType jobType, long l2, long l3, JobInitCode jobInitCode, long l4) {
        try {
            ForecastedObjectType forecastedObjectType = this.toForecastedObjectType(jobType);
            switch (jobInitCode) {
                case SCHEDULE: 
                case SCHEDULED_WITH_PREREQS: {
                    this.forecastDM.updateIfExactMatch(l4, l, forecastedObjectType, l2, l3);
                    break;
                }
                case REACTIVE: {
                    this.forecastDM.updateIfProbableMatch(l4, l, forecastedObjectType, l2, l3);
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Init Code {0} is not supported by this method.", (Object[])new Object[]{jobInitCode}));
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast job as submitted.", (Throwable)exception);
        }
    }

    public void memberSubmitted(long l, long l2, long l3, long l4) {
        try {
            this.forecastDM.updateIfProbableMatch(l4, l, ForecastedObjectType.MEMBER_JOB, l2, l3);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast member job as submitted.", (Throwable)exception);
        }
    }

    public void memberSkipped(long l, long l2, long l3, long l4) {
        try {
            this.forecastDM.updateIfProbableMatch(l4, l, ForecastedObjectType.MEMBER_JOB, l2, l3);
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast member job as skipped.", (Throwable)exception);
        }
    }

    public void suiteMissed_Ignored(long l, long l2) {
        long l3 = 0L;
        try {
            long l4 = this.forecastDM.updateIfExactMatchAndReturnID(l2, l, ForecastedObjectType.JOB_SUITE, l3, ForecastDM.ActivityMatchCode.MISSED_IGNORED);
            if (l4 > 0L) {
                this.forecastDM.updateAllMembersAsMatched(l4, ForecastDM.ActivityMatchCode.PARENT_SUITE_MISSED);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast suite as missed - ignored.", (Throwable)exception);
        }
    }

    public void suiteMissed_Ended(long l, long l2, long l3) {
        long l4 = 0L;
        try {
            long l5 = this.forecastDM.updateIfExactMatchAndReturnID(l2, l, ForecastedObjectType.JOB_SUITE, l4, ForecastDM.ActivityMatchCode.EXACT, l3);
            if (l5 > 0L) {
                this.forecastDM.updateAllMembersAsMatched(l5, ForecastDM.ActivityMatchCode.PARENT_SUITE_MISSED);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast suite as missed - ended.", (Throwable)exception);
        }
    }

    public void suiteManaged_Deleted(long l) {
        try {
            long l2 = this.forecastDM.getMatchedSuiteEventID(l);
            if (l2 > 0L) {
                this.forecastDM.updateAllMembersAsMatched(l2, ForecastDM.ActivityMatchCode.PARENT_SUITE_MANAGED_DELETED);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast suite as managed - deleted.", (Throwable)exception);
        }
    }

    public void suiteManaged_Ended(long l) {
        try {
            long l2 = this.forecastDM.getMatchedSuiteEventID(l);
            if (l2 > 0L) {
                this.forecastDM.updateAllMembersAsMatched(l2, ForecastDM.ActivityMatchCode.PARENT_SUITE_MANAGED_ENDED);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast suite as managed - ended.", (Throwable)exception);
        }
    }

    public void suiteSkipped_IsHeld(long l, JobInitCode jobInitCode, long l2) {
        try {
            long l3;
            long l4 = 0L;
            switch (jobInitCode) {
                case SCHEDULE: 
                case SCHEDULED_WITH_PREREQS: {
                    l3 = this.forecastDM.updateIfExactMatchAndReturnID(l2, l, ForecastedObjectType.JOB_SUITE, l4, ForecastDM.ActivityMatchCode.SKIPPED_HELD);
                    break;
                }
                case REACTIVE: {
                    l3 = this.forecastDM.updateIfProbableMatch(l2, l, ForecastedObjectType.JOB_SUITE, l4, ForecastDM.ActivityMatchCode.SKIPPED_HELD);
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Init Code {0} is not supported by this method.", (Object[])new Object[]{jobInitCode}));
                }
            }
            if (l3 > 0L) {
                this.forecastDM.updateAllMembersAsMatched(l3, ForecastDM.ActivityMatchCode.PARENT_SUITE_HELD);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"An error occurred while trying to mark a forecast suite as skipped.", (Throwable)exception);
        }
    }

    private ForecastedObjectType toForecastedObjectType(JobType jobType) {
        switch (jobType) {
            case JOB: {
                return ForecastedObjectType.JOB;
            }
            case SUITE: {
                return ForecastedObjectType.JOB_SUITE;
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
    }
}

