/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.automate;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.amts_11.automate.constructs.TaskServiceObjectInformationBriefConstruct;
import com.helpsystems.enterprise.amts_11.automate.messages.AuthenticationRequestMessage;
import com.helpsystems.enterprise.amts_11.automate.messages.AuthenticationResultCodes_t;
import com.helpsystems.enterprise.amts_11.automate.messages.GetTaskAndFolderNamesRequestMessage;
import com.helpsystems.enterprise.amts_11.org.tempuri.AMTSWCFServerLocator;
import com.helpsystems.enterprise.amts_11.org.tempuri.Authenticate;
import com.helpsystems.enterprise.amts_11.org.tempuri.AuthenticateResponse;
import com.helpsystems.enterprise.amts_11.org.tempuri.GetTaskAndFolderNames;
import com.helpsystems.enterprise.amts_11.org.tempuri.GetTaskAndFolderNamesResponse;
import com.helpsystems.enterprise.amts_11.org.tempuri.IAMTSHTTPServiceContract;
import com.helpsystems.enterprise.bpa_11.automate.constructs.AgentConstruct;
import com.helpsystems.enterprise.bpa_11.automate.constructs.AgentGroupConstruct;
import com.helpsystems.enterprise.bpa_11.automate.constructs.AgentType;
import com.helpsystems.enterprise.bpa_11.automate.constructs.AutomationConstruct;
import com.helpsystems.enterprise.bpa_11.automate.constructs.AutomationObjectInfoConstruct;
import com.helpsystems.enterprise.bpa_11.automate.constructs.ClientType;
import com.helpsystems.enterprise.bpa_11.automate.constructs.ConstructType;
import com.helpsystems.enterprise.bpa_11.automate.messages.CloseSessionRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllAgentGroupsRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllAgentGroupsResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllAgentsRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllAgentsResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllFoldersRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllFoldersResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllRepositoryContentsRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.GetAllRepositoryContentsResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.OpenSessionRequestMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.OpenSessionResponseMessage;
import com.helpsystems.enterprise.bpa_11.automate.messages.ResponseMessageBase;
import com.helpsystems.enterprise.bpa_11.org.tempuri.BPAManagementServerWCFServerLocator;
import com.helpsystems.enterprise.bpa_11.org.tempuri.CloseSessionRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllAgentGroupsRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllAgentGroupsRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllAgentsRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllAgentsRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllFoldersRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllFoldersRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllRepositoryContentsRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.GetAllRepositoryContentsRequestResponse;
import com.helpsystems.enterprise.bpa_11.org.tempuri.IBPAManagementServerHTTPServiceContract;
import com.helpsystems.enterprise.bpa_11.org.tempuri.OpenSessionRequest;
import com.helpsystems.enterprise.bpa_11.org.tempuri.OpenSessionRequestResponse;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.automate.AgentInformation;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPACommand;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateBPARequestComposite;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateObject;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSearchSelection;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemDefinition;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemType;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskInformation;
import com.helpsystems.enterprise.core.busobj.automate.RepositoryContents;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AutomateV11Helper {
    static final String USER_OR_PASSWORD_INCORRECT = "username or password is incorrect";
    private static final String USER_ACCOUNT_NOT_ACTIVE = "user account is not active.";
    private static final String USER_ALREADY_LOGGED_IN = "UserAlreadyLoggedIn";
    private static final String USER_LOCKED_OUT = "UserLockedOut";
    static final String NOT_LICENSED = "Automate not licensed.";
    private static DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static Logger logger;

    public AutomateV11Helper(Logger logger) {
        AutomateV11Helper.logger = logger;
    }

    public AutomateV11Helper() {
    }

    protected IBPAManagementServerHTTPServiceContract getServiceContract(String string) throws ServiceException {
        this.configureProxyServer();
        BPAManagementServerWCFServerLocator bPAManagementServerWCFServerLocator = new BPAManagementServerWCFServerLocator();
        bPAManagementServerWCFServerLocator.setBasicHttpBinding_IBPAManagementServerHTTPServiceContractEndpointAddress(string);
        IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract = bPAManagementServerWCFServerLocator.getBasicHttpBinding_IBPAManagementServerHTTPServiceContract();
        return iBPAManagementServerHTTPServiceContract;
    }

    IAMTSHTTPServiceContract getIAMTSHTTPServiceContract(String string) throws ServiceException {
        this.configureProxyServer();
        AMTSWCFServerLocator aMTSWCFServerLocator = new AMTSWCFServerLocator();
        aMTSWCFServerLocator.setBasicHttpBinding_IAMTSHTTPServiceContractEndpointAddress(string);
        IAMTSHTTPServiceContract iAMTSHTTPServiceContract = aMTSWCFServerLocator.getBasicHttpBinding_IAMTSHTTPServiceContract();
        return iAMTSHTTPServiceContract;
    }

    String authenticateConnection(long l, AutoMateSystemDefinition autoMateSystemDefinition, IAMTSHTTPServiceContract iAMTSHTTPServiceContract) throws Exception {
        Calendar calendar = null;
        String string = "authenticate." + l;
        String string2 = null;
        Boolean bl = Boolean.FALSE;
        String string3 = String.valueOf(autoMateSystemDefinition.getVersion());
        AuthenticationRequestMessage authenticationRequestMessage = new AuthenticationRequestMessage(string, calendar, string2, bl, autoMateSystemDefinition.getDecryptedPassword(), string3);
        Authenticate authenticate = new Authenticate(authenticationRequestMessage);
        AuthenticateResponse authenticateResponse = null;
        try {
            authenticateResponse = iAMTSHTTPServiceContract.authenticate(authenticate);
        }
        catch (RemoteException remoteException) {
            throw new IllegalArgumentException(remoteException.getMessage());
        }
        if (!authenticateResponse.getAuthenticateResult().getResponseResult().booleanValue()) {
            String string4 = "Authenticate did not get a positive response result: " + authenticateResponse.getAuthenticateResult().getResponseErrorText();
            throw new Exception(string4);
        }
        String string5 = authenticateResponse.getAuthenticateResult().getResultCode().getValue();
        if (!AuthenticationResultCodes_t.AuthenticationResultCode_OK.getValue().equalsIgnoreCase(string5)) {
            String string6 = "Authentication failed with Result Code: " + string5;
            if ("AuthenticationResultCode_Unknown".equalsIgnoreCase(string5)) {
                string6 = "Check Password.  Result Code: " + string5;
                throw new IllegalArgumentException(string6);
            }
            if ("AuthenticationResultCode_BadVersion".equalsIgnoreCase(string5)) {
                string6 = "Endpoint URL might not match System Type.  Result Code: " + string5;
                throw new IllegalArgumentException(string6);
            }
            throw new Exception(string6);
        }
        return authenticateResponse.getAuthenticateResult().getToken();
    }

    private void configureProxyServer() {
        String string = "SKYBOT_AM_PROXY_HOST";
        String string2 = "SKYBOT_AM_PROXY_PORT";
        String string3 = "SKYBOT_AM_PROXY_USER";
        String string4 = "SKYBOT_AM_PROXY_PWD";
        try {
            String string5;
            String string6;
            String string7;
            String string8 = System.getenv(string);
            if (string8 != null && string8.trim().length() > 0) {
                string7 = "Configuring Proxy Host: " + string8;
                this.logMessage(Level.INFO, "\t" + string7);
                System.setProperty("http.proxyHost", string8);
            }
            if ((string7 = System.getenv(string2)) != null && string7.trim().length() > 0) {
                string6 = "Configuring Proxy Port: " + string7;
                this.logMessage(Level.INFO, "\t" + string6);
                System.setProperty("http.proxyPort", string7);
            }
            if ((string6 = System.getenv(string3)) != null && string6.trim().length() > 0) {
                string5 = "Configuring Proxy User: " + string6;
                this.logMessage(Level.INFO, "\t" + string5);
                System.setProperty("http.proxyUser", string6);
            }
            if ((string5 = System.getenv(string4)) != null && string5.trim().length() > 0) {
                String string9 = "Configuring Proxy PWD: " + string5;
                this.logMessage(Level.INFO, "\t" + string9);
                System.setProperty("http.proxyPassword", string5);
            }
        }
        catch (Exception exception) {
            this.logMessage(Level.ERROR, "Error setting Proxy Server: " + exception.getMessage());
        }
    }

    String getTargetIDFromTargetName(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, AutoMateBPARequestComposite autoMateBPARequestComposite) throws Exception {
        String string4 = null;
        AutoMateBPACommand autoMateBPACommand = autoMateBPARequestComposite.getAutoMateBPACommand();
        AutoMateObject[] autoMateObjectArray = null;
        AgentType agentType = null;
        switch (autoMateBPACommand.getTargetType()) {
            case AGENT: {
                switch (autoMateBPACommand.getCommandType()) {
                    case TASK: {
                        agentType = AgentType.Task;
                        break;
                    }
                    case PROCESS: {
                        agentType = AgentType.Process;
                        break;
                    }
                    default: {
                        throw new Exception("Invalid Command Type of " + autoMateBPACommand.getCommandType() + " passed.");
                    }
                }
                autoMateObjectArray = this.getAutoMateEnterpriseAgents(iBPAManagementServerHTTPServiceContract, string, string2, string3, agentType);
                break;
            }
            case AGENT_GROUP: {
                autoMateObjectArray = this.getAutomateEnterpriseAgentGroupsByName(iBPAManagementServerHTTPServiceContract, string, string2, string3);
            }
        }
        if (autoMateObjectArray != null) {
            for (int i = 0; i < autoMateObjectArray.length; ++i) {
                AutoMateObject autoMateObject = autoMateObjectArray[i];
                String string5 = autoMateObject.getName();
                try {
                    string5 = autoMateObject.getPathWithName();
                }
                catch (Exception exception) {
                    this.logMessage(Level.WARN, exception.getMessage());
                    this.logMessage(Level.WARN, "Error getting path with name for Agent " + string5 + ".  Name alone will be used.");
                }
                if (!string5.equals(autoMateBPACommand.getTargetPath())) continue;
                string4 = autoMateObject.getId();
                break;
            }
        } else {
            this.logMessage(Level.INFO, "No Agents returned from search.");
        }
        return string4;
    }

    private HashMap<String, AutomationObjectInfoConstruct> getAllFoldersHM(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3) throws Exception {
        HashMap<String, AutomationObjectInfoConstruct> hashMap = new HashMap<String, AutomationObjectInfoConstruct>();
        GetAllFoldersRequestMessage getAllFoldersRequestMessage = new GetAllFoldersRequestMessage(string, string2, null);
        GetAllFoldersRequest getAllFoldersRequest = new GetAllFoldersRequest(getAllFoldersRequestMessage, string3);
        GetAllFoldersRequestResponse getAllFoldersRequestResponse = iBPAManagementServerHTTPServiceContract.getAllFoldersRequest(getAllFoldersRequest);
        GetAllFoldersResponseMessage getAllFoldersResponseMessage = getAllFoldersRequestResponse.getGetAllFoldersRequestResult();
        this.processResponseMessage(getAllFoldersResponseMessage);
        AutomationObjectInfoConstruct[] automationObjectInfoConstructArray = getAllFoldersResponseMessage.getFolders();
        for (int i = 0; i < automationObjectInfoConstructArray.length; ++i) {
            if (automationObjectInfoConstructArray[i] != null) {
                hashMap.put(automationObjectInfoConstructArray[i].getID(), automationObjectInfoConstructArray[i]);
                continue;
            }
            this.logMessage(Level.WARN, "All folders item is null at index: " + i);
        }
        return hashMap;
    }

    protected String getCurrentTimestampString() {
        return formatter.format(new Date(System.currentTimeMillis()));
    }

    protected String getFormattedTimestamp(Calendar calendar) {
        if (calendar == null) {
            return "null";
        }
        if (calendar.getTimeInMillis() < 0L) {
            return "N/A";
        }
        return calendar.getTimeInMillis() + " (" + formatter.format(calendar.getTime()) + ")";
    }

    private AutoMateObject[] getAutomateEnterpriseAgentGroupsByName(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3) throws Exception {
        return this.getAutomateEnterpriseAgentGroups(iBPAManagementServerHTTPServiceContract, string, string2, string3, "", AutoMateSearchSelection.BY_NAME);
    }

    public AutoMateObject[] getAutomateEnterpriseAgentGroups(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, String string4, AutoMateSearchSelection autoMateSearchSelection) throws Exception {
        SortedSet<AutoMateObject> sortedSet = null;
        HashMap<String, AutomationObjectInfoConstruct> hashMap = this.getAllFoldersHM(iBPAManagementServerHTTPServiceContract, string, string2, string3);
        Calendar calendar = Calendar.getInstance();
        GetAllAgentGroupsRequestMessage getAllAgentGroupsRequestMessage = new GetAllAgentGroupsRequestMessage(string, string2, calendar);
        GetAllAgentGroupsRequest getAllAgentGroupsRequest = new GetAllAgentGroupsRequest(getAllAgentGroupsRequestMessage, string3);
        GetAllAgentGroupsRequestResponse getAllAgentGroupsRequestResponse = iBPAManagementServerHTTPServiceContract.getAllAgentGroupsRequest(getAllAgentGroupsRequest);
        GetAllAgentGroupsResponseMessage getAllAgentGroupsResponseMessage = getAllAgentGroupsRequestResponse.getGetAllAgentGroupsRequestResult();
        this.processResponseMessage(getAllAgentGroupsResponseMessage);
        sortedSet = this.getAutomateEnterpriseObjectSortedSet(autoMateSearchSelection);
        AgentGroupConstruct[] agentGroupConstructArray = getAllAgentGroupsResponseMessage.getAgentGroups();
        for (int i = 0; i < agentGroupConstructArray.length; ++i) {
            AgentGroupConstruct agentGroupConstruct = agentGroupConstructArray[i];
            String string5 = this.getFolderString(agentGroupConstruct, hashMap);
            String string6 = string5 != null ? string5 + "\\" + agentGroupConstruct.getName() : agentGroupConstruct.getName();
            if (string4.length() != 0 && !string6.toLowerCase().contains(string4.toLowerCase()) && !agentGroupConstruct.getID().toLowerCase().contains(string4)) continue;
            sortedSet.add(new AutoMateObject(agentGroupConstruct.getID(), agentGroupConstruct.getName(), string5));
        }
        return sortedSet.toArray(new AutoMateObject[sortedSet.size()]);
    }

    private String getFolderString(AutomationConstruct automationConstruct, HashMap<String, AutomationObjectInfoConstruct> hashMap) {
        String string = null;
        AutomationObjectInfoConstruct automationObjectInfoConstruct = hashMap.get(automationConstruct.getParentID());
        AutomateEnterpriseGUID automateEnterpriseGUID = null;
        while (automationObjectInfoConstruct != null) {
            string = string != null ? automationObjectInfoConstruct.getName() + "\\" + string : automationObjectInfoConstruct.getName();
            automateEnterpriseGUID = AutomateEnterpriseGUID.persistanceCodeToEnum(automationObjectInfoConstruct.getParentID());
            if (automateEnterpriseGUID != null) {
                string = "\\" + automateEnterpriseGUID.rootFolderName + "\\" + string;
                break;
            }
            automationObjectInfoConstruct = hashMap.get(automationObjectInfoConstruct.getParentID());
        }
        if (string == null) {
            if (automateEnterpriseGUID == null) {
                automateEnterpriseGUID = AutomateEnterpriseGUID.persistanceCodeToEnum(automationConstruct.getParentID());
            }
            string = "\\" + automateEnterpriseGUID.rootFolderName;
        }
        return string;
    }

    private AutoMateObject[] getAutoMateEnterpriseAgents(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, AgentType agentType) throws Exception {
        return this.getAutomateEnterpriseAgents(iBPAManagementServerHTTPServiceContract, string, string2, string3, "", agentType);
    }

    private AutoMateObject[] getAutomateEnterpriseAgents(IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract, String string, String string2, String string3, String string4, AgentType agentType) throws Exception {
        HashMap<String, AutomationObjectInfoConstruct> hashMap = this.getAllFoldersHM(iBPAManagementServerHTTPServiceContract, string, string2, string3);
        Calendar calendar = Calendar.getInstance();
        SortedSet<AutoMateObject> sortedSet = null;
        sortedSet = this.getAutomateEnterpriseObjectSortedSet(AutoMateSearchSelection.BY_NAME);
        GetAllAgentsRequestMessage getAllAgentsRequestMessage = new GetAllAgentsRequestMessage(string, string2, calendar);
        GetAllAgentsRequest getAllAgentsRequest = new GetAllAgentsRequest(getAllAgentsRequestMessage, string3);
        GetAllAgentsRequestResponse getAllAgentsRequestResponse = iBPAManagementServerHTTPServiceContract.getAllAgentsRequest(getAllAgentsRequest);
        GetAllAgentsResponseMessage getAllAgentsResponseMessage = getAllAgentsRequestResponse.getGetAllAgentsRequestResult();
        AgentConstruct[] agentConstructArray = getAllAgentsResponseMessage.getAgents();
        for (int i = 0; i < agentConstructArray.length; ++i) {
            AgentConstruct agentConstruct = agentConstructArray[i];
            if (!agentConstruct.getAgentType().equals(agentType)) continue;
            String string5 = this.getFolderString(agentConstruct, hashMap);
            String string6 = string5 != null ? string5 + "\\" + agentConstruct.getName() : agentConstruct.getName();
            if (string4.length() != 0 && !string6.toLowerCase().contains(string4.toLowerCase()) && !agentConstruct.getID().toLowerCase().contains(string4)) continue;
            sortedSet.add((AutoMateObject)new AgentInformation(agentConstruct.getID(), agentConstruct.getName(), string5, agentConstruct.getAgentType().toString()));
        }
        return (AutoMateObject[])sortedSet.toArray(new AgentInformation[sortedSet.size()]);
    }

    private SortedSet<AutoMateObject> getAutomateEnterpriseObjectSortedSet(AutoMateSearchSelection autoMateSearchSelection) {
        TreeSet treeSet = null;
        switch (autoMateSearchSelection) {
            case BY_ID: {
                treeSet = new TreeSet(AutoMateObject.ID_COMPARATOR);
                break;
            }
            case BY_NAME: {
                treeSet = new TreeSet(AutoMateObject.NAME_COMPARATOR);
                break;
            }
            case PATH_OR_ID: {
                treeSet = new TreeSet(AutoMateObject.PATH_WITH_NAME_COMPARATOR);
            }
        }
        return treeSet;
    }

    private void closeSession(String string, String string2, String string3, IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract) {
        CloseSessionRequestMessage closeSessionRequestMessage = new CloseSessionRequestMessage(string, string2, null, string3);
        CloseSessionRequest closeSessionRequest = new CloseSessionRequest(closeSessionRequestMessage);
        try {
            iBPAManagementServerHTTPServiceContract.closeSessionRequest(closeSessionRequest);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    protected void processResponseMessage(ResponseMessageBase responseMessageBase) throws Exception {
        Boolean bl = responseMessageBase.getResponseResult();
        if (!bl.booleanValue()) {
            String string = "Connection failed!";
            String string2 = responseMessageBase.getResponseErrorText();
            if (string2 != null && string2.length() > 0) {
                string = string + " " + string2;
            }
            throw new Exception(string);
        }
    }

    private void logMessage(Level level, String string) {
        if (logger != null) {
            logger.log(level, (Object)string);
        } else {
            System.out.println(string);
        }
    }

    private OpenSessionRequest getOpenSessionRequest(AutoMateSystemDefinition autoMateSystemDefinition) throws ResourceUnavailableException {
        String string = System.getenv().get("COMPUTERNAME");
        String string2 = string + "." + System.currentTimeMillis();
        OpenSessionRequestMessage openSessionRequestMessage = new OpenSessionRequestMessage();
        openSessionRequestMessage.setConnectionID(string2);
        openSessionRequestMessage.setClientID(string2);
        openSessionRequestMessage.setClientName(string2);
        openSessionRequestMessage.setClientType(ClientType.Skybot);
        openSessionRequestMessage.setUsername(autoMateSystemDefinition.getUsername());
        openSessionRequestMessage.setPassword(autoMateSystemDefinition.getDecryptedPassword());
        OpenSessionRequest openSessionRequest = new OpenSessionRequest(openSessionRequestMessage);
        return openSessionRequest;
    }

    protected void checkForUserRelatedErrors(String string, String string2) throws Exception {
        this.checkForUserOrPasswordIncorrectInError(string, string2);
        this.checkForUserLoggedInError(string, string2);
        this.checkForUserLockedOutInError(string, string2);
        this.checkForUserAccountNotActiveInError(string, string2);
    }

    private void checkForUserOrPasswordIncorrectInError(String string, String string2) throws Exception {
        if (string.contains(USER_OR_PASSWORD_INCORRECT)) {
            String[] stringArray = new String[]{string2};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.AUTOMATE_USER_OR_PASSWORD_INCORRECT.newLogEntry(stringArray);
            this.logMessage(Level.ERROR, scheduleLogEntry.getMessageText());
            throw new Exception(scheduleLogEntry.getMessageText());
        }
    }

    private void checkForUserLoggedInError(String string, String string2) throws Exception {
        if (string.contains(USER_ALREADY_LOGGED_IN)) {
            String[] stringArray = new String[]{string2};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.AUTOMATE_USER_ALREADY_LOGGED_IN.newLogEntry(stringArray);
            this.logMessage(Level.ERROR, scheduleLogEntry.getMessageText());
            throw new Exception(scheduleLogEntry.getMessageText());
        }
    }

    private void checkForUserLockedOutInError(String string, String string2) throws Exception {
        String[] stringArray = new String[]{string2};
        if (string.contains(USER_LOCKED_OUT)) {
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.AUTOMATE_USER_LOCKED_OUT.newLogEntry(stringArray);
            this.logMessage(Level.ERROR, scheduleLogEntry.getMessageText());
            throw new Exception(scheduleLogEntry.getMessageText());
        }
    }

    private void checkForUserAccountNotActiveInError(String string, String string2) throws Exception {
        String[] stringArray = new String[]{string2};
        if (string.contains(USER_ACCOUNT_NOT_ACTIVE)) {
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.AUTOMATE_USER_ACCOUNT_NOT_ACTIVE.newLogEntry(stringArray);
            this.logMessage(Level.ERROR, scheduleLogEntry.getMessageText());
            throw new Exception(scheduleLogEntry.getMessageText());
        }
    }

    protected String translateAxisFault(Throwable throwable) {
        AxisFault axisFault;
        String string;
        if (throwable == null) {
            return "The Throwable is null.";
        }
        if (throwable.getMessage() == null) {
            return "The Throwable message is null.";
        }
        if (throwable instanceof AxisFault && (string = (axisFault = (AxisFault)throwable).getFaultString()).contains("0x80040200")) {
            return "Automate not licensed. (" + string + ")";
        }
        return throwable.getMessage();
    }

    private void checkForLicenseErrors(Exception exception) throws Exception {
        AxisFault axisFault;
        String string;
        if (exception instanceof AxisFault && (string = (axisFault = (AxisFault)((Object)exception)).getFaultString()) != null && string.contains("0x80040200")) {
            String string2 = "Automate not licensed. (" + string + ")";
            this.logMessage(Level.ERROR, string2);
            throw new Exception(string2);
        }
        if (exception.getMessage().contains("License key") || exception.getMessage().contains("No Enterprise Server license")) {
            this.logMessage(Level.ERROR, exception.getMessage());
            throw new Exception(exception.getMessage());
        }
    }

    public void validateSystemDefinition(AutoMateSystemType autoMateSystemType, AutoMateSystemDefinition autoMateSystemDefinition, String string) throws Exception {
        try {
            switch (autoMateSystemType) {
                case AUTOMATE_V11: {
                    IAMTSHTTPServiceContract iAMTSHTTPServiceContract = null;
                    long l = System.currentTimeMillis();
                    logger.debug((Object)("Validating Automate v11 at URL: " + autoMateSystemDefinition.getEndPointURL()));
                    iAMTSHTTPServiceContract = this.getIAMTSHTTPServiceContract(autoMateSystemDefinition.getEndPointURL());
                    this.authenticateConnection(l, autoMateSystemDefinition, iAMTSHTTPServiceContract);
                    logger.debug((Object)"Connection Successful!");
                    break;
                }
                case AUTOMATE_ENTERPRISE_V11: {
                    logger.debug((Object)("Validating Automate Enterprise v11 at URL: " + autoMateSystemDefinition.getEndPointURL()));
                    IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract = this.getServiceContract(autoMateSystemDefinition.getEndPointURL());
                    OpenSessionRequest openSessionRequest = this.getOpenSessionRequest(autoMateSystemDefinition);
                    OpenSessionRequestResponse openSessionRequestResponse = iBPAManagementServerHTTPServiceContract.openSessionRequest(openSessionRequest);
                    OpenSessionResponseMessage openSessionResponseMessage = openSessionRequestResponse.getOpenSessionRequestResult();
                    this.processResponseMessage(openSessionResponseMessage);
                    logger.debug((Object)"Connection Successful!");
                    break;
                }
                default: {
                    throw new Exception("Invalid System Type of " + autoMateSystemType + " passed.");
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error validating " + autoMateSystemDefinition.getEndPointURL()));
            this.checkForLicenseErrors(exception);
            this.checkForUserRelatedErrors(exception.getMessage(), string);
            throw exception;
        }
    }

    public String getAutomateEnterpriseRepositoryObjectsJSON(AutoMateSystemDefinition autoMateSystemDefinition, String string, AutoMateSearchSelection autoMateSearchSelection, RepositoryContents repositoryContents) throws Exception {
        String string2 = "";
        String string3 = "N/A";
        try {
            string3 = autoMateSystemDefinition.getUsername();
            IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract = this.getServiceContract(autoMateSystemDefinition.getEndPointURL());
            logger.debug((Object)("About to open Session to EndPoint: " + autoMateSystemDefinition.getEndPointURL()));
            OpenSessionRequest openSessionRequest = this.getOpenSessionRequest(autoMateSystemDefinition);
            String string4 = openSessionRequest.getRequest().getConnectionID();
            OpenSessionRequestResponse openSessionRequestResponse = iBPAManagementServerHTTPServiceContract.openSessionRequest(openSessionRequest);
            OpenSessionResponseMessage openSessionResponseMessage = openSessionRequestResponse.getOpenSessionRequestResult();
            this.processResponseMessage(openSessionResponseMessage);
            logger.debug((Object)"Connection Successful!");
            String string5 = openSessionResponseMessage.getMessageID();
            String string6 = openSessionResponseMessage.getConnectionID();
            logger.debug((Object)("Connection sessionID: " + string6));
            logger.debug((Object)("Connection messageID: " + string5));
            GetAllRepositoryContentsRequestMessage getAllRepositoryContentsRequestMessage = new GetAllRepositoryContentsRequestMessage(string4, string5, null);
            GetAllRepositoryContentsRequest getAllRepositoryContentsRequest = new GetAllRepositoryContentsRequest(getAllRepositoryContentsRequestMessage, string6);
            GetAllRepositoryContentsRequestResponse getAllRepositoryContentsRequestResponse = iBPAManagementServerHTTPServiceContract.getAllRepositoryContentsRequest(getAllRepositoryContentsRequest);
            GetAllRepositoryContentsResponseMessage getAllRepositoryContentsResponseMessage = getAllRepositoryContentsRequestResponse.getGetAllRepositoryContentsRequestResult();
            this.processResponseMessage(getAllRepositoryContentsResponseMessage);
            HashMap<String, AutomationObjectInfoConstruct> hashMap = this.getAllFoldersHM(iBPAManagementServerHTTPServiceContract, string4, string5, string6);
            AutoMateObject[] autoMateObjectArray = this.getAutomateEnterpriseRepositoryObjects(getAllRepositoryContentsResponseMessage, repositoryContents, autoMateSearchSelection, string, hashMap);
            boolean bl = false;
            for (int i = 0; i < autoMateObjectArray.length; ++i) {
                AutoMateObject autoMateObject = autoMateObjectArray[i];
                if (bl) {
                    string2 = string2 + ",";
                }
                string2 = string2 + autoMateObject.getJSONString();
                bl = true;
            }
            this.closeSession(string4, string5, string6, iBPAManagementServerHTTPServiceContract);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Automate Enterprise " + repositoryContents + " from Automate System Definition: " + autoMateSystemDefinition.getName()));
            this.checkForLicenseErrors(exception);
            this.checkForUserRelatedErrors(exception.getMessage(), string3);
            throw exception;
        }
        return string2;
    }

    private AutoMateObject[] getAutomateEnterpriseRepositoryObjects(GetAllRepositoryContentsResponseMessage getAllRepositoryContentsResponseMessage, RepositoryContents repositoryContents, AutoMateSearchSelection autoMateSearchSelection, String string, HashMap<String, AutomationObjectInfoConstruct> hashMap) {
        AutomationObjectInfoConstruct[] automationObjectInfoConstructArray = getAllRepositoryContentsResponseMessage.getContents();
        AutoMateObject autoMateObject = null;
        SortedSet<AutoMateObject> sortedSet = null;
        sortedSet = this.getAutomateEnterpriseObjectSortedSet(autoMateSearchSelection);
        block13: for (int i = 0; i < automationObjectInfoConstructArray.length; ++i) {
            AutomationObjectInfoConstruct automationObjectInfoConstruct = automationObjectInfoConstructArray[i];
            boolean bl = false;
            switch (repositoryContents) {
                case ALL: {
                    bl = true;
                    break;
                }
                case PROCESSES: {
                    bl = automationObjectInfoConstruct.getType().equals(ConstructType.Process);
                    break;
                }
                case WORKFLOWS: {
                    if (AutomateEnterpriseGUID.META_WORKFLOW_GUID.persistanceCode().equalsIgnoreCase(automationObjectInfoConstruct.getParentID())) break;
                    bl = automationObjectInfoConstruct.getType().equals(ConstructType.WorkFlow);
                    break;
                }
                case TASKS: {
                    bl = automationObjectInfoConstruct.getType().equals(ConstructType.Task);
                }
            }
            if (!bl) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("AutomationObjectInfoConstruct[" + i + "]:" + " Type: " + automationObjectInfoConstruct.getType() + " Name: " + automationObjectInfoConstruct.getName() + " ParentID: " + automationObjectInfoConstruct.getParentID() + " ID: " + automationObjectInfoConstruct.getID()));
            }
            String string2 = this.getFolderString(automationObjectInfoConstruct, hashMap);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loaded folder string: " + string2));
            }
            autoMateObject = new AutoMateObject(automationObjectInfoConstruct.getID(), automationObjectInfoConstruct.getName(), string2);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Loaded AutoMateObject: " + autoMateObject));
            }
            if (string.length() == 0) {
                sortedSet.add(autoMateObject);
                continue;
            }
            switch (autoMateSearchSelection) {
                case BY_ID: {
                    if (!autoMateObject.getId().startsWith(string)) continue block13;
                    sortedSet.add(autoMateObject);
                    continue block13;
                }
                case BY_NAME: {
                    if (!autoMateObject.getName().toLowerCase().startsWith(string.toLowerCase())) continue block13;
                    sortedSet.add(autoMateObject);
                    continue block13;
                }
                case PATH_OR_ID: {
                    String string3 = autoMateObject.getName();
                    try {
                        string3 = autoMateObject.getPathWithName();
                    }
                    catch (Exception exception) {
                        logger.warn((Object)("Error getting path with name for Automate object " + string3 + ".  Name alone will be used."), (Throwable)exception);
                    }
                    if (!string3.toLowerCase().contains(string.toLowerCase()) && !autoMateObject.getId().toLowerCase().contains(string.toLowerCase())) continue block13;
                    sortedSet.add(autoMateObject);
                }
            }
        }
        return sortedSet.toArray(new AutoMateObject[sortedSet.size()]);
    }

    public String getAutomateEnterpriseAgentGroupsJSON(String string, AutoMateSystemDefinition autoMateSystemDefinition, String string2, AutoMateSearchSelection autoMateSearchSelection) throws Exception {
        String string3 = "";
        try {
            IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract = this.getServiceContract(autoMateSystemDefinition.getEndPointURL());
            logger.debug((Object)("About to open Session to EndPoint: " + autoMateSystemDefinition.getEndPointURL()));
            OpenSessionRequest openSessionRequest = this.getOpenSessionRequest(autoMateSystemDefinition);
            String string4 = openSessionRequest.getRequest().getConnectionID();
            OpenSessionRequestResponse openSessionRequestResponse = iBPAManagementServerHTTPServiceContract.openSessionRequest(openSessionRequest);
            OpenSessionResponseMessage openSessionResponseMessage = openSessionRequestResponse.getOpenSessionRequestResult();
            this.processResponseMessage(openSessionResponseMessage);
            logger.debug((Object)"Connection Successful!");
            String string5 = openSessionResponseMessage.getMessageID();
            String string6 = openSessionResponseMessage.getConnectionID();
            logger.debug((Object)("Connection sessionID: " + string6));
            logger.debug((Object)("Connection messageID: " + string5));
            AutoMateObject[] autoMateObjectArray = this.getAutomateEnterpriseAgentGroups(iBPAManagementServerHTTPServiceContract, string4, string5, string6, string2, autoMateSearchSelection);
            boolean bl = false;
            for (int i = 0; i < autoMateObjectArray.length; ++i) {
                AutoMateObject autoMateObject = autoMateObjectArray[i];
                if (bl) {
                    string3 = string3 + ",";
                }
                string3 = string3 + autoMateObject.getJSONString();
                bl = true;
            }
            this.closeSession(string4, string5, string6, iBPAManagementServerHTTPServiceContract);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Automate Enterprise Agent Groups from " + autoMateSystemDefinition.getName()));
            this.checkForLicenseErrors(exception);
            this.checkForUserRelatedErrors(exception.getMessage(), string);
            throw exception;
        }
        return string3;
    }

    private String getAutomateEnterpriseAgentsJSON(AutoMateSystemDefinition autoMateSystemDefinition, String string, AgentType agentType, AutoMateSearchSelection autoMateSearchSelection) throws Exception {
        String string2 = "[";
        logger.debug((Object)("*** About to retrieve Automate Enterprise " + agentType + " Agents for Automate Enterprise System Definition " + autoMateSystemDefinition.getName() + " using search string '" + string + "' " + autoMateSearchSelection));
        String string3 = autoMateSystemDefinition.getUsername();
        try {
            IBPAManagementServerHTTPServiceContract iBPAManagementServerHTTPServiceContract = this.getServiceContract(autoMateSystemDefinition.getEndPointURL());
            logger.debug((Object)("About to open Session to EndPoint: " + autoMateSystemDefinition.getEndPointURL()));
            OpenSessionRequest openSessionRequest = this.getOpenSessionRequest(autoMateSystemDefinition);
            String string4 = openSessionRequest.getRequest().getConnectionID();
            OpenSessionRequestResponse openSessionRequestResponse = iBPAManagementServerHTTPServiceContract.openSessionRequest(openSessionRequest);
            OpenSessionResponseMessage openSessionResponseMessage = openSessionRequestResponse.getOpenSessionRequestResult();
            this.processResponseMessage(openSessionResponseMessage);
            logger.debug((Object)"Connection Successful!");
            String string5 = openSessionResponseMessage.getMessageID();
            String string6 = openSessionResponseMessage.getConnectionID();
            logger.debug((Object)("Connection sessionID: " + string6));
            logger.debug((Object)("Connection messageID: " + string5));
            AutoMateObject[] autoMateObjectArray = this.getAutomateEnterpriseAgents(iBPAManagementServerHTTPServiceContract, string4, string5, string6, string, agentType);
            boolean bl = false;
            for (int i = 0; i < autoMateObjectArray.length; ++i) {
                AutoMateObject autoMateObject = autoMateObjectArray[i];
                if (bl) {
                    string2 = string2 + ",";
                }
                string2 = string2 + autoMateObject.getJSONString();
                bl = true;
            }
            this.closeSession(string4, string5, string6, iBPAManagementServerHTTPServiceContract);
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Automate Enterprise Agents from " + autoMateSystemDefinition.getName()));
            this.checkForLicenseErrors(exception);
            this.checkForUserRelatedErrors(exception.getMessage(), string3);
            throw exception;
        }
        finally {
            string2 = string2 + "]";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Agent List JSON: " + string2));
        }
        return string2;
    }

    public String getAutoMateTasksJSON(AutoMateSystemDefinition autoMateSystemDefinition, String string, AutoMateSearchSelection autoMateSearchSelection) throws Exception {
        String string2 = "";
        IAMTSHTTPServiceContract iAMTSHTTPServiceContract = null;
        String string3 = null;
        long l = System.currentTimeMillis();
        try {
            logger.debug((Object)("Endpoint: " + autoMateSystemDefinition.getEndPointURL()));
            iAMTSHTTPServiceContract = this.getIAMTSHTTPServiceContract(autoMateSystemDefinition.getEndPointURL());
            logger.debug((Object)"======================================================================");
            logger.debug((Object)"Authenticating Connection...");
            string3 = this.authenticateConnection(l, autoMateSystemDefinition, iAMTSHTTPServiceContract);
            AutoMateTaskInformation[] autoMateTaskInformationArray = AutomateV11Helper.getAutoMateTasks(l, string3, iAMTSHTTPServiceContract, string, autoMateSearchSelection);
            boolean bl = false;
            for (int i = 0; i < autoMateTaskInformationArray.length; ++i) {
                AutoMateTaskInformation autoMateTaskInformation = autoMateTaskInformationArray[i];
                if (bl) {
                    string2 = string2 + ",";
                }
                string2 = string2 + autoMateTaskInformation.getJSONString();
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error retrieving Automate Tasks from Automate System Definition: " + autoMateSystemDefinition.getName()));
            this.checkForLicenseErrors(exception);
            throw exception;
        }
        return string2;
    }

    private static AutoMateTaskInformation[] getAutoMateTasks(long l, String string, IAMTSHTTPServiceContract iAMTSHTTPServiceContract, String string2, AutoMateSearchSelection autoMateSearchSelection) throws RemoteException {
        String string3 = "gettaskandfoldernames." + l;
        Calendar calendar = null;
        boolean bl = true;
        boolean bl2 = false;
        String string4 = "";
        GetTaskAndFolderNamesRequestMessage getTaskAndFolderNamesRequestMessage = new GetTaskAndFolderNamesRequestMessage(string3, calendar, string, bl2, bl, string4);
        GetTaskAndFolderNames getTaskAndFolderNames = new GetTaskAndFolderNames(getTaskAndFolderNamesRequestMessage);
        GetTaskAndFolderNamesResponse getTaskAndFolderNamesResponse = iAMTSHTTPServiceContract.getTaskAndFolderNames(getTaskAndFolderNames);
        if (!getTaskAndFolderNamesResponse.getGetTaskAndFolderNamesResult().getResponseResult().booleanValue()) {
            String string5 = "GetTaskAndFolderNames did not get a positive response result: " + getTaskAndFolderNamesResponse.getGetTaskAndFolderNamesResult().getResponseErrorText();
            throw new RuntimeException(string5);
        }
        Object[] objectArray = getTaskAndFolderNamesResponse.getGetTaskAndFolderNamesResult().getNames();
        SortedSet<AutoMateTaskInformation> sortedSet = null;
        sortedSet = AutomateV11Helper.getAutoMateTaskInformationSortedSet(autoMateSearchSelection);
        block5: for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof TaskServiceObjectInformationBriefConstruct)) continue;
            TaskServiceObjectInformationBriefConstruct taskServiceObjectInformationBriefConstruct = (TaskServiceObjectInformationBriefConstruct)objectArray[i];
            switch (autoMateSearchSelection) {
                case BY_ID: {
                    AutoMateTaskInformation autoMateTaskInformation;
                    if (string2.length() == 0) {
                        autoMateTaskInformation = AutomateV11Helper.createAutoMateTaskInformation(taskServiceObjectInformationBriefConstruct);
                        sortedSet.add(autoMateTaskInformation);
                        continue block5;
                    }
                    String string6 = taskServiceObjectInformationBriefConstruct.getID();
                    if (!string6.startsWith(string2)) continue block5;
                    logger.debug((Object)("Found Task " + taskServiceObjectInformationBriefConstruct.getName() + "(" + string6 + ") with ID starting with " + string2));
                    autoMateTaskInformation = AutomateV11Helper.createAutoMateTaskInformation(taskServiceObjectInformationBriefConstruct);
                    sortedSet.add(autoMateTaskInformation);
                    continue block5;
                }
                case BY_NAME: {
                    AutoMateTaskInformation autoMateTaskInformation = AutomateV11Helper.createAutoMateTaskInformation(taskServiceObjectInformationBriefConstruct);
                    if (string2.length() == 0) {
                        sortedSet.add(autoMateTaskInformation);
                        continue block5;
                    }
                    if (!autoMateTaskInformation.getName().toLowerCase().startsWith(string2.toLowerCase())) continue block5;
                    logger.debug((Object)("Found Task(" + autoMateTaskInformation + ") with name starting with " + string2));
                    sortedSet.add(autoMateTaskInformation);
                    continue block5;
                }
                case PATH_OR_ID: {
                    AutoMateTaskInformation autoMateTaskInformation = AutomateV11Helper.createAutoMateTaskInformation(taskServiceObjectInformationBriefConstruct);
                    if (string2.length() == 0) {
                        sortedSet.add(autoMateTaskInformation);
                        continue block5;
                    }
                    if (!autoMateTaskInformation.getPathOrName().toLowerCase().contains(string2.toLowerCase()) && !autoMateTaskInformation.getId().toLowerCase().contains(string2.toLowerCase())) continue block5;
                    logger.debug((Object)("Found Task(" + autoMateTaskInformation + ") with full path or id containing " + string2));
                    sortedSet.add(autoMateTaskInformation);
                }
            }
        }
        return sortedSet.toArray(new AutoMateTaskInformation[sortedSet.size()]);
    }

    private static AutoMateTaskInformation createAutoMateTaskInformation(TaskServiceObjectInformationBriefConstruct taskServiceObjectInformationBriefConstruct) {
        AutoMateTaskInformation autoMateTaskInformation;
        String string = taskServiceObjectInformationBriefConstruct.getName();
        String[] stringArray = string.split("/");
        if (stringArray.length > 1) {
            String string2 = stringArray[stringArray.length - 1];
            autoMateTaskInformation = new AutoMateTaskInformation(taskServiceObjectInformationBriefConstruct.getID(), string2, string);
        } else {
            autoMateTaskInformation = new AutoMateTaskInformation(taskServiceObjectInformationBriefConstruct.getID(), string);
        }
        return autoMateTaskInformation;
    }

    private static SortedSet<AutoMateTaskInformation> getAutoMateTaskInformationSortedSet(AutoMateSearchSelection autoMateSearchSelection) {
        TreeSet treeSet = null;
        switch (autoMateSearchSelection) {
            case BY_ID: {
                treeSet = new TreeSet(AutoMateTaskInformation.ID_COMPARATOR_TASK);
                break;
            }
            case BY_NAME: 
            case PATH_OR_ID: {
                treeSet = new TreeSet(AutoMateTaskInformation.NAME_COMPARATOR_TASK);
            }
        }
        return treeSet;
    }

    public String getAutomateEnterpriseTaskAgentsJSON(AutoMateSystemDefinition autoMateSystemDefinition, String string) throws Exception {
        return this.getAutomateEnterpriseAgentsJSON(autoMateSystemDefinition, string, AgentType.Task, AutoMateSearchSelection.PATH_OR_ID);
    }

    public String getAutomateEnterpriseProcessAgentsJSON(AutoMateSystemDefinition autoMateSystemDefinition, String string) throws Exception {
        return this.getAutomateEnterpriseAgentsJSON(autoMateSystemDefinition, string, AgentType.Process, AutoMateSearchSelection.PATH_OR_ID);
    }

    public static enum AutomateEnterpriseGUID implements PersistableEnum<String>
    {
        REPOSITORY_ROOTNODE_GUID("{B1114A8C-6429-49ca-85AA-B09711BBCAB6}"),
        WORKFLOW_ROOTNODE_GUID("{589D12C2-1282-4466-B7E3-FE547509AF31}", "Workflows"),
        TASK_ROOTNODE_GUID("{E893A7FD-2758-4315-9181-93F8728332E5}", "Tasks"),
        TRIGGER_ROOTNODE_GUID("{5B00CA35-3EFB-41ea-95C0-D8B50B9BFA9F}"),
        USERS_ROOTNODE_GUID("{CF0A8EFD-08A7-47b1-9A2A-335B743D284A}"),
        USERSGROUPS_ROOTNODE_GUID("{E6B6C664-3B87-43a1-AD19-4B60191B8F3C}"),
        AGENTS_ROOTNODE_GUID("{A5B6AF52-5DAC-45a0-8B26-602E3E3BBC59}", "Task Agents"),
        AGENTGROUPS_ROOTNODE_GUID("{65B26C46-C286-45d8-88AE-2E16774F0DAB}", "Agent Groups"),
        PROCESS_ROOTNODE_GUID("{8E19BEB0-9625-4810-AF6E-5EAD7069E83C}", "Processes"),
        PROCESSAGENT_ROOTNODE_GUID("{84334DCF-3643-4988-83CA-79019097AA7D}", "Process Agents"),
        ADMIN_USER_GUID("{6AD627E8-373B-4104-81B7-9670A9D2F430}"),
        SERVER_GUID("{F910794D-0969-409d-9096-BB9A5BF3D5FE}"),
        META_WORKFLOW_GUID("{7A6D4D66-90FF-404D-807B-97C403F6198A}"),
        SERVICE_USER_GUID("{D861132E-8459-4201-A487-7349CA0AAA80}"),
        TRIGGEREDAGENT_GUID("{C1E0C335-CF54-42f0-AA90-BB2854E37E8A}"),
        CONDITIONAGENT_GUID("{2C046FDD-97A9-4a79-B34F-0C7A97E9CE69}"),
        PREVIOUSAGENT_GUID("{AC557F76-ABFF-4860-9ED4-259CC8758C76}"),
        DEFAULTAGENT_GUID("{CC3AD52F-C1DC-4d24-B6BE-32467159C86C}"),
        VARIABLEAGENT_GUID("{EEF25965-316C-4a47-98F7-8D113F76333D}");

        private String idString;
        private String rootFolderName;
        private static PersistanceCodeToEnumMap<String, AutomateEnterpriseGUID> map;

        private AutomateEnterpriseGUID(String string2) {
            this.idString = string2;
        }

        private AutomateEnterpriseGUID(String string2, String string3) {
            this.idString = string2;
            this.rootFolderName = string3;
        }

        public String persistanceCode() {
            return this.idString;
        }

        public String toString() {
            return "idString: " + this.idString + " rootFolderName: " + this.rootFolderName;
        }

        public static AutomateEnterpriseGUID persistanceCodeToEnum(String string) {
            AutomateEnterpriseGUID automateEnterpriseGUID = (AutomateEnterpriseGUID)map.get((Object)string);
            return automateEnterpriseGUID;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])AutomateEnterpriseGUID.values());
        }
    }
}

