/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.automate;

import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.enterprise.amts_10.automate.constructs.RunResult;
import com.helpsystems.enterprise.amts_10.automate.constructs.RunningTaskConstruct;
import com.helpsystems.enterprise.amts_10.automate.constructs.TaskServiceObjectInformationBriefConstruct;
import com.helpsystems.enterprise.amts_10.automate.constructs.TaskServiceTaskHistoryEventConstruct;
import com.helpsystems.enterprise.amts_10.automate.messages.GetTaskAndFolderNamesRequestMessage;
import com.helpsystems.enterprise.amts_10.automate.messages.GetTaskHistoryEventsRequestMessage;
import com.helpsystems.enterprise.amts_10.automate.messages.GetTaskProcessingStatisticsRequestMessage;
import com.helpsystems.enterprise.amts_10.automate.messages.RunTaskRequestMessage;
import com.helpsystems.enterprise.amts_10.automate.messages.RunTaskResponseMessage;
import com.helpsystems.enterprise.amts_10.automate.messages.TaskRunRequestResult_t;
import com.helpsystems.enterprise.amts_10.org.tempuri.GetTaskAndFolderNames;
import com.helpsystems.enterprise.amts_10.org.tempuri.GetTaskAndFolderNamesResponse;
import com.helpsystems.enterprise.amts_10.org.tempuri.GetTaskHistoryEvents;
import com.helpsystems.enterprise.amts_10.org.tempuri.GetTaskHistoryEventsResponse;
import com.helpsystems.enterprise.amts_10.org.tempuri.GetTaskProcessingStatistics;
import com.helpsystems.enterprise.amts_10.org.tempuri.GetTaskProcessingStatisticsResponse;
import com.helpsystems.enterprise.amts_10.org.tempuri.IAMTSHTTPServiceContract;
import com.helpsystems.enterprise.amts_10.org.tempuri.RunTask;
import com.helpsystems.enterprise.amts_10.org.tempuri.RunTaskResponse;
import com.helpsystems.enterprise.automate.AutoMateHelper;
import com.helpsystems.enterprise.automate.AutomateV11TaskRunner;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemDefinition;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskCommand;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateTaskRequestComposite;
import com.helpsystems.enterprise.core.busobj.automate.RunTaskResponseInfo;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.axis.AxisFault;

public class AutoMateTaskRunner {
    private static LogLevel currentLogLevel = LogLevel.INFO;
    private static final String TAB = "\t";
    private static final long DEFAULT_POLLING_INTERVAL_MILLIS = 2000L;
    private static DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static AutoMateHelper autoMateHelper;

    private AutoMateTaskRunner() {
    }

    public static void main(String[] stringArray) {
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Starting command...");
        AutoMateTaskRequestComposite autoMateTaskRequestComposite = AutoMateTaskRunner.getAutoMateTaskRequestComposite(stringArray);
        try {
            AutoMateTaskRunner autoMateTaskRunner = new AutoMateTaskRunner();
            autoMateTaskRunner.runTask(autoMateTaskRequestComposite);
            System.exit(0);
        }
        catch (Exception exception) {
            String string = AutoMateTaskRunner.getAutoMateHelper().translateAxisFault(exception);
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "AutoMateTaskRunner ended in error: " + string);
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
            if (currentLogLevel == LogLevel.DEBUG) {
                exception.printStackTrace();
            }
            System.exit(1);
        }
    }

    private static AutoMateTaskRequestComposite getAutoMateTaskRequestComposite(String[] stringArray) {
        AutoMateTaskRequestComposite autoMateTaskRequestComposite = null;
        if (stringArray.length < 1) {
            AutoMateTaskRunner.exit(1, "Command failed: File name containing an Automate Task request definition is required.");
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            int n3 = stringArray2.length;
            if (n3 > 0) {
                string = stringArray2[0].trim().toLowerCase();
            }
            string2 = null;
            if (n3 == 2) {
                string2 = stringArray2[1];
            } else if (n3 > 2) {
                String string4;
                string2 = string4 = stringArray[i].substring(stringArray2[0].length() + 1);
            }
            try {
                if (string.equals("-xml")) {
                    string3 = string2;
                    continue;
                }
                if (string.equals("-is_unix")) {
                    bl = Boolean.parseBoolean(string2);
                    continue;
                }
                AutoMateTaskRunner.exit(1, "Command failed: Invalid option parameter: " + string + " full parm: " + stringArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AutoMateTaskRunner.exit(1, "Command failed:" + illegalArgumentException.getMessage());
            }
        }
        File file = new File(string3);
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Loading Automate Task Request Definition from: " + file.getAbsolutePath());
        try {
            autoMateTaskRequestComposite = AutoMateTaskRequestComposite.restoreFromDisk((String)file.getAbsolutePath());
            return autoMateTaskRequestComposite;
        }
        catch (Exception exception) {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
            exception.printStackTrace();
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
            AutoMateTaskRunner.exit(1, "Command failed: Error loading Automate Task request definition.");
            return autoMateTaskRequestComposite;
        }
    }

    private static void exit(int n, String string) {
        AutoMateTaskRunner.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }

    private void runTask(AutoMateTaskRequestComposite autoMateTaskRequestComposite) throws Exception {
        AutoMateSystemDefinition autoMateSystemDefinition = autoMateTaskRequestComposite.getAutoMateSystemDefinition();
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "System Type: " + autoMateSystemDefinition.getAutoMateSystemType());
        switch (autoMateSystemDefinition.getAutoMateSystemType()) {
            case AUTOMATE_V10: {
                this.runTaskV10(autoMateTaskRequestComposite, autoMateSystemDefinition);
                break;
            }
            case AUTOMATE_V11: {
                AutomateV11TaskRunner automateV11TaskRunner = new AutomateV11TaskRunner();
                automateV11TaskRunner.runAutomateTask(autoMateTaskRequestComposite, autoMateSystemDefinition);
                break;
            }
            default: {
                throw new Exception("Invalid System Type of " + autoMateSystemDefinition.getAutoMateSystemType() + " for System Definition " + autoMateSystemDefinition.getName());
            }
        }
    }

    private void runTaskV10(AutoMateTaskRequestComposite autoMateTaskRequestComposite, AutoMateSystemDefinition autoMateSystemDefinition) throws Exception {
        RunTaskResponseInfo runTaskResponseInfo;
        AutoMateTaskCommand autoMateTaskCommand = autoMateTaskRequestComposite.getAutoMateTaskCommand();
        boolean bl = false;
        IAMTSHTTPServiceContract iAMTSHTTPServiceContract = null;
        String string = null;
        long l = System.currentTimeMillis();
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Endpoint: " + autoMateSystemDefinition.getEndPointURL());
        try {
            iAMTSHTTPServiceContract = AutoMateTaskRunner.getAutoMateHelper().getIAMTSHTTPServiceContract(autoMateSystemDefinition.getEndPointURL());
            string = AutoMateTaskRunner.getAutoMateHelper().authenticateConnection(l, autoMateSystemDefinition, iAMTSHTTPServiceContract);
        }
        catch (Exception exception) {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "Error running Automate Task on URL '" + autoMateSystemDefinition.getEndPointURL() + "'");
            throw exception;
        }
        System.out.println();
        String string2 = autoMateTaskCommand.getTaskID();
        if (autoMateTaskCommand.isRunByID()) {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "Running Task by ID     : " + string2);
        } else {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "Running Task by Path   : " + autoMateTaskCommand.getTaskPath());
        }
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Approximate start time : " + this.formatTimestamp(l));
        if (!autoMateTaskCommand.isRunByID() || string2 == null || string2.length() == 0) {
            string2 = this.lookupTaskID(l, string, autoMateTaskRequestComposite, iAMTSHTTPServiceContract);
            autoMateTaskCommand.setTaskID(string2);
        }
        if ((runTaskResponseInfo = this.startTask(l, string, autoMateTaskRequestComposite, iAMTSHTTPServiceContract)).getResponseResultValue().equals("TaskRunRequestResult_QueueMaxTasksExceeded")) {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "Task with instance ID " + runTaskResponseInfo.getInstanceID() + " exceeded the maximum queued tasks.");
            System.exit(1);
        }
        if (runTaskResponseInfo.getResponseResultValue().equals("TaskRunRequestResult_Queued")) {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "Task with instance ID " + runTaskResponseInfo.getInstanceID() + " is queued.");
        }
        this.waitForRunningTask(string, autoMateSystemDefinition, runTaskResponseInfo.getInstanceID(), iAMTSHTTPServiceContract);
        bl = this.wasTaskSuccessful(l, string, runTaskResponseInfo.getInstanceID(), autoMateTaskCommand.getTaskID(), iAMTSHTTPServiceContract);
        if (iAMTSHTTPServiceContract != null) {
            // empty if block
        }
        if (!bl) {
            System.exit(1);
        }
    }

    private String formatTimestamp(long l) {
        if (l < 0L) {
            return "N/A";
        }
        return l + " (" + formatter.format(l) + ")";
    }

    private String lookupTaskID(long l, String string, AutoMateTaskRequestComposite autoMateTaskRequestComposite, IAMTSHTTPServiceContract iAMTSHTTPServiceContract) throws RemoteException {
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "======================================================================");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Lookup Task with Get Task And Folder Names:");
        AutoMateTaskCommand autoMateTaskCommand = autoMateTaskRequestComposite.getAutoMateTaskCommand();
        String string2 = "gettaskandfoldernames." + l;
        Calendar calendar = null;
        boolean bl = true;
        boolean bl2 = false;
        String string3 = "";
        GetTaskAndFolderNamesRequestMessage getTaskAndFolderNamesRequestMessage = new GetTaskAndFolderNamesRequestMessage(string2, calendar, string, bl2, bl, string3);
        GetTaskAndFolderNames getTaskAndFolderNames = new GetTaskAndFolderNames(getTaskAndFolderNamesRequestMessage);
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Parameters:");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tMessage ID: " + getTaskAndFolderNamesRequestMessage.getMessageID());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tToken: " + getTaskAndFolderNamesRequestMessage.getToken());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tInclude Empty Folders: " + getTaskAndFolderNamesRequestMessage.getIncludeEmptyFolders());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tNames As Paths: " + getTaskAndFolderNamesRequestMessage.getNamesAsPaths());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tRoot Folder ID: " + getTaskAndFolderNamesRequestMessage.getRootFolderID());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        GetTaskAndFolderNamesResponse getTaskAndFolderNamesResponse = iAMTSHTTPServiceContract.getTaskAndFolderNames(getTaskAndFolderNames);
        if (!getTaskAndFolderNamesResponse.getGetTaskAndFolderNamesResult().getResponseResult().booleanValue()) {
            String string4 = "GetTaskAndFolderNames did not get a positive response result: " + getTaskAndFolderNamesResponse.getGetTaskAndFolderNamesResult().getResponseErrorText();
            throw new RuntimeException(string4);
        }
        Object[] objectArray = getTaskAndFolderNamesResponse.getGetTaskAndFolderNamesResult().getNames();
        for (int i = 0; i < objectArray.length; ++i) {
            TaskServiceObjectInformationBriefConstruct taskServiceObjectInformationBriefConstruct;
            if (!(objectArray[i] instanceof TaskServiceObjectInformationBriefConstruct) || !(taskServiceObjectInformationBriefConstruct = (TaskServiceObjectInformationBriefConstruct)objectArray[i]).getName().equalsIgnoreCase(autoMateTaskCommand.getTaskPath())) continue;
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "Found matching Task ID: " + taskServiceObjectInformationBriefConstruct.getID() + " for task path '" + autoMateTaskCommand.getTaskPath() + "'");
            return taskServiceObjectInformationBriefConstruct.getID();
        }
        throw new IllegalStateException("A matching task was not found for the task path '" + autoMateTaskCommand.getTaskPath() + "'.");
    }

    private boolean wasTaskSuccessful(long l, String string, String string2, String string3, IAMTSHTTPServiceContract iAMTSHTTPServiceContract) throws RemoteException {
        Object object;
        Serializable serializable;
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "======================================================================");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Polling for completed Task...");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Get Task History Event for instance: " + string2);
        String string4 = "gettaskhistoryevents." + l;
        Calendar calendar = null;
        long l2 = 86400000L;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(l - l2);
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTimeInMillis(System.currentTimeMillis() + l2);
        long l3 = 200L;
        boolean bl = false;
        GetTaskHistoryEventsRequestMessage getTaskHistoryEventsRequestMessage = new GetTaskHistoryEventsRequestMessage(string4, calendar, string, calendar2, calendar3, string2, l3, bl, string3);
        GetTaskHistoryEvents getTaskHistoryEvents = new GetTaskHistoryEvents(getTaskHistoryEventsRequestMessage);
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "");
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "Parameters for request:");
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tMessage ID . . . . : " + getTaskHistoryEventsRequestMessage.getMessageID());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tToken  . . . . . . : " + getTaskHistoryEventsRequestMessage.getToken());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tMax Records  . . . : " + getTaskHistoryEventsRequestMessage.getMaxRecords());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tSort Date Ascending: " + getTaskHistoryEventsRequestMessage.getSortDateAscending());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tTask ID  . . . . . : " + getTaskHistoryEventsRequestMessage.getTaskID());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tTask Instance ID   : " + getTaskHistoryEventsRequestMessage.getInstanceID());
        if (getTaskHistoryEventsRequestMessage.getBeginDate() != null) {
            serializable = new Date(getTaskHistoryEventsRequestMessage.getBeginDate().getTimeInMillis());
            object = DateTranslator.formatDateTimeWithTZ((Date)serializable);
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tBegin Date/Time  . : " + (String)object);
        }
        if (getTaskHistoryEventsRequestMessage.getEndDate() != null) {
            serializable = new Date(getTaskHistoryEventsRequestMessage.getEndDate().getTimeInMillis());
            object = DateTranslator.formatDateTimeWithTZ((Date)serializable);
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tEnd Date/Time  . . : " + (String)object);
        }
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "");
        serializable = iAMTSHTTPServiceContract.getTaskHistoryEvents(getTaskHistoryEvents);
        if (serializable == null) {
            throw new NullPointerException("getTaskHistoryEventsResponse is null.  Session error?");
        }
        if (((GetTaskHistoryEventsResponse)serializable).getGetTaskHistoryEventsResult() == null) {
            throw new NullPointerException("getTaskHistoryEventsResponse.getGetTaskHistoryEventsResult is null.  Session error?");
        }
        if (!((GetTaskHistoryEventsResponse)serializable).getGetTaskHistoryEventsResult().getResponseResult().booleanValue()) {
            object = "GetTaskHistoryEvents did not get a positive response result: " + ((GetTaskHistoryEventsResponse)serializable).getGetTaskHistoryEventsResult().getResponseErrorText();
            throw new RuntimeException((String)object);
        }
        object = ((GetTaskHistoryEventsResponse)serializable).getGetTaskHistoryEventsResult().getEvents();
        TaskServiceTaskHistoryEventConstruct taskServiceTaskHistoryEventConstruct = null;
        taskServiceTaskHistoryEventConstruct = this.getTaskEventHistory(string2, (Object[])object);
        if (taskServiceTaskHistoryEventConstruct == null) {
            String string5 = "Task History Event was not found for Task Instance ID: " + string2;
            throw new RuntimeException(string5);
        }
        String string6 = DateTranslator.formatDateTimeWithTZ((Date)new Date(taskServiceTaskHistoryEventConstruct.getStartDateTime().getTimeInMillis()));
        String string7 = DateTranslator.formatDateTimeWithTZ((Date)new Date(taskServiceTaskHistoryEventConstruct.getEndDateTime().getTimeInMillis()));
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Found Task History Event:");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tInstanceID . . : " + taskServiceTaskHistoryEventConstruct.getInstanceID());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tMachineName    : " + taskServiceTaskHistoryEventConstruct.getMachineName());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tTaskID . . . . : " + taskServiceTaskHistoryEventConstruct.getTaskID());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tTaskName . . . : " + taskServiceTaskHistoryEventConstruct.getTaskName());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tDescription    : " + taskServiceTaskHistoryEventConstruct.getDescription());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tExecutionResult: " + taskServiceTaskHistoryEventConstruct.getExecutionResult().getValue());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tStartDateTime  : " + string6);
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "\tEndDateTime  . : " + string7);
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        long l4 = taskServiceTaskHistoryEventConstruct.getEndDateTime().getTimeInMillis() - taskServiceTaskHistoryEventConstruct.getStartDateTime().getTimeInMillis();
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Automate Duration: " + l4 + " ms");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        long l5 = System.currentTimeMillis() - l;
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Automate Schedule Duration: " + l5 + " ms");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        String string8 = taskServiceTaskHistoryEventConstruct.getExecutionResult().getValue();
        if (RunResult.Okay.getValue().equalsIgnoreCase(string8) || RunResult.Stop.getValue().equalsIgnoreCase(string8)) {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "Task completed successfully with Run Result: " + string8);
            return true;
        }
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Task failed with Run Result: " + string8);
        return false;
    }

    private TaskServiceTaskHistoryEventConstruct getTaskEventHistory(String string, Object[] objectArray) {
        TaskServiceTaskHistoryEventConstruct taskServiceTaskHistoryEventConstruct = null;
        for (int i = 0; i < objectArray.length; ++i) {
            TaskServiceTaskHistoryEventConstruct taskServiceTaskHistoryEventConstruct2;
            if (!(objectArray[i] instanceof TaskServiceTaskHistoryEventConstruct) || !(taskServiceTaskHistoryEventConstruct2 = (TaskServiceTaskHistoryEventConstruct)objectArray[i]).getInstanceID().equals(string)) continue;
            taskServiceTaskHistoryEventConstruct = taskServiceTaskHistoryEventConstruct2;
            break;
        }
        return taskServiceTaskHistoryEventConstruct;
    }

    private void waitForRunningTask(String string, AutoMateSystemDefinition autoMateSystemDefinition, String string2, IAMTSHTTPServiceContract iAMTSHTTPServiceContract) throws RemoteException {
        long l = 2000L;
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "======================================================================");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Polling for running Task...");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        String string3 = "gettaskprocessingstatistics." + System.currentTimeMillis();
        Calendar calendar = null;
        GetTaskProcessingStatisticsRequestMessage getTaskProcessingStatisticsRequestMessage = new GetTaskProcessingStatisticsRequestMessage(string3, calendar, string);
        GetTaskProcessingStatistics getTaskProcessingStatistics = new GetTaskProcessingStatistics(getTaskProcessingStatisticsRequestMessage);
        String string4 = DateTranslator.formatDateTimeWithTZ((Date)new Date(System.currentTimeMillis()));
        RunningTaskConstruct runningTaskConstruct = this.getRunningTask(iAMTSHTTPServiceContract, getTaskProcessingStatistics, string2);
        long l2 = System.currentTimeMillis();
        while (runningTaskConstruct != null) {
            try {
                l = this.getPollingInterval(l2, autoMateSystemDefinition.getStatusPollingInterval());
                AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "Waiting " + l + " ms...");
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            runningTaskConstruct = this.getRunningTask(iAMTSHTTPServiceContract, getTaskProcessingStatistics, string2);
        }
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        string4 = DateTranslator.formatDateTimeWithTZ((Date)new Date(System.currentTimeMillis()));
        AutoMateTaskRunner.logmsg(LogLevel.INFO, string4 + " Running Task was not found for Task Instance ID " + string2);
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "The Task must have ended.");
    }

    private RunningTaskConstruct getRunningTask(IAMTSHTTPServiceContract iAMTSHTTPServiceContract, GetTaskProcessingStatistics getTaskProcessingStatistics, String string) throws RemoteException {
        RunningTaskConstruct runningTaskConstruct = null;
        GetTaskProcessingStatisticsResponse getTaskProcessingStatisticsResponse = iAMTSHTTPServiceContract.getTaskProcessingStatistics(getTaskProcessingStatistics);
        if (getTaskProcessingStatisticsResponse == null) {
            throw new NullPointerException("getTaskProcessingStatisticsResponse is null.  Session error?");
        }
        if (getTaskProcessingStatisticsResponse.getGetTaskProcessingStatisticsResult() == null) {
            throw new NullPointerException("getTaskProcessingStatisticsResponse..getGetTaskProcessingStatisticsResult is null.  Session error?");
        }
        if (!getTaskProcessingStatisticsResponse.getGetTaskProcessingStatisticsResult().getResponseResult().booleanValue()) {
            String string2 = "GetTaskProcessingStatistics did not get a positive response result: " + getTaskProcessingStatisticsResponse.getGetTaskProcessingStatisticsResult().getResponseErrorText();
            throw new RuntimeException(string2);
        }
        Object[] objectArray = getTaskProcessingStatisticsResponse.getGetTaskProcessingStatisticsResult().getRunningTasks();
        for (int i = 0; i < objectArray.length; ++i) {
            RunningTaskConstruct runningTaskConstruct2;
            if (!(objectArray[i] instanceof RunningTaskConstruct) || !(runningTaskConstruct2 = (RunningTaskConstruct)objectArray[i]).getInstanceID().equals(string)) continue;
            String string3 = DateTranslator.formatDateTimeWithTZ((Date)new Date(runningTaskConstruct2.getStartTime().getTimeInMillis()));
            String string4 = "Found Running Task: ";
            if (currentLogLevel == LogLevel.INFO) {
                string4 = string4 + runningTaskConstruct2.getInstanceID();
            }
            this.logmsgWithTimestamp(LogLevel.INFO, string4);
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tInstanceID . . : " + runningTaskConstruct2.getInstanceID());
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tTaskID . . . . : " + runningTaskConstruct2.getTaskID());
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tTaskName . . . : " + runningTaskConstruct2.getTaskName());
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tProcessID  . . : " + runningTaskConstruct2.getProcessID());
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tStepNumber . . : " + runningTaskConstruct2.getStepNumber());
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tIsQueued   . . : " + runningTaskConstruct2.getIsQueued());
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tStartDateTime  : " + string3);
            AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "");
            runningTaskConstruct = runningTaskConstruct2;
            break;
        }
        return runningTaskConstruct;
    }

    private void logmsgWithTimestamp(LogLevel logLevel, String string) {
        AutoMateTaskRunner.logmsg(logLevel, AutoMateTaskRunner.getAutoMateHelper().getCurrentTimestampString() + " - " + string);
    }

    private long getPollingInterval(long l, long l2) {
        if (l < 1L) {
            return 2000L;
        }
        if (l2 > 0L) {
            if (l2 > 15000L) {
                return 15000L;
            }
            return l2;
        }
        long l3 = System.currentTimeMillis() - l;
        if (l3 < 30000L) {
            return 2000L;
        }
        if (l3 < 300000L) {
            return 5000L;
        }
        return 15000L;
    }

    private RunTaskResponseInfo startTask(long l, String string, AutoMateTaskRequestComposite autoMateTaskRequestComposite, IAMTSHTTPServiceContract iAMTSHTTPServiceContract) throws Exception {
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "======================================================================");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Starting Task...");
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Task ID        : " + autoMateTaskRequestComposite.getAutoMateTaskCommand().getTaskID());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Task Path      : " + autoMateTaskRequestComposite.getAutoMateTaskCommand().getTaskPath());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "Must Be Enabled: " + autoMateTaskRequestComposite.getAutoMateTaskCommand().getTaskMustBeEnabled());
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        AutoMateTaskCommand autoMateTaskCommand = autoMateTaskRequestComposite.getAutoMateTaskCommand();
        String string2 = "SkybotRunAutoMateTask." + l;
        Calendar calendar = null;
        AutoMateSystemDefinition autoMateSystemDefinition = autoMateTaskRequestComposite.getAutoMateSystemDefinition();
        RunTaskRequestMessage runTaskRequestMessage = new RunTaskRequestMessage(string2, calendar, string, autoMateSystemDefinition.getDecryptedPassword(), autoMateTaskCommand.getTaskID(), autoMateTaskCommand.isTaskMustBeEnabled());
        RunTask runTask = new RunTask(runTaskRequestMessage);
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "Parameters for request:");
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tMessage ID . . : " + runTaskRequestMessage.getMessageID());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tToken  . . . . : " + runTaskRequestMessage.getToken());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tPassword . . . : ******");
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tTask ID  . . . : " + runTaskRequestMessage.getTaskID());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "\tMust Be Enabled: " + runTaskRequestMessage.getTaskMustBeEnabled());
        AutoMateTaskRunner.logmsg(LogLevel.DEBUG, "");
        RunTaskResponse runTaskResponse = null;
        try {
            runTaskResponse = iAMTSHTTPServiceContract.runTask(runTask);
        }
        catch (Exception exception) {
            AxisFault axisFault;
            if (exception instanceof AxisFault && (axisFault = (AxisFault)((Object)exception)).getFaultString() != null && axisFault.getFaultString().contains("0x80010105")) {
                AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
                AutoMateTaskRunner.logmsg(LogLevel.INFO, "WARNING: The error returned may be an indication of an invalid Task ID.");
                AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
            }
            throw exception;
        }
        if (runTaskResponse == null) {
            throw new NullPointerException("runTaskResponse is null.  Session error?");
        }
        RunTaskResponseMessage runTaskResponseMessage = runTaskResponse.getRunTaskResult();
        if (runTaskResponseMessage == null) {
            throw new NullPointerException("runTaskResponseMessage is null.  Session error?");
        }
        if (!runTaskResponseMessage.getResponseResult().booleanValue()) {
            String string3 = "RunTask did not get a positive response result: " + runTaskResponse.getRunTaskResult().getResponseErrorText();
            throw new RuntimeException(string3);
        }
        String string4 = runTaskResponseMessage.getResult().getValue();
        String string5 = runTaskResponseMessage.getInstanceID();
        long l2 = runTaskResponseMessage.getTimestamp().getTimeInMillis();
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        if (string4.equals("TaskRunRequestResult_TaskIsNotEnabled")) {
            throw new Exception("Task is not enabled.");
        }
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "RunTask Response Result Value: " + string4);
        if (runTaskResponseMessage.getResponseErrorText() != null) {
            AutoMateTaskRunner.logmsg(LogLevel.INFO, "RunTask Error Text . . . . . : " + runTaskResponseMessage.getResponseErrorText());
        }
        if (string5 == null) {
            String string6 = "A Task Instance ID was not returned.  RunTask Failed.";
            throw new Exception(string6);
        }
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "RunTask Task Instance ID . . : " + string5);
        AutoMateTaskRunner.logmsg(LogLevel.INFO, "");
        if (runTaskResponseMessage.getResult() != TaskRunRequestResult_t.TaskRunRequestResult_OK && runTaskResponseMessage.getResult() != TaskRunRequestResult_t.TaskRunRequestResult_Queued && runTaskResponseMessage.getResult() != TaskRunRequestResult_t.TaskRunRequestResult_Unknown) {
            String string7 = "Run task failed with result code: " + runTaskResponseMessage.getResult().getValue();
            AutoMateTaskRunner.logmsg(LogLevel.INFO, string7);
            throw new Exception(string7);
        }
        RunTaskResponseInfo runTaskResponseInfo = new RunTaskResponseInfo();
        runTaskResponseInfo.setInstanceID(string5);
        runTaskResponseInfo.setRunTime(l2);
        runTaskResponseInfo.setResponseResultValue(string4);
        return runTaskResponseInfo;
    }

    private static AutoMateHelper getAutoMateHelper() {
        if (autoMateHelper == null) {
            autoMateHelper = new AutoMateHelper();
        }
        return autoMateHelper;
    }

    private static void logmsg(LogLevel logLevel, String string) {
        switch (logLevel) {
            case DEBUG: {
                if (currentLogLevel == LogLevel.DEBUG) {
                    System.out.println(string);
                }
                return;
            }
            case INFO: {
                if (currentLogLevel == LogLevel.DEBUG || currentLogLevel == LogLevel.INFO) {
                    System.out.println(string);
                }
                return;
            }
        }
        System.out.println(string);
    }

    static {
        String string = "SKYBOT_AUTOMATE_LOGLEVEL";
        String string2 = System.getenv(string);
        if (string2 != null && string2.trim().length() > 0) {
            if (string2.trim().equalsIgnoreCase("debug")) {
                currentLogLevel = LogLevel.DEBUG;
            } else if (string2.trim().equalsIgnoreCase("info")) {
                currentLogLevel = LogLevel.INFO;
            } else {
                System.out.println("Undefined value for " + string + ": " + string2);
                System.out.println(string + " must be INFO or DEBUG when specified.");
            }
        }
    }

    private static enum LogLevel {
        DEBUG,
        INFO;

    }
}

